/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.transport.EntryPacket;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.jdbc.SelectColumn;
import com.j_spaces.jdbc.query.QueryTableData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@InternalApi
public class JoinedEntry
extends EntryPacket
implements Serializable {
    private static final long serialVersionUID = 1L;
    private IEntryPacket[] _entries;

    public JoinedEntry() {
    }

    public JoinedEntry(IEntryPacket ... entries) {
        this._entries = entries;
    }

    @Override
    public boolean equals(Object ob) {
        if (ob instanceof JoinedEntry) {
            JoinedEntry entry = (JoinedEntry)ob;
            if (this._entries.length != entry._entries.length) {
                return false;
            }
            for (int i = 0; i < this._entries.length; ++i) {
                if (this.getEntry(i).equals(entry.getEntry(i))) continue;
                return false;
            }
            return true;
        }
        if (ob instanceof IEntryPacket) {
            IEntryPacket entry = (IEntryPacket)ob;
            for (IEntryPacket thisEntry : this._entries) {
                if (!entry.equals(thisEntry)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public IEntryPacket getEntry(int index) {
        return this._entries[index];
    }

    public int getSize() {
        if (this._entries == null) {
            return 0;
        }
        return this._entries.length;
    }

    public void createProjection(List<SelectColumn> columns) {
        ArrayList<Object> fieldValues = new ArrayList<Object>();
        for (int i = 0; i < columns.size(); ++i) {
            SelectColumn column = columns.get(i);
            if (!column.isVisible()) continue;
            QueryTableData columnTableData = column.getColumnTableData();
            if (columnTableData == null) {
                fieldValues.add(null);
                continue;
            }
            IEntryPacket entry = this.getEntry(columnTableData.getTableIndex());
            if (entry == null) {
                fieldValues.add(null);
                continue;
            }
            if (column.isUid()) {
                fieldValues.add(entry.getUID());
                continue;
            }
            fieldValues.add(column.getFieldValue(entry));
        }
        this.setFieldsValues(fieldValues.toArray());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this._entries);
        return result;
    }
}

