/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc;

import com.gigaspaces.api.InternalApi;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;

@InternalApi
public class NumberUtil {
    private static HashMap<String, NumberHandler> _numberMap = new HashMap();

    public static Number cast(Number x, String numberClassName) {
        NumberHandler handler = NumberUtil.getHandler(numberClassName);
        return handler.cast(x);
    }

    public static Number add(Number x, Number y, String numberClassName) {
        NumberHandler handler = NumberUtil.getHandler(numberClassName);
        return handler.add(x, y);
    }

    public static Number subtract(Number x, Number y, String numberClassName) {
        NumberHandler handler = NumberUtil.getHandler(numberClassName);
        return handler.subtract(x, y);
    }

    public static Number mul(Number x, Number y, String numberClassName) {
        NumberHandler handler = NumberUtil.getHandler(numberClassName);
        return handler.mul(x, y);
    }

    public static Number divide(Number x, Number y, String numberClassName) {
        NumberHandler handler = NumberUtil.getHandler(numberClassName);
        return handler.divide(x, y);
    }

    private static NumberHandler getHandler(String numberClassName) {
        NumberHandler handler = _numberMap.get(numberClassName);
        if (handler == null) {
            throw new IllegalArgumentException("Invalid number class - [" + numberClassName + "]");
        }
        return handler;
    }

    static {
        _numberMap.put(Integer.class.getName(), new IntegerHandler());
        _numberMap.put(Long.class.getName(), new LongHandler());
        _numberMap.put(Double.class.getName(), new DoubleHandler());
        _numberMap.put(Float.class.getName(), new FloatHandler());
        _numberMap.put(Short.class.getName(), new ShortHandler());
        _numberMap.put(Byte.class.getName(), new ByteHandler());
        _numberMap.put(BigDecimal.class.getName(), new BigDecimalHandler());
        _numberMap.put(BigInteger.class.getName(), new BigIntegerHandler());
        _numberMap.put(Integer.TYPE.getName(), new IntegerHandler());
        _numberMap.put(Long.TYPE.getName(), new LongHandler());
        _numberMap.put(Double.TYPE.getName(), new DoubleHandler());
        _numberMap.put(Float.TYPE.getName(), new FloatHandler());
        _numberMap.put(Short.TYPE.getName(), new ShortHandler());
        _numberMap.put(Byte.TYPE.getName(), new ByteHandler());
    }

    private static class BigIntegerHandler
    implements NumberHandler {
        private BigIntegerHandler() {
        }

        @Override
        public BigInteger cast(Number number) {
            return (BigInteger)number;
        }

        @Override
        public Number divide(Number x, Number y) {
            return this.cast(x).divide(this.cast(y));
        }

        @Override
        public Number subtract(Number x, Number y) {
            return this.cast(x).subtract(this.cast(y));
        }

        @Override
        public Number mul(Number x, Number y) {
            return this.cast(x).multiply(this.cast(y));
        }

        @Override
        public Number add(Number x, Number y) {
            return this.cast(x).add(this.cast(y));
        }
    }

    private static class BigDecimalHandler
    implements NumberHandler {
        private BigDecimalHandler() {
        }

        @Override
        public BigDecimal cast(Number number) {
            return (BigDecimal)number;
        }

        @Override
        public Number divide(Number x, Number y) {
            return this.cast(x).divide(this.cast(y));
        }

        @Override
        public Number subtract(Number x, Number y) {
            return this.cast(x).subtract(this.cast(y));
        }

        @Override
        public Number mul(Number x, Number y) {
            return this.cast(x).multiply(this.cast(y));
        }

        @Override
        public Number add(Number x, Number y) {
            return this.cast(x).add(this.cast(y));
        }
    }

    private static class ByteHandler
    implements NumberHandler {
        private ByteHandler() {
        }

        @Override
        public Byte cast(Number number) {
            return this.cast0(number);
        }

        private byte cast0(Number number) {
            return number.byteValue();
        }

        @Override
        public Number divide(Number x, Number y) {
            return this.cast0(x) / this.cast0(y);
        }

        @Override
        public Number subtract(Number x, Number y) {
            return this.cast0(x) - this.cast0(y);
        }

        @Override
        public Number mul(Number x, Number y) {
            return this.cast0(x) * this.cast0(y);
        }

        @Override
        public Number add(Number x, Number y) {
            return this.cast0(x) + this.cast0(y);
        }
    }

    private static class ShortHandler
    implements NumberHandler {
        private ShortHandler() {
        }

        @Override
        public Short cast(Number number) {
            return this.cast0(number);
        }

        public short cast0(Number number) {
            return number.shortValue();
        }

        @Override
        public Number divide(Number x, Number y) {
            return this.cast0(x) / this.cast0(y);
        }

        @Override
        public Number subtract(Number x, Number y) {
            return this.cast0(x) - this.cast0(y);
        }

        @Override
        public Number mul(Number x, Number y) {
            return this.cast0(x) * this.cast0(y);
        }

        @Override
        public Number add(Number x, Number y) {
            return this.cast0(x) + this.cast0(y);
        }
    }

    private static class FloatHandler
    implements NumberHandler {
        private FloatHandler() {
        }

        @Override
        public Float cast(Number number) {
            return Float.valueOf(this.cast0(number));
        }

        private float cast0(Number number) {
            return number.floatValue();
        }

        @Override
        public Number divide(Number x, Number y) {
            return Float.valueOf(this.cast0(x) / this.cast0(y));
        }

        @Override
        public Number subtract(Number x, Number y) {
            return Float.valueOf(this.cast0(x) - this.cast0(y));
        }

        @Override
        public Number mul(Number x, Number y) {
            return Float.valueOf(this.cast0(x) * this.cast0(y));
        }

        @Override
        public Number add(Number x, Number y) {
            return Float.valueOf(this.cast0(x) + this.cast0(y));
        }
    }

    private static class DoubleHandler
    implements NumberHandler {
        private DoubleHandler() {
        }

        @Override
        public Double cast(Number number) {
            return this.cast0(number);
        }

        private double cast0(Number number) {
            return number.doubleValue();
        }

        @Override
        public Number divide(Number x, Number y) {
            return this.cast0(x) / this.cast0(y);
        }

        @Override
        public Number subtract(Number x, Number y) {
            return this.cast0(x) - this.cast0(y);
        }

        @Override
        public Number mul(Number x, Number y) {
            return this.cast0(x) * this.cast0(y);
        }

        @Override
        public Number add(Number x, Number y) {
            return this.cast0(x) + this.cast0(y);
        }
    }

    private static class LongHandler
    implements NumberHandler {
        private LongHandler() {
        }

        @Override
        public Long cast(Number number) {
            return this.cast0(number);
        }

        private long cast0(Number number) {
            return number.longValue();
        }

        @Override
        public Number divide(Number x, Number y) {
            return this.cast0(x) / this.cast0(y);
        }

        @Override
        public Number subtract(Number x, Number y) {
            return this.cast0(x) - this.cast0(y);
        }

        @Override
        public Number mul(Number x, Number y) {
            return this.cast0(x) * this.cast0(y);
        }

        @Override
        public Number add(Number x, Number y) {
            return this.cast0(x) + this.cast0(y);
        }
    }

    private static class IntegerHandler
    implements NumberHandler {
        private IntegerHandler() {
        }

        @Override
        public Integer cast(Number number) {
            return this.cast0(number);
        }

        private int cast0(Number number) {
            return number.intValue();
        }

        @Override
        public Number divide(Number x, Number y) {
            return this.cast0(x) / this.cast0(y);
        }

        @Override
        public Number subtract(Number x, Number y) {
            return this.cast0(x) - this.cast0(y);
        }

        @Override
        public Number mul(Number x, Number y) {
            return this.cast0(x) * this.cast0(y);
        }

        @Override
        public Number add(Number x, Number y) {
            return this.cast0(x) + this.cast0(y);
        }
    }

    private static interface NumberHandler {
        public Number cast(Number var1);

        public Number add(Number var1, Number var2);

        public Number subtract(Number var1, Number var2);

        public Number mul(Number var1, Number var2);

        public Number divide(Number var1, Number var2);
    }
}

