/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.core.ExternalEntryPacket;
import com.j_spaces.jdbc.AbstractDMLQuery;
import com.j_spaces.jdbc.IProcedure;
import com.j_spaces.jdbc.ResponsePacket;
import com.j_spaces.jdbc.ResultEntry;
import com.j_spaces.jdbc.driver.GConnection;
import com.j_spaces.jdbc.driver.GDriver;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.jini.core.transaction.Transaction;

@InternalApi
public class ProcedureQuery
extends AbstractDMLQuery {
    private String procName;
    private ArrayList paramList = new ArrayList();

    public void setProcName(String procName) {
        this.procName = procName;
    }

    public void addParamList(Object param) {
        this.paramList.add(param);
    }

    @Override
    public ResponsePacket executeOnSpace(ISpaceProxy space, Transaction txn) throws SQLException {
        ResponsePacket packet = new ResponsePacket();
        GConnection con = null;
        ResultEntry result = null;
        IProcedure runObj = null;
        ArrayList<Object> param = null;
        try {
            con = GConnection.getInstance(space);
            runObj = this.getProcedure(this.procName);
            if (this.isPrepared) {
                param = new ArrayList<Object>();
                param.addAll(0, Arrays.asList(this.preparedValues));
            } else {
                param = this.paramList;
            }
            result = runObj.execute(con, space, param);
            if (result == null) {
                result = new ResultEntry(new String[]{this.procName}, new String[]{this.procName}, new String[]{""}, new Object[0][0]);
            }
            if (this.isConvertResultToArray()) {
                packet.setResultEntry(result);
            } else {
                ArrayList<IEntryPacket> resultSet = new ArrayList<IEntryPacket>(result.getFieldValues().length);
                ITypeDesc typeDesc = this.getTypeInfo();
                for (Object[] value : result.getFieldValues()) {
                    resultSet.add(new ExternalEntryPacket(typeDesc, value));
                }
                packet.setResultSet(resultSet);
            }
            con.close();
        }
        catch (Exception ex) {
            SQLException se = new SQLException("Failed to execute stored procedure; Cause: " + ex, "GSP", -222);
            se.initCause(ex);
            throw se;
        }
        return packet;
    }

    public IProcedure getProcedure(String procName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        IProcedure runObj = null;
        HashMap pTable = GDriver.getProcTable();
        if (pTable.containsKey(procName)) {
            runObj = (IProcedure)pTable.get(procName);
        } else {
            runObj = (IProcedure)ClassLoaderHelper.loadClass(procName).newInstance();
            pTable.put(procName, runObj);
        }
        return runObj;
    }

    @Override
    public ProcedureQuery clone() {
        ProcedureQuery query = new ProcedureQuery();
        query.paramList = this.paramList;
        query.procName = this.procName;
        query.isPrepared = this.isPrepared;
        query._tablesData = this._tablesData;
        query.tables = this.tables;
        return query;
    }
}

