/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.transaction.ITransactionManagerProvider;
import com.gigaspaces.client.transaction.TransactionManagerProviderFactory;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.exceptions.BatchQueryException;
import com.gigaspaces.security.service.SecurityInterceptor;
import com.j_spaces.core.IJSpace;
import com.j_spaces.jdbc.AbstractDMLQuery;
import com.j_spaces.jdbc.Query;
import com.j_spaces.jdbc.QueryCache;
import com.j_spaces.jdbc.QueryProcessorConfiguration;
import com.j_spaces.jdbc.QuerySession;
import com.j_spaces.jdbc.RequestPacket;
import com.j_spaces.jdbc.ResponsePacket;
import com.j_spaces.jdbc.parser.grammar.SqlParser;
import com.j_spaces.jdbc.request.SetAutoCommitRequest;
import com.j_spaces.jdbc.request.SetTransaction;
import com.j_spaces.jdbc.request.SetUseSingleSpace;
import java.io.BufferedReader;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.transaction.CannotCommitException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.TransactionFactory;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.TransactionManager;

@InternalApi
public class QueryHandler {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.query");
    private final ISpaceProxy _spaceCluster;
    private final ISpaceProxy _spaceRegular;
    private final QueryCache _queryCache;
    private final QueryProcessorConfiguration _config;
    private final SecurityInterceptor securityInterceptor;
    private volatile ITransactionManagerProvider _transactionManagerProvider;

    public QueryHandler(IJSpace spaceCluster, IJSpace spaceRegular, QueryProcessorConfiguration config, SecurityInterceptor securityInterceptor) {
        this._spaceCluster = (ISpaceProxy)spaceCluster;
        this._spaceRegular = (ISpaceProxy)spaceRegular;
        this.securityInterceptor = securityInterceptor;
        this._queryCache = new QueryCache();
        this._config = config;
    }

    private ResponsePacket handleRequest(RequestPacket request, QuerySession session) throws LeaseDeniedException, RemoteException, SQLException, TransactionException {
        ResponsePacket response = new ResponsePacket();
        ISpaceProxy space = this.getSpace(session.isUseRegularSpace());
        switch (request.getType()) {
            case STATEMENT: {
                Query query = this.handleStatement(request, space);
                this.attachTransaction(session, query);
                query.setSession(session);
                query.setSecurityInterceptor(this.securityInterceptor);
                response = query.executeOnSpace(space, session.getTransaction());
                session.setUnderTransaction(request.getStatement());
                this.commitForcedTransaction(query, session);
                break;
            }
            case PREPARED_WITH_VALUES: {
                AbstractDMLQuery dmlQuery = (AbstractDMLQuery)this.handleStatement(request, space);
                this.attachTransaction(session, dmlQuery);
                request.build(dmlQuery);
                dmlQuery.setSession(session);
                dmlQuery.setSecurityInterceptor(this.securityInterceptor);
                response = dmlQuery.executeOnSpace(space, session.getTransaction());
                session.setUnderTransaction(request.getStatement());
                this.commitForcedTransaction(dmlQuery, session);
                break;
            }
            case PREPARED_STATEMENT: {
                Query query = this.handleStatement(request, space);
                query.setSession(session);
                query.setSecurityInterceptor(this.securityInterceptor);
                response.setIntResult(0);
                break;
            }
            case PREPARED_VALUES_BATCH: {
                AbstractDMLQuery dmlQuery = (AbstractDMLQuery)this.handleStatement(request, space);
                this.attachTransaction(session, dmlQuery);
                dmlQuery.setSession(session);
                dmlQuery.setSecurityInterceptor(this.securityInterceptor);
                response = dmlQuery.executePreparedValuesBatch(space, session.getTransaction(), request.getPreparedValuesCollection());
                session.setUnderTransaction(request.getStatement());
                this.commitForcedTransaction(dmlQuery, session);
                break;
            }
            default: {
                throw new SQLException("Unknown execution type [" + (Object)((Object)request.getType()) + "]", "GSP", -117);
            }
        }
        return response;
    }

    private void commitForcedTransaction(Query query, QuerySession session) throws UnknownTransactionException, CannotCommitException, RemoteException {
        if (session.isAutoCommit() && query.isForceUnderTransaction()) {
            session.getTransaction().commit();
            session.setSelectedForUpdate(null);
            session.setTransaction(null);
        }
    }

    private void attachTransaction(QuerySession session, Query query) throws TransactionException, RemoteException, LeaseDeniedException {
        if (!session.isAutoCommit() && session.getTransaction() == null || query.isForceUnderTransaction()) {
            session.setTransaction(this.createTransaction());
        }
        session.setQueryHandler(this);
    }

    public Query handleStatement(RequestPacket request, ISpaceProxy space) throws SQLException {
        Query query = this._queryCache.getQueryFromCache(request.getStatement());
        try {
            if (query == null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Query wasn't in cache, will be parsed");
                }
                StringReader sReader = new StringReader(request.getStatement());
                BufferedReader reader = new BufferedReader(sReader);
                SqlParser parser = new SqlParser(reader);
                query = parser.parseStatement();
                query.validateQuery(space);
                if (!query.isPrepared() && !query.containsSubQueries()) {
                    query.build();
                }
                this._queryCache.addQueryToCache(request.getStatement(), query);
            } else if (query instanceof AbstractDMLQuery) {
                query = ((AbstractDMLQuery)query).clone();
            }
            return query;
        }
        catch (SQLException sqlEx) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Error executing statement [" + request + "]", sqlEx);
            }
            throw sqlEx;
        }
        catch (Throwable t) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Couldn't parse given statement [" + request + "]", t);
            }
            SQLException sqlEx = new SQLException("Error in statement [" + request + "]; Cause: " + t, "GSP", -201);
            sqlEx.initCause(t);
            throw sqlEx;
        }
    }

    private Transaction createTransaction() throws LeaseDeniedException, RemoteException, TransactionException {
        ITransactionManagerProvider transactionManagerProvider = this.getTransactionManagerProvider();
        return TransactionFactory.create((TransactionManager)transactionManagerProvider.getTransactionManager(), (long)this._config.getTransactionTimeout()).transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITransactionManagerProvider getTransactionManagerProvider() throws TransactionException, RemoteException {
        if (this._transactionManagerProvider == null) {
            QueryHandler queryHandler = this;
            synchronized (queryHandler) {
                if (this._transactionManagerProvider == null) {
                    this._transactionManagerProvider = TransactionManagerProviderFactory.newInstance(this.getSpace(false), this._config.getTransactionManagerConfiguration());
                }
            }
        }
        return this._transactionManagerProvider;
    }

    ISpaceProxy getSpace(boolean useRegularSpace) {
        return !useRegularSpace && this._spaceCluster != null ? this._spaceCluster : this._spaceRegular;
    }

    public void close() throws RemoteException {
        if (this._transactionManagerProvider != null) {
            this._transactionManagerProvider.destroy();
        }
        this._queryCache.clear();
    }

    public QueryCache getQueryCache() {
        return this._queryCache;
    }

    public ResponsePacket visit(RequestPacket request, QuerySession session) throws LeaseDeniedException, RemoteException, TransactionException, SQLException {
        try {
            return this.handleRequest(request, session);
        }
        catch (BatchQueryException ex) {
            SQLException sqlEx = new SQLException("Failed to execute SQL command.");
            sqlEx.initCause(ex);
            throw sqlEx;
        }
    }

    public ResponsePacket visit(SetAutoCommitRequest request, QuerySession session) throws LeaseDeniedException, RemoteException, TransactionException {
        ResponsePacket response = new ResponsePacket();
        if (request.isAutoCommit() == session.isAutoCommit()) {
            return response;
        }
        if (request.isAutoCommit()) {
            block6: {
                if (session.getTransaction() != null) {
                    try {
                        session.getTransaction().abort();
                    }
                    catch (Exception e) {
                        if (!_logger.isLoggable(Level.FINE)) break block6;
                        _logger.log(Level.FINE, "Failed to abort transaction.", e);
                    }
                }
            }
            session.setTransaction(null);
            session.clearUnderTransaction();
        } else {
            session.setTransaction(this.createTransaction());
        }
        session.setAutoCommit(request.isAutoCommit());
        session.setSelectedForUpdate(null);
        response.setIntResult(0);
        return response;
    }

    public ResponsePacket visit(SetUseSingleSpace request, QuerySession session) {
        ResponsePacket response = new ResponsePacket();
        session.setUseRegularSpace(request.isUseSingleSpace());
        return response;
    }

    public ResponsePacket visit(SetTransaction request, QuerySession session) {
        ResponsePacket response = new ResponsePacket();
        session.setTransaction(request.getTransaction());
        response.setIntResult(0);
        return response;
    }
}

