/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.server.space.IRemoteSpace;
import com.gigaspaces.security.AccessDeniedException;
import com.gigaspaces.security.service.SecurityInterceptor;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.core.service.ServiceConfigLoader;
import com.j_spaces.jdbc.ConnectionContext;
import com.j_spaces.jdbc.IQueryProcessor;
import com.j_spaces.jdbc.QueryHandler;
import com.j_spaces.jdbc.QueryProcessorConfiguration;
import com.j_spaces.jdbc.QueryProcessorFactory;
import com.j_spaces.jdbc.QueryProcessorStub;
import com.j_spaces.jdbc.QuerySession;
import com.j_spaces.jdbc.RequestPacket;
import com.j_spaces.jdbc.ResponsePacket;
import com.j_spaces.jdbc.SQLUtil;
import java.io.FileInputStream;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.export.Exporter;

@InternalApi
public class QueryProcessor
implements IQueryProcessor {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.query");
    private static QueryProcessorConfiguration defaultConfig;
    private IJSpace _spaceCluster;
    private IJSpace _spaceRegular;
    private QueryHandler _queryHandler;
    private IQueryProcessor _stub;
    private Exporter _exporter;
    private final AtomicLong _sessionCounter = new AtomicLong();
    private final Map<ConnectionContext, QuerySession> _sessions = new ConcurrentHashMap<ConnectionContext, QuerySession>();
    private final QueryProcessorConfiguration _config;
    private SecurityInterceptor securityInterceptor;
    private Transaction _transaction;

    public QueryProcessor(IJSpace clusterProxy, IJSpace spaceProxy, Properties overrideProperties, SecurityInterceptor securityInterceptor) throws Exception {
        this._spaceCluster = clusterProxy;
        this._spaceRegular = spaceProxy;
        this.securityInterceptor = securityInterceptor;
        this._config = new QueryProcessorConfiguration(SQLUtil.getAdmin(this._spaceRegular).getConfig(), overrideProperties);
        QueryProcessor.setDefaultConfig(this._config);
        this.init();
    }

    private synchronized void init() {
        this._queryHandler = new QueryHandler(this._spaceCluster, this._spaceRegular, this._config, this.securityInterceptor);
    }

    public void initStub() throws ExportException {
        this._exporter = ServiceConfigLoader.getExporter();
        IQueryProcessor qpStub = (IQueryProcessor)this._exporter.export((Remote)this);
        this._stub = new QueryProcessorStub(this, qpStub);
    }

    public void close() throws RemoteException {
        if (this._exporter != null) {
            this._exporter.unexport(true);
        }
        if (this._queryHandler != null) {
            this._queryHandler.close();
        }
        if (this._sessions != null) {
            this._sessions.clear();
        }
        this._spaceRegular = null;
        this._spaceCluster = null;
        this.securityInterceptor = null;
    }

    @Override
    public ResponsePacket executeQuery(RequestPacket request, ConnectionContext context) throws RemoteException, SQLException {
        try {
            if (context == null) {
                throw new SQLException("Invalid connection context.");
            }
            QuerySession session = this._sessions.get(context);
            if (session == null) {
                throw new SQLException("Invalid connection context.");
            }
            if (session.getTransaction() == null) {
                session.setTransaction(this._transaction);
            }
            session.setConnectionContext(context);
            session.setModifiers(request.getModifiers());
            ResponsePacket response = null;
            if (this._config.isTraceExecTime()) {
                long startTime = System.currentTimeMillis();
                response = request.accept(this._queryHandler, session);
                long queryTime = System.currentTimeMillis() - startTime;
                if (_logger.isLoggable(Level.INFO)) {
                    _logger.info("Statement=" + request.toString() + ", execution time=" + queryTime + " milliseconds.");
                }
            } else {
                response = request.accept(this._queryHandler, session);
            }
            return response;
        }
        catch (LeaseDeniedException e) {
            throw new SQLException("Failed to execute query; Cause: " + (Object)((Object)e), e);
        }
        catch (TransactionException e) {
            throw new SQLException("Failed to execute query; Cause: " + (Object)((Object)e), e);
        }
        catch (AccessDeniedException e) {
            throw new SQLException("Failed to execute query; Cause: " + e, e);
        }
    }

    @Override
    public void setTransaction(Transaction transaction) throws RemoteException {
        this._transaction = transaction;
    }

    @Override
    public boolean isAvailable() throws RemoteException {
        try {
            this._spaceRegular.ping();
            return true;
        }
        catch (RemoteException e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "Connection to space failed.", e);
            }
            return false;
        }
    }

    @Override
    public ConnectionContext newConnection() throws RemoteException {
        QuerySession session = new QuerySession(QuerySession.class.getSimpleName() + "_" + this._sessionCounter.incrementAndGet());
        session.setAutoCommit(this._config.isAutoCommit());
        this._sessions.put(session.getConnectionContext(), session);
        return session.getConnectionContext();
    }

    @Override
    public QuerySession getSession(ConnectionContext context) throws RemoteException {
        return context == null ? null : this._sessions.get(context);
    }

    @Override
    public void closeConnection(ConnectionContext context) throws RemoteException {
        this._sessions.remove(context);
    }

    public IQueryProcessor getStub() {
        return this._stub;
    }

    public static synchronized void setDefaultConfig(QueryProcessorConfiguration defaultConfig) {
        if (QueryProcessor.defaultConfig == null) {
            QueryProcessor.defaultConfig = defaultConfig;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("~~~INITIALIZING of QueryProcessor.defaultConfig, DateTimeFormat=" + defaultConfig.getDateTimeFormat() + ", DateFormat=" + defaultConfig.getDateFormat() + ", TimeFormat=" + defaultConfig.getTimeFormat());
            }
        }
    }

    public static QueryProcessorConfiguration getDefaultConfig() {
        if (defaultConfig == null) {
            QueryProcessor.setDefaultConfig(new QueryProcessorConfiguration(null, new Properties()));
        }
        return defaultConfig;
    }

    public void clean() throws RemoteException {
        if (this._queryHandler != null) {
            this._queryHandler.close();
        }
        this._spaceCluster.getDirectProxy().directClean();
        this._spaceRegular.getDirectProxy().directClean();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Throwable {
        Object keepAlive;
        if (args.length != 1) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.info("Usage: QueryProcessor <property file>");
            }
            System.exit(-1);
        }
        Properties config = new Properties();
        FileInputStream fileIn = new FileInputStream(args[0]);
        config.load(fileIn);
        fileIn.close();
        QueryProcessorConfiguration qpConfig = new QueryProcessorConfiguration(null, config);
        IJSpace space = (IJSpace)SpaceFinder.find(qpConfig.getSpaceURL());
        IRemoteSpace remoteSpace = ((IDirectSpaceProxy)space).getRemoteJSpace();
        QueryProcessor qp = (QueryProcessor)QueryProcessorFactory.newInstance(space, remoteSpace, config);
        try {
            int listenPort = qpConfig.getListenPort();
            Registry registry = LocateRegistry.createRegistry(listenPort);
            qp.initStub();
            registry.bind("qp", qp._stub);
            _logger.info("QueryProcessor started on port:" + listenPort);
        }
        catch (Throwable e) {
            qp.close();
            throw e;
        }
        Object object = keepAlive = new Object();
        synchronized (object) {
            try {
                keepAlive.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

