/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.transaction.ITransactionManagerProvider;
import com.gigaspaces.client.transaction.LookupTransactionManagerConfiguration;
import com.gigaspaces.client.transaction.TransactionManagerConfiguration;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.core.Constants;
import com.j_spaces.core.JSpaceAttributes;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class QueryProcessorConfiguration {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.query");
    private static final String TRACE_EXEC_TIME_PROPERTY = "TRACE_EXEC_TIME";
    private static final String AUTO_COMMIT_PROPERTY = "AUTO_COMMIT";
    private static final String PARSER_CASE_SENSETIVITY_PROPERTY = "PARSER_CASE_SENSETIVITY";
    private static final String TRANSACTION_TIMEOUT_PROPERTY = "TRANSACTION_TIMEOUT";
    private static final String SPACE_WRITE_LEASE_PROPERTY = "SPACE_WRITE_LEASE";
    private static final String SPACE_READ_LEASE_TIME_PROPERTY = "SPACE_READ_LEASE_TIME";
    private static final String SPACE_URL = "SPACE_URL";
    private static final String PORT_PROPERTY = "PORT";
    private static final int PORT_DEFAULT = 2872;
    private static final String DATE_FORMAT_PROPERTY = "DATE_FORMAT";
    private static final String DATE_TIME_FORMAT_PROPERTY = "DATETIME_FORMAT";
    private static final String TIME_FORMAT_PROPERTY = "TIME_FORMAT";
    private int _readLease = Integer.parseInt(Constants.QueryProcessorInfo.QP_SPACE_READ_LEASE_TIME_DEFAULT);
    private long _writeLease = Long.parseLong(Constants.QueryProcessorInfo.QP_SPACE_WRITE_LEASE_DEFAULT);
    private long _transactionTimeout = Integer.parseInt(Constants.QueryProcessorInfo.QP_TRANSACTION_TIMEOUT_DEFAULT);
    private boolean _parserCaseSensitivity = Boolean.parseBoolean(Constants.QueryProcessorInfo.QP_PARSER_CASE_SENSETIVITY_DEFAULT);
    private String _dateFormat = "yyyy-MM-dd";
    private String _dateTimeFormat = "yyyy-MM-dd HH:mm:ss";
    private String _timeFormat = "HH:mm:ss";
    private boolean _traceExecTime = Boolean.parseBoolean(Constants.QueryProcessorInfo.QP_TRACE_EXEC_TIME_DEFAULT);
    private boolean _autoCommit = Boolean.parseBoolean(Constants.QueryProcessorInfo.QP_AUTO_COMMIT_DEFAULT);
    private String _spaceURL;
    private int _listenPort = 2872;
    private TransactionManagerConfiguration _transactionManagerConfiguration;

    public QueryProcessorConfiguration(JSpaceAttributes conf, Properties localProps) {
        if (conf != null) {
            this._readLease = conf.getQpSpaceReadLeaseTime();
            this._writeLease = conf.getQpSpaceWriteLeaseTime();
            this._transactionTimeout = conf.getQpTransactionTimeout();
            this._parserCaseSensitivity = conf.isQPParserCaseSensetivity();
            this._autoCommit = conf.isQPAutoCommit();
            this._traceExecTime = conf.isQPTraceExecTime();
            this._dateFormat = conf.getQpDateFormat();
            this._dateTimeFormat = conf.getQpDateTimeFormat();
            this._timeFormat = conf.getQpTimeFormat();
        }
        this.configure(localProps);
        if (_logger.isLoggable(Level.CONFIG)) {
            _logger.config("\n QueryProcessor configuration:\n\tparserCaseSensitivity=" + this._parserCaseSensitivity + "\n\twriteLease=" + this._writeLease + "\n\treadLease=" + this._readLease + "\n\ttransactionTimeout=" + this._transactionTimeout + "\n\tautoCommit=" + this._autoCommit + "\n\ttraceExecTime=" + this._traceExecTime + "\n\tdateFormat=" + this._dateFormat + "\n\tdateTimeFormat=" + this._dateTimeFormat + "\n\ttimeFormat=" + this._timeFormat);
        }
    }

    private void configure(Properties localProps) {
        if (localProps == null) {
            return;
        }
        this._readLease = QueryProcessorConfiguration.getInteger(localProps.getProperty(SPACE_READ_LEASE_TIME_PROPERTY), this._readLease);
        this._writeLease = QueryProcessorConfiguration.getLong(localProps.getProperty(SPACE_WRITE_LEASE_PROPERTY), this._writeLease);
        this._transactionTimeout = QueryProcessorConfiguration.getLong(localProps.getProperty(TRANSACTION_TIMEOUT_PROPERTY), this._transactionTimeout);
        this._parserCaseSensitivity = QueryProcessorConfiguration.getBoolean(localProps.getProperty(PARSER_CASE_SENSETIVITY_PROPERTY), this._parserCaseSensitivity);
        this._autoCommit = QueryProcessorConfiguration.getBoolean(localProps.getProperty(AUTO_COMMIT_PROPERTY), this._autoCommit);
        this._traceExecTime = QueryProcessorConfiguration.getBoolean(localProps.getProperty(TRACE_EXEC_TIME_PROPERTY), this._traceExecTime);
        this._dateFormat = localProps.getProperty(DATE_FORMAT_PROPERTY, this._dateFormat);
        this._dateTimeFormat = localProps.getProperty(DATE_TIME_FORMAT_PROPERTY, this._dateTimeFormat);
        this._timeFormat = localProps.getProperty(TIME_FORMAT_PROPERTY, this._timeFormat);
        this._spaceURL = localProps.getProperty(SPACE_URL);
        this._listenPort = QueryProcessorConfiguration.getInteger(localProps.getProperty(PORT_PROPERTY), 2872);
        String txnType = localProps.getProperty("gs.tx_manager_type", Constants.QueryProcessorInfo.QP_TRANSACTION_TYPE_DEFAULT);
        ITransactionManagerProvider.TransactionManagerType transactionManagerType = ITransactionManagerProvider.TransactionManagerType.getValue(txnType);
        if (transactionManagerType == null) {
            transactionManagerType = ITransactionManagerProvider.TransactionManagerType.DISTRIBUTED;
        }
        this._transactionManagerConfiguration = TransactionManagerConfiguration.newConfiguration(transactionManagerType);
        if (transactionManagerType == ITransactionManagerProvider.TransactionManagerType.LOOKUP_DISTRIBUTED) {
            LookupTransactionManagerConfiguration lookupConfiguration = (LookupTransactionManagerConfiguration)this._transactionManagerConfiguration;
            lookupConfiguration.setLookupTransactionName(localProps.getProperty("gs.lookup_tx.name", Constants.QueryProcessorInfo.QP_LOOKUP_TRANSACTION_NAME_DEFAULT));
            lookupConfiguration.setLookupTransactionGroups(localProps.getProperty("gs.lookup_tx.groups", SystemInfo.singleton().lookup().defaultGroups()));
            lookupConfiguration.setLookupTransactionLocators(localProps.getProperty("gs.lookup_tx.locators", Constants.QueryProcessorInfo.QP_LOOKUP_TRANSACTION_LOCATORS_DEFAULT));
            lookupConfiguration.setLookupTransactionTimeout(QueryProcessorConfiguration.getLong(localProps.getProperty("gs.lookup_tx.timeout"), 3000L));
        }
    }

    private static boolean getBoolean(String val, boolean defaultVal) {
        return val != null ? Boolean.parseBoolean(val) : defaultVal;
    }

    private static int getInteger(String val, int defaultVal) {
        return val != null ? Integer.parseInt(val) : defaultVal;
    }

    private static long getLong(String val, long defaultVal) {
        return val != null ? Long.parseLong(val) : defaultVal;
    }

    public int getReadLease() {
        return this._readLease;
    }

    public void setReadLease(int readLease) {
        this._readLease = readLease;
    }

    public long getWriteLease() {
        return this._writeLease;
    }

    public void setWriteLease(long writeLease) {
        this._writeLease = writeLease;
    }

    public long getTransactionTimeout() {
        return this._transactionTimeout;
    }

    public void setTransactionTimeout(long transactionTimeout) {
        this._transactionTimeout = transactionTimeout;
    }

    public boolean isParserCaseSensitivity() {
        return this._parserCaseSensitivity;
    }

    public void setParserCaseSensitivity(boolean parserCaseSensitivity) {
        this._parserCaseSensitivity = parserCaseSensitivity;
    }

    public String getDateFormat() {
        return this._dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this._dateFormat = dateFormat;
    }

    public String getDateTimeFormat() {
        return this._dateTimeFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this._dateTimeFormat = dateTimeFormat;
    }

    public String getTimeFormat() {
        return this._timeFormat;
    }

    public void setTimeFormat(String timeFormat) {
        this._timeFormat = timeFormat;
    }

    public boolean isTraceExecTime() {
        return this._traceExecTime;
    }

    public void setTraceExecTime(boolean traceExecTime) {
        this._traceExecTime = traceExecTime;
    }

    public boolean isAutoCommit() {
        return this._autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this._autoCommit = autoCommit;
    }

    public String getSpaceURL() {
        return this._spaceURL;
    }

    public void setSpaceURL(String spaceURL) {
        this._spaceURL = spaceURL;
    }

    public int getListenPort() {
        return this._listenPort;
    }

    public void setListenPort(int listenPort) {
        this._listenPort = listenPort;
    }

    public TransactionManagerConfiguration getTransactionManagerConfiguration() {
        return this._transactionManagerConfiguration;
    }
}

