/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.server.space.IRemoteSpace;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.service.SecurityInterceptor;
import com.j_spaces.core.IJSpace;
import com.j_spaces.jdbc.IQueryProcessor;
import com.j_spaces.jdbc.QueryProcessor;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

@InternalApi
public class QueryProcessorFactory {
    public static final String COM_GS_EMBEDDED_QP_ENABLED = "com.gs.embeddedQP.enabled";
    public static final String COM_GIGASPACES_EMBEDDED_QP_ENABLED = "com.gigaspaces.embeddedQP.enabled";
    private static final String COM_GS_EMBEDDED_QP_PROPERTIES = "com.gs.embeddedQP.properties";
    private static final String COM_GIGASPACES_EMBEDDED_QP_PROPERTIES = "com.gigaspaces.embeddedQP.properties";

    public static IQueryProcessor newInstance(IJSpace proxy, IRemoteSpace remoteSpace, Properties config) throws Exception {
        ISpaceProxy clusteredProxy;
        if (QueryProcessorFactory.isRemoteQueryProcessor(config)) {
            return remoteSpace.getQueryProcessor();
        }
        ISpaceProxy singleProxy = clusteredProxy = (ISpaceProxy)proxy;
        if (clusteredProxy.isClustered()) {
            singleProxy = (ISpaceProxy)clusteredProxy.getDirectProxy().getNonClusteredProxy();
            CredentialsProvider credentialsProvider = clusteredProxy.getDirectProxy().getSecurityManager().getCredentialsProvider();
            if (credentialsProvider != null) {
                singleProxy.getDirectProxy().getSecurityManager().login(credentialsProvider);
            }
        }
        return QueryProcessorFactory.newLocalInstance(clusteredProxy, singleProxy, config, null);
    }

    public static IQueryProcessor newLocalInstance(IJSpace clusterProxy, IJSpace spaceProxy, Properties connectionProperties, SecurityInterceptor securityInterceptor) throws Exception {
        Properties embeddedProperties = QueryProcessorFactory.loadEmbeddedPropertiesFile();
        Properties mergedProps = QueryProcessorFactory.mergeProperties(connectionProperties, embeddedProperties);
        return new QueryProcessor(clusterProxy, spaceProxy, mergedProps, securityInterceptor);
    }

    private static Properties mergeProperties(Properties overrideProperties, Properties properties) {
        Properties merged = new Properties();
        if (properties != null) {
            merged.putAll((Map<?, ?>)properties);
        }
        if (overrideProperties != null) {
            merged.putAll((Map<?, ?>)overrideProperties);
        }
        return merged;
    }

    private static Properties loadEmbeddedPropertiesFile() throws IOException {
        String propsFile = System.getProperty(COM_GIGASPACES_EMBEDDED_QP_PROPERTIES);
        if (propsFile == null) {
            propsFile = System.getProperty(COM_GS_EMBEDDED_QP_PROPERTIES);
        }
        Properties info = new Properties();
        if (propsFile == null) {
            return info;
        }
        FileInputStream fileIn = new FileInputStream(propsFile);
        info.load(fileIn);
        fileIn.close();
        return info;
    }

    private static boolean isRemoteQueryProcessor(Properties config) {
        boolean embeddedQP = false;
        String isLocalValue = config.getProperty(COM_GIGASPACES_EMBEDDED_QP_ENABLED);
        if (isLocalValue == null) {
            isLocalValue = config.getProperty(COM_GS_EMBEDDED_QP_ENABLED);
        }
        if (isLocalValue == null && (isLocalValue = System.getProperty(COM_GIGASPACES_EMBEDDED_QP_ENABLED)) == null) {
            isLocalValue = System.getProperty(COM_GS_EMBEDDED_QP_ENABLED);
        }
        if (isLocalValue != null && isLocalValue.equalsIgnoreCase("true")) {
            embeddedQP = true;
        }
        return !embeddedQP;
    }
}

