/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.jdbc.AbstractDMLQuery;
import com.j_spaces.jdbc.QueryHandler;
import com.j_spaces.jdbc.QuerySession;
import com.j_spaces.jdbc.ResponsePacket;
import com.j_spaces.jdbc.driver.GPreparedStatement;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Arrays;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.transaction.TransactionException;

@InternalApi
public class RequestPacket
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Type type;
    private String statement = null;
    private Object[] preparedValues = null;
    private GPreparedStatement.PreparedValuesCollection _preparedValuesCollection;
    private transient Integer modifiers;

    public Integer getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(Integer modifiers) {
        this.modifiers = modifiers;
    }

    public Object[] getPreparedValues() {
        return this.preparedValues;
    }

    public void setPreparedValues(Object[] preparedValues) {
        this.preparedValues = preparedValues;
    }

    public String getStatement() {
        return this.statement;
    }

    public void setStatement(String statement) {
        this.statement = statement;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void build(AbstractDMLQuery dmlQuery) {
        dmlQuery.setPreparedValues(this.getPreparedValues());
    }

    public String toString() {
        switch (this.type) {
            case STATEMENT: 
            case PREPARED_STATEMENT: {
                return this.getStatement();
            }
            case PREPARED_WITH_VALUES: {
                return this.getStatement() + ", values=" + Arrays.toString(this.preparedValues);
            }
        }
        return super.toString();
    }

    public ResponsePacket accept(QueryHandler handler, QuerySession session) throws LeaseDeniedException, RemoteException, TransactionException, SQLException {
        return handler.visit(this, session);
    }

    public void setPreparedValuesCollection(GPreparedStatement.PreparedValuesCollection preparedValuesCollection) {
        this._preparedValuesCollection = preparedValuesCollection;
    }

    public GPreparedStatement.PreparedValuesCollection getPreparedValuesCollection() {
        return this._preparedValuesCollection;
    }

    public static enum Type {
        LOGIN,
        STATEMENT,
        PREPARED_STATEMENT,
        PREPARED_WITH_VALUES,
        PREPARED_VALUES_BATCH;

    }
}

