/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.jdbc.ResultEntry;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

@InternalApi
public class ResponsePacket
implements Serializable,
Iterable<IEntryPacket> {
    private static final long serialVersionUID = 1L;
    private int intResult = -1;
    private ResultEntry resultEntry = null;
    private Collection<IEntryPacket> resultSet = null;
    private IEntryPacket[] resultArray;

    public int getIntResult() {
        return this.intResult;
    }

    public void setIntResult(int intResult) {
        this.intResult = intResult;
    }

    public ResultEntry getResultEntry() {
        return this.resultEntry;
    }

    public void setResultSet(Collection<IEntryPacket> resultSet) {
        this.resultSet = resultSet;
    }

    public void setResultEntry(ResultEntry resultEntry) {
        this.resultEntry = resultEntry;
    }

    public String toString() {
        if (this.intResult != -1) {
            return String.valueOf(this.intResult);
        }
        if (this.resultEntry != null) {
            return this.resultEntry.toString();
        }
        return null;
    }

    public void setResultArray(IEntryPacket[] resultArray) {
        this.resultArray = resultArray;
    }

    public Object getFirst() {
        if (this.resultEntry != null) {
            return this.resultEntry.getFieldValues()[0][0];
        }
        if (this.resultArray != null) {
            return this.resultArray[0];
        }
        return this.resultSet.iterator().next();
    }

    public IEntryPacket[] getArray() {
        if (this.resultArray != null) {
            return this.resultArray;
        }
        IEntryPacket[] result = (IEntryPacket[])Array.newInstance(IEntryPacket.class, this.resultSet.size());
        return this.resultSet.toArray(result);
    }

    public int size() {
        if (this.resultEntry != null) {
            return this.resultEntry.getRowNumber();
        }
        if (this.resultArray != null) {
            return this.resultArray.length;
        }
        return this.resultSet.size();
    }

    @Override
    public Iterator<IEntryPacket> iterator() {
        if (this.resultArray != null) {
            return new ArrayIterator<IEntryPacket>(this.resultArray);
        }
        return this.resultSet.iterator();
    }

    private static class ArrayIterator<T>
    implements Iterator<T> {
        public T[] _arr;
        private int _iterIndex = 0;

        public ArrayIterator(T[] resultArray) {
            this._arr = resultArray;
        }

        @Override
        public boolean hasNext() {
            return this._iterIndex < this._arr.length;
        }

        @Override
        public T next() {
            return this._arr[this._iterIndex++];
        }

        @Override
        public void remove() {
        }
    }
}

