/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.query.sql.functions.AbsSqlFunction;
import com.gigaspaces.query.sql.functions.AppendSqlFunction;
import com.gigaspaces.query.sql.functions.CeilSqlFunction;
import com.gigaspaces.query.sql.functions.CharLengthSqlFunction;
import com.gigaspaces.query.sql.functions.ConcatSqlFunction;
import com.gigaspaces.query.sql.functions.FloorSqlFunction;
import com.gigaspaces.query.sql.functions.InStrSqlFunction;
import com.gigaspaces.query.sql.functions.LowerSqlFunction;
import com.gigaspaces.query.sql.functions.ModSqlFunction;
import com.gigaspaces.query.sql.functions.RoundSqlFunction;
import com.gigaspaces.query.sql.functions.SqlFunction;
import com.gigaspaces.query.sql.functions.SqlFunctionExecutionContext;
import com.gigaspaces.query.sql.functions.ToCharSqlFunction;
import com.gigaspaces.query.sql.functions.ToNumberSqlFunction;
import com.gigaspaces.query.sql.functions.UpperSqlFunction;
import com.j_spaces.jdbc.builder.range.FunctionCallDescription;
import java.util.HashMap;
import java.util.Map;

@InternalApi
public class SQLFunctions {
    private final Map<String, SqlFunction> functions = new HashMap<String, SqlFunction>();
    private static final Map<String, SqlFunction> builtInFunctions = new HashMap<String, SqlFunction>();

    public SQLFunctions(Map<String, SqlFunction> userFunctions) {
        if (userFunctions != null) {
            this.functions.putAll(userFunctions);
        }
    }

    public static Object apply(SqlFunction func, SqlFunctionExecutionContext ctx) throws RuntimeException {
        return func.apply(ctx);
    }

    public SqlFunction create(FunctionCallDescription functionCallDescription) {
        SqlFunction userFunction = this.functions.get(functionCallDescription.getName().toUpperCase());
        if (userFunction != null) {
            return userFunction;
        }
        return builtInFunctions.get(functionCallDescription.getName().toUpperCase());
    }

    public static boolean isBuiltIn(String functionName) {
        return builtInFunctions.keySet().contains(functionName.toUpperCase());
    }

    public static SqlFunction getBuildInFunction(String functionName) {
        return builtInFunctions.get(functionName);
    }

    static {
        builtInFunctions.put("ABS", new AbsSqlFunction());
        builtInFunctions.put("MOD", new ModSqlFunction());
        builtInFunctions.put("ROUND", new RoundSqlFunction());
        builtInFunctions.put("CEIL", new CeilSqlFunction());
        builtInFunctions.put("FLOOR", new FloorSqlFunction());
        builtInFunctions.put("CHAR_LENGTH", new CharLengthSqlFunction());
        builtInFunctions.put("LOWER", new LowerSqlFunction());
        builtInFunctions.put("UPPER", new UpperSqlFunction());
        builtInFunctions.put("APPEND", new AppendSqlFunction());
        builtInFunctions.put("CONCAT", new ConcatSqlFunction());
        builtInFunctions.put("INSTR", new InStrSqlFunction());
        builtInFunctions.put("TO_NUMBER", new ToNumberSqlFunction());
        builtInFunctions.put("TO_CHAR", new ToCharSqlFunction());
    }
}

