/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.ITypeIntrospector;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.utils.ObjectConverter;
import com.gigaspaces.metadata.SpaceMetadataException;
import com.gigaspaces.metadata.SpacePropertyDescriptor;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.UnknownTypeException;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.jdbc.driver.Blob;
import com.j_spaces.jdbc.driver.Clob;
import com.j_spaces.jdbc.query.QueryColumnData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Arrays;

@InternalApi
public class SQLUtil {
    private static final int DEFAULT_BUFFER_SIZE = 2048;

    public static Object cast(ITypeDesc typeDesc, String propertyName, Object obj, boolean isPreparedValue) throws SQLException {
        if (obj == null) {
            return null;
        }
        Class<?> type = SQLUtil.getPropertyType(typeDesc, propertyName);
        if (type == Void.TYPE) {
            return obj;
        }
        if (isPreparedValue) {
            if (type.getName().equals(Clob.class.getName())) {
                return new Clob((String)obj);
            }
            if (type.getName().equals(Blob.class.getName())) {
                return new Blob((byte[])obj);
            }
            return obj;
        }
        return ObjectConverter.convert(obj, type);
    }

    private static Class<?> getPropertyType(ITypeDesc typeDesc, String propertyName) throws SQLException {
        if (propertyName.contains("[*]")) {
            return Void.TYPE;
        }
        SpacePropertyDescriptor property = typeDesc.getFixedProperty(propertyName);
        if (property != null) {
            return property.getType();
        }
        ITypeIntrospector introspector = typeDesc.getIntrospector(typeDesc.getObjectType());
        if (introspector.supportsNestedOperations()) {
            return introspector.getPathType(propertyName);
        }
        if (typeDesc.supportsDynamicProperties()) {
            return Void.TYPE;
        }
        throw new SQLException("Property '" + propertyName + "' doesn't exist in type '" + typeDesc.getTypeName() + "'. Valid properties are " + Arrays.toString(typeDesc.getPropertiesNames()) + ".");
    }

    public static Object getFieldValue(IEntryPacket e, ITypeDesc typeDesc, String propertyName) {
        SpacePropertyDescriptor property = typeDesc.getFixedProperty(propertyName);
        if (property != null) {
            return e.getPropertyValue(propertyName);
        }
        ITypeIntrospector introspector = typeDesc.getIntrospector(typeDesc.getObjectType());
        if (!introspector.supportsNestedOperations()) {
            return null;
        }
        return introspector.getPathValue(e, propertyName);
    }

    public static Object getFieldValue(IEntryPacket entry, QueryColumnData columnData) {
        if (columnData.isNestedQueryColumn()) {
            return SQLUtil.getFieldValue(entry, entry.getTypeDescriptor(), columnData.getColumnPath());
        }
        if (columnData.getColumnIndexInTable() == -1) {
            if (columnData.getColumnTableData() != null && columnData.getColumnTableData().getTypeDesc().supportsDynamicProperties()) {
                return entry.getPropertyValue(columnData.getColumnName());
            }
            throw new IllegalArgumentException("No table was found for column '" + columnData.getColumnName() + "'");
        }
        if (entry.getTypeDescriptor().getIdentifierPropertyId() == columnData.getColumnIndexInTable()) {
            return entry.getID();
        }
        return entry.getFieldValue(columnData.getColumnIndexInTable());
    }

    public static IRemoteJSpaceAdmin getAdmin(IJSpace space) throws RemoteException {
        return (IRemoteJSpaceAdmin)((ISpaceProxy)space).getPrivilegedAdmin();
    }

    public static ITypeDesc checkTableExistence(String tableName, IJSpace space) throws SQLException {
        try {
            return ((ISpaceProxy)space).getDirectProxy().getTypeManager().getTypeDescByName(tableName);
        }
        catch (SpaceMetadataException ex) {
            if (ex.getCause() instanceof UnknownTypeException) {
                throw new SQLException("Table [" + tableName + "] does not exist", "GSP", -105);
            }
            throw ex;
        }
    }

    public static byte[] convertInputStreamToByteArray(InputStream inputStream, int inputStreamLength) throws IOException {
        int read;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int blockSize = 2048;
        byte[] buffer = new byte[blockSize];
        for (int left = inputStreamLength; left > 0 && (read = inputStream.read(buffer, 0, left > blockSize ? blockSize : left)) != -1; left -= read) {
            out.write(buffer, 0, read);
        }
        return out.toByteArray();
    }

    public static String convertAsciiInputStreamToString(InputStream inputStream, int inputStreamLength) throws IOException {
        int read;
        InputStreamReader in = new InputStreamReader(inputStream);
        StringWriter writer = new StringWriter();
        int blockSize = 2048;
        char[] buffer = new char[blockSize];
        for (int left = inputStreamLength; left > 0 && (read = in.read(buffer, 0, left > blockSize ? blockSize : left)) != -1; left -= read) {
            writer.write(buffer, 0, read);
        }
        writer.close();
        return writer.toString();
    }

    public static String convertReaderToString(Reader reader, int readerLength) throws IOException {
        int read;
        StringWriter writer = new StringWriter();
        int blockSize = 2048;
        char[] buffer = new char[blockSize];
        for (int left = readerLength; left > 0 && (read = reader.read(buffer, 0, left > blockSize ? blockSize : left)) != -1; left -= read) {
            writer.write(buffer, 0, read);
        }
        writer.close();
        return writer.toString();
    }
}

