/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.jdbc.AbstractDMLQuery;
import com.j_spaces.jdbc.SQLUtil;
import com.j_spaces.jdbc.query.QueryColumnData;
import com.j_spaces.jdbc.query.QueryTableData;
import java.sql.SQLException;

@InternalApi
public class SelectColumn {
    private String name = null;
    private String alias = null;
    private boolean isSum = false;
    private boolean isCount = false;
    private int projectedIndex = -1;
    private Object initValue;
    private boolean isInitValue = false;
    private String funcName;
    private boolean isVisible = true;
    private QueryColumnData _columnData;
    private final boolean _isDynamic;

    public SelectColumn() {
        this._isDynamic = false;
    }

    public SelectColumn(String columnPath) {
        this.name = columnPath;
        this._isDynamic = false;
    }

    public SelectColumn(String columnName, String columnAlias) {
        this(columnName);
        this.alias = columnAlias;
    }

    public SelectColumn(QueryTableData tableData, String columnPath) throws SQLException {
        this(columnPath);
        this._columnData = new QueryColumnData(tableData, columnPath);
    }

    public SelectColumn(QueryTableData tableData, String columnPath, boolean isDynamic) throws SQLException {
        this.name = columnPath;
        this._columnData = new QueryColumnData(tableData, columnPath);
        this._isDynamic = isDynamic;
    }

    public void createColumnData(AbstractDMLQuery query) throws SQLException {
        this._columnData = QueryColumnData.newColumnData(this.name, query);
        this.name = this._columnData.getColumnPath();
    }

    public boolean hasAlias() {
        return this.alias != null;
    }

    public String getAlias() {
        if (this.hasAlias()) {
            return this.alias;
        }
        return this.toString();
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAllColumns() {
        return this._columnData.isAsterixColumn();
    }

    public boolean isCount() {
        return this.isCount;
    }

    public boolean isSum() {
        return this.isSum;
    }

    public void setCount(boolean isCount) {
        this.isCount = isCount;
    }

    public boolean isUid() {
        return this._columnData.isUidColumn();
    }

    public void setValue(Object initValues) {
        this.initValue = initValues;
        this.isInitValue = true;
    }

    public Object getValue() {
        return this.initValue;
    }

    public boolean isInitValues() {
        return this.isInitValue;
    }

    public void setSum(boolean isSum) {
        this.isSum = isSum;
    }

    public boolean isFunction() {
        return this.isSum || this.isCount;
    }

    public boolean isAggregatedFunction() {
        return this.funcName != null;
    }

    public boolean isDynamic() {
        return this._isDynamic;
    }

    public boolean equals(Object ob) {
        if (ob instanceof SelectColumn) {
            SelectColumn another = (SelectColumn)ob;
            return this.getName().equals(another.getName());
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.funcName != null) {
            buffer.append(this.funcName + "(");
            buffer.append(this.getName());
            buffer.append(")");
        } else {
            buffer.append(this.getName());
        }
        return buffer.toString();
    }

    public void setFunctionName(String funcName) {
        this.funcName = funcName;
    }

    public String getFunctionName() {
        return this.funcName;
    }

    public void setVisible(boolean flag) {
        this.isVisible = flag;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public int getProjectedIndex() {
        return this.projectedIndex;
    }

    public void setProjectedIndex(int projectedIndex) {
        this.projectedIndex = projectedIndex;
    }

    public QueryTableData getColumnTableData() {
        return this._columnData.getColumnTableData();
    }

    public int getColumnIndexInTable() {
        return this._columnData.getColumnIndexInTable();
    }

    public QueryColumnData getColumnData() {
        return this._columnData;
    }

    public Object getFieldValue(IEntryPacket entry) {
        if (this.isUid()) {
            return entry.getUID();
        }
        if (this.isInitValues()) {
            return this.getValue();
        }
        return SQLUtil.getFieldValue(entry, this._columnData);
    }
}

