/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.transaction.ITransactionManagerProvider;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.exceptions.BatchQueryException;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.PropertyInfo;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ProjectionTemplate;
import com.gigaspaces.internal.utils.ReflectionUtils;
import com.gigaspaces.query.aggregators.AggregationSet;
import com.gigaspaces.security.AccessDeniedException;
import com.gigaspaces.security.authorities.SpaceAuthority;
import com.gigaspaces.security.service.SecurityContext;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.SpaceContext;
import com.j_spaces.core.SpaceContextHelper;
import com.j_spaces.core.admin.SpaceRuntimeInfo;
import com.j_spaces.core.client.Modifiers;
import com.j_spaces.jdbc.AbstractDMLQuery;
import com.j_spaces.jdbc.AggregationsUtil;
import com.j_spaces.jdbc.JoinedEntry;
import com.j_spaces.jdbc.OrderColumn;
import com.j_spaces.jdbc.QueryProcessor;
import com.j_spaces.jdbc.ResponsePacket;
import com.j_spaces.jdbc.ResultEntry;
import com.j_spaces.jdbc.SQLUtil;
import com.j_spaces.jdbc.SelectColumn;
import com.j_spaces.jdbc.batching.BatchResponsePacket;
import com.j_spaces.jdbc.builder.QueryEntryPacket;
import com.j_spaces.jdbc.builder.QueryTemplatePacket;
import com.j_spaces.jdbc.driver.GPreparedStatement;
import com.j_spaces.jdbc.executor.JoinedQueryExecutor;
import com.j_spaces.jdbc.executor.QueryExecutor;
import com.j_spaces.jdbc.parser.ExpNode;
import com.j_spaces.jdbc.parser.RowNumNode;
import com.j_spaces.jdbc.query.ArrayListResult;
import com.j_spaces.jdbc.query.IQueryResultSet;
import com.j_spaces.jdbc.query.ProjectedResultSet;
import com.j_spaces.jdbc.query.QueryColumnData;
import com.j_spaces.jdbc.query.QueryTableData;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.TransactionFactory;
import net.jini.core.transaction.server.TransactionManager;

@InternalApi
public class SelectQuery
extends AbstractDMLQuery {
    private static final String SYSTABLES = "SYSTABLES";
    private static final String SYSTABLES_TABLENAME = "TABLENAME";
    private ArrayList<OrderColumn> orderColumns = null;
    private ArrayList<SelectColumn> groupColumn = null;
    private boolean isAggFunction = false;
    private boolean forUpdate = false;
    private boolean isAddAbsentCol = false;
    private boolean isDistinct = false;
    private static final boolean useAggregationsApi = Boolean.parseBoolean(System.getProperty("com.gigaspaces.query.useAggregationsApi", "true"));
    protected AggregationSet _aggregationSet;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.query");
    private boolean isSelectAll;

    private ArrayList<SelectColumn> getAggregateFunc() {
        List<SelectColumn> aList = this.getQueryColumns();
        if (aList == null || aList.isEmpty()) {
            return new ArrayList<SelectColumn>(0);
        }
        ArrayList<SelectColumn> aFuncList = new ArrayList<SelectColumn>(aList.size());
        for (int i = 0; i < aList.size(); ++i) {
            SelectColumn col = aList.get(i);
            if (!col.isAggregatedFunction()) continue;
            aFuncList.add(col);
        }
        return aFuncList;
    }

    public void addAbsentCol() {
        this.isAddAbsentCol = true;
    }

    public void setAggFunction(boolean flag) {
        this.isAggFunction = flag;
    }

    public boolean isAggFunction() {
        return this.isAggFunction;
    }

    private boolean isCount() {
        List<SelectColumn> aList = this.getQueryColumns();
        if (aList == null || aList.isEmpty()) {
            return false;
        }
        return aList.get(0).isCount();
    }

    @Override
    public ResponsePacket executeOnSpace(ISpaceProxy space, Transaction txn) throws SQLException {
        IQueryResultSet<IEntryPacket> entries = null;
        ResponsePacket packet = new ResponsePacket();
        try {
            if (this.getSecurityInterceptor() != null) {
                SpaceContext spaceContext = this.getSession().getConnectionContext().getSpaceContext();
                SecurityContext securityContext = SpaceContextHelper.getSecurityContext(spaceContext);
                this.getSecurityInterceptor().intercept(securityContext, SpaceAuthority.SpacePrivilege.READ, this.getTableName());
            }
            if (this.getSession() != null && this.getSession().getModifiers() != null) {
                this.validateCommonJavaTypeOnDocumentOrStringReturnProperties();
            }
            txn = this.startTransaction(space, txn);
            this.prepare(space, txn);
            if (this.useAggregationApi(txn)) {
                this.createProjectionTemplate();
            }
            if (this.getTableName().equals(SYSTABLES)) {
                return this.executeSysTablesQuery(space, packet);
            }
            if (this.isJoined()) {
                this._executor = new JoinedQueryExecutor(this);
                entries = this.executeJoinedQuery(space, txn);
            } else if (this.expTree == null) {
                this._executor = new QueryExecutor(this);
                if (this.isCount() && !this.isGroupBy()) {
                    return this.executeCountAll(space, txn);
                }
                if (this.useAggregationApi(txn)) {
                    this._aggregationSet = AggregationsUtil.createAggregationSet(this, this.getRownumLimit());
                }
                entries = this.executeEmptyQuery(space, txn, entries);
            } else {
                this._executor = new QueryExecutor(this);
                if (this.expTree.getTemplate() == null || this.expTree.getTemplate().isComplex()) {
                    entries = this.executeQuery(space, txn);
                } else if (this.expTree.getTemplate().isAlwaysEmpty()) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Logical error - query is always empty - fix your SQL syntax");
                    }
                    if (this.isBuildOnly()) {
                        throw new SQLException("Logical error - query is always empty - fix your SQL syntax");
                    }
                    entries = new ArrayListResult();
                } else {
                    if (this.isBuildOnly()) {
                        entries = new ArrayListResult();
                        this.build();
                        entries.add(this.expTree.getTemplate());
                        packet.setResultSet(entries);
                        return packet;
                    }
                    if (this.isCount() && !this.isGroupBy() && !this.isDistinct() && this.getAggregateFunc().size() == 1) {
                        return this.executeCount(this.expTree.getTemplate(), space, txn);
                    }
                    entries = this.executeQuery(space, txn);
                }
            }
            if (entries.isEmpty()) {
                return this.emptyResult(entries);
            }
            if (this.isConvertResultToArray()) {
                this.addDynamicSelectColumns(entries);
            }
            this.createProjectionIndices(entries);
            if (!this.useAggregationApi(txn)) {
                if (this.isGroupBy()) {
                    entries = this.groupBy(entries);
                } else if (this.isAggFunction()) {
                    entries = this.aggregate(entries);
                }
            }
            if (this.isDistinct()) {
                this._executor.filterDistinctEntries(entries);
            }
            if (this.isOrderBy() && (!this.useAggregationApi(txn) || this.getGroupColumn() != null)) {
                this.orderBy(entries);
            }
            this.filterByRownum(entries);
            this.prepareResult(packet, entries);
        }
        catch (AccessDeniedException e) {
            throw e;
        }
        catch (BatchQueryException e) {
            throw e;
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new SQLException("Select failed; Cause: " + e, "GSP", -120, e);
        }
        return packet;
    }

    private IQueryResultSet<IEntryPacket> aggregate(IQueryResultSet<IEntryPacket> entries) throws SQLException {
        IEntryPacket aggregation = this._executor.aggregate(entries);
        entries = new ProjectedResultSet();
        entries.add(aggregation);
        return entries;
    }

    private IQueryResultSet<IEntryPacket> groupBy(IQueryResultSet<IEntryPacket> entries) throws SQLException {
        return this._executor.groupBy(entries, this.groupColumn);
    }

    private void prepareResult(ResponsePacket packet, IQueryResultSet<IEntryPacket> entries) throws SQLException {
        if (this.isConvertResultToArray()) {
            ResultEntry result = this.isAggFunction() ? this.buildAggregationResult(entries) : this._executor.convertEntriesToResultArrays(entries);
            packet.setResultEntry(result);
        } else {
            packet.setResultSet(entries);
        }
    }

    private void orderBy(IQueryResultSet<IEntryPacket> entries) throws SQLException {
        this._executor.orderBy(entries, this.orderColumns);
    }

    private IQueryResultSet<IEntryPacket> executeQuery(ISpaceProxy space, Transaction txn) throws SQLException {
        if (this.useAggregationApi(txn) && this.expTree.getTemplate() != null) {
            this._aggregationSet = AggregationsUtil.createAggregationSet(this, this.getRownumLimit());
            this.expTree.getTemplate().setAggregationSet(this._aggregationSet);
        }
        return this._executor.execute(space, txn, this.getReadModifier(), this.getEntriesLimit());
    }

    private int getEntriesLimit() {
        if (this.isOrderBy() || this.isGroupBy() || this.isDistinct() || this.isAggFunction()) {
            return Integer.MAX_VALUE;
        }
        return super.getRownumLimit();
    }

    private Transaction startTransaction(IJSpace space, Transaction txn) throws LeaseDeniedException, RemoteException, TransactionException {
        if (this.forUpdate && txn == null) {
            ITransactionManagerProvider managerProvider = this.getSession().getQueryHandler().getTransactionManagerProvider();
            txn = TransactionFactory.create((TransactionManager)managerProvider.getTransactionManager(), (long)(QueryProcessor.getDefaultConfig().getTransactionTimeout() * 100L)).transaction;
            this.getSession().setTransaction(txn);
        }
        return txn;
    }

    private ResponsePacket executeSysTablesQuery(IJSpace space, ResponsePacket packet) throws RemoteException {
        Object[] classList = SQLUtil.getAdmin((IJSpace)space).getRuntimeInfo().m_ClassNames.toArray();
        String[] fieldNames = new String[]{SYSTABLES_TABLENAME};
        Object[][] fieldValues = new Object[classList.length][1];
        for (int i = 0; i < classList.length; ++i) {
            fieldValues[i][0] = classList[i];
        }
        ResultEntry result = new ResultEntry(fieldNames, new String[]{this.getQueryColumns().get(0).getAlias()}, new String[]{SYSTABLES}, fieldValues);
        packet.setResultEntry(result);
        return packet;
    }

    private ResponsePacket executeCount(QueryTemplatePacket template, IJSpace space, Transaction txn) throws SQLException {
        try {
            template.setRouting(this.getRouting());
            template.setExplainPlan(this.getExplainPlan());
            int count = space.count(template, txn, this.getReadModifier());
            ResponsePacket response = new ResponsePacket();
            Object[][] values = new Object[1][1];
            values[0][0] = count;
            ResultEntry result = new ResultEntry(new String[]{this.getCountColumnName()}, new String[]{this.getCountColumnLabel()}, new String[]{""}, values);
            response.setResultEntry(result);
            return response;
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new SQLException("Failed to execute count: " + e, "GSP", -111);
        }
    }

    private String getCountColumnName() {
        return this.getQueryColumns().get(0).toString();
    }

    private String getCountColumnLabel() {
        return this.getQueryColumns().get(0).getAlias();
    }

    private ResultEntry buildAggregationResult(IQueryResultSet<IEntryPacket> entries) {
        int i = 0;
        String[] fieldNames = null;
        Object[][] fieldValues = null;
        for (IEntryPacket packet : entries) {
            QueryEntryPacket entry = (QueryEntryPacket)packet;
            if (fieldNames == null) {
                fieldNames = entry.getFieldNames();
                fieldValues = new Object[entries.size()][fieldNames.length];
            }
            fieldValues[i++] = entry.getFieldValues();
        }
        String[] tableNames = new String[fieldNames.length];
        for (int j = 0; j < tableNames.length; ++j) {
            tableNames[j] = "";
        }
        String[] columnLabels = new String[fieldNames.length];
        int fieldIndex = 0;
        for (SelectColumn column : this.getQueryColumns()) {
            if (!column.isVisible()) continue;
            columnLabels[fieldIndex++] = column.getAlias();
        }
        ResultEntry result = new ResultEntry(fieldNames, columnLabels, tableNames, fieldValues);
        return result;
    }

    private ResponsePacket emptyResult(IQueryResultSet<IEntryPacket> entries) {
        Object[][] fieldValues;
        String[] tableNames;
        String[] columnLabels;
        String[] fieldNames;
        if (this.isCount()) {
            fieldNames = new String[]{this.getCountColumnName()};
            columnLabels = new String[]{this.getCountColumnLabel()};
            tableNames = new String[]{""};
            fieldValues = new Object[][]{{0}};
        } else {
            int numOfColumns = this.getQueryColumns().size();
            ArrayList<String> columnNamesList = new ArrayList<String>(numOfColumns);
            ArrayList<String> columnLabelsList = new ArrayList<String>(numOfColumns);
            ArrayList<String> tableNamesList = new ArrayList<String>(numOfColumns);
            for (SelectColumn resultColumn : this.getQueryColumns()) {
                if (!resultColumn.isVisible()) continue;
                columnNamesList.add(resultColumn.toString());
                columnLabelsList.add(resultColumn.getAlias());
                tableNamesList.add(resultColumn.getColumnTableData().getTableName());
            }
            fieldNames = columnNamesList.toArray(new String[columnNamesList.size()]);
            columnLabels = columnLabelsList.toArray(new String[columnLabelsList.size()]);
            tableNames = tableNamesList.toArray(new String[tableNamesList.size()]);
            fieldValues = new Object[0][0];
        }
        ResultEntry result = new ResultEntry(fieldNames, columnLabels, tableNames, fieldValues);
        ResponsePacket packet = new ResponsePacket();
        packet.setResultEntry(result);
        packet.setResultSet(entries);
        return packet;
    }

    private ResponsePacket executeCountAll(IJSpace space, Transaction txn) throws RemoteException, TransactionException, UnusableEntryException {
        Integer count;
        ResponsePacket packet;
        block5: {
            packet = new ResponsePacket();
            boolean embeddedQpNeedsSecurityCheck = space.isSecured() && this.getSecurityInterceptor() == null;
            count = 0;
            if (((ISpaceProxy)space).isClustered() || embeddedQpNeedsSecurityCheck) {
                QueryTemplatePacket template = new QueryTemplatePacket(this.getTableData(), this._queryResultType);
                template.setRouting(this.getRouting());
                count = space.count(template, txn);
            } else {
                try {
                    SpaceRuntimeInfo info = SQLUtil.getAdmin(space).getRuntimeInfo(this.getTableName());
                    for (int entryCount : info.m_NumOFEntries) {
                        count = count + entryCount;
                    }
                }
                catch (IllegalArgumentException ex) {
                    if (!_logger.isLoggable(Level.FINE)) break block5;
                    _logger.log(Level.FINE, "Trying to count single space when the metadata is not available.", ex);
                }
            }
        }
        ResultEntry result = new ResultEntry(new String[]{this.getCountColumnName()}, new String[]{this.getCountColumnLabel()}, new String[]{""}, new Object[][]{{count}});
        packet.setResultEntry(result);
        return packet;
    }

    @Override
    public SelectQuery clone() {
        SelectQuery query = new SelectQuery();
        query.tables = this.tables;
        query._tablesData = this._tablesData;
        query.rownum = (RowNumNode)(this.rownum == null ? null : this.rownum.clone());
        query.orderColumns = this.orderColumns;
        query.groupColumn = this.groupColumn;
        query.isPrepared = this.isPrepared;
        query.forUpdate = this.forUpdate;
        query.isAggFunction = this.isAggFunction;
        query.isDistinct = this.isDistinct;
        query.setRouting(this.getRouting());
        query.setProjectionTemplate(this.getProjectionTemplate());
        query.setContainsSubQueries(this.containsSubQueries());
        query.isSelectAll = this.isSelectAll;
        int numOfColumns = 0;
        for (SelectColumn col : this.getQueryColumns()) {
            if (col.isDynamic()) continue;
            ++numOfColumns;
        }
        query.queryColumns = new ArrayList(numOfColumns);
        if (numOfColumns != 0) {
            for (SelectColumn col : this.getQueryColumns()) {
                if (col.isDynamic()) continue;
                query.queryColumns.add(col);
            }
        }
        if (this.getExpTree() != null) {
            query.setExpTree((ExpNode)this.getExpTree().clone());
        }
        return query;
    }

    public void addColumn(SelectColumn column) {
        if (this.queryColumns == null) {
            this.queryColumns = new ArrayList();
        }
        this.queryColumns.add(column);
    }

    public void setOrderColumns(ArrayList<OrderColumn> ordCol) {
        this.orderColumns = ordCol;
    }

    public void setGroupColumn(ArrayList<SelectColumn> groupColumnList) {
        this.groupColumn = groupColumnList;
    }

    public ArrayList<SelectColumn> getGroupColumn() {
        return this.groupColumn;
    }

    private boolean isGroupBy() {
        return this.groupColumn != null;
    }

    private boolean isOrderBy() {
        return this.orderColumns != null && !this.orderColumns.isEmpty();
    }

    public void setForUpdate(boolean forUpdate) {
        this.forUpdate = forUpdate;
    }

    @Override
    public void validateQuery(ISpaceProxy space) throws SQLException {
        if (this.getTableName().equals(SYSTABLES)) {
            return;
        }
        super.validateQuery(space);
        if (this.isBuildOnly()) {
            this.validateNotifyQuery();
        }
        this.validateAndPrepareSelectColumns();
        if (this.isOrderBy()) {
            for (SelectColumn selectColumn : this.orderColumns) {
                selectColumn.createColumnData(this);
            }
        }
        if (this.isGroupBy()) {
            for (SelectColumn selectColumn : this.groupColumn) {
                selectColumn.createColumnData(this);
            }
        }
        this.validateCommonJavaTypeOnDocumentOrStringReturnProperties();
    }

    private void validateCommonJavaTypeOnDocumentOrStringReturnProperties() {
        if (Modifiers.contains(this.getReadModifier(), 0x200000) || Modifiers.contains(this.getReadModifier(), 0x400000)) {
            if (this.isOrderBy()) {
                for (SelectColumn selectColumn : this.orderColumns) {
                    if (SelectQuery.isCommonJavaType(selectColumn)) continue;
                    QueryColumnData columnData = selectColumn.getColumnData();
                    int propertyIndex = columnData.getColumnIndexInTable();
                    throw new UnsupportedOperationException("ORDER BY can only be performed by specifying java common types while provided type is: " + columnData.getColumnTableData().getTypeDesc().getPropertiesTypes()[propertyIndex]);
                }
            }
            if (this.isGroupBy()) {
                for (SelectColumn selectColumn : this.groupColumn) {
                    if (SelectQuery.isCommonJavaType(selectColumn)) continue;
                    QueryColumnData columnData = selectColumn.getColumnData();
                    int propertyIndex = columnData.getColumnIndexInTable();
                    throw new UnsupportedOperationException("GROUP BY can only be performed by specifying java common types while provided type is: " + columnData.getColumnTableData().getTypeDesc().getPropertiesTypes()[propertyIndex]);
                }
            }
        }
    }

    private static boolean isCommonJavaType(SelectColumn column) {
        QueryColumnData columnData = column.getColumnData();
        int propertyIndex = columnData.getColumnIndexInTable();
        String columnPath = columnData.getColumnPath();
        boolean commonJavaType = false;
        if (columnPath.contains(".")) {
            try {
                Class<?> type = SelectQuery.getFieldClassType(columnData);
                commonJavaType = ReflectionUtils.isCommonJavaType(type) || type.isEnum();
            }
            catch (Exception e) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "Failed verifying common Java type for [" + columnPath + "]", e);
                }
            }
        } else {
            PropertyInfo propertyInfo = columnData.getColumnTableData().getTypeDesc().getProperties()[propertyIndex];
            commonJavaType = propertyInfo.isCommonJavaType() || propertyInfo.getType() != null && propertyInfo.getType().isEnum();
        }
        return commonJavaType;
    }

    private static Class<?> getFieldClassType(QueryColumnData columnData) throws NoSuchFieldException {
        String columnPath = columnData.getColumnPath();
        String[] paths = columnPath.split("\\.");
        Class<Object> fieldClassType = null;
        for (String path : paths) {
            if (fieldClassType == null) {
                fieldClassType = columnData.getColumnTableData().getTypeDesc().getObjectClass();
            }
            fieldClassType = fieldClassType.getDeclaredField(path).getType();
        }
        return fieldClassType;
    }

    private void validateAndPrepareSelectColumns() throws SQLException {
        for (int i = 0; i < this.getQueryColumns().size(); ++i) {
            SelectColumn sc = this.getQueryColumns().get(i);
            sc.createColumnData(this);
            if (!sc.isAllColumns() || sc.isFunction()) continue;
            this.isSelectAll = true;
            this.getQueryColumns().remove(i);
            if (sc.getColumnTableData() == null) {
                for (int t = 0; t < this._tablesData.size(); ++t) {
                    QueryTableData queryTableData = (QueryTableData)this._tablesData.get(t);
                    List<SelectColumn> toAdd = this.getWildcardColumns(queryTableData);
                    this.getQueryColumns().addAll(i, toAdd);
                    i += toAdd.size();
                }
            } else {
                List<SelectColumn> toAdd = this.getWildcardColumns(sc.getColumnTableData());
                this.getQueryColumns().addAll(i, toAdd);
                i += toAdd.size();
            }
            --i;
        }
        this.addAbsentColumns();
    }

    private List<SelectColumn> getWildcardColumns(QueryTableData queryTableData) throws SQLException {
        ITypeDesc info = queryTableData.getTypeDesc();
        ArrayList<SelectColumn> toAdd = new ArrayList<SelectColumn>(info.getNumOfFixedProperties());
        for (int i = 0; i < info.getNumOfFixedProperties(); ++i) {
            SelectColumn newColumn = new SelectColumn(queryTableData, info.getFixedProperty(i).getName());
            toAdd.add(newColumn);
        }
        return toAdd;
    }

    private void addAbsentColumns() throws SQLException {
        if (this.isAddAbsentCol) {
            QueryTableData tableData = (QueryTableData)this.tables.get(this.getTableName());
            ITypeDesc info = tableData.getTypeDesc();
            for (int c = 0; c < info.getNumOfFixedProperties(); ++c) {
                boolean found = false;
                for (SelectColumn col : this.getQueryColumns()) {
                    if (col.getColumnData().getColumnName() == null || !col.getColumnData().getColumnName().equals(info.getFixedProperty(c).getName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                SelectColumn newColumn = new SelectColumn(tableData, info.getFixedProperty(c).getName());
                newColumn.setVisible(false);
                this.getQueryColumns().add(newColumn);
            }
        }
    }

    private void validateNotifyQuery() throws SQLException {
        if (this.isJoined()) {
            throw new SQLException("Operation doesn't support multiple tables.");
        }
        if (this.isGroupBy()) {
            throw new SQLException("Operation doesn't support 'group by'.");
        }
        if (this.isJoined()) {
            throw new SQLException("Operation doesn't support join queries.");
        }
        if (this.isOrderBy()) {
            throw new SQLException("Operation doesn't support 'order by'.");
        }
        if (this.isAggFunction()) {
            throw new SQLException("Operation doesn't support aggregation.");
        }
        if (this.isDistinct()) {
            throw new SQLException("Operation doesn't support 'distinct'.");
        }
        if (this.forUpdate) {
            throw new SQLException("Operation doesn't support 'for update'.");
        }
    }

    private boolean isDistinct() {
        return this.isDistinct;
    }

    public void setDistinct(boolean isDistinct) {
        this.isDistinct = isDistinct;
    }

    private IQueryResultSet<IEntryPacket> executeEmptyQuery(ISpaceProxy space, Transaction txn, IQueryResultSet<IEntryPacket> entries) throws Exception {
        int size = this.getEntriesLimit();
        QueryTemplatePacket template = new QueryTemplatePacket(this.getTableData(), this._queryResultType);
        if (this.isBuildOnly()) {
            entries = new ArrayListResult();
            entries.add(template);
            return entries;
        }
        if (this.useAggregationApi(txn)) {
            template.setAggregationSet(this._aggregationSet);
        }
        return template.read(space, this, txn, this.getReadModifier(), size);
    }

    private boolean useAggregationApi(Transaction txn) {
        if (!useAggregationsApi) {
            return false;
        }
        if (txn != null) {
            return false;
        }
        if (this.isJoined()) {
            return false;
        }
        if (this.getGroupColumn() != null) {
            return true;
        }
        if (this.getOrderColumns() != null && !this.isAggFunction()) {
            return true;
        }
        return this.isAggFunction();
    }

    private IQueryResultSet<IEntryPacket> executeJoinedQuery(ISpaceProxy space, Transaction txn) throws RemoteException, TransactionException, UnusableEntryException, SQLException {
        return this._executor.execute(space, txn, this.getReadModifier(), this.getEntriesLimit());
    }

    private void createProjectionIndices(IQueryResultSet<IEntryPacket> entries) {
        if (this.isJoined()) {
            for (IEntryPacket entry : entries) {
                JoinedEntry joinedEntry = (JoinedEntry)entry;
                joinedEntry.createProjection(this.getQueryColumns());
            }
        }
        int projIndex = 0;
        boolean isProjected = this.isGroupBy() || this.isAggFunction() || this.isJoined();
        for (SelectColumn selectColumn : this.getQueryColumns()) {
            if (!selectColumn.isVisible()) continue;
            if (isProjected) {
                selectColumn.setProjectedIndex(projIndex++);
                continue;
            }
            selectColumn.setProjectedIndex(selectColumn.getColumnIndexInTable());
        }
        if (this.isOrderBy() && this._projectionTemplate == null) {
            projIndex = 0;
            for (SelectColumn selectColumn : this.getOrderColumns()) {
                if (isProjected) {
                    selectColumn.setProjectedIndex(projIndex++);
                    continue;
                }
                selectColumn.setProjectedIndex(selectColumn.getColumnIndexInTable());
            }
        }
    }

    private void createProjectionTemplate() {
        if (this._projectionTemplate != null || !this.isConvertResultToArray() || this.isSelectAll) {
            return;
        }
        ArrayList<String> projectedProperties = new ArrayList<String>(this.getQueryColumns().size());
        for (SelectColumn selectColumn : this.getQueryColumns()) {
            if (!selectColumn.isVisible() || selectColumn.isAllColumns()) continue;
            projectedProperties.add(selectColumn.getName());
        }
        if (!projectedProperties.isEmpty()) {
            if (this.isOrderBy()) {
                for (SelectColumn selectColumn : this.getOrderColumns()) {
                    selectColumn.setProjectedIndex(projectedProperties.indexOf(selectColumn.getName()));
                }
            }
            this._projectionTemplate = ProjectionTemplate.create(projectedProperties.toArray(new String[projectedProperties.size()]), this.getTypeInfo());
        }
    }

    public ArrayList<OrderColumn> getOrderColumns() {
        return this.orderColumns;
    }

    @Override
    public boolean isSelectQuery() {
        return true;
    }

    @Override
    public BatchResponsePacket executePreparedValuesBatch(ISpaceProxy space, Transaction transaction, GPreparedStatement.PreparedValuesCollection preparedValuesCollection) throws SQLException {
        throw new SQLException("Batching is not supported for SELECT queries.");
    }

    private void addDynamicSelectColumns(IQueryResultSet<IEntryPacket> entries) throws SQLException {
        HashMap<String, QueryTableData> dynamicPropertiesTables = new HashMap<String, QueryTableData>();
        HashMap<QueryTableData, HashMap<String, SelectColumn>> dynamicColumnsMap = new HashMap<QueryTableData, HashMap<String, SelectColumn>>();
        for (QueryTableData tableData : this.getTablesData()) {
            if (!tableData.hasAsterixSelectColumns() || !tableData.getTypeDesc().supportsDynamicProperties()) continue;
            dynamicPropertiesTables.put(tableData.getTableName(), tableData);
            dynamicColumnsMap.put(tableData, new HashMap());
        }
        if (!dynamicPropertiesTables.isEmpty()) {
            for (IEntryPacket entryPacket : entries) {
                if (this.isJoined()) {
                    JoinedEntry joinedEntry = (JoinedEntry)entryPacket;
                    for (int i = 0; i < joinedEntry.getSize(); ++i) {
                        IEntryPacket entry = joinedEntry.getEntry(i);
                        QueryTableData table = this.getTablesData().get(i);
                        this.addDynamicColumns(table, dynamicColumnsMap, entry);
                    }
                    continue;
                }
                QueryTableData table = this.getTableData();
                this.addDynamicColumns(table, dynamicColumnsMap, entryPacket);
            }
            for (HashMap dynamicColumns : dynamicColumnsMap.values()) {
                for (SelectColumn dynamicColumn : dynamicColumns.values()) {
                    this.getQueryColumns().add(dynamicColumn);
                }
            }
        }
    }

    private void addDynamicColumns(QueryTableData table, HashMap<QueryTableData, HashMap<String, SelectColumn>> dynamicColumnsMap, IEntryPacket entryPacket) throws SQLException {
        Map<String, Object> dynamicProperties = entryPacket.getDynamicProperties();
        if (dynamicProperties == null || dynamicProperties.size() == 0) {
            return;
        }
        Set<String> dynamicPropertiesNames = dynamicProperties.keySet();
        HashMap<String, SelectColumn> dynamicColumns = dynamicColumnsMap.get(table);
        for (String prop : dynamicPropertiesNames) {
            if (dynamicColumns.containsKey(prop)) continue;
            SelectColumn dynamicColumn = new SelectColumn(table, prop, true);
            dynamicColumns.put(dynamicColumn.getName(), dynamicColumn);
        }
    }
}

