/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.WriteMultipleException;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.security.authorities.SpaceAuthority;
import com.gigaspaces.security.service.SecurityContext;
import com.j_spaces.core.LeaseContext;
import com.j_spaces.core.SpaceContext;
import com.j_spaces.core.SpaceContextHelper;
import com.j_spaces.core.client.EntryVersionConflictException;
import com.j_spaces.core.client.ExternalEntry;
import com.j_spaces.jdbc.AbstractDMLQuery;
import com.j_spaces.jdbc.NumberUtil;
import com.j_spaces.jdbc.QueryProcessor;
import com.j_spaces.jdbc.ResponsePacket;
import com.j_spaces.jdbc.UpdateColumn;
import com.j_spaces.jdbc.batching.BatchResponsePacket;
import com.j_spaces.jdbc.driver.GPreparedStatement;
import com.j_spaces.jdbc.driver.ObjectWithUID;
import com.j_spaces.jdbc.executor.QueryExecutor;
import com.j_spaces.jdbc.parser.ExpNode;
import com.j_spaces.jdbc.parser.LiteralNode;
import com.j_spaces.jdbc.query.IQueryResultSet;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.Transaction;

@InternalApi
public class UpdateQuery
extends AbstractDMLQuery {
    private List<LiteralNode> updatedValues;
    private boolean byUid = false;
    private List<UpdateColumn> _updatedColumns = new ArrayList<UpdateColumn>();
    private boolean _selfIncrementedUpdateColumn = false;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.query");

    @Override
    public ResponsePacket executeOnSpace(ISpaceProxy space, Transaction txn) throws SQLException {
        this._executor = new QueryExecutor(this);
        ResponsePacket response = new ResponsePacket();
        if (this._selfIncrementedUpdateColumn) {
            this.setReadModifier(512);
        }
        try {
            if (this.getSecurityInterceptor() != null) {
                SpaceContext spaceContext = this.getSession().getConnectionContext().getSpaceContext();
                SecurityContext securityContext = SpaceContextHelper.getSecurityContext(spaceContext);
                this.getSecurityInterceptor().intercept(securityContext, SpaceAuthority.SpacePrivilege.WRITE, this.getTableName());
            }
            this.validateUpdateColumns();
            if (this.byUid && this.isPrepared()) {
                ObjectWithUID object = (ObjectWithUID)this.preparedValues[0];
                ExternalEntry template = new ExternalEntry(object.getEntryUID());
                ExternalEntry externalEntry = (ExternalEntry)space.read(template, null, Integer.MAX_VALUE, this.getReadModifier());
                externalEntry.m_FieldsValues[object.getObjectIndex()] = object;
                space.update(externalEntry, txn, 0L, QueryProcessor.getDefaultConfig().getReadLease());
                response.setIntResult(0);
            } else {
                if (this.isPrepared()) {
                    int preparedValueIndex = 0;
                    for (LiteralNode literalNode : this.updatedValues) {
                        if (!literalNode.isPreparedValue()) continue;
                        literalNode.setValue(this.preparedValues[preparedValueIndex++]);
                    }
                    if (this.expTree != null) {
                        this.expTree.prepareValues(this.preparedValues);
                    }
                }
                this.build();
                IQueryResultSet<IEntryPacket> entries = this.expTree != null ? this._executor.execute(space, txn, this.getReadModifier(), Integer.MAX_VALUE) : this._executor.readAll(space, txn);
                this.filterByRownum(entries);
                Iterator iter = entries.iterator();
                if (!iter.hasNext()) {
                    response.setIntResult(0);
                    ResponsePacket responsePacket = response;
                    return responsePacket;
                }
                ITypeDesc iTypeDesc = this.getTypeInfo();
                int j = 0;
                int[] indices = new int[this.getUpdatedColumns().size()];
                boolean[] modifiedIndices = new boolean[iTypeDesc.getNumOfFixedProperties()];
                boolean doPartialUpdate = true;
                Object[] convertedUpdateValues = new Object[this.updatedValues.size()];
                block9: for (UpdateColumn updateColumn : this._updatedColumns) {
                    for (int i = 0; i < iTypeDesc.getNumOfFixedProperties(); ++i) {
                        if (!iTypeDesc.getFixedProperty(i).getName().equalsIgnoreCase(updateColumn.getName())) continue;
                        modifiedIndices[i] = true;
                        indices[j] = i;
                        convertedUpdateValues[j] = this.updatedValues.get(j).getConvertedObject(iTypeDesc, updateColumn.getName());
                        doPartialUpdate = doPartialUpdate && convertedUpdateValues[j] != null;
                        ++j;
                        continue block9;
                    }
                }
                while (iter.hasNext()) {
                    int i;
                    IEntryPacket entry = (IEntryPacket)iter.next();
                    for (i = 0; i < indices.length; ++i) {
                        int propertyIndex = indices[i];
                        if (this._updatedColumns.get(i).isSelfIncremented()) {
                            try {
                                entry.setFieldValue(propertyIndex, NumberUtil.add((Number)entry.getFieldValue(propertyIndex), (Number)convertedUpdateValues[i], iTypeDesc.getFixedProperty(propertyIndex).getTypeName()));
                                continue;
                            }
                            catch (ClassCastException e) {
                                throw new SQLException("Operator '+' is only allowed for numeric column types.");
                            }
                        }
                        entry.setFieldValue(propertyIndex, convertedUpdateValues[i]);
                    }
                    for (i = 0; i < modifiedIndices.length; ++i) {
                        boolean hasInvalidWrappedStringProperty;
                        boolean bl = hasInvalidWrappedStringProperty = (this.getReadModifier() & 0x200000) != 0 && (!doPartialUpdate || i == iTypeDesc.getRoutingPropertyId()) && entry.getFieldValue(i) != null && !iTypeDesc.getFixedProperty(i).isCommonJavaType();
                        if (hasInvalidWrappedStringProperty) {
                            throw new SQLException("Cannot set a property to null on an entry that contains other non primitive properties [" + iTypeDesc.getFixedProperty(i) + "]");
                        }
                        if (!doPartialUpdate || modifiedIndices[i] || i == iTypeDesc.getRoutingPropertyId()) continue;
                        entry.setFieldValue(i, null);
                    }
                }
                Object[] originalEntries = entries.toArray((IEntryPacket[])new IEntryPacket[entries.size()]);
                int modifiers = 8;
                if (doPartialUpdate) {
                    modifiers |= 0x10;
                }
                LeaseContext[] updatedEntries = space.writeMultiple(originalEntries, txn, 0L, null, 0L, modifiers);
                int notUpdated = 0;
                for (int e = 0; e < updatedEntries.length; ++e) {
                    LeaseContext updateEntry = updatedEntries[e];
                    if (updateEntry != null && !(updateEntry instanceof EntryVersionConflictException)) continue;
                    ++notUpdated;
                }
                response.setIntResult(updatedEntries.length - notUpdated);
            }
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, e.getMessage(), e);
            }
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            SQLException se = new SQLException("Failed to update row; Cause: " + e, "GSP", -130);
            se.initCause(e);
            throw se;
        }
        finally {
            this._executor = null;
        }
        return response;
    }

    private void validateUpdateColumns() throws SQLException {
        for (UpdateColumn column : this._updatedColumns) {
            column.createColumnData(this);
            if (!column.isSelfIncremented()) continue;
            column.validateSelfIncrementedColumnName(this);
        }
    }

    public void setUpdatedValues(List<LiteralNode> values) {
        this.updatedValues = values;
    }

    public boolean isByUid() {
        return this.byUid;
    }

    public void setByUid(boolean byUid) {
        this.byUid = byUid;
    }

    @Override
    public UpdateQuery clone() {
        UpdateQuery query = new UpdateQuery();
        query.tables = this.tables;
        query._tablesData = this._tablesData;
        query.isPrepared = this.isPrepared;
        query.byUid = this.byUid;
        query._updatedColumns = this.getUpdatedColumns();
        query.setContainsSubQueries(this.containsSubQueries());
        if (this.getExpTree() != null && this.isPrepared()) {
            query.setExpTree((ExpNode)this.getExpTree().clone());
        } else {
            query.setExpTree(this.expTree);
        }
        query.updatedValues = this.updatedValues;
        return query;
    }

    public void addUpdateColumn(UpdateColumn updateColumn) {
        this._updatedColumns.add(updateColumn);
    }

    public List<UpdateColumn> getUpdatedColumns() {
        return this._updatedColumns;
    }

    public void setSelfIncrementedUpdateColumn(boolean selfIncrementedUpdateColumn) {
        this._selfIncrementedUpdateColumn = selfIncrementedUpdateColumn;
    }

    @Override
    public boolean isForceUnderTransaction() {
        return this._selfIncrementedUpdateColumn;
    }

    @Override
    public BatchResponsePacket executePreparedValuesBatch(ISpaceProxy space, Transaction transaction, GPreparedStatement.PreparedValuesCollection preparedValuesCollection) throws SQLException {
        if (this.byUid) {
            return super.executePreparedValuesBatch(space, transaction, preparedValuesCollection);
        }
        return this.executeBatch(space, transaction, preparedValuesCollection);
    }

    private BatchResponsePacket executeBatch(ISpaceProxy space, Transaction transaction, GPreparedStatement.PreparedValuesCollection preparedValuesCollection) throws SQLException {
        this._executor = new QueryExecutor(this);
        ArrayList<IEntryPacket[]> readResult = new ArrayList<IEntryPacket[]>();
        ExpNode tempExpTree = this.expTree;
        try {
            if (this.getSecurityInterceptor() != null) {
                SpaceContext spaceContext = this.getSession().getConnectionContext().getSpaceContext();
                SecurityContext securityContext = SpaceContextHelper.getSecurityContext(spaceContext);
                this.getSecurityInterceptor().intercept(securityContext, SpaceAuthority.SpacePrivilege.WRITE, this.getTableName());
            }
            this.validateUpdateColumns();
            ITypeDesc info = this.getTypeInfo();
            int[] indices = new int[this.getUpdatedColumns().size()];
            int j = 0;
            block10: for (UpdateColumn updateColumn : this._updatedColumns) {
                for (int i = 0; i < info.getNumOfFixedProperties(); ++i) {
                    if (!info.getFixedProperty(i).getName().equalsIgnoreCase(updateColumn.getName())) continue;
                    indices[j] = i;
                    ++j;
                    continue block10;
                }
            }
            for (Object[] preparedValues : preparedValuesCollection.getBatchValues()) {
                IEntryPacket[] readEntryPackets;
                int preparedValueIndex = 0;
                for (LiteralNode literalNode : this.updatedValues) {
                    if (!literalNode.isPreparedValue()) continue;
                    literalNode.setValue(preparedValues[preparedValueIndex++]);
                }
                if (this.expTree != null) {
                    this.expTree = (ExpNode)tempExpTree.clone();
                    this.expTree.prepareValues(preparedValues);
                    this.setPreparedValues(preparedValues);
                    if (this.containsSubQueries()) {
                        this.executeSubQueries(space, transaction);
                    }
                }
                this.build();
                IQueryResultSet<IEntryPacket> entries = this.expTree != null ? this._executor.execute(space, transaction, this.getReadModifier(), Integer.MAX_VALUE) : this._executor.readAll(space, transaction);
                this.filterByRownum(entries);
                Object[] convertedUpdateValues = new Object[this.updatedValues.size()];
                j = 0;
                for (UpdateColumn updateColumn : this._updatedColumns) {
                    convertedUpdateValues[j] = this.updatedValues.get(j).getConvertedObject(info, updateColumn.getName());
                    ++j;
                }
                for (IEntryPacket entry : readEntryPackets = entries.toArray((IEntryPacket[])new IEntryPacket[entries.size()])) {
                    for (int i = 0; i < indices.length; ++i) {
                        if (this._updatedColumns.get(i).isSelfIncremented()) {
                            try {
                                entry.setFieldValue(indices[i], NumberUtil.add((Number)entry.getFieldValue(indices[i]), (Number)convertedUpdateValues[i], info.getFixedProperty(i).getTypeName()));
                                continue;
                            }
                            catch (ClassCastException e) {
                                throw new SQLException("Operator '+' is only allowed for numeric column types.");
                            }
                        }
                        entry.setFieldValue(indices[i], convertedUpdateValues[i]);
                    }
                }
                readResult.add(readEntryPackets);
            }
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, e.getMessage(), e);
            }
            SQLException se = new SQLException("Failed to update row; Cause: " + e, "GSP", -130);
            se.initCause(e);
            throw se;
        }
        finally {
            this._executor = null;
        }
        ArrayList<IEntryPacket> originalEntries = new ArrayList<IEntryPacket>();
        for (IEntryPacket[] updatedEntryPackets : readResult) {
            for (int i = 0; i < updatedEntryPackets.length; ++i) {
                originalEntries.add(updatedEntryPackets[i]);
            }
        }
        try {
            if (originalEntries.size() > 0) {
                space.writeMultiple(originalEntries.toArray(), transaction, 0L, null, 0L, 8);
            }
        }
        catch (WriteMultipleException e) {
            int[] result = new int[readResult.size()];
            int batchIndex = 0;
            int entryIndex = 0;
            for (WriteMultipleException.IWriteResult writeResult : e.getResults()) {
                while (entryIndex == ((IEntryPacket[])readResult.get(entryIndex)).length) {
                    ++batchIndex;
                    entryIndex = 0;
                }
                if (!writeResult.isError()) {
                    result[batchIndex] = -3;
                }
                if (result[batchIndex] != -3) {
                    int n = batchIndex;
                    result[n] = result[n] + 1;
                }
                ++entryIndex;
            }
            throw new BatchUpdateException(e.getMessage(), result);
        }
        catch (Exception e) {
            int[] result = new int[readResult.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = -3;
            }
            throw new BatchUpdateException(e.getMessage(), result);
        }
        int[] result = new int[readResult.size()];
        int resultIndex = 0;
        for (IEntryPacket[] updatedEntryPackets : readResult) {
            result[resultIndex++] = updatedEntryPackets.length;
        }
        return new BatchResponsePacket(result);
    }
}

