/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.builder;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.query.CompoundContainsItemsCustomQuery;
import com.gigaspaces.internal.query.IContainsItemsCustomQuery;
import com.gigaspaces.metadata.StorageType;
import com.j_spaces.jdbc.AbstractDMLQuery;
import com.j_spaces.jdbc.Stack;
import com.j_spaces.jdbc.builder.QueryTemplatePacket;
import com.j_spaces.jdbc.builder.range.CompositeRange;
import com.j_spaces.jdbc.builder.range.ContainsItemValueRange;
import com.j_spaces.jdbc.builder.range.ContainsValueRange;
import com.j_spaces.jdbc.builder.range.EqualValueRange;
import com.j_spaces.jdbc.builder.range.FunctionCallDescription;
import com.j_spaces.jdbc.builder.range.InRange;
import com.j_spaces.jdbc.builder.range.IsNullRange;
import com.j_spaces.jdbc.builder.range.NotEqualValueRange;
import com.j_spaces.jdbc.builder.range.NotNullRange;
import com.j_spaces.jdbc.builder.range.NotRegexRange;
import com.j_spaces.jdbc.builder.range.Range;
import com.j_spaces.jdbc.builder.range.RegexRange;
import com.j_spaces.jdbc.builder.range.RelationRange;
import com.j_spaces.jdbc.builder.range.SegmentRange;
import com.j_spaces.jdbc.builder.range.UidsRange;
import com.j_spaces.jdbc.parser.AbstractInNode;
import com.j_spaces.jdbc.parser.AndNode;
import com.j_spaces.jdbc.parser.ColumnNode;
import com.j_spaces.jdbc.parser.ContainsItemNode;
import com.j_spaces.jdbc.parser.ContainsItemsRootNode;
import com.j_spaces.jdbc.parser.ContainsNode;
import com.j_spaces.jdbc.parser.ExpNode;
import com.j_spaces.jdbc.parser.InNode;
import com.j_spaces.jdbc.parser.IsNullNode;
import com.j_spaces.jdbc.parser.LikeNode;
import com.j_spaces.jdbc.parser.LiteralNode;
import com.j_spaces.jdbc.parser.NotInNode;
import com.j_spaces.jdbc.parser.NotLikeNode;
import com.j_spaces.jdbc.parser.OrNode;
import com.j_spaces.jdbc.parser.RelationNode;
import com.j_spaces.jdbc.query.QueryColumnData;
import com.j_spaces.jdbc.query.QueryTableData;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

@InternalApi
public class QueryTemplateBuilder {
    private AbstractDMLQuery query;

    public QueryTemplateBuilder(AbstractDMLQuery query) {
        this.query = query;
    }

    public void buildContainsTemplate(ContainsNode containsNode) throws SQLException {
        if (containsNode.getRightChild() != null && containsNode.getRightChild().isContainsItemsRootNode()) {
            ContainsItemsRootNode rn = (ContainsItemsRootNode)containsNode.getRightChild();
            if (rn.getTemplate() == null) {
                throw new RuntimeException("invalid traverse tree state null template in containsItemsRoot");
            }
            containsNode.setTemplate(rn.getTemplate());
            return;
        }
        QueryColumnData queryColumnData = ((ColumnNode)containsNode.getLeftChild()).getColumnData();
        FunctionCallDescription functionCallDescription = ((ColumnNode)containsNode.getLeftChild()).getFunctionCallDescription();
        if (containsNode.isJoined()) {
            if (this.query.isJoined()) {
                return;
            }
            this.throwIllegalJoinExpressionException(containsNode);
        }
        QueryTableData tableData = queryColumnData.getColumnTableData();
        ExpNode right = containsNode.getRightChild();
        Set value = null;
        if (right instanceof LiteralNode) {
            value = ((LiteralNode)right).getValue();
        } else if (!(right instanceof IsNullNode)) {
            value = ((AbstractInNode)right).getConvertedValues(tableData.getTypeDesc(), containsNode.getPath());
        }
        QueryTemplatePacket template = new QueryTemplatePacket(tableData, this.query.getQueryResultType(), queryColumnData.getColumnPath(), new ContainsValueRange(containsNode.getPath(), functionCallDescription, value, containsNode.getTemplateMatchCode()));
        containsNode.setTemplate(template);
    }

    public void buildContainsItemsRootTemplate(ContainsItemsRootNode rn) throws SQLException {
        QueryColumnData queryColumnData = rn.getRootColumnNode().getColumnData();
        if (rn.isJoined()) {
            if (this.query.isJoined()) {
                return;
            }
            this.throwIllegalJoinExpressionException(rn);
        }
        QueryTableData tableData = queryColumnData.getColumnTableData();
        QueryTemplatePacket template = new QueryTemplatePacket(tableData, this.query.getQueryResultType(), this.buildContainsItemsRootQuery(rn, null));
        rn.setTemplate(template);
    }

    private IContainsItemsCustomQuery buildContainsItemsRootQuery(ContainsItemsRootNode rn, String path) throws SQLException {
        ExpNode exp;
        LinkedList<IContainsItemsCustomQuery> subs = new LinkedList<IContainsItemsCustomQuery>();
        String fullPath = rn.getRoot();
        if (path != null) {
            StringBuilder sb = new StringBuilder(path);
            sb.append(".");
            sb.append(rn.getRoot());
            fullPath = sb.toString();
        }
        if ((exp = rn.getContainsSubtree()).isContainsItemNode() || exp.isContainsItemsRootNode()) {
            this.buildContainsItemsBasicQuery(exp, fullPath, subs);
        } else {
            if (exp.getLeftChild() != null) {
                this.buildContainsItemsBasicQuery(exp.getLeftChild(), fullPath, subs);
            }
            if (exp.getRightChild() != null) {
                this.buildContainsItemsBasicQuery(exp.getRightChild(), fullPath, subs);
            }
        }
        return new CompoundContainsItemsCustomQuery(rn.getRoot(), fullPath, subs);
    }

    private void buildContainsItemsBasicQuery(ExpNode node, String fullPath, List<IContainsItemsCustomQuery> subs) throws SQLException {
        if (node.isContainsItemsRootNode()) {
            subs.add(this.buildContainsItemsRootQuery((ContainsItemsRootNode)node, fullPath));
            return;
        }
        if (node.isContainsItemNode() && !node.getRightChild().isContainsItemsRootNode()) {
            ContainsItemNode cn = (ContainsItemNode)node;
            StringBuilder sb = new StringBuilder(fullPath);
            sb.append(".");
            sb.append(cn.getPath());
            fullPath = sb.toString();
            ExpNode right = node.getRightChild();
            Set value = null;
            value = right instanceof LiteralNode ? ((LiteralNode)right).getValue() : ((AbstractInNode)right).getConvertedValues(this.query.getTypeInfo(), fullPath);
            subs.add(new ContainsItemValueRange(cn.getPath(), sb.toString(), null, value, cn.getTemplateMatchCode()));
            return;
        }
        if (node.getLeftChild() != null) {
            this.buildContainsItemsBasicQuery(node.getLeftChild(), fullPath, subs);
        }
        if (node.getRightChild() != null) {
            this.buildContainsItemsBasicQuery(node.getRightChild(), fullPath, subs);
        }
    }

    public void build(ExpNode node, short op, short nullOp) throws SQLException {
        if (node.isJoined()) {
            if (this.query.isJoined()) {
                return;
            }
            this.throwIllegalJoinExpressionException(node);
        }
        ColumnNode col = (ColumnNode)node.getLeftChild();
        QueryTemplatePacket template = this.buildTemplate((LiteralNode)node.getRightChild(), col.getColumnData(), op, nullOp, col.getFunctionCallDescription(), node);
        node.setTemplate(template);
    }

    public void build(RelationNode node) throws SQLException {
        String[] relations = node.getRelation().split(":");
        String namespace = relations[0];
        String op = relations[1];
        QueryTemplatePacket template = this.buildTemplate((ColumnNode)node.getLeftChild(), namespace, op, (LiteralNode)node.getRightChild());
        node.setTemplate(template);
    }

    public void build(ExpNode node, short op) throws SQLException {
        this.build(node, op, op);
    }

    public void build(LikeNode node, short op) throws SQLException {
        if (node.isJoined()) {
            this.throwIllegalJoinExpressionException(node);
        }
        ColumnNode col = (ColumnNode)node.getLeftChild();
        QueryTableData tableData = col.getColumnData().getColumnTableData();
        Object obj = ((LiteralNode)node.getRightChild()).getConvertedObject(tableData.getTypeDesc(), col.getColumnPath());
        String regex = ((String)obj).replaceAll("%", ".*").replaceAll("_", ".");
        Range range = QueryTemplateBuilder.toRange(col.getColumnPath(), col.getFunctionCallDescription(), regex, (short)8);
        node.setTemplate(new QueryTemplatePacket(tableData, this.query.getQueryResultType(), col.getColumnPath(), range));
    }

    public void build(InNode node) throws SQLException {
        QueryTemplatePacket template = QueryTemplateBuilder.buildTemplate(node, this.query);
        node.setTemplate(template);
    }

    public void build(NotInNode node) throws SQLException {
        QueryTemplatePacket template = QueryTemplateBuilder.buildTemplate(node, this.query);
        node.setTemplate(template);
    }

    public static QueryTemplatePacket buildTemplate(NotInNode node, AbstractDMLQuery query) throws SQLException {
        ColumnNode column = (ColumnNode)node.getLeftChild();
        QueryTableData tableData = column.getColumnData().getColumnTableData();
        String colName = column.getColumnPath();
        CompositeRange range = new CompositeRange(colName);
        Set notInValues = node.getConvertedValues(tableData.getTypeDesc(), colName);
        for (Object notInValue : notInValues) {
            if (notInValue == null) {
                range.add(new NotNullRange(colName, column.getFunctionCallDescription()));
                continue;
            }
            range.add(new NotEqualValueRange(colName, column.getFunctionCallDescription(), notInValue));
        }
        QueryTemplatePacket template = new QueryTemplatePacket(tableData, query.getQueryResultType(), colName, range);
        return template;
    }

    public static QueryTemplatePacket buildTemplate(InNode node, AbstractDMLQuery query) throws SQLException {
        ColumnNode column = (ColumnNode)node.getLeftChild();
        QueryTableData tableData = column.getColumnData().getColumnTableData();
        ITypeDesc info = tableData.getTypeDesc();
        String idPropertyName = info.getIdPropertyName();
        if (idPropertyName != null && info.isAutoGenerateId() && column.getColumnPath().equals(idPropertyName)) {
            String[] colNames = new String[]{column.getColumnPath()};
            Set uids = node.getConvertedValues(info, colNames[0]);
            UidsRange range = new UidsRange(column.getColumnPath(), column.getFunctionCallDescription(), uids);
            return new QueryTemplatePacket(tableData, query.getQueryResultType(), column.getColumnPath(), range);
        }
        ITypeDesc typeDesc = tableData.getTypeDesc();
        Set inValues = node.getConvertedValues(typeDesc, column.getColumnData().getColumnPath());
        InRange range = new InRange(column.getColumnPath(), column.getFunctionCallDescription(), inValues);
        return new QueryTemplatePacket(tableData, query.getQueryResultType(), column.getColumnPath(), range);
    }

    public QueryTemplatePacket buildTemplate(LiteralNode node, QueryColumnData queryColumnData, short op, short nullOp, FunctionCallDescription functionCallDescription, ExpNode father) throws SQLException {
        QueryTableData tableData = queryColumnData.getColumnTableData();
        ITypeDesc typeDesc = tableData.getTypeDesc();
        Object value = node.getConvertedObject(typeDesc, queryColumnData.getColumnPath());
        return new QueryTemplatePacket(tableData, this.query.getQueryResultType(), queryColumnData.getColumnPath(), QueryTemplateBuilder.toRange(queryColumnData.getColumnPath(), functionCallDescription, value, value == null ? nullOp : op, father, this.query));
    }

    private QueryTemplatePacket buildTemplate(ColumnNode columnNode, String namespace, String op, LiteralNode valueNode) throws SQLException {
        QueryColumnData columnData = columnNode.getColumnData();
        QueryTableData tableData = columnData.getColumnTableData();
        ITypeDesc typeDesc = tableData.getTypeDesc();
        Object value = valueNode.getConvertedObject(typeDesc, columnData.getColumnPath());
        return new QueryTemplatePacket(tableData, this.query.getQueryResultType(), columnData.getColumnPath(), new RelationRange(typeDesc.getTypeName(), columnData.getColumnPath(), value, namespace, op));
    }

    public static Range toRange(String colName, FunctionCallDescription functionCallDescription, Object value, short matchCode) {
        return QueryTemplateBuilder.toRange(colName, functionCallDescription, value, matchCode, null, null);
    }

    public static Range toRange(String colName, FunctionCallDescription functionCallDescription, Object value, short matchCode, ExpNode node, AbstractDMLQuery query) {
        switch (matchCode) {
            case 6: {
                return new IsNullRange(colName, functionCallDescription);
            }
            case 7: {
                return new NotNullRange(colName, functionCallDescription);
            }
            case 0: {
                ColumnNode column;
                QueryTableData tableData;
                ITypeDesc info;
                String idPropertyName;
                if (node != null && (idPropertyName = (info = (tableData = (column = (ColumnNode)node.getLeftChild()).getColumnData().getColumnTableData()).getTypeDesc()).getIdPropertyName()) != null && info.isAutoGenerateId() && column.getColumnPath().equals(idPropertyName)) {
                    String uid = (String)((LiteralNode)node.getRightChild()).getValue();
                    HashSet<String> uids = new HashSet<String>();
                    uids.add(uid);
                    return new UidsRange(column.getColumnPath(), column.getFunctionCallDescription(), uids);
                }
                return new EqualValueRange(colName, functionCallDescription, value);
            }
            case 1: {
                return new NotEqualValueRange(colName, functionCallDescription, value);
            }
            case 2: {
                return new SegmentRange(colName, functionCallDescription, QueryTemplateBuilder.castToComparable(value), false, null, false);
            }
            case 3: {
                return new SegmentRange(colName, functionCallDescription, QueryTemplateBuilder.castToComparable(value), true, null, false);
            }
            case 5: {
                return new SegmentRange(colName, functionCallDescription, null, false, QueryTemplateBuilder.castToComparable(value), true);
            }
            case 4: {
                return new SegmentRange(colName, functionCallDescription, null, false, QueryTemplateBuilder.castToComparable(value), false);
            }
            case 8: {
                return new RegexRange(colName, functionCallDescription, (String)value);
            }
            case 10: {
                return new NotRegexRange(colName, functionCallDescription, (String)value);
            }
            case 11: {
                return new InRange(colName, functionCallDescription, (Set)value);
            }
        }
        return Range.EMPTY_RANGE;
    }

    private static Comparable castToComparable(Object obj) {
        try {
            return (Comparable)obj;
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Type " + obj.getClass() + " doesn't implement Comparable, Serialization mode might be different than " + (Object)((Object)StorageType.OBJECT) + ".", cce);
        }
    }

    public void build(AndNode node) throws SQLException {
        if (this.query.isJoined()) {
            return;
        }
        ExpNode left = node.getLeftChild();
        ExpNode right = node.getRightChild();
        if (left == null) {
            node.setTemplate(right.getTemplate());
            return;
        }
        if (right == null) {
            node.setTemplate(left.getTemplate());
            return;
        }
        QueryTemplatePacket leftTemplate = left.getTemplate();
        QueryTemplatePacket rightTemplate = right.getTemplate();
        if (leftTemplate == null && rightTemplate == null) {
            return;
        }
        if (leftTemplate != null && leftTemplate.isAlwaysEmpty()) {
            node.setTemplate(leftTemplate);
            return;
        }
        if (rightTemplate != null && rightTemplate.isAlwaysEmpty()) {
            node.setTemplate(rightTemplate);
            return;
        }
        if (leftTemplate == null || rightTemplate == null) {
            return;
        }
        node.setTemplate(leftTemplate.buildAndPacket(rightTemplate));
    }

    public void build(OrNode node) throws SQLException {
        ExpNode left = node.getLeftChild();
        ExpNode right = node.getRightChild();
        if (this.query.isJoined()) {
            return;
        }
        if (left == null) {
            node.setTemplate(right.getTemplate());
            return;
        }
        if (right == null) {
            node.setTemplate(left.getTemplate());
            return;
        }
        QueryTemplatePacket leftTemplate = left.getTemplate();
        QueryTemplatePacket rightTemplate = right.getTemplate();
        if (leftTemplate == null && rightTemplate == null) {
            return;
        }
        if (leftTemplate != null && leftTemplate.isAlwaysEmpty()) {
            node.setTemplate(rightTemplate);
            return;
        }
        if (rightTemplate != null && rightTemplate.isAlwaysEmpty()) {
            node.setTemplate(leftTemplate);
            return;
        }
        if (leftTemplate != null && rightTemplate != null) {
            node.setTemplate(leftTemplate.buildOrPacket(rightTemplate));
        }
    }

    public void traverseExpressionTree(ExpNode root) throws SQLException {
        if (root != null) {
            Stack<ExpNode> stack = new Stack<ExpNode>();
            Stack<ExpNode> stack2 = new Stack<ExpNode>();
            stack.push(root);
            while (!stack.isEmpty()) {
                ExpNode curr = (ExpNode)stack.pop();
                stack2.push(curr);
                if (curr.getLeftChild() != null) {
                    stack.push(curr.getLeftChild());
                }
                if (curr.getRightChild() == null) continue;
                stack.push(curr.getRightChild());
            }
            while (!stack2.isEmpty()) {
                ExpNode node = (ExpNode)stack2.pop();
                node.accept(this);
                if (node.getTemplate() == null) {
                    if (node.getLeftChild() != null && node.getLeftChild().getTemplate() != null) {
                        node.getLeftChild().getTemplate().prepareForSpace(this.query.getTypeInfo());
                    }
                    if (node.getRightChild() == null || node.getRightChild().getTemplate() == null) continue;
                    node.getRightChild().getTemplate().prepareForSpace(this.query.getTypeInfo());
                    continue;
                }
                if (!stack2.isEmpty()) continue;
                node.getTemplate().prepareForSpace(this.query.getTypeInfo());
            }
        }
        if (this.query.isJoined()) {
            this.buildJoinInfo();
        }
    }

    private void buildJoinInfo() {
        for (QueryTableData tableData : this.query.getTablesData()) {
            tableData.createJoinIndex(this.query.getExpTree());
        }
        LinkedList joinedSequences = new LinkedList();
        for (int i = 0; i < this.query.getTablesData().size(); ++i) {
            QueryTableData tableData = this.query.getTablesData().get(i);
            if (tableData.isJoined()) continue;
            LinkedList<QueryTableData> linkedList = new LinkedList<QueryTableData>();
            linkedList.add(tableData);
            while (tableData.getJoinTable() != null) {
                tableData = tableData.getJoinTable();
                linkedList.add(tableData);
            }
            joinedSequences.add(linkedList);
        }
        QueryTableData lastJoined = null;
        for (LinkedList linkedList : joinedSequences) {
            if (lastJoined != null) {
                lastJoined.setJoinTable((QueryTableData)linkedList.getFirst());
                ((QueryTableData)linkedList.getFirst()).setJoined(true);
            }
            lastJoined = (QueryTableData)linkedList.getLast();
        }
    }

    public void build(NotLikeNode node) throws SQLException {
        if (node.isJoined()) {
            this.throwIllegalJoinExpressionException(node);
        }
        ColumnNode col = (ColumnNode)node.getLeftChild();
        QueryTableData tableData = col.getColumnData().getColumnTableData();
        Object value = ((LiteralNode)node.getRightChild()).getConvertedObject(tableData.getTypeDesc(), col.getColumnPath());
        String regex = ((String)value).replaceAll("%", ".*").replaceAll("_", ".");
        NotRegexRange range = new NotRegexRange(col.getColumnPath(), col.getFunctionCallDescription(), regex);
        node.setTemplate(new QueryTemplatePacket(tableData, this.query.getQueryResultType(), col.getColumnPath(), range));
    }

    private void throwIllegalJoinExpressionException(ExpNode node) throws SQLException {
        throw new SQLException("Right-hand expression of=[" + node + "] must be a constant value - '" + node.getRightChild() + "'.");
    }

    public void build(ColumnNode node) throws SQLException {
        node.createColumnData(this.query);
    }
}

