/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.builder;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.protective.ProtectiveMode;
import com.gigaspaces.client.protective.ProtectiveModeException;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.query.CompoundAndCustomQuery;
import com.gigaspaces.internal.query.CompoundContainsItemsCustomQuery;
import com.gigaspaces.internal.query.ExacValueCompoundIndexScanner;
import com.gigaspaces.internal.query.IContainsItemsCustomQuery;
import com.gigaspaces.internal.query.ICustomQuery;
import com.gigaspaces.internal.query.IQueryIndexScanner;
import com.gigaspaces.internal.query.NullValueIndexScanner;
import com.gigaspaces.internal.query.RangeCompoundIndexScanner;
import com.gigaspaces.internal.transport.AbstractProjectionTemplate;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.metadata.index.CompoundIndex;
import com.gigaspaces.metadata.index.ISpaceCompoundIndexSegment;
import com.gigaspaces.metadata.index.SpaceIndex;
import com.gigaspaces.query.aggregators.AggregationSet;
import com.gigaspaces.query.explainplan.ExplainPlan;
import com.j_spaces.core.ExternalTemplatePacket;
import com.j_spaces.core.IJSpace;
import com.j_spaces.jdbc.AbstractDMLQuery;
import com.j_spaces.jdbc.AggregationsUtil;
import com.j_spaces.jdbc.JoinedEntry;
import com.j_spaces.jdbc.SQLUtil;
import com.j_spaces.jdbc.builder.UnionTemplatePacket;
import com.j_spaces.jdbc.builder.range.ContainsItemIntersectionBase;
import com.j_spaces.jdbc.builder.range.ContainsItemValueRange;
import com.j_spaces.jdbc.builder.range.EmptyRange;
import com.j_spaces.jdbc.builder.range.Range;
import com.j_spaces.jdbc.builder.range.RelationRange;
import com.j_spaces.jdbc.query.ArrayListResult;
import com.j_spaces.jdbc.query.IQueryResultSet;
import com.j_spaces.jdbc.query.QueryTableData;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;

@InternalApi
public class QueryTemplatePacket
extends ExternalTemplatePacket {
    private static final long serialVersionUID = 1L;
    private QueryTableData _table;
    private HashMap<String, Range> _ranges = new HashMap();
    private boolean _isAlwaysEmpty;
    private Set<String> _multipleUids;
    protected boolean _preparedForSpace;
    private transient Object _routing = null;
    private QueryResultTypeInternal _queryResultType;
    private AbstractProjectionTemplate _projectionTemplate;
    protected AggregationSet _aggregationSet;
    private transient List<IContainsItemsCustomQuery> _containsItemsQueries;
    protected boolean _allIndexValuesQuery;
    public static final IQueryIndexScanner _dummyNullIndexScanner = new NullValueIndexScanner();
    private transient ExplainPlan explainPlan;

    public QueryTemplatePacket() {
    }

    public QueryTemplatePacket(QueryTableData table, QueryResultTypeInternal queryResultType) {
        this._table = table;
        this._typeName = table.getTableName();
        this._queryResultType = queryResultType;
        this.init(table.getTypeDesc());
    }

    public QueryTemplatePacket(QueryTableData table, QueryResultTypeInternal queryResultType, String fieldName, Range range) {
        this(table, queryResultType);
        this._ranges.put(fieldName, range);
    }

    public QueryTemplatePacket(QueryTableData table, QueryResultTypeInternal queryResultType, IContainsItemsCustomQuery containsItemsQuery) {
        this(table, queryResultType);
        if (this._containsItemsQueries == null) {
            this._containsItemsQueries = new ArrayList<IContainsItemsCustomQuery>();
        }
        this._containsItemsQueries.add(containsItemsQuery);
    }

    public QueryTemplatePacket(QueryTemplatePacket template) {
        this._typeName = template.getTypeName();
        this._table = template._table;
        this._queryResultType = template.getQueryResultType();
        this._isAlwaysEmpty = template.isAlwaysEmpty();
        this._ranges = new HashMap<String, Range>(template.getRanges());
        if (template.getMultipleUids() != null) {
            this._multipleUids = new HashSet<String>(template.getMultipleUids());
        }
        this.uniteContainsItems(template);
        this._typeDesc = template.getTypeDescriptor();
        if (this._typeDesc != null) {
            this.init(this._typeDesc);
        }
    }

    private void init(ITypeDesc typeDesc) {
        this._typeDesc = typeDesc;
        this._typeDescChecksum = typeDesc.getChecksum();
        this._entryType = typeDesc.getObjectType();
        this.setFieldsValues(new Object[typeDesc.getNumOfFixedProperties()]);
        this._extendedMatchCodes = new short[typeDesc.getNumOfFixedProperties()];
    }

    @Override
    public boolean isTransient() {
        return this._typeDesc == null ? false : this._typeDesc.getIntrospector(null).isTransient(null);
    }

    public void prepareForSpace(ITypeDesc typeDesc) {
        HashMap<String, Range> possibleCompoundSegments;
        if (this._preparedForSpace) {
            return;
        }
        if (this._typeDesc == null) {
            this.init(typeDesc);
        }
        this._allIndexValuesQuery = true;
        if (this._multipleUids != null) {
            this.setMultipleUIDs(this._multipleUids.toArray(new String[this._multipleUids.size()]));
            this._allIndexValuesQuery = false;
        }
        boolean anyCompoundIndexCreated = false;
        LinkedList<IQueryIndexScanner> queryIndexes = new LinkedList<IQueryIndexScanner>();
        ArrayList<ICustomQuery> customQueries = null;
        HashMap<String, List<Range>> containsSamePathRanges = null;
        if (this._containsItemsQueries != null && !this._containsItemsQueries.isEmpty()) {
            customQueries = new ArrayList<IContainsItemsCustomQuery>(this._containsItemsQueries);
            if (this._ranges == null) {
                this._ranges = new HashMap();
            }
            containsSamePathRanges = new HashMap<String, List<Range>>();
            HashMap<ContainsItemIntersectionBase, ContainsItemValueRange> containsIntersections = new HashMap<ContainsItemIntersectionBase, ContainsItemValueRange>();
            this.insertContainsItemsRanges(this._containsItemsQueries, containsSamePathRanges, null, containsIntersections);
        }
        HashMap<Range, IQueryIndexScanner> usedByRanges = null;
        HashMap<String, Range> hashMap = possibleCompoundSegments = typeDesc.anyCompoundIndex() && this._ranges != null ? new HashMap<String, Range>() : null;
        if (this._ranges != null) {
            if (customQueries == null) {
                customQueries = new ArrayList();
            }
            for (Map.Entry<String, Range> mapEntry : this._ranges.entrySet()) {
                String fieldName = mapEntry.getKey();
                Range range = mapEntry.getValue();
                int propertyIndex = this._typeDesc.getFixedPropertyPosition(fieldName);
                boolean addedRange = false;
                if (propertyIndex != -1 || range.isUidsRange()) {
                    if (range.getFunctionCallDescription() == null) {
                        range.toEntryPacket(this, propertyIndex);
                        addedRange = true;
                        if (!range.isRelevantForAllIndexValuesOptimization() || !this._typeDesc.getPropertiesIndexTypes()[propertyIndex]) {
                            this._allIndexValuesQuery = false;
                        }
                        if (possibleCompoundSegments != null && range.suitableAsCompoundIndexSegment()) {
                            if (usedByRanges == null) {
                                usedByRanges = new HashMap<Range, IQueryIndexScanner>();
                            }
                            usedByRanges.put(range, _dummyNullIndexScanner);
                        }
                    } else {
                        this._allIndexValuesQuery = false;
                    }
                }
                if (range.isNestedQuery() || range.isComplex() || propertyIndex == -1 && this._typeDesc.supportsDynamicProperties()) {
                    if (!range.isInternalRange()) {
                        customQueries.add(mapEntry.getValue());
                        addedRange = true;
                    }
                    if (range.isIndexed(this._typeDesc) || range.isUidsRange()) {
                        IQueryIndexScanner indexScanner;
                        if (!range.isRelevantForAllIndexValuesOptimization() && !range.isUidsRange()) {
                            this._allIndexValuesQuery = false;
                        }
                        if ((indexScanner = range.getIndexScanner()) != null) {
                            queryIndexes.add(indexScanner);
                            if (possibleCompoundSegments != null && range.suitableAsCompoundIndexSegment()) {
                                if (usedByRanges == null) {
                                    usedByRanges = new HashMap();
                                }
                                usedByRanges.put(range, indexScanner);
                            }
                        }
                        if (containsSamePathRanges != null && containsSamePathRanges.containsKey(range.getPath())) {
                            List<Range> l = containsSamePathRanges.get(range.getPath());
                            for (Range r : l) {
                                if (r == range) continue;
                                IQueryIndexScanner is = r.getIndexScanner();
                                if (indexScanner == null) continue;
                                queryIndexes.add(is);
                            }
                        }
                    } else {
                        this._allIndexValuesQuery = false;
                    }
                } else if (propertyIndex == -1) {
                    this._allIndexValuesQuery = false;
                }
                if (!addedRange || possibleCompoundSegments == null || !range.suitableAsCompoundIndexSegment()) continue;
                possibleCompoundSegments.put(mapEntry.getKey(), range);
            }
            if (possibleCompoundSegments != null && possibleCompoundSegments.size() > 1) {
                ArrayList<Range> possibleSegments = new ArrayList<Range>();
                for (SpaceIndex idx : typeDesc.getCompoundIndexes()) {
                    IQueryIndexScanner indexScanner;
                    possibleSegments.clear();
                    CompoundIndex index = (CompoundIndex)idx;
                    for (ISpaceCompoundIndexSegment seg : index.getCompoundIndexSegments()) {
                        Range checkedRange = (Range)possibleCompoundSegments.get(seg.getName());
                        if (checkedRange == null || checkedRange.getFunctionCallDescription() != null) {
                            possibleSegments.clear();
                            break;
                        }
                        possibleSegments.add((Range)possibleCompoundSegments.get(seg.getName()));
                    }
                    if (possibleSegments.isEmpty() || (indexScanner = this.buildCompoundIndexScannerFromSegmentRanges(index, possibleSegments)) == null) continue;
                    queryIndexes.add(indexScanner);
                    anyCompoundIndexCreated = true;
                    if (usedByRanges == null || usedByRanges.isEmpty()) continue;
                    for (Range r : possibleSegments) {
                        IQueryIndexScanner s = (IQueryIndexScanner)usedByRanges.get(r);
                        if (s == null) continue;
                        if (s == _dummyNullIndexScanner) {
                            if (!r.isIndexed(this._typeDesc)) continue;
                            int propertyIndex = this._typeDesc.getFixedPropertyPosition(r.getPath());
                            this.setFieldValue(propertyIndex, null);
                            this.setExtendedMatchCode(propertyIndex, (short)0);
                            customQueries.add(r);
                            continue;
                        }
                        queryIndexes.remove(s);
                    }
                }
            }
            if (!customQueries.isEmpty() || anyCompoundIndexCreated && !queryIndexes.isEmpty()) {
                CompoundAndCustomQuery customQuery = new CompoundAndCustomQuery(customQueries);
                customQuery.getCustomIndexes().addAll(queryIndexes);
                this.setCustomQuery(customQuery);
            }
        }
        this._preparedForSpace = true;
    }

    private boolean isRangeIndexed(Range range) {
        if (range.isUidsRange()) {
            return true;
        }
        if (range.getClass().equals(RelationRange.class)) {
            return range.isIndexed(this._typeDesc);
        }
        if (range.getFunctionCallDescription() != null) {
            return false;
        }
        return this._typeDesc.getIndexes().containsKey(range.getPath());
    }

    private IQueryIndexScanner buildCompoundIndexScannerFromSegmentRanges(CompoundIndex index, List<Range> possibleSegments) {
        if (possibleSegments.get(0).isEqualValueRange()) {
            return ExacValueCompoundIndexScanner.build(index.getName(), possibleSegments);
        }
        if (possibleSegments.get(0).isSegmentRange()) {
            if (!index.getIndexType().isOrdered()) {
                return null;
            }
            Range first = possibleSegments.get(0);
            return RangeCompoundIndexScanner.build(index.getName(), possibleSegments, first.isIndexed(this._typeDesc) && this._typeDesc.getIndexes().get(first.getPath()).getIndexType().isOrdered());
        }
        return null;
    }

    private void insertContainsItemsRanges(List<IContainsItemsCustomQuery> lq, HashMap<String, List<Range>> containsSamePathRanges, IContainsItemsCustomQuery root, HashMap<ContainsItemIntersectionBase, ContainsItemValueRange> containsIntersections) {
        for (IContainsItemsCustomQuery q : lq) {
            List<Object> lr;
            if (q.isRootHandler()) {
                this.insertContainsItemsRanges(((CompoundContainsItemsCustomQuery)q).getSubQueries(), containsSamePathRanges, q, containsIntersections);
                continue;
            }
            ContainsItemValueRange r = (ContainsItemValueRange)q;
            r.setRoot(root);
            if (r.supportsIntersection()) {
                ContainsItemIntersectionBase ib = new ContainsItemIntersectionBase(r);
                if (containsIntersections.containsKey(ib)) {
                    if (containsIntersections.get(ib).intersectIfPossible(r)) {
                        return;
                    }
                } else {
                    containsIntersections.put(ib, r);
                }
            }
            if (!this._ranges.containsKey(r.getPath())) {
                this._ranges.put(r.getPath(), r);
            }
            if (containsSamePathRanges.containsKey(r.getPath())) {
                lr = containsSamePathRanges.get(r.getPath());
                lr.add(r);
                continue;
            }
            lr = new ArrayList(2);
            lr.add(r);
            containsSamePathRanges.put(r.getPath(), lr);
        }
    }

    public void prepareForUnion(ITypeDesc typeDesc) {
        HashMap<String, Range> possibleCompoundSegments;
        this._allIndexValuesQuery = true;
        if (this._multipleUids != null) {
            this.setMultipleUIDs(this._multipleUids.toArray(new String[this._multipleUids.size()]));
            this._allIndexValuesQuery = false;
        }
        LinkedList<IQueryIndexScanner> queryIndexes = new LinkedList<IQueryIndexScanner>();
        ArrayList<ICustomQuery> customQueries = null;
        HashMap<String, List<Range>> containsSamePathRanges = null;
        if (this._containsItemsQueries != null && !this._containsItemsQueries.isEmpty()) {
            customQueries = new ArrayList<IContainsItemsCustomQuery>(this._containsItemsQueries);
            if (this._ranges == null) {
                this._ranges = new HashMap();
            }
            containsSamePathRanges = new HashMap<String, List<Range>>();
            HashMap<ContainsItemIntersectionBase, ContainsItemValueRange> containsIntersections = new HashMap<ContainsItemIntersectionBase, ContainsItemValueRange>();
            this.insertContainsItemsRanges(this._containsItemsQueries, containsSamePathRanges, null, containsIntersections);
        }
        HashMap<Range, IQueryIndexScanner> usedByRanges = null;
        HashMap<String, Range> hashMap = possibleCompoundSegments = typeDesc.anyCompoundIndex() && this._ranges != null ? new HashMap<String, Range>() : null;
        if (this._ranges != null) {
            Range routingRange;
            String routingPropertyName;
            if (customQueries == null) {
                customQueries = new ArrayList();
            }
            if ((routingPropertyName = typeDesc.getRoutingPropertyName()) != null && (routingRange = this._ranges.get(routingPropertyName)) != null) {
                int propertyIndex = this._typeDesc.getFixedPropertyPosition(routingPropertyName);
                routingRange.toEntryPacket(this, propertyIndex);
            }
            for (Map.Entry<String, Range> mapEntry : this._ranges.entrySet()) {
                Range range = mapEntry.getValue();
                if (!range.isInternalRange()) {
                    customQueries.add(mapEntry.getValue());
                }
                if (possibleCompoundSegments != null && range.suitableAsCompoundIndexSegment()) {
                    possibleCompoundSegments.put(mapEntry.getKey(), range);
                }
                if (this.isRangeIndexed(range)) {
                    IQueryIndexScanner indexScanner;
                    if (!range.isRelevantForAllIndexValuesOptimization()) {
                        this._allIndexValuesQuery = false;
                    }
                    if ((indexScanner = range.getIndexScanner()) != null) {
                        queryIndexes.add(indexScanner);
                        if (possibleCompoundSegments != null && range.suitableAsCompoundIndexSegment()) {
                            if (usedByRanges == null) {
                                usedByRanges = new HashMap<Range, IQueryIndexScanner>();
                            }
                            usedByRanges.put(range, indexScanner);
                        }
                    }
                    if (containsSamePathRanges == null || !containsSamePathRanges.containsKey(range.getPath())) continue;
                    List<Range> l = containsSamePathRanges.get(range.getPath());
                    Iterator iterator = l.iterator();
                    while (iterator.hasNext()) {
                        Range r = (Range)iterator.next();
                        if (r == range) continue;
                        IQueryIndexScanner is = r.getIndexScanner();
                        if (indexScanner == null) continue;
                        queryIndexes.add(is);
                    }
                    continue;
                }
                this._allIndexValuesQuery = false;
            }
            if (!customQueries.isEmpty() && possibleCompoundSegments != null && possibleCompoundSegments.size() > 1) {
                ArrayList<Range> possibleSegments = new ArrayList<Range>();
                for (SpaceIndex idx : typeDesc.getCompoundIndexes()) {
                    IQueryIndexScanner indexScanner;
                    possibleSegments.clear();
                    CompoundIndex index = (CompoundIndex)idx;
                    for (ISpaceCompoundIndexSegment seg : index.getCompoundIndexSegments()) {
                        Range checkedRange = (Range)possibleCompoundSegments.get(seg.getName());
                        if (checkedRange == null || checkedRange.getFunctionCallDescription() != null) {
                            possibleSegments.clear();
                            break;
                        }
                        possibleSegments.add((Range)possibleCompoundSegments.get(seg.getName()));
                    }
                    if (possibleSegments.isEmpty() || (indexScanner = this.buildCompoundIndexScannerFromSegmentRanges(index, possibleSegments)) == null) continue;
                    queryIndexes.add(indexScanner);
                    if (usedByRanges == null || usedByRanges.isEmpty()) continue;
                    for (Range r : possibleSegments) {
                        IQueryIndexScanner s = (IQueryIndexScanner)usedByRanges.get(r);
                        if (s == null) continue;
                        queryIndexes.remove(s);
                    }
                }
            }
            if (!customQueries.isEmpty()) {
                if (customQueries.size() == 1) {
                    ((ICustomQuery)customQueries.get(0)).getCustomIndexes().addAll(queryIndexes);
                    this.setCustomQuery((ICustomQuery)customQueries.get(0));
                } else {
                    CompoundAndCustomQuery customQuery = new CompoundAndCustomQuery(customQueries);
                    customQuery.getCustomIndexes().addAll(queryIndexes);
                    this.setCustomQuery(customQuery);
                }
            }
        }
        this._preparedForSpace = true;
    }

    public HashMap<String, Range> getRanges() {
        return this._ranges;
    }

    public boolean isAlwaysEmpty() {
        return this._isAlwaysEmpty;
    }

    public void setAlwaysEmpty(boolean isAlwaysEmpty) {
        this._isAlwaysEmpty = isAlwaysEmpty;
    }

    public boolean isComplex() {
        return false;
    }

    public QueryTemplatePacket buildAndPacket(QueryTemplatePacket packet) {
        return packet.and(this);
    }

    public QueryTemplatePacket and(QueryTemplatePacket template) {
        QueryTemplatePacket result = new QueryTemplatePacket(this);
        result.intersectRanges(template);
        result.intersectUids(template);
        result.uniteContainsItems(template);
        return result;
    }

    public QueryTemplatePacket and(UnionTemplatePacket template) {
        LinkedList<QueryTemplatePacket> optimizedPackets = new LinkedList<QueryTemplatePacket>();
        for (QueryTemplatePacket packet : template.getPackets()) {
            QueryTemplatePacket result = new QueryTemplatePacket(this);
            result.intersectRanges(packet);
            result.intersectUids(packet);
            if (result.isAlwaysEmpty()) continue;
            optimizedPackets.add(result);
        }
        if (optimizedPackets.isEmpty()) {
            template.setAlwaysEmpty(true);
        }
        template.setPackets(optimizedPackets);
        return template;
    }

    protected void intersectUids(QueryTemplatePacket template) {
        if (template.getMultipleUids() == null) {
            return;
        }
        if (this._multipleUids == null) {
            this._multipleUids = template.getMultipleUids();
            return;
        }
        this._multipleUids.retainAll(template.getMultipleUids());
    }

    public void intersectRanges(QueryTemplatePacket template) {
        for (Map.Entry<String, Range> entry : template.getRanges().entrySet()) {
            String fieldName = entry.getKey();
            Range newRange = entry.getValue();
            Range prevRange = this._ranges.get(fieldName);
            if (prevRange == null) {
                this._ranges.put(fieldName, newRange);
                continue;
            }
            Range intersection = prevRange.intersection(newRange);
            this._ranges.put(fieldName, intersection);
            if (!(intersection instanceof EmptyRange)) continue;
            this.setAlwaysEmpty(true);
            return;
        }
    }

    public Set<String> getMultipleUids() {
        return this._multipleUids;
    }

    public void setMultipleUids(Set<String> multipleUids) {
        this._multipleUids = multipleUids;
    }

    public void setExtendedMatchCode(int index, short eq) {
        this._extendedMatchCodes[index] = eq;
    }

    public void setRangeValue(int index, Object range) {
        if (this._rangeValues == null) {
            this._rangeValues = new Object[this._typeDesc.getNumOfFixedProperties()];
        }
        this._rangeValues[index] = range;
    }

    public void setRangeValueInclusion(int index, boolean include) {
        if (this._rangeValuesInclusion == null) {
            this._rangeValuesInclusion = new boolean[this._typeDesc.getNumOfFixedProperties()];
        }
        this._rangeValuesInclusion[index] = include;
    }

    public void setEntryType(EntryType objectType) {
        this._entryType = objectType;
    }

    @Override
    public QueryResultTypeInternal getQueryResultType() {
        return this._queryResultType;
    }

    public void setQueryResultType(QueryResultTypeInternal queryResultType) {
        this._queryResultType = queryResultType;
    }

    public QueryTemplatePacket buildOrPacket(QueryTemplatePacket packet) {
        return packet.union(this);
    }

    public QueryTemplatePacket union(UnionTemplatePacket composite) {
        composite.add(this);
        return composite;
    }

    public QueryTemplatePacket union(QueryTemplatePacket packet) {
        UnionTemplatePacket composite = new UnionTemplatePacket(this._table, packet.getQueryResultType());
        composite.add(this);
        composite.add(packet);
        return composite;
    }

    public IQueryResultSet<IEntryPacket> readMultiple(ISpaceProxy space, Transaction txn, int maxResults, int modifiers) throws Exception {
        return this.read(space, txn, 0L, modifiers, false, maxResults, 0);
    }

    @Override
    public Object getRoutingFieldValue() {
        return this._routing != null ? this._routing : super.getRoutingFieldValue();
    }

    public void setRouting(Object routing) {
        Object superRouting;
        this._routing = routing;
        if (ProtectiveMode.isAmbiguousQueryRoutingUsageProtectionEnabled() && routing != null && (superRouting = super.getRoutingFieldValue()) != null && !superRouting.equals(routing)) {
            throw new ProtectiveModeException("Ambiguous routing: Routing in SQL expression is <" + superRouting + "> and the SQLQuery's routing was explicitly set to <" + routing + "> (you can disable this protection, though it is not recommended, by setting the following system property: " + "com.gs.protectiveMode.ambiguousQueryRoutingUsage" + "=false)");
        }
    }

    @Override
    public AbstractProjectionTemplate getProjectionTemplate() {
        return this._projectionTemplate;
    }

    @Override
    public void setProjectionTemplate(AbstractProjectionTemplate projectionTemplate) {
        this._projectionTemplate = projectionTemplate;
    }

    public AggregationSet getAggregationSet() {
        return this._aggregationSet;
    }

    public void setAggregationSet(AggregationSet aggregationSet) {
        this._aggregationSet = aggregationSet;
    }

    public IQueryResultSet<IEntryPacket> read(ISpaceProxy space, AbstractDMLQuery query, Transaction txn, int modifiers, int maxResults) throws Exception {
        this.setRouting(query.getRouting());
        this.setProjectionTemplate(query.getProjectionTemplate());
        this.setQueryResultType(query.getQueryResultType());
        return this.read(space, txn, query.getTimeout(), modifiers, query.getIfExists(), maxResults, query.getMinEntriesToWaitFor());
    }

    public IQueryResultSet<IEntryPacket> read(ISpaceProxy space, Transaction txn, long timeout, int modifiers, boolean ifExists, int maxResults, int minEntriesToWaitFor) throws Exception {
        if (this.isAlwaysEmpty()) {
            return new ArrayListResult();
        }
        if (this.getAggregationSet() != null) {
            return AggregationsUtil.aggregate(this, this.getAggregationSet(), space, txn, modifiers);
        }
        if (maxResults == 1) {
            IEntryPacket result = (IEntryPacket)space.read(this, txn, timeout, modifiers, ifExists);
            if (result != null) {
                return new ArrayListResult(result);
            }
        } else {
            IEntryPacket[] result = timeout != 0L ? (IEntryPacket[])space.readMultiple(this, txn, timeout, maxResults, minEntriesToWaitFor, modifiers, false, ifExists) : (IEntryPacket[])space.readMultiple(this, txn, maxResults, modifiers);
            if (result != null) {
                return new ArrayListResult(result);
            }
        }
        return new ArrayListResult();
    }

    public ArrayList<IEntryPacket> take(IJSpace space, Object routing, AbstractProjectionTemplate projectionTemplate, Transaction txn, long timeout, int modifiers, boolean ifExists, int maxResults, int minEntriesToWaitFor, QueryResultTypeInternal resultType) throws RemoteException, TransactionException, UnusableEntryException, InterruptedException {
        ArrayList<IEntryPacket> entries = new ArrayList<IEntryPacket>();
        this.setRouting(routing);
        this.setQueryResultType(resultType);
        this.setProjectionTemplate(projectionTemplate);
        if (maxResults == 1) {
            ISpaceProxy spaceProxy = (ISpaceProxy)space;
            IEntryPacket result = (IEntryPacket)spaceProxy.take(this, txn, timeout, modifiers, ifExists);
            if (result != null) {
                entries.add(result);
            }
        } else {
            IEntryPacket[] result;
            if (timeout != 0L) {
                ISpaceProxy spaceProxy = (ISpaceProxy)space;
                result = (IEntryPacket[])spaceProxy.takeMultiple(this, txn, timeout, maxResults, minEntriesToWaitFor, modifiers, false, ifExists);
            } else {
                result = (IEntryPacket[])space.takeMultiple(this, txn, maxResults, modifiers);
            }
            if (result != null) {
                Collections.addAll(entries, result);
            }
        }
        return entries;
    }

    protected boolean matches(IEntryPacket entryPacket) {
        for (Map.Entry<String, Range> entry : this._ranges.entrySet()) {
            String fieldName = entry.getKey();
            Range range = entry.getValue();
            Object fieldValue = range.isNestedQuery() ? SQLUtil.getFieldValue(entryPacket, this._typeDesc, fieldName) : entryPacket.getPropertyValue(fieldName);
            if (range.getPredicate().execute(fieldValue)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(JoinedEntry joinedEntry) {
        IEntryPacket entry = joinedEntry.getEntry(this._table.getTableIndex());
        return this.matches(entry);
    }

    @Override
    public boolean isAllIndexValuesSqlQuery() {
        return this._allIndexValuesQuery;
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        this.serialize(out, PlatformLogicalVersion.getLogicalVersion());
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this.deserialize(in, PlatformLogicalVersion.getLogicalVersion());
    }

    @Override
    protected void writeExternal(ObjectOutput out, PlatformLogicalVersion version) throws IOException {
        super.writeExternal(out, version);
        this.serialize(out, version);
    }

    @Override
    protected void readExternal(ObjectInput in, PlatformLogicalVersion version) throws IOException, ClassNotFoundException {
        super.readExternal(in, version);
        this.deserialize(in, version);
    }

    private void serialize(ObjectOutput out, PlatformLogicalVersion version) throws IOException {
        if (this._containsItemsQueries != null && version.lessThan(PlatformLogicalVersion.v9_6_0) && !this._containsItemsQueries.isEmpty()) {
            throw new RuntimeException("cannot execute query- server version does not support contains-item");
        }
        out.writeByte(this._queryResultType.getCode());
        if (version.greaterOrEquals(PlatformLogicalVersion.v9_5_0)) {
            IOUtils.writeObject(out, this._projectionTemplate);
        }
        if (version.greaterOrEquals(PlatformLogicalVersion.v11_0_0)) {
            out.writeBoolean(this._allIndexValuesQuery);
        }
    }

    private void deserialize(ObjectInput in, PlatformLogicalVersion version) throws IOException, ClassNotFoundException {
        byte code = in.readByte();
        this._queryResultType = QueryResultTypeInternal.fromCode(code);
        if (this._queryResultType == null) {
            throw new IllegalStateException("code=" + code);
        }
        if (version.greaterOrEquals(PlatformLogicalVersion.v9_5_0)) {
            this._projectionTemplate = (AbstractProjectionTemplate)IOUtils.readObject(in);
        }
        if (version.greaterOrEquals(PlatformLogicalVersion.v11_0_0)) {
            this._allIndexValuesQuery = in.readBoolean();
        }
    }

    private void uniteContainsItems(QueryTemplatePacket template) {
        if (template._containsItemsQueries != null && !template._containsItemsQueries.isEmpty()) {
            if (this._containsItemsQueries != null) {
                this._containsItemsQueries.addAll(template._containsItemsQueries);
            } else {
                this._containsItemsQueries = template._containsItemsQueries;
            }
        }
    }

    public void setExplainPlan(ExplainPlan explainPlan) {
        this.explainPlan = explainPlan;
    }

    public ExplainPlan getExplainPlan() {
        return this.explainPlan;
    }
}

