/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.builder;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.query.CompoundAndIndexScanner;
import com.gigaspaces.internal.query.CompoundOrCustomQuery;
import com.gigaspaces.internal.query.CompoundOrIndexScanner;
import com.gigaspaces.internal.query.ICustomQuery;
import com.gigaspaces.internal.query.IQueryIndexScanner;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.jdbc.JoinedEntry;
import com.j_spaces.jdbc.builder.QueryTemplatePacket;
import com.j_spaces.jdbc.query.QueryTableData;
import java.util.LinkedList;
import java.util.List;

@InternalApi
public class UnionTemplatePacket
extends QueryTemplatePacket {
    private static final long serialVersionUID = 1L;
    private transient List<QueryTemplatePacket> _packets;
    private transient List<Object> _routingValues;

    public UnionTemplatePacket() {
    }

    public UnionTemplatePacket(QueryTableData table, QueryResultTypeInternal queryResultType) {
        super(table, queryResultType);
        this._packets = new LinkedList<QueryTemplatePacket>();
        this._routingValues = new LinkedList<Object>();
    }

    public List<QueryTemplatePacket> getPackets() {
        return this._packets;
    }

    public void setPackets(List<QueryTemplatePacket> packets) {
        this._packets = packets;
    }

    public void add(QueryTemplatePacket packet) {
        this._packets.add(packet);
    }

    @Override
    public QueryTemplatePacket buildOrPacket(QueryTemplatePacket packet) {
        return packet.union(this);
    }

    @Override
    public QueryTemplatePacket union(QueryTemplatePacket packet) {
        this.add(packet);
        return this;
    }

    @Override
    public QueryTemplatePacket union(UnionTemplatePacket composite) {
        this._packets.addAll(composite.getPackets());
        return this;
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public QueryTemplatePacket buildAndPacket(QueryTemplatePacket packet) {
        return packet.and(this);
    }

    @Override
    public QueryTemplatePacket and(QueryTemplatePacket template) {
        LinkedList<QueryTemplatePacket> optimizedPackets = new LinkedList<QueryTemplatePacket>();
        for (QueryTemplatePacket packet : this.getPackets()) {
            QueryTemplatePacket result = new QueryTemplatePacket(packet);
            result.intersectRanges(template);
            if (result.isAlwaysEmpty()) continue;
            optimizedPackets.add(result);
        }
        this.setPackets(optimizedPackets);
        if (optimizedPackets.isEmpty()) {
            this.setAlwaysEmpty(true);
        }
        return this;
    }

    @Override
    public QueryTemplatePacket and(UnionTemplatePacket template) {
        LinkedList<QueryTemplatePacket> optimizedPackets = new LinkedList<QueryTemplatePacket>();
        for (QueryTemplatePacket packet : this.getPackets()) {
            for (QueryTemplatePacket packet2 : template.getPackets()) {
                QueryTemplatePacket newPacket = new QueryTemplatePacket(packet);
                newPacket.intersectRanges(packet2);
                if (newPacket.isAlwaysEmpty()) continue;
                optimizedPackets.add(newPacket);
            }
        }
        this.setPackets(optimizedPackets);
        if (optimizedPackets.isEmpty()) {
            this.setAlwaysEmpty(true);
        }
        return this;
    }

    @Override
    public void prepareForSpace(ITypeDesc typeDesc) {
        if (this._preparedForSpace) {
            return;
        }
        if (this.isAlwaysEmpty()) {
            return;
        }
        this._allIndexValuesQuery = true;
        LinkedList<ICustomQuery> subQueries = new LinkedList<ICustomQuery>();
        CompoundOrIndexScanner indexScanner = new CompoundOrIndexScanner();
        for (QueryTemplatePacket packet : this._packets) {
            packet.prepareForUnion(typeDesc);
            this._allIndexValuesQuery &= packet.isAllIndexValuesSqlQuery();
            this.addRouting(packet);
            if (packet.getCustomQuery() == null) continue;
            subQueries.add(packet.getCustomQuery());
            List<IQueryIndexScanner> customIndexes = packet.getCustomQuery().getCustomIndexes();
            if (customIndexes == null || customIndexes.isEmpty()) continue;
            indexScanner.add(new CompoundAndIndexScanner(customIndexes));
        }
        if (this.getTypeDescriptor().getRoutingPropertyName() != null) {
            if (this._routingValues.size() == this._packets.size()) {
                Object lastRouting = this._routingValues.get(0);
                for (Object routing : this._routingValues) {
                    if (lastRouting == routing) continue;
                    lastRouting = null;
                }
                this.setPropertyValue(this.getTypeDescriptor().getRoutingPropertyName(), lastRouting);
            } else {
                this._routingValues.clear();
            }
        }
        if (subQueries.size() > 0) {
            CompoundOrCustomQuery orQuery = new CompoundOrCustomQuery(subQueries);
            if (indexScanner.getIndexScanners().size() == subQueries.size()) {
                orQuery.addCustomIndex(indexScanner);
            }
            this.setCustomQuery(orQuery);
        }
        this._preparedForSpace = true;
    }

    private void addRouting(QueryTemplatePacket packet) {
        Object routing = packet.getRoutingFieldValue();
        if (routing != null) {
            this._routingValues.add(routing);
        }
    }

    @Override
    protected boolean matches(IEntryPacket entryPacket) {
        for (QueryTemplatePacket packet : this._packets) {
            boolean isInRange = packet.matches(entryPacket);
            if (!isInRange) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(JoinedEntry joinedEntry) {
        for (QueryTemplatePacket packet : this._packets) {
            boolean isInRange = packet.matches(joinedEntry);
            if (!isInRange) continue;
            return true;
        }
        return false;
    }
}

