/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.builder.range;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.query.predicate.composite.AllSpacePredicate;
import com.j_spaces.core.client.SQLQuery;
import com.j_spaces.jdbc.builder.QueryTemplatePacket;
import com.j_spaces.jdbc.builder.range.EqualValueRange;
import com.j_spaces.jdbc.builder.range.InRange;
import com.j_spaces.jdbc.builder.range.IsNullRange;
import com.j_spaces.jdbc.builder.range.NotEqualValueRange;
import com.j_spaces.jdbc.builder.range.NotNullRange;
import com.j_spaces.jdbc.builder.range.NotRegexRange;
import com.j_spaces.jdbc.builder.range.Range;
import com.j_spaces.jdbc.builder.range.RegexRange;
import com.j_spaces.jdbc.builder.range.RelationRange;
import com.j_spaces.jdbc.builder.range.SegmentRange;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;

@InternalApi
public class CompositeRange
extends Range {
    private static final long serialVersionUID = 1L;
    private LinkedList<Range> _ranges = new LinkedList();

    public CompositeRange() {
    }

    public CompositeRange(Range r1, Range r2) {
        super(r1.getPath(), null, new AllSpacePredicate());
        this.add(r1);
        this.add(r2);
    }

    public CompositeRange(String path) {
        super(path, null, new AllSpacePredicate());
    }

    public CompositeRange add(Range range) {
        this._ranges.add(range);
        ((AllSpacePredicate)this.getPredicate()).addOperand(range.getPredicate());
        return this;
    }

    @Override
    public Range intersection(Range range) {
        CompositeRange newRange = new CompositeRange(this.getPath());
        for (Range r : this._ranges) {
            newRange.add(r);
        }
        newRange.add(range);
        return newRange;
    }

    @Override
    public Range intersection(SegmentRange range) {
        return range.intersection(this);
    }

    @Override
    public Range intersection(EqualValueRange range) {
        return range.intersection(this);
    }

    @Override
    public Range intersection(NotEqualValueRange range) {
        return range.intersection(this);
    }

    @Override
    public Range intersection(NotNullRange range) {
        return range.intersection(this);
    }

    @Override
    public Range intersection(IsNullRange range) {
        return range.intersection(this);
    }

    @Override
    public void toEntryPacket(QueryTemplatePacket e, int index) {
        this._ranges.getFirst().toEntryPacket(e, index);
    }

    @Override
    public Range intersection(RegexRange range) {
        return range.intersection(this);
    }

    @Override
    public Range intersection(RelationRange range) {
        return this.add(range);
    }

    @Override
    public Range intersection(NotRegexRange range) {
        return range.intersection(this);
    }

    @Override
    public Range intersection(InRange range) {
        return range.intersection(this);
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public boolean isRelevantForAllIndexValuesOptimization() {
        boolean res = true;
        if (this._ranges != null) {
            for (Range r : this._ranges) {
                res &= r.isRelevantForAllIndexValuesOptimization();
            }
        }
        return res;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._ranges = (LinkedList)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this._ranges);
    }

    @Override
    public SQLQuery toSQLQuery(ITypeDesc typeDesc) {
        LinkedList<Object> preparedValues = new LinkedList<Object>();
        StringBuilder b = new StringBuilder();
        for (Range query : this._ranges) {
            SQLQuery sqlQuery = query.toSQLQuery(typeDesc);
            if (b.length() > 0) {
                b.append(" and ");
            }
            b.append(sqlQuery.getQuery());
            if (sqlQuery.getParameters() == null) continue;
            for (int i = 0; i < sqlQuery.getParameters().length; ++i) {
                preparedValues.add(sqlQuery.getParameters()[i]);
            }
        }
        return new SQLQuery(typeDesc.getTypeName(), b.toString(), preparedValues.toArray());
    }

    public LinkedList<Range> get_ranges() {
        return this._ranges;
    }
}

