/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.builder.range;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.query.IQueryIndexScanner;
import com.gigaspaces.internal.query.predicate.comparison.ContainsPredicate;
import com.gigaspaces.server.ServerEntry;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.client.SQLQuery;
import com.j_spaces.jdbc.builder.QueryTemplateBuilder;
import com.j_spaces.jdbc.builder.QueryTemplatePacket;
import com.j_spaces.jdbc.builder.range.ContainsCompositeRange;
import com.j_spaces.jdbc.builder.range.EqualValueRange;
import com.j_spaces.jdbc.builder.range.FunctionCallDescription;
import com.j_spaces.jdbc.builder.range.InRange;
import com.j_spaces.jdbc.builder.range.IsNullRange;
import com.j_spaces.jdbc.builder.range.NotEqualValueRange;
import com.j_spaces.jdbc.builder.range.NotNullRange;
import com.j_spaces.jdbc.builder.range.NotRegexRange;
import com.j_spaces.jdbc.builder.range.Range;
import com.j_spaces.jdbc.builder.range.RegexRange;
import com.j_spaces.jdbc.builder.range.RelationRange;
import com.j_spaces.jdbc.builder.range.SegmentRange;
import com.j_spaces.jdbc.builder.range.SingleValueRange;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class ContainsValueRange
extends SingleValueRange {
    private static final long serialVersionUID = 1L;
    protected short _templateMatchCode;

    public ContainsValueRange() {
    }

    public ContainsValueRange(String colName, FunctionCallDescription functionCallDescription, Object value, short templateMatchCode) {
        this(colName, functionCallDescription, value, templateMatchCode, new ContainsPredicate(value, functionCallDescription, colName, templateMatchCode));
    }

    public ContainsValueRange(String colName, FunctionCallDescription functionCallDescription, Object value, short templateMatchCode, ContainsPredicate predicate) {
        super(colName, functionCallDescription, value, predicate);
        this._templateMatchCode = templateMatchCode;
    }

    @Override
    public void toEntryPacket(QueryTemplatePacket e, int index) {
    }

    @Override
    public Range intersection(Range range) {
        return new ContainsCompositeRange(this, range);
    }

    @Override
    public Range intersection(EqualValueRange range) {
        throw new IllegalStateException("Range intersection paths are different: '" + this.getPath() + "' != '" + range.getPath() + "'");
    }

    @Override
    public Range intersection(SegmentRange range) {
        throw new IllegalStateException("Range intersection paths are different: '" + this.getPath() + "' != '" + range.getPath() + "'");
    }

    @Override
    public Range intersection(NotEqualValueRange range) {
        throw new IllegalStateException("Range intersection paths are different: '" + this.getPath() + "' != '" + range.getPath() + "'");
    }

    @Override
    public Range intersection(IsNullRange range) {
        throw new IllegalStateException("Range intersection paths are different: '" + this.getPath() + "' != '" + range.getPath() + "'");
    }

    @Override
    public Range intersection(NotNullRange range) {
        throw new IllegalStateException("Range intersection paths are different: '" + this.getPath() + "' != '" + range.getPath() + "'");
    }

    @Override
    public Range intersection(RegexRange range) {
        throw new IllegalStateException("Range intersection paths are different: '" + this.getPath() + "' != '" + range.getPath() + "'");
    }

    @Override
    public Range intersection(NotRegexRange range) {
        throw new IllegalStateException("Range intersection paths are different: '" + this.getPath() + "' != '" + range.getPath() + "'");
    }

    @Override
    public Range intersection(InRange range) {
        throw new IllegalStateException("Range intersection paths are different: '" + this.getPath() + "' != '" + range.getPath() + "'");
    }

    @Override
    public Range intersection(RelationRange range) {
        throw new IllegalStateException("Range intersection paths are different: '" + this.getPath() + "' != '" + range.getPath() + "'");
    }

    @Override
    public SQLQuery toSQLQuery(ITypeDesc typeDesc) {
        return new SQLQuery<String>(typeDesc.getTypeName(), "");
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public boolean matches(CacheManager cacheManager, ServerEntry entry, String skipAlreadyMatchedIndexPath) {
        return this.getPredicate().execute(entry);
    }

    @Override
    public IQueryIndexScanner getIndexScanner() {
        return QueryTemplateBuilder.toRange(this.getPath(), this.getFunctionCallDescription(), this.getValue(), this._templateMatchCode).getIndexScanner();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._templateMatchCode = in.readShort();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeShort(this._templateMatchCode);
    }

    public short getTemplateMatchCode() {
        return this._templateMatchCode;
    }
}

