/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.builder.range;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.query.IQueryIndexScanner;
import com.gigaspaces.internal.query.QueryIndexes;
import com.gigaspaces.internal.query.predicate.comparison.EqualsSpacePredicate;
import com.j_spaces.core.client.SQLQuery;
import com.j_spaces.jdbc.SQLFunctions;
import com.j_spaces.jdbc.builder.QueryTemplatePacket;
import com.j_spaces.jdbc.builder.range.CompositeRange;
import com.j_spaces.jdbc.builder.range.EmptyRange;
import com.j_spaces.jdbc.builder.range.FunctionCallDescription;
import com.j_spaces.jdbc.builder.range.InRange;
import com.j_spaces.jdbc.builder.range.IsNullRange;
import com.j_spaces.jdbc.builder.range.NotEqualValueRange;
import com.j_spaces.jdbc.builder.range.NotNullRange;
import com.j_spaces.jdbc.builder.range.NotRegexRange;
import com.j_spaces.jdbc.builder.range.Range;
import com.j_spaces.jdbc.builder.range.RegexRange;
import com.j_spaces.jdbc.builder.range.RelationRange;
import com.j_spaces.jdbc.builder.range.SegmentRange;
import com.j_spaces.jdbc.builder.range.SingleValueRange;
import com.j_spaces.sadapter.datasource.DefaultSQLQueryBuilder;

@InternalApi
public class EqualValueRange
extends SingleValueRange {
    private static final long serialVersionUID = 1L;

    public EqualValueRange() {
    }

    public EqualValueRange(String colName, FunctionCallDescription functionCallDescription, Object value) {
        super(colName, functionCallDescription, value, new EqualsSpacePredicate(value, functionCallDescription));
    }

    public EqualValueRange(String colName, Object value) {
        this(colName, null, value);
    }

    @Override
    public void toEntryPacket(QueryTemplatePacket e, int index) {
        ITypeDesc typeDesc = e.getTypeDescriptor();
        String idPropertyName = typeDesc.getIdPropertyName();
        e.setFieldValue(index, this.getValue());
        e.setExtendedMatchCode(index, (short)0);
    }

    @Override
    public Range intersection(Range range) {
        return range.intersection(this);
    }

    @Override
    public Range intersection(EqualValueRange range) {
        if (!this.hasFunctionCallDescription(this) && !this.hasFunctionCallDescription(range)) {
            if (this.getValue().equals(range.getValue())) {
                return this;
            }
            return EMPTY_RANGE;
        }
        if (!this.twoBuiltInFunctions(this, range)) {
            return new CompositeRange(this, range);
        }
        if (this.hasFunctionCallDescription(this) && !this.hasFunctionCallDescription(range)) {
            Object applyOrNull = SQLFunctions.apply(this.getFunction(), this.getFunctionCallDescription().setColumnValue(range.getValue()));
            if (applyOrNull != null && applyOrNull.equals(this.getValue())) {
                return range;
            }
            return new EmptyRange();
        }
        if (!this.hasFunctionCallDescription(this) && this.hasFunctionCallDescription(range)) {
            FunctionCallDescription functionCallDescription = range.getFunctionCallDescription();
            Object valueToSearch = range.getValue();
            Object applyOrNull = SQLFunctions.apply(range.getFunction(), range.getFunctionCallDescription().setColumnValue(this.getValue()));
            String colName = range.getPath();
            return this.equalValueWithOneFunction(range, functionCallDescription, valueToSearch, applyOrNull, colName);
        }
        if (this.hasFunctionCallDescription(this) && this.hasFunctionCallDescription(range)) {
            if (this.hasSameFunction(range)) {
                if (this.getValue().equals(range.getValue())) {
                    return this;
                }
                return EMPTY_RANGE;
            }
            return new CompositeRange(this, range);
        }
        return new CompositeRange(this, range);
    }

    private Range equalValueWithOneFunction(EqualValueRange range, FunctionCallDescription functionCallDescription, Object valueToSearch, Object applyOrNull, String colName) {
        if (applyOrNull == null) {
            return new CompositeRange(this, range);
        }
        if (!applyOrNull.equals(valueToSearch)) {
            return EMPTY_RANGE;
        }
        return new EqualValueRange(colName, functionCallDescription, valueToSearch);
    }

    @Override
    public Range intersection(SegmentRange range) {
        return range.intersection(this);
    }

    @Override
    public Range intersection(NotEqualValueRange range) {
        if (!this.hasFunctionCallDescription(this) && !this.hasFunctionCallDescription(range)) {
            return this.isEqualValues(range);
        }
        if (!this.twoBuiltInFunctions(this, range)) {
            return new CompositeRange(this, range);
        }
        if (this.hasFunctionCallDescription(this) && !this.hasFunctionCallDescription(range)) {
            return new CompositeRange(this, range);
        }
        if (!this.hasFunctionCallDescription(this) && this.hasFunctionCallDescription(range)) {
            Object notEqualValue = range.getValue();
            Object applyOrNull = SQLFunctions.apply(range.getFunction(), range.getFunctionCallDescription().setColumnValue(this.getValue()));
            if (applyOrNull != null) {
                if (applyOrNull.equals(notEqualValue)) {
                    return EMPTY_RANGE;
                }
                return this;
            }
            return new CompositeRange(this, range);
        }
        if (this.hasFunctionCallDescription(this) && this.hasFunctionCallDescription(range)) {
            if (this.hasSameFunction(range)) {
                return this.isEqualValues(range);
            }
            return new CompositeRange(this, range);
        }
        return new CompositeRange(this, range);
    }

    private Range isEqualValues(NotEqualValueRange range) {
        if (this.getValue().equals(range.getValue())) {
            return EMPTY_RANGE;
        }
        return this;
    }

    @Override
    public Range intersection(IsNullRange range) {
        return EMPTY_RANGE;
    }

    @Override
    public Range intersection(NotNullRange range) {
        return this;
    }

    @Override
    public Range intersection(RegexRange range) {
        return new CompositeRange(range, this);
    }

    @Override
    public Range intersection(NotRegexRange range) {
        return new CompositeRange(range, this);
    }

    @Override
    public IQueryIndexScanner getIndexScanner() {
        return QueryIndexes.newIndexScanner(this.getPath(), this.getValue());
    }

    @Override
    public SQLQuery toSQLQuery(ITypeDesc typeDesc) {
        return new SQLQuery(typeDesc.getTypeName(), this.getPath() + DefaultSQLQueryBuilder.mapCodeToSign((short)0) + "?", this.getValue());
    }

    @Override
    public Range intersection(InRange range) {
        return range.intersection(this);
    }

    @Override
    public Range intersection(RelationRange range) {
        return new CompositeRange(range, this);
    }

    @Override
    public boolean suitableAsCompoundIndexSegment() {
        return true;
    }

    @Override
    public boolean isEqualValueRange() {
        return true;
    }
}

