/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.builder.range;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.query.sql.functions.SqlFunctionExecutionContext;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@InternalApi
public class FunctionCallDescription
implements Externalizable,
SqlFunctionExecutionContext {
    private static final long serialVersionUID = 1L;
    private String name;
    private List<Object> args;
    private int columnIndex;

    public FunctionCallDescription() {
        this.args = Collections.emptyList();
    }

    public FunctionCallDescription(String name, int columnIndex, List<Object> args) {
        this.name = name;
        this.columnIndex = columnIndex;
        this.args = args;
    }

    public String getName() {
        return this.name;
    }

    public void setArgs(List<Object> args) {
        this.args = args;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public int getNumberOfArguments() {
        return this.args.size();
    }

    @Override
    public Object getArgument(int index) {
        return this.args.get(index);
    }

    public FunctionCallDescription setColumnValue(Object value) {
        this.args.set(this.columnIndex, value);
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeString(out, this.name);
        out.writeInt(this.columnIndex);
        out.writeObject(this.args);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = IOUtils.readString(in);
        this.columnIndex = in.readInt();
        this.args = (List)in.readObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionCallDescription that = (FunctionCallDescription)o;
        return this.columnIndex == that.columnIndex && Objects.equals(this.name, that.name) && Objects.equals(this.args, that.args);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.args, this.columnIndex);
    }
}

