/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.builder.range;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.query.IQueryIndexScanner;
import com.gigaspaces.internal.query.InValueIndexScanner;
import com.gigaspaces.internal.query.predicate.comparison.InSpacePredicate;
import com.gigaspaces.query.sql.functions.SqlFunction;
import com.j_spaces.core.client.SQLQuery;
import com.j_spaces.jdbc.SQLFunctions;
import com.j_spaces.jdbc.builder.QueryTemplatePacket;
import com.j_spaces.jdbc.builder.range.CompositeRange;
import com.j_spaces.jdbc.builder.range.EqualValueRange;
import com.j_spaces.jdbc.builder.range.FunctionCallDescription;
import com.j_spaces.jdbc.builder.range.IsNullRange;
import com.j_spaces.jdbc.builder.range.NotEqualValueRange;
import com.j_spaces.jdbc.builder.range.NotNullRange;
import com.j_spaces.jdbc.builder.range.NotRegexRange;
import com.j_spaces.jdbc.builder.range.Range;
import com.j_spaces.jdbc.builder.range.RegexRange;
import com.j_spaces.jdbc.builder.range.RelationRange;
import com.j_spaces.jdbc.builder.range.SegmentRange;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

@InternalApi
public class InRange
extends Range {
    private static final long serialVersionUID = 1L;

    public Set getInValues() {
        InSpacePredicate inSpacePredicate = (InSpacePredicate)this.getPredicate();
        return inSpacePredicate.getInValues();
    }

    public InRange() {
    }

    public InRange(String colName, Set inValues) {
        this(colName, null, inValues);
    }

    public InRange(String colName, FunctionCallDescription functionCallDescription, Set inValues) {
        super(colName, functionCallDescription, new InSpacePredicate(inValues));
    }

    @Override
    public Range intersection(Range range) {
        return range.intersection(this);
    }

    @Override
    public Range intersection(SegmentRange range) {
        return range.intersection(this);
    }

    @Override
    public Range intersection(EqualValueRange range) {
        if (!this.hasFunctionCallDescription(this) && !this.hasFunctionCallDescription(range)) {
            if (this.getInValues().contains(range.getValue())) {
                return range;
            }
            return EMPTY_RANGE;
        }
        if (!this.twoBuiltInFunctions(this, range)) {
            return new CompositeRange(this, range);
        }
        if (this.hasFunctionCallDescription(this) && !this.hasFunctionCallDescription(range)) {
            HashSet<Object> matchObjects = new HashSet<Object>();
            for (Object inValue : this.getInValues()) {
                if (!SQLFunctions.apply(this.getFunction(), this.getFunctionCallDescription().setColumnValue(range.getValue())).equals(inValue)) continue;
                matchObjects.add(inValue);
            }
            return this.chooseRange(matchObjects);
        }
        if (!this.hasFunctionCallDescription(this) && this.hasFunctionCallDescription(range)) {
            HashSet<Object> matchObjects = new HashSet<Object>();
            Object valueToSearch = range.getValue();
            for (Object inValue : this.getInValues()) {
                if (!SQLFunctions.apply(range.getFunction(), range.getFunctionCallDescription().setColumnValue(inValue)).equals(valueToSearch)) continue;
                matchObjects.add(inValue);
            }
            return this.chooseRange(matchObjects);
        }
        if (this.hasFunctionCallDescription(this) && this.hasFunctionCallDescription(range)) {
            if (this.hasSameFunction(range)) {
                for (Object inValue : this.getInValues()) {
                    if (!inValue.equals(range.getValue())) continue;
                    return range;
                }
                return EMPTY_RANGE;
            }
            return new CompositeRange(this, range);
        }
        return new CompositeRange(this, range);
    }

    @Override
    public Range intersection(NotEqualValueRange range) {
        if (!this.hasFunctionCallDescription(this) && !this.hasFunctionCallDescription(range)) {
            HashSet<Object> matchObjects = new HashSet<Object>();
            for (Object inValue : this.getInValues()) {
                if (inValue.equals(range.getValue())) continue;
                matchObjects.add(inValue);
            }
            return this.chooseRange(matchObjects);
        }
        if (!this.twoBuiltInFunctions(this, range)) {
            return new CompositeRange(this, range);
        }
        if (this.hasFunctionCallDescription(this) && !this.hasFunctionCallDescription(range)) {
            return new CompositeRange(this, range);
        }
        if (!this.hasFunctionCallDescription(this) && this.hasFunctionCallDescription(range)) {
            HashSet<Object> matchObjects = new HashSet<Object>();
            for (Object inValue : this.getInValues()) {
                if (SQLFunctions.apply(range.getFunction(), range.getFunctionCallDescription().setColumnValue(inValue)).equals(range.getValue())) continue;
                matchObjects.add(inValue);
            }
            return this.chooseRange(matchObjects);
        }
        if (this.hasFunctionCallDescription(this) && this.hasFunctionCallDescription(range)) {
            if (this.hasSameFunction(range)) {
                HashSet<Object> matchObjects = new HashSet<Object>();
                for (Object inValue : this.getInValues()) {
                    Object value;
                    if (inValue.equals(value = range.getValue())) continue;
                    matchObjects.add(inValue);
                }
                return this.chooseRange(matchObjects);
            }
            return new CompositeRange(this, range);
        }
        return new CompositeRange(this, range);
    }

    @Override
    public Range intersection(IsNullRange range) {
        if (this.getInValues().contains(null)) {
            return this;
        }
        return Range.EMPTY_RANGE;
    }

    @Override
    public Range intersection(NotNullRange range) {
        if (this.getInValues().contains(null)) {
            HashSet inValues = new HashSet(this.getInValues());
            inValues.remove(null);
            return new InRange(this.getPath(), this.getFunctionCallDescription(), inValues);
        }
        return this;
    }

    @Override
    public Range intersection(InRange range) {
        if (!this.hasFunctionCallDescription(this) && !this.hasFunctionCallDescription(range)) {
            HashSet<Object> matchObjects = new HashSet<Object>();
            Set myInValues = this.getInValues();
            Set otherInValues = range.getInValues();
            for (Object myInValue : myInValues) {
                if (!otherInValues.contains(myInValue)) continue;
                matchObjects.add(myInValue);
            }
            return this.chooseRange(matchObjects);
        }
        if (!this.twoBuiltInFunctions(this, range)) {
            return new CompositeRange(this, range);
        }
        if (this.hasFunctionOnlyOnOneSide(this, range)) {
            HashSet<Object> matchObjects = new HashSet<Object>();
            if (this.hasFunctionCallDescription(this)) {
                for (Object rangeInValue : range.getInValues()) {
                    if (!this.getInValues().contains(SQLFunctions.apply(this.getFunction(), this.getFunctionCallDescription().setColumnValue(rangeInValue)))) continue;
                    matchObjects.add(rangeInValue);
                }
                return this.chooseRange(matchObjects);
            }
            for (Object inValue : this.getInValues()) {
                FunctionCallDescription ctx = range.getFunctionCallDescription().setColumnValue(inValue);
                SqlFunction function = range.getFunction();
                Object o = SQLFunctions.apply(function, ctx);
                if (!range.getInValues().contains(o)) continue;
                matchObjects.add(inValue);
            }
            return this.chooseRange(matchObjects);
        }
        if (this.hasFunctionCallDescription(this) && this.hasFunctionCallDescription(range)) {
            return new CompositeRange(this, range);
        }
        return new CompositeRange(this, range);
    }

    @Override
    public void toEntryPacket(QueryTemplatePacket e, int index) {
    }

    @Override
    public Range intersection(NotRegexRange range) {
        return new CompositeRange(range, this);
    }

    @Override
    public SQLQuery toSQLQuery(ITypeDesc typeDesc) {
        StringBuilder sqlQuerybuilder = new StringBuilder(this.getPath());
        sqlQuerybuilder.append(" in (");
        Iterator iterator = this.getInValues().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            sqlQuerybuilder.append("?");
            if (!iterator.hasNext()) continue;
            sqlQuerybuilder.append(",");
        }
        sqlQuerybuilder.append(")");
        SQLQuery<String> query = new SQLQuery<String>(typeDesc.getTypeName(), sqlQuerybuilder.toString());
        int index = 0;
        for (Object inValue : this.getInValues()) {
            query.setParameter(++index, inValue);
        }
        return query;
    }

    @Override
    public Range intersection(RegexRange range) {
        return new CompositeRange(range, this);
    }

    @Override
    public Range intersection(RelationRange range) {
        return new CompositeRange(range, this);
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public IQueryIndexScanner getIndexScanner() {
        return new InValueIndexScanner(this.getPath(), this.getInValues());
    }
}

