/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.builder.range;

import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.query.AbstractCustomQuery;
import com.gigaspaces.internal.query.IQueryIndexScanner;
import com.gigaspaces.internal.query.predicate.ISpacePredicate;
import com.gigaspaces.internal.query.valuegetter.ISpaceValueGetter;
import com.gigaspaces.internal.query.valuegetter.SpaceEntryPathGetter;
import com.gigaspaces.internal.query.valuegetter.SpaceEntryPropertyGetter;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.query.sql.functions.SqlFunction;
import com.gigaspaces.server.ServerEntry;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.jdbc.SQLFunctions;
import com.j_spaces.jdbc.builder.QueryTemplatePacket;
import com.j_spaces.jdbc.builder.range.CompositeRange;
import com.j_spaces.jdbc.builder.range.EmptyRange;
import com.j_spaces.jdbc.builder.range.EqualValueRange;
import com.j_spaces.jdbc.builder.range.FunctionCallDescription;
import com.j_spaces.jdbc.builder.range.InRange;
import com.j_spaces.jdbc.builder.range.IsNullRange;
import com.j_spaces.jdbc.builder.range.NotEqualValueRange;
import com.j_spaces.jdbc.builder.range.NotNullRange;
import com.j_spaces.jdbc.builder.range.NotRegexRange;
import com.j_spaces.jdbc.builder.range.RegexRange;
import com.j_spaces.jdbc.builder.range.RelationRange;
import com.j_spaces.jdbc.builder.range.SegmentRange;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.Set;

public abstract class Range
extends AbstractCustomQuery {
    private static final long serialVersionUID = 1L;
    private transient String _path;
    private FunctionCallDescription functionCallDescription;
    private transient boolean _isNested;
    private ISpaceValueGetter<ServerEntry> _valueGetter;
    private ISpacePredicate _predicate;
    private SqlFunction function;
    public static final EmptyRange EMPTY_RANGE = new EmptyRange();

    public Range() {
    }

    protected Range(String path, FunctionCallDescription functionCallDescription, ISpacePredicate predicate) {
        this._path = path;
        this._isNested = Range.isNested(path);
        this._valueGetter = this._isNested ? new SpaceEntryPathGetter(path) : new SpaceEntryPropertyGetter(path);
        this._predicate = predicate;
        this.setFunctionCallDescription(functionCallDescription);
    }

    public boolean isIndexed(ITypeDesc typeDesc) {
        return this.functionCallDescription == null && typeDesc.getIndexes().containsKey(this._path);
    }

    public ISpacePredicate getPredicate() {
        return this._predicate;
    }

    public String getPath() {
        return this._path;
    }

    public boolean isNestedQuery() {
        return this._isNested;
    }

    @Override
    public boolean matches(CacheManager cacheManager, ServerEntry entry, String skipAlreadyMatchedIndexPath) {
        if (skipAlreadyMatchedIndexPath != null && skipAlreadyMatchedIndexPath.equals(this.getPath())) {
            return true;
        }
        Object value = this._valueGetter.getValue(entry);
        if (this instanceof CompositeRange) {
            return this.handleCompositeRange((CompositeRange)this, value, cacheManager);
        }
        return this.matchRange(this, value, cacheManager);
    }

    private boolean handleCompositeRange(CompositeRange compositeRange, Object value, CacheManager cacheManager) {
        LinkedList<Range> ranges = compositeRange.get_ranges();
        int size = ranges.size();
        boolean[] booleans = new boolean[size];
        for (int i = 0; i < size; ++i) {
            boolean matchRange;
            Range range = ranges.get(i);
            booleans[i] = matchRange = this.matchRange(range, value, cacheManager);
        }
        return this.checkIfAllTrue(booleans);
    }

    private boolean checkIfAllTrue(boolean[] booleans) {
        for (boolean aBoolean : booleans) {
            if (aBoolean) continue;
            return false;
        }
        return true;
    }

    private boolean matchRange(Range range, Object value, CacheManager cacheManager) {
        if (range.getFunctionCallDescription() != null && range.getFunction() == null) {
            SqlFunction sqlFunction = cacheManager.getSqlFunctions().create(range.getFunctionCallDescription());
            if (sqlFunction != null) {
                range.setFunction(sqlFunction);
            } else {
                throw new RuntimeException("can't find SQL function: " + range.getFunctionCallDescription().getName());
            }
        }
        if (range.getFunction() != null) {
            try {
                value = SQLFunctions.apply(range.getFunction(), range.getFunctionCallDescription().setColumnValue(value));
            }
            catch (Exception e) {
                return false;
            }
        }
        if (range.getPredicate().requiresCacheManagerForExecution()) {
            range.getPredicate().setCacheManagerForExecution(cacheManager);
        }
        return range.getPredicate().execute(value);
    }

    private static boolean isNested(String path) {
        return path.indexOf(46) != -1;
    }

    public void toEntryPacket(QueryTemplatePacket e, int index) {
    }

    public boolean isComplex() {
        return this.functionCallDescription != null;
    }

    public IQueryIndexScanner getIndexScanner() {
        return null;
    }

    public abstract Range intersection(Range var1);

    public Range intersection(EmptyRange range) {
        return range;
    }

    public Range intersection(CompositeRange range) {
        return range.intersection(this);
    }

    public boolean suitableAsCompoundIndexSegment() {
        return false;
    }

    public boolean isEqualValueRange() {
        return false;
    }

    public boolean isSegmentRange() {
        return false;
    }

    public boolean isInternalRange() {
        return false;
    }

    public boolean isEmptyRange() {
        return false;
    }

    public abstract Range intersection(IsNullRange var1);

    public abstract Range intersection(NotNullRange var1);

    public abstract Range intersection(EqualValueRange var1);

    public abstract Range intersection(NotEqualValueRange var1);

    public abstract Range intersection(RegexRange var1);

    public abstract Range intersection(NotRegexRange var1);

    public abstract Range intersection(SegmentRange var1);

    public abstract Range intersection(InRange var1);

    public abstract Range intersection(RelationRange var1);

    public boolean isRelevantForAllIndexValuesOptimization() {
        return false;
    }

    public FunctionCallDescription getFunctionCallDescription() {
        return this.functionCallDescription;
    }

    public void setFunctionCallDescription(FunctionCallDescription functionCallDescription) {
        String functionName;
        this.functionCallDescription = functionCallDescription;
        if (functionCallDescription != null && SQLFunctions.isBuiltIn(functionName = functionCallDescription.getName())) {
            this.function = SQLFunctions.getBuildInFunction(functionName);
        }
    }

    protected boolean hasSameFunction(Range range) {
        return range.functionCallDescription == null && this.functionCallDescription == null || range.functionCallDescription != null && range.functionCallDescription.equals(this.functionCallDescription);
    }

    protected boolean hasFunctionCallDescription(Range range) {
        return range.getFunctionCallDescription() != null && range.getFunctionCallDescription().getName() != null && !range.getFunctionCallDescription().getName().isEmpty();
    }

    protected boolean twoBuiltInFunctions(Range range1, Range range2) {
        boolean isBuiltinFunctionRange1 = true;
        boolean isBuiltinFunctionRange2 = true;
        if (range1.getFunctionCallDescription() != null) {
            String range1FunctionName = range1.getFunctionCallDescription().getName();
            isBuiltinFunctionRange1 = SQLFunctions.isBuiltIn(range1FunctionName);
        }
        if (range2.getFunctionCallDescription() != null) {
            String range2FunctionName = range2.getFunctionCallDescription().getName();
            isBuiltinFunctionRange2 = SQLFunctions.isBuiltIn(range2FunctionName);
        }
        return isBuiltinFunctionRange1 && isBuiltinFunctionRange2;
    }

    public SqlFunction getFunction() {
        return this.function;
    }

    public void setFunction(SqlFunction function) {
        this.function = function;
    }

    public boolean isUidsRange() {
        return false;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._valueGetter = (ISpaceValueGetter)in.readObject();
        this._predicate = (ISpacePredicate)in.readObject();
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v11_0_0)) {
            this.setFunctionCallDescription((FunctionCallDescription)in.readObject());
        }
        this._path = this._valueGetter instanceof SpaceEntryPathGetter ? ((SpaceEntryPathGetter)this._valueGetter).getPath() : (this._valueGetter instanceof SpaceEntryPropertyGetter ? ((SpaceEntryPropertyGetter)this._valueGetter).getPropertyName() : "");
        this._isNested = Range.isNested(this._path);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this._valueGetter);
        out.writeObject(this._predicate);
        out.writeObject(this.functionCallDescription);
    }

    protected Range chooseRange(Set<Object> matchObjects) {
        if (matchObjects.size() >= 2) {
            return new InRange(this.getPath(), null, matchObjects);
        }
        if (matchObjects.size() == 1) {
            return new EqualValueRange(this.getPath(), null, matchObjects.iterator().next());
        }
        return EMPTY_RANGE;
    }

    protected boolean hasFunctionOnlyOnOneSide(Range range, Range range1) {
        return this.hasFunctionCallDescription(range) && !this.hasFunctionCallDescription(range1) || !this.hasFunctionCallDescription(range) && this.hasFunctionCallDescription(range1);
    }
}

