/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.builder.range;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.query.IQueryIndexScanner;
import com.gigaspaces.internal.query.RelationIndexScanner;
import com.gigaspaces.internal.query.predicate.comparison.RelationPredicate;
import com.j_spaces.core.client.SQLQuery;
import com.j_spaces.jdbc.builder.range.CompositeRange;
import com.j_spaces.jdbc.builder.range.EqualValueRange;
import com.j_spaces.jdbc.builder.range.InRange;
import com.j_spaces.jdbc.builder.range.IsNullRange;
import com.j_spaces.jdbc.builder.range.NotEqualValueRange;
import com.j_spaces.jdbc.builder.range.NotNullRange;
import com.j_spaces.jdbc.builder.range.NotRegexRange;
import com.j_spaces.jdbc.builder.range.Range;
import com.j_spaces.jdbc.builder.range.RegexRange;
import com.j_spaces.jdbc.builder.range.SegmentRange;
import com.j_spaces.jdbc.builder.range.SingleValueRange;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class RelationRange
extends SingleValueRange {
    private static final long serialVersionUID = 1L;
    private static final Logger _logger = Logger.getLogger(RelationRange.class.getName());
    private String typeName;
    private String namespace;
    private String relation;

    public RelationRange() {
    }

    public RelationRange(String typeName, String columnPath, Object subject, String namespace, String relation) {
        super(columnPath, null, subject, new RelationPredicate(namespace, typeName, columnPath, relation, subject));
        this.typeName = typeName;
        this.namespace = namespace;
        this.relation = relation;
    }

    public String getRelation() {
        return this.relation;
    }

    @Override
    public Range intersection(Range range) {
        return range.intersection(this);
    }

    @Override
    public Range intersection(IsNullRange range) {
        return EMPTY_RANGE;
    }

    @Override
    public Range intersection(NotNullRange range) {
        return this;
    }

    @Override
    public Range intersection(EqualValueRange range) {
        return new CompositeRange(range, this);
    }

    @Override
    public Range intersection(NotEqualValueRange range) {
        return new CompositeRange(this, range);
    }

    @Override
    public Range intersection(RegexRange range) {
        return new CompositeRange(this, range);
    }

    @Override
    public Range intersection(NotRegexRange range) {
        return new CompositeRange(this, range);
    }

    @Override
    public Range intersection(SegmentRange range) {
        return new CompositeRange(range, this);
    }

    @Override
    public Range intersection(InRange range) {
        return new CompositeRange(this, range);
    }

    @Override
    public Range intersection(RelationRange range) {
        if (this.equals(range) && range.getValue().equals(this.getValue())) {
            return this;
        }
        return new CompositeRange(this, range);
    }

    @Override
    public SQLQuery toSQLQuery(ITypeDesc typeDesc) {
        return null;
    }

    @Override
    public IQueryIndexScanner getIndexScanner() {
        return new RelationIndexScanner(this.typeName, this.getPath(), this.namespace, this.relation, this.getValue());
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        IOUtils.writeString(out, this.typeName);
        IOUtils.writeString(out, this.namespace);
        IOUtils.writeString(out, this.relation);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.typeName = IOUtils.readString(in);
        this.namespace = IOUtils.readString(in);
        this.relation = IOUtils.readString(in);
    }

    @Override
    public boolean isIndexed(ITypeDesc typeDesc) {
        boolean result;
        boolean bl = result = typeDesc.getQueryExtensions() != null && typeDesc.getQueryExtensions().isIndexed(this.namespace, this.getPath());
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "isIndexed(" + this.typeName + "." + this.getPath() + ") - " + result);
        }
        return result;
    }

    @Override
    public boolean isRelevantForAllIndexValuesOptimization() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationRange that = (RelationRange)o;
        return Objects.equals(this.typeName, that.typeName) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.relation, that.relation);
    }

    public int hashCode() {
        return Objects.hash(this.typeName, this.namespace, this.relation);
    }
}

