/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.builder.range;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.query.IQueryIndexScanner;
import com.gigaspaces.internal.query.QueryIndexes;
import com.gigaspaces.internal.query.predicate.ISpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.BetweenSpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.GreaterEqualsSpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.GreaterSpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.LessEqualsSpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.LessSpacePredicate;
import com.j_spaces.core.client.SQLQuery;
import com.j_spaces.jdbc.SQLFunctions;
import com.j_spaces.jdbc.builder.QueryTemplatePacket;
import com.j_spaces.jdbc.builder.range.CompositeRange;
import com.j_spaces.jdbc.builder.range.EqualValueRange;
import com.j_spaces.jdbc.builder.range.FunctionCallDescription;
import com.j_spaces.jdbc.builder.range.InRange;
import com.j_spaces.jdbc.builder.range.IsNullRange;
import com.j_spaces.jdbc.builder.range.NotEqualValueRange;
import com.j_spaces.jdbc.builder.range.NotNullRange;
import com.j_spaces.jdbc.builder.range.NotRegexRange;
import com.j_spaces.jdbc.builder.range.Range;
import com.j_spaces.jdbc.builder.range.RegexRange;
import com.j_spaces.jdbc.builder.range.RelationRange;
import com.j_spaces.sadapter.datasource.DefaultSQLQueryBuilder;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

@InternalApi
public class SegmentRange
extends Range {
    private static final long serialVersionUID = 1L;
    private Comparable _min;
    private boolean _includeMin;
    private Comparable _max;
    private boolean _includeMax;

    public SegmentRange() {
    }

    public SegmentRange(String colName, Comparable<?> value1, boolean includeMin, Comparable<?> value2, boolean includeMax) {
        this(colName, null, value1, includeMin, value2, includeMax);
    }

    public SegmentRange(String colName, FunctionCallDescription functionCallDescription, Comparable<?> value1, boolean includeMin, Comparable<?> value2, boolean includeMax) {
        super(colName, functionCallDescription, SegmentRange.createSpacePredicate(value1, includeMin, value2, includeMax));
        this._min = value1;
        this._max = value2;
        if (this._min != null && this._max != null && this._min.compareTo(this._max) > 0) {
            throw new IllegalArgumentException("Invalid range (" + value1 + "," + value2 + ")");
        }
        this._includeMin = includeMin;
        this._includeMax = includeMax;
    }

    private static ISpacePredicate createSpacePredicate(Comparable<?> value1, boolean includeMin, Comparable<?> value2, boolean includeMax) {
        if (value1 != null && value2 != null) {
            return new BetweenSpacePredicate(value1, value2, includeMin, includeMax);
        }
        if (value1 != null) {
            return includeMin ? new GreaterEqualsSpacePredicate(value1) : new GreaterSpacePredicate(value1);
        }
        if (value2 != null) {
            return includeMax ? new LessEqualsSpacePredicate(value2) : new LessSpacePredicate(value2);
        }
        throw new IllegalArgumentException("Both values cannot be null.");
    }

    public Comparable getMin() {
        return this._min;
    }

    public Comparable getMax() {
        return this._max;
    }

    public boolean isIncludeMin() {
        return this._includeMin;
    }

    public void setIncludeMin(boolean includeMin) {
        this._includeMin = includeMin;
    }

    public void setIncludeMax(boolean includeMax) {
        this._includeMax = includeMax;
    }

    public boolean isIncludeMax() {
        return this._includeMax;
    }

    @Override
    public void toEntryPacket(QueryTemplatePacket e, int index) {
        if (this.getMin() == null) {
            e.setFieldValue(index, this.getMax());
            e.setExtendedMatchCode(index, this._includeMax ? (short)5 : 4);
        } else if (this.getMax() == null) {
            e.setFieldValue(index, this.getMin());
            e.setExtendedMatchCode(index, this._includeMin ? (short)3 : 2);
        } else {
            e.setFieldValue(index, this.getMin());
            e.setExtendedMatchCode(index, this._includeMin ? (short)3 : 2);
            e.setRangeValue(index, this.getMax());
            e.setRangeValueInclusion(index, this._includeMax);
        }
    }

    public boolean contains(Comparable value) {
        int compareTo;
        if (this._min != null && ((compareTo = this._min.compareTo(value)) > 0 || compareTo == 0 && !this._includeMin)) {
            return false;
        }
        return this._max == null || (compareTo = this._max.compareTo(value)) >= 0 && (compareTo != 0 || this._includeMax);
    }

    @Override
    public Range intersection(SegmentRange range) {
        if (!this.hasFunctionCallDescription(this) && !this.hasFunctionCallDescription(range)) {
            return this.handleSegmentWithSegment(range);
        }
        if (!this.twoBuiltInFunctions(this, range)) {
            return new CompositeRange(this, range);
        }
        if (this.hasFunctionOnlyOnOneSide(this, range)) {
            return new CompositeRange(this, range);
        }
        if (this.hasFunctionCallDescription(this) && this.hasFunctionCallDescription(range)) {
            if (this.hasSameFunction(range)) {
                return this.handleSegmentWithSegment(range);
            }
            return new CompositeRange(this, range);
        }
        return new CompositeRange(this, range);
    }

    private Range handleSegmentWithSegment(SegmentRange range) {
        boolean includeMax;
        Comparable max;
        boolean includeMin;
        Comparable min;
        if (this.getMin() == null) {
            min = range.getMin();
            includeMin = range.isIncludeMin();
        } else if (range.getMin() == null) {
            min = this.getMin();
            includeMin = this.isIncludeMin();
        } else if (this.getMin().compareTo(range.getMin()) == 0) {
            min = this.getMin();
            includeMin = this.isIncludeMin() && range.isIncludeMin();
        } else if (this.getMin().compareTo(range.getMin()) > 0) {
            min = this.getMin();
            includeMin = this.isIncludeMin();
        } else {
            min = range.getMin();
            includeMin = range.isIncludeMin();
        }
        if (this.getMax() == null) {
            max = range.getMax();
            includeMax = range.isIncludeMax();
        } else if (range.getMax() == null) {
            max = this.getMax();
            includeMax = this.isIncludeMax();
        } else if (this.getMax().compareTo(range.getMax()) == 0) {
            max = this.getMax();
            includeMax = this.isIncludeMax() && range.isIncludeMax();
        } else if (this.getMax().compareTo(range.getMax()) < 0) {
            max = this.getMax();
            includeMax = this.isIncludeMax();
        } else {
            max = range.getMax();
            includeMax = range.isIncludeMax();
        }
        if (min == null && max == null) {
            return EMPTY_RANGE;
        }
        if (min != null && max != null) {
            if (min.equals(max)) {
                if (includeMin && includeMax) {
                    return new EqualValueRange(this.getPath(), this.getFunctionCallDescription(), min);
                }
                return EMPTY_RANGE;
            }
            if (min.compareTo(max) > 0) {
                return EMPTY_RANGE;
            }
        }
        return new SegmentRange(this.getPath(), this.getFunctionCallDescription(), min, includeMin, max, includeMax);
    }

    @Override
    public Range intersection(Range range) {
        return range.intersection(this);
    }

    @Override
    public Range intersection(EqualValueRange range) {
        if (!this.hasFunctionCallDescription(this) && !this.hasFunctionCallDescription(range)) {
            if (this.contains((Comparable)range.getValue())) {
                return range;
            }
            return EMPTY_RANGE;
        }
        if (!this.twoBuiltInFunctions(this, range)) {
            return new CompositeRange(this, range);
        }
        if (this.hasFunctionCallDescription(this) && !this.hasFunctionCallDescription(range)) {
            Object applyOrNull = SQLFunctions.apply(this.getFunction(), this.getFunctionCallDescription().setColumnValue(range.getValue()));
            if (applyOrNull != null) {
                if (this.contains((Comparable)applyOrNull)) {
                    return range;
                }
                return EMPTY_RANGE;
            }
            return new CompositeRange(this, range);
        }
        if (!this.hasFunctionCallDescription(this) && this.hasFunctionCallDescription(range)) {
            return new CompositeRange(this, range);
        }
        if (this.hasFunctionCallDescription(this) && this.hasFunctionCallDescription(range)) {
            if (this.hasSameFunction(range)) {
                if (this.contains((Comparable)range.getValue())) {
                    return range;
                }
                return EMPTY_RANGE;
            }
            return new CompositeRange(this, range);
        }
        return new CompositeRange(this, range);
    }

    @Override
    public Range intersection(NotEqualValueRange range) {
        if (!this.hasFunctionCallDescription(this) && !this.hasFunctionCallDescription(range)) {
            return this.checkEdges(range);
        }
        if (!this.twoBuiltInFunctions(this, range)) {
            return new CompositeRange(this, range);
        }
        if (this.hasFunctionCallDescription(this) && !this.hasFunctionCallDescription(range)) {
            return new CompositeRange(this, range);
        }
        if (!this.hasFunctionCallDescription(this) && this.hasFunctionCallDescription(range)) {
            Object applyOnMin = SQLFunctions.apply(range.getFunction(), range.getFunctionCallDescription().setColumnValue(this.getMin()));
            Object applyOnMax = SQLFunctions.apply(range.getFunction(), range.getFunctionCallDescription().setColumnValue(this.getMax()));
            Object notEqualValue = range.getValue();
            if (applyOnMin != null && applyOnMax != null) {
                boolean isFuncOnMinNotEqual = applyOnMin.equals(notEqualValue);
                boolean isFuncOnMaxNotEqual = applyOnMax.equals(notEqualValue);
                if (!isFuncOnMinNotEqual && !isFuncOnMaxNotEqual) {
                    return new CompositeRange(this, range);
                }
                return new SegmentRange(this.getPath(), this.getFunctionCallDescription(), this.getMin(), !isFuncOnMinNotEqual, this.getMax(), !isFuncOnMaxNotEqual);
            }
            return new CompositeRange(this, range);
        }
        if (this.hasFunctionCallDescription(this) && this.hasFunctionCallDescription(range)) {
            if (this.hasSameFunction(range)) {
                return this.checkEdges(range);
            }
            return new CompositeRange(this, range);
        }
        return new CompositeRange(this, range);
    }

    private Range checkEdges(NotEqualValueRange range) {
        if (this.getMin() != null && this.getMin().equals(range.getValue())) {
            return new SegmentRange(this.getPath(), this.getFunctionCallDescription(), this.getMin(), false, this.getMax(), this.isIncludeMax());
        }
        if (this.getMax() != null && this.getMax().equals(range.getValue())) {
            return new SegmentRange(this.getPath(), this.getFunctionCallDescription(), this.getMin(), this.isIncludeMin(), this.getMax(), false);
        }
        if (this.contains((Comparable)range.getValue())) {
            return new CompositeRange(this, range);
        }
        return this;
    }

    @Override
    public Range intersection(IsNullRange range) {
        return EMPTY_RANGE;
    }

    @Override
    public Range intersection(NotNullRange range) {
        return this;
    }

    @Override
    public Range intersection(RegexRange range) {
        return new CompositeRange(this, range);
    }

    @Override
    public Range intersection(NotRegexRange range) {
        return new CompositeRange(this, range);
    }

    @Override
    public Range intersection(InRange range) {
        if (!this.hasFunctionCallDescription(this) && !this.hasFunctionCallDescription(range)) {
            HashSet<Object> matchObjects = new HashSet<Object>();
            for (Object inRangeValue : range.getInValues()) {
                if (!this.contains((Comparable)inRangeValue)) continue;
                matchObjects.add(inRangeValue);
            }
            return this.chooseRange(matchObjects);
        }
        if (!this.twoBuiltInFunctions(this, range)) {
            return new CompositeRange(this, range);
        }
        if (this.hasFunctionCallDescription(this) && !this.hasFunctionCallDescription(range)) {
            HashSet<Object> matchObjects = new HashSet<Object>();
            Set inRangeValues = range.getInValues();
            for (Object inRangeValue : inRangeValues) {
                Object apply = SQLFunctions.apply(this.getFunction(), this.getFunctionCallDescription().setColumnValue(inRangeValue));
                if (apply == null || !this.contains((Comparable)apply)) continue;
                matchObjects.add(inRangeValue);
            }
            return this.chooseRange(matchObjects);
        }
        if (!this.hasFunctionCallDescription(this) && this.hasFunctionCallDescription(range)) {
            return new CompositeRange(this, range);
        }
        if (this.hasFunctionCallDescription(this) && this.hasFunctionCallDescription(range)) {
            return new CompositeRange(this, range);
        }
        return new CompositeRange(this, range);
    }

    @Override
    public Range intersection(RelationRange range) {
        return new CompositeRange(this, range);
    }

    @Override
    public boolean suitableAsCompoundIndexSegment() {
        return false;
    }

    @Override
    public boolean isSegmentRange() {
        return true;
    }

    @Override
    public boolean isRelevantForAllIndexValuesOptimization() {
        return true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._min = (Comparable)IOUtils.readObject(in);
        this._includeMin = in.readBoolean();
        this._max = (Comparable)IOUtils.readObject(in);
        this._includeMax = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        IOUtils.writeObject(out, this._min);
        out.writeBoolean(this._includeMin);
        IOUtils.writeObject(out, this._max);
        out.writeBoolean(this._includeMax);
    }

    @Override
    public IQueryIndexScanner getIndexScanner() {
        return QueryIndexes.newRangeIndexScanner(this.getPath(), this._min, this._includeMin, this._max, this._includeMax);
    }

    @Override
    public SQLQuery toSQLQuery(ITypeDesc typeDesc) {
        LinkedList<Comparable> parameters = new LinkedList<Comparable>();
        StringBuilder b = new StringBuilder();
        if (this._min != null) {
            b.append(this.getPath()).append(DefaultSQLQueryBuilder.mapCodeToSign(this._includeMin ? (short)3 : 2)).append("?");
            parameters.add(this._min);
        }
        if (this._max != null) {
            if (b.length() > 0) {
                b.append(" and ");
            }
            b.append(this.getPath()).append(DefaultSQLQueryBuilder.mapCodeToSign(this._includeMax ? (short)5 : 4)).append("?");
            parameters.add(this._max);
        }
        return new SQLQuery(typeDesc.getTypeName(), b.toString(), parameters.toArray());
    }
}

