/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.builder.range;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.query.IQueryIndexScanner;
import com.gigaspaces.internal.query.UidsIndexScanner;
import com.gigaspaces.internal.query.predicate.comparison.InSpacePredicate;
import com.gigaspaces.server.ServerEntry;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.core.client.SQLQuery;
import com.j_spaces.jdbc.builder.QueryTemplatePacket;
import com.j_spaces.jdbc.builder.range.CompositeRange;
import com.j_spaces.jdbc.builder.range.EqualValueRange;
import com.j_spaces.jdbc.builder.range.FunctionCallDescription;
import com.j_spaces.jdbc.builder.range.InRange;
import com.j_spaces.jdbc.builder.range.IsNullRange;
import com.j_spaces.jdbc.builder.range.NotEqualValueRange;
import com.j_spaces.jdbc.builder.range.NotNullRange;
import com.j_spaces.jdbc.builder.range.NotRegexRange;
import com.j_spaces.jdbc.builder.range.Range;
import com.j_spaces.jdbc.builder.range.RegexRange;
import com.j_spaces.jdbc.builder.range.RelationRange;
import com.j_spaces.jdbc.builder.range.SegmentRange;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

@InternalApi
public class UidsRange
extends Range {
    private static final long serialVersionUID = 1L;
    private transient Set<String> _uids;

    public Set getInValues() {
        InSpacePredicate inSpacePredicate = (InSpacePredicate)this.getPredicate();
        return inSpacePredicate.getInValues();
    }

    public UidsRange() {
    }

    public UidsRange(String colName, Set inValues) {
        this(colName, null, inValues);
    }

    public UidsRange(String colName, FunctionCallDescription functionCallDescription, Set inValues) {
        super(colName, functionCallDescription, new InSpacePredicate(inValues));
    }

    @Override
    public Range intersection(Range range) {
        if (range.isUidsRange()) {
            return this.intersectionUids((UidsRange)range);
        }
        return range.intersection(this);
    }

    @Override
    public Range intersection(SegmentRange range) {
        return new CompositeRange(range, this);
    }

    @Override
    public Range intersection(EqualValueRange range) {
        return new CompositeRange(this, range);
    }

    @Override
    public Range intersection(NotEqualValueRange range) {
        return new CompositeRange(this, range);
    }

    @Override
    public Range intersection(IsNullRange range) {
        return Range.EMPTY_RANGE;
    }

    @Override
    public Range intersection(NotNullRange range) {
        return this;
    }

    @Override
    public Range intersection(InRange range) {
        return new CompositeRange(this, range);
    }

    private Range intersectionUids(UidsRange range) {
        HashSet<Object> matchObjects = new HashSet<Object>();
        Set myInValues = this.getInValues();
        Set otherInValues = range.getInValues();
        for (Object myInValue : myInValues) {
            if (!otherInValues.contains(myInValue)) continue;
            matchObjects.add(myInValue);
        }
        return this.chooseUidsRange(matchObjects);
    }

    private Range chooseUidsRange(Set<Object> matchObjects) {
        if (matchObjects.size() >= 1) {
            return new UidsRange(this.getPath(), null, matchObjects);
        }
        return EMPTY_RANGE;
    }

    @Override
    public void toEntryPacket(QueryTemplatePacket e, int index) {
    }

    @Override
    public Range intersection(NotRegexRange range) {
        return new CompositeRange(range, this);
    }

    @Override
    public SQLQuery toSQLQuery(ITypeDesc typeDesc) {
        StringBuilder sqlQuerybuilder = new StringBuilder(this.getPath());
        sqlQuerybuilder.append(" in (");
        Iterator iterator = this.getInValues().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            sqlQuerybuilder.append("?");
            if (!iterator.hasNext()) continue;
            sqlQuerybuilder.append(",");
        }
        sqlQuerybuilder.append(")");
        SQLQuery<String> query = new SQLQuery<String>(typeDesc.getTypeName(), sqlQuerybuilder.toString());
        int index = 0;
        for (Object inValue : this.getInValues()) {
            query.setParameter(++index, inValue);
        }
        return query;
    }

    @Override
    public Range intersection(RegexRange range) {
        return new CompositeRange(range, this);
    }

    @Override
    public Range intersection(RelationRange range) {
        return new CompositeRange(range, this);
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public IQueryIndexScanner getIndexScanner() {
        return new UidsIndexScanner(this.getPath(), this.getInValues());
    }

    @Override
    public boolean isIndexed(ITypeDesc typeDesc) {
        return true;
    }

    @Override
    public boolean matches(CacheManager cacheManager, ServerEntry entry, String skipAlreadyMatchedIndexPath) {
        Context context = cacheManager.viewCacheContext();
        if (context == null) {
            throw new RuntimeException("UidsRange and no cache context!!!!!!!!!!");
        }
        if (this._uids == null) {
            this._uids = this.getInValues();
        }
        String uid = context.getOnMatchUid();
        return this._uids.contains(uid);
    }

    @Override
    public boolean isUidsRange() {
        return true;
    }

    @Override
    public boolean isRelevantForAllIndexValuesOptimization() {
        return true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
    }
}

