/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.driver;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.jdbc.driver.BlobOutputStream;
import com.j_spaces.jdbc.driver.ObjectWithUID;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;

@InternalApi
public class Blob
extends ObjectWithUID
implements java.sql.Blob,
Comparable {
    private static final long serialVersionUID = 7084515297198345838L;
    protected byte[] blob;
    protected transient Connection conn;

    public Blob(byte[] blob, Connection conn) throws SQLException {
        if (blob == null) {
            throw new SQLException("Blob cannot hold null data", "GSP", -131);
        }
        this.blob = blob;
        this.conn = conn;
    }

    public Blob(byte[] blob) {
        this.blob = blob;
    }

    @Override
    public long length() throws SQLException {
        return this.blob.length;
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw new SQLException("Command not supported!", "GSP", -132);
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos < 1L || length < 1) {
            throw new SQLException("Both parameters should be greater than 1", "GSP", -133);
        }
        if (pos + (long)length > (long)(this.blob.length + 1)) {
            length = this.blob.length - (int)pos + 1;
        }
        byte[] newarray = new byte[length];
        System.arraycopy(this.blob, (int)pos - 1, newarray, 0, length);
        return newarray;
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new SQLException("Command not supported!", "GSP", -132);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new SQLException("Command not supported!", "GSP", -132);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        boolean found = false;
        while (!found) {
            if ((long)pattern.length + start > (long)(this.blob.length + 1)) {
                return -1L;
            }
            found = true;
            for (int i = 0; i <= pattern.length; ++i) {
                if (pattern[i] == this.blob[i + (int)start - 1]) continue;
                found = false;
                break;
            }
            if (found) continue;
            ++start;
        }
        return start;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.blob);
    }

    public OutputStream getBinaryOutputStream() throws SQLException {
        return this.setBinaryStream(0L);
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        return new BlobOutputStream(this, (int)pos);
    }

    @Override
    public long position(java.sql.Blob pattern, long start) throws SQLException {
        Blob gBlob = (Blob)pattern;
        return this.position(gBlob.blob, start);
    }

    public boolean equals(Object ob) {
        if (!(ob instanceof Blob)) {
            return false;
        }
        Blob oBlob = (Blob)ob;
        if (oBlob.blob.length != this.blob.length) {
            return false;
        }
        for (int i = 0; i < this.blob.length; ++i) {
            if (this.blob[i] == oBlob.blob[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int sum = 0;
        for (int i = 0; i < this.blob.length; ++i) {
            sum += this.blob[i];
        }
        return sum;
    }

    public int compareTo(Object other) throws ClassCastException {
        return this.hashCode() - ((Blob)other).hashCode();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("BLOB[");
        for (int i = 0; i < this.blob.length; ++i) {
            buffer.append(this.blob[i]);
            buffer.append(',');
        }
        buffer.deleteCharAt(buffer.length() - 1);
        buffer.append(']');
        return buffer.toString();
    }

    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    @Override
    public void free() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

