/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.driver;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.jdbc.driver.Blob;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;

@InternalApi
public class BlobOutputStream
extends OutputStream {
    private Blob blob = null;
    private int startPosition = 0;

    public BlobOutputStream(Blob blob, int position) {
        this.blob = blob;
        this.startPosition = position;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        byte[] newarray = new byte[this.blob.blob.length + len];
        System.arraycopy(bytes, off, newarray, this.startPosition, len);
        this.blob.blob = newarray;
        this.updateSpace();
    }

    @Override
    public void write(int c) throws IOException {
        this.write(new byte[]{(byte)c});
    }

    public void updateSpace() throws IOException {
        PreparedStatement ps = null;
        try {
            ps = this.blob.conn.prepareStatement("UPDATE BY UID SET LOB=?");
            ps.setBlob(1, this.blob);
            ps.executeUpdate();
        }
        catch (SQLException sqle) {
            throw new IOException(sqle.getMessage());
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }
}

