/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.driver;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.jdbc.driver.ClobWriter;
import com.j_spaces.jdbc.driver.ObjectWithUID;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;

@InternalApi
public class Clob
extends ObjectWithUID
implements java.sql.Clob,
Comparable {
    static final long serialVersionUID = 8586407571272951992L;
    protected String clob;
    protected transient Connection conn;

    public Clob(String clob, Connection conn) throws SQLException {
        if (clob == null) {
            throw new SQLException("Clob cannot hold null data", "GSP", -134);
        }
        this.clob = clob;
        this.conn = conn;
    }

    public Clob(String clob) {
        this.clob = clob;
    }

    public String getClobData() {
        return this.clob;
    }

    @Override
    public long length() throws SQLException {
        return this.clob.length();
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw new SQLException("Command not supported!", "GSP", -132);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        try {
            byte[] asciiBytes = this.clob.getBytes("ASCII");
            return new ByteArrayInputStream(asciiBytes);
        }
        catch (UnsupportedEncodingException uee) {
            throw new SQLException("Can't convert clob to ASCII, unsupported encoding", "GSP", -135);
        }
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw new SQLException("Command  not supported!", "GSP", -132);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return new StringReader(this.clob);
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        return new ClobWriter(this, (int)pos);
    }

    public Writer getCharacterOutputStream() throws SQLException {
        return this.setCharacterStream(0L);
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        int p = (int)pos - 1;
        if (p < 0 || length < 1 || p + length > this.clob.length()) {
            throw new SQLException("Substring out of clob's bounds", "GSP", -136);
        }
        return this.clob.substring(p, p + length);
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        throw new SQLException("Command not supported!", "GSP", -132);
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        throw new SQLException("Command not supported!", "GSP", -132);
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        for (int i = (int)start - 1; i < this.clob.length(); ++i) {
            if (!this.clob.regionMatches(i, searchstr, 0, searchstr.length())) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long position(java.sql.Clob searchstr, long start) throws SQLException {
        Clob gClob = (Clob)searchstr;
        return this.position(gClob.clob, start);
    }

    public boolean equals(Object ob) {
        if (!(ob instanceof Clob)) {
            return false;
        }
        Clob oClob = (Clob)ob;
        return oClob.clob.equals(this.clob);
    }

    public int hashCode() {
        return this.clob.hashCode();
    }

    public int compareTo(Object other) throws ClassCastException {
        if (other instanceof Clob) {
            return this.clob.compareTo(((Clob)other).clob);
        }
        return -1;
    }

    public String toString() {
        return "CLOB[" + this.clob + "]";
    }

    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    @Override
    public void free() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

