/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.driver;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.jdbc.driver.Clob;
import java.io.IOException;
import java.io.Writer;
import java.sql.PreparedStatement;
import java.sql.SQLException;

@InternalApi
public class ClobWriter
extends Writer {
    private final Clob clob;

    public ClobWriter(Clob clob, int position) {
        this.clob = clob;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.writeIntoClob(new String(cbuf));
    }

    @Override
    public void write(int c) throws IOException {
        this.writeIntoClob(new String(new char[]{(char)c}));
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.writeIntoClob(str.substring(off, off + len));
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writeIntoClob(new String(cbuf, off, len));
    }

    @Override
    public void write(String str) throws IOException {
        this.writeIntoClob(str);
    }

    private void writeIntoClob(String newString) throws IOException {
        this.clob.clob = newString;
        this.updateSpace();
    }

    private void updateSpace() throws IOException {
        PreparedStatement ps = null;
        try {
            ps = this.clob.conn.prepareStatement("UPDATE BY UID SET LOB=?");
            ps.setClob(1, this.clob);
            ps.executeUpdate();
        }
        catch (SQLException sqle) {
            throw new IOException(sqle.getMessage());
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }
}

