/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.driver;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.router.SpaceProxyRouter;
import com.gigaspaces.internal.server.space.IRemoteSpace;
import com.gigaspaces.security.directory.DefaultCredentialsProvider;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.client.BasicTypeInfo;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.jdbc.ConnectionContext;
import com.j_spaces.jdbc.ExtendedRequestPacket;
import com.j_spaces.jdbc.IQueryProcessor;
import com.j_spaces.jdbc.QueryProcessorFactory;
import com.j_spaces.jdbc.RequestPacket;
import com.j_spaces.jdbc.ResponsePacket;
import com.j_spaces.jdbc.ResultEntry;
import com.j_spaces.jdbc.batching.BatchResponsePacket;
import com.j_spaces.jdbc.driver.Blob;
import com.j_spaces.jdbc.driver.Clob;
import com.j_spaces.jdbc.driver.GDatabaseMetaData;
import com.j_spaces.jdbc.driver.GPreparedStatement;
import com.j_spaces.jdbc.driver.GResultSet;
import com.j_spaces.jdbc.driver.GStatement;
import com.j_spaces.jdbc.request.SetAutoCommitRequest;
import com.j_spaces.jdbc.request.SetTransaction;
import com.j_spaces.jdbc.request.SetUseSingleSpace;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.server.ServerTransaction;

@InternalApi
public class GConnection
implements Connection {
    public static final String READ_MODIFIERS = "readModifiers";
    public static final String JDBC_GIGASPACES = "jdbc:gigaspaces:";
    public static final String JDBC_GIGASPACES_URL = "jdbc:gigaspaces:url:";
    private static final long EXECUTE_RETRY_TIMEOUT = 60000L;
    private String url;
    private ISpaceProxy space;
    private IQueryProcessor qp;
    private ConnectionContext context;
    private Integer readModifiers;
    private Properties properties;

    private GConnection(IJSpace space, Properties properties) throws SQLException {
        try {
            this.url = JDBC_GIGASPACES_URL + space.getURL().getURL();
            this.space = (ISpaceProxy)space;
            this.properties = properties;
            this.initialize(space.getDirectProxy().getRemoteJSpace());
        }
        catch (Exception e) {
            SQLException se = new SQLException("Connect to space failed:[ " + space.getURL().getURL() + "]");
            se.initCause(e);
            throw se;
        }
    }

    public GConnection(String url, Properties properties) throws SQLException {
        try {
            if (!url.startsWith(JDBC_GIGASPACES_URL)) {
                throw new IllegalArgumentException("Invalid Url [" + url + "] - does not start with " + JDBC_GIGASPACES_URL);
            }
            this.url = url.substring(JDBC_GIGASPACES_URL.length());
            this.space = (ISpaceProxy)SpaceFinder.find(this.url);
            this.properties = properties;
            this.initialize(this.space.getDirectProxy().getRemoteJSpace());
        }
        catch (Exception e) {
            SQLException se = new SQLException("Error creating connection; Cause: " + e, "GSP", -137);
            se.initCause(e);
            throw se;
        }
    }

    private void initialize(IRemoteSpace remoteSpace) throws Exception {
        if (this.properties != null) {
            Object modifiersProp = this.properties.get(READ_MODIFIERS);
            this.readModifiers = modifiersProp == null ? null : Integer.valueOf(modifiersProp.toString());
            String username = this.properties.getProperty("user");
            String password = this.properties.getProperty("password");
            if (username != null && username.length() > 0) {
                this.space.getDirectProxy().login(new DefaultCredentialsProvider(username, password));
            }
        }
        this.qp = QueryProcessorFactory.newInstance(this.space, remoteSpace, this.properties);
        this.context = this.qp.newConnection();
        this.context.setSpaceContext(this.space.getDirectProxy().getSecurityManager().acquireContext(remoteSpace));
    }

    public static GConnection getInstance(IJSpace space) throws SQLException {
        return new GConnection(space, new Properties());
    }

    public static GConnection getInstance(IJSpace space, Properties properties) throws SQLException {
        return new GConnection(space, properties);
    }

    public static Connection getInstance(IJSpace space, String username, String password) throws SQLException {
        Properties config = new Properties();
        config.setProperty("user", username);
        config.setProperty("password", password);
        return new GConnection(space, config);
    }

    public void setTransaction(Transaction transaction) throws SQLException {
        if (this.getAutoCommit()) {
            throw new IllegalArgumentException("Setting a transaction is not allowed when autoCommit = true.");
        }
        try {
            if (transaction instanceof ServerTransaction) {
                ServerTransaction serverTransaction = (ServerTransaction)transaction;
                serverTransaction = serverTransaction.createCopy();
                serverTransaction.setEmbeddedMgrProxySideInstance(false);
                SetTransaction packet = new SetTransaction((Transaction)serverTransaction);
                this.writeRequestPacket(packet);
            }
            this.qp.setTransaction(transaction);
        }
        catch (RemoteException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public ResultSet getTableColumnsInformation(String tableName) throws SQLException {
        ResultEntry result;
        String[] columns = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE"};
        String[] tables = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        try {
            ISpaceProxy spaceProxy = this.space;
            IRemoteJSpaceAdmin admin = (IRemoteJSpaceAdmin)spaceProxy.getAdmin();
            try {
                BasicTypeInfo typeInfo = admin.getClassTypeInfo(tableName);
                if (typeInfo != null) {
                    for (int i = 0; i < typeInfo.m_FieldsNames.length; ++i) {
                        Object[] row = new Object[23];
                        row[0] = null;
                        row[1] = null;
                        row[2] = tableName;
                        row[3] = typeInfo.m_FieldsNames[i];
                        row[4] = 1111;
                        row[5] = typeInfo.m_FieldsTypes[i];
                        row[6] = 0;
                        row[7] = 0;
                        row[8] = 0;
                        row[9] = 10;
                        row[10] = 2;
                        row[11] = null;
                        row[12] = null;
                        row[13] = 0;
                        row[14] = 0;
                        row[15] = 0;
                        row[16] = i + 1;
                        row[17] = "";
                        row[18] = null;
                        row[19] = null;
                        row[20] = null;
                        row[21] = null;
                        rows.add(row);
                    }
                }
            }
            catch (NullPointerException i) {
                // empty catch block
            }
            Object[][] valuesArray = new Object[rows.size()][];
            for (int i = 0; i < rows.size(); ++i) {
                valuesArray[i] = (Object[])rows.get(i);
            }
            result = new ResultEntry(columns, columns, tables, valuesArray);
        }
        catch (RemoteException e) {
            SQLException sqe = new SQLException(e.getMessage());
            sqe.initCause(e);
            throw sqe;
        }
        return new GResultSet(null, result);
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 1;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
        try {
            this.qp.closeConnection(this.context);
            this.qp = null;
        }
        catch (IOException ioe) {
            throw new SQLException(ioe.getMessage());
        }
    }

    @Override
    public void commit() throws SQLException {
        this.sendStatement("COMMIT");
    }

    @Override
    public void rollback() throws SQLException {
        this.sendStatement("ROLLBACK");
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        try {
            return this.qp.getSession(this.context).isAutoCommit();
        }
        catch (RemoteException e) {
            SQLException se = new SQLException("Error in calling getAutoCommit() on QueryProcessor. ");
            se.initCause(e);
            throw se;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return !this.qp.isAvailable();
        }
        catch (RemoteException e) {
            return true;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLException("Not Supported!");
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if (level != 1) {
            throw new SQLException("This isolation level is not supported");
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        SetAutoCommitRequest packet = new SetAutoCommitRequest(autoCommit);
        this.writeRequestPacket(packet);
    }

    public void setUseSingleSpace(boolean useSingleSpace) throws SQLException {
        SetUseSingleSpace packet = new SetUseSingleSpace(useSingleSpace);
        this.writeRequestPacket(packet);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
    }

    @Override
    public String getCatalog() throws SQLException {
        return null;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new GDatabaseMetaData(this);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("Not Supported!");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLException("Not Supported!");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLException("Not Supported!");
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new GStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLException("Not Supported!");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("Not Supported!");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLException("Not Supported!");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLException("Not Supported!");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLException("Not Supported!");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLException("Not Supported!");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("Not Supported!");
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        GPreparedStatement ps = new GPreparedStatement(this, sql);
        RequestPacket packet = new RequestPacket();
        packet.setType(RequestPacket.Type.PREPARED_STATEMENT);
        packet.setStatement(sql);
        packet.setModifiers(this.readModifiers);
        this.writeRequestPacket(packet);
        return ps;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Not Supported!");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("Not Supported!");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Not Supported!");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLException("Not Supported!");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Not Supported!");
    }

    public ResponsePacket writeRequestPacket(RequestPacket packet) throws SQLException {
        long start = System.currentTimeMillis();
        boolean useRouter = false;
        while (true) {
            if (!useRouter) {
                try {
                    return this.writeRequestPacketInternal(packet);
                }
                catch (RemoteException re) {
                    this.sleep(1000L);
                    if (System.currentTimeMillis() - start <= 60000L) continue;
                    useRouter = true;
                    continue;
                }
            }
            this.reinitialize();
            start = System.currentTimeMillis();
            useRouter = false;
        }
    }

    private void reinitialize() throws SQLException {
        long startDiscovery = System.currentTimeMillis();
        SpaceProxyRouter router = this.space.getDirectProxy().getProxyRouter();
        while (true) {
            IRemoteSpace newRemoteSpace = router.getAnyActiveSpace();
            try {
                this.initialize(newRemoteSpace);
            }
            catch (Exception e) {
                this.sleep(1000L);
                if (System.currentTimeMillis() - startDiscovery <= 60000L) continue;
                throw new SQLException("Remote space is unreachable");
            }
            break;
        }
    }

    private ResponsePacket writeRequestPacketInternal(RequestPacket packet) throws RemoteException, SQLException {
        if (packet.getModifiers() != null) {
            return this.qp.executeQuery(new ExtendedRequestPacket(packet), this.context);
        }
        ResponsePacket responsePacket = this.qp.executeQuery(packet, this.context);
        return responsePacket;
    }

    private void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Blob createBlob(byte[] bytes) throws SQLException {
        return new Blob(bytes, this);
    }

    public Clob createClob(String clob) throws SQLException {
        return new Clob(clob, this);
    }

    public ResponsePacket sendStatement(String statement) throws SQLException {
        RequestPacket packet = new RequestPacket();
        packet.setModifiers(this.readModifiers);
        packet.setType(RequestPacket.Type.STATEMENT);
        packet.setStatement(statement);
        return this.writeRequestPacket(packet);
    }

    public ResponsePacket sendPreparedStatement(String statement, Object[] values) throws SQLException {
        RequestPacket packet = new RequestPacket();
        packet.setModifiers(this.readModifiers);
        packet.setType(RequestPacket.Type.PREPARED_WITH_VALUES);
        packet.setStatement(statement);
        packet.setPreparedValues(values);
        return this.writeRequestPacket(packet);
    }

    public BatchResponsePacket sendPreparedStatementBatch(String statement, GPreparedStatement.PreparedValuesCollection preparedValuesCollection) throws SQLException {
        RequestPacket packet = new RequestPacket();
        packet.setType(RequestPacket.Type.PREPARED_VALUES_BATCH);
        packet.setStatement(statement);
        packet.setModifiers(this.readModifiers);
        packet.setPreparedValuesCollection(preparedValuesCollection);
        return (BatchResponsePacket)this.writeRequestPacket(packet);
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public java.sql.Blob createBlob() throws SQLException {
        return new Blob(new byte[0], this);
    }

    @Override
    public java.sql.Clob createClob() throws SQLException {
        return new Clob("", this);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSchema() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new UnsupportedOperationException();
    }
}

