/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.driver;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.j_spaces.jdbc.ResponsePacket;
import com.j_spaces.jdbc.SQLUtil;
import com.j_spaces.jdbc.batching.BatchResponsePacket;
import com.j_spaces.jdbc.driver.GConnection;
import com.j_spaces.jdbc.driver.GStatement;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

@InternalApi
public class GPreparedStatement
extends GStatement
implements PreparedStatement {
    private final String sql;
    private PreparedValuesCollection _preparedValuesCollection;

    public GPreparedStatement(GConnection con, String sql) throws SQLException {
        super(con);
        this.sql = sql;
        int numOfValues = 0;
        for (int i = 0; i < sql.length(); ++i) {
            if (sql.charAt(i) != '?') continue;
            ++numOfValues;
        }
        this._preparedValuesCollection = new PreparedValuesCollection(numOfValues);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (this._preparedValuesCollection.size() > 0) {
            BatchResponsePacket response = this.connection.sendPreparedStatementBatch(this.sql, this._preparedValuesCollection);
            this._preparedValuesCollection.clear();
            return response.getResult();
        }
        return new int[0];
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkValues();
        if (this.sql.toUpperCase().startsWith("SELECT")) {
            throw new SQLException("Cannot call SELECT with executeUpdate. Use executeQuery instead", "GSP", -143);
        }
        ResponsePacket response = this.connection.sendPreparedStatement(this.sql, this._preparedValuesCollection.getCurrentValues());
        this.updateCount = response.getIntResult();
        return this.updateCount;
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkValues();
        this._preparedValuesCollection.addBatch();
    }

    @Override
    public void clearBatch() throws SQLException {
        this._preparedValuesCollection.clear();
    }

    @Override
    public void clearParameters() throws SQLException {
        this._preparedValuesCollection.resetCurrentValues();
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkValues();
        ResponsePacket response = this.connection.sendPreparedStatement(this.sql, this._preparedValuesCollection.getCurrentValues());
        if (response.getResultEntry() != null) {
            this.buildResultSet(response.getResultEntry());
            return true;
        }
        this.updateCount = response.getIntResult();
        return false;
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkIndex(parameterIndex);
        this._preparedValuesCollection.setValue(parameterIndex - 1, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkIndex(parameterIndex);
        this._preparedValuesCollection.setValue(parameterIndex - 1, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkIndex(parameterIndex);
        this._preparedValuesCollection.setValue(parameterIndex - 1, Float.valueOf(x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkIndex(parameterIndex);
        this._preparedValuesCollection.setValue(parameterIndex - 1, x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkIndex(parameterIndex);
        this._preparedValuesCollection.setValue(parameterIndex - 1, null);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkIndex(parameterIndex);
        this._preparedValuesCollection.setValue(parameterIndex - 1, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkIndex(parameterIndex);
        this._preparedValuesCollection.setValue(parameterIndex - 1, x);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkIndex(parameterIndex);
        this._preparedValuesCollection.setValue(parameterIndex - 1, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkIndex(parameterIndex);
        if (x == null) {
            throw new SQLException("Cannot set a null ascii stream", "GSP", -144);
        }
        try {
            this._preparedValuesCollection.setValue(parameterIndex - 1, SQLUtil.convertAsciiInputStreamToString(x, length));
        }
        catch (IOException e) {
            throw new SQLException("Error reading from input stream: " + e.getMessage());
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkIndex(parameterIndex);
        if (x == null) {
            throw new SQLException("Cannot set a null binary stream", "GSP", -144);
        }
        try {
            this._preparedValuesCollection.setValue(parameterIndex - 1, SQLUtil.convertInputStreamToByteArray(x, length));
        }
        catch (IOException e) {
            throw new SQLException("Error reading from input stream: " + e.getMessage());
        }
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.checkIndex(parameterIndex);
        if (reader == null) {
            throw new SQLException("Cannot set a null character stream", "GSP", -144);
        }
        try {
            this._preparedValuesCollection.setValue(parameterIndex - 1, SQLUtil.convertReaderToString(reader, length));
        }
        catch (IOException e) {
            throw new SQLException("Error reading from reader: " + e.getMessage());
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkIndex(parameterIndex);
        if (x == null) {
            throw new SQLException("Cannot set a null object", "GSP", -144);
        }
        this._preparedValuesCollection.setValue(parameterIndex - 1, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(paramIndex, sqlType);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkIndex(parameterIndex);
        this._preparedValuesCollection.setValue(parameterIndex - 1, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.checkIndex(parameterIndex);
        this._preparedValuesCollection.setValue(parameterIndex - 1, x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.checkIndex(parameterIndex);
        this._preparedValuesCollection.setValue(parameterIndex - 1, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkIndex(parameterIndex);
        Calendar cal = Calendar.getInstance();
        cal.setTime(x);
        Calendar cal2 = Calendar.getInstance();
        cal2.clear();
        cal2.set(5, cal.get(5));
        cal2.set(2, cal.get(2));
        cal2.set(1, cal.get(1));
        this._preparedValuesCollection.setValue(parameterIndex - 1, new Date(cal2.getTime().getTime()));
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkValues();
        if (!this.sql.toUpperCase().startsWith("SELECT") && !this.sql.toUpperCase().startsWith("CALL")) {
            this.executeUpdate();
        } else {
            ResponsePacket response = this.connection.sendPreparedStatement(this.sql, this._preparedValuesCollection.getCurrentValues());
            this.buildResultSet(response.getResultEntry());
        }
        return this.resultSet;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkIndex(parameterIndex);
        this._preparedValuesCollection.setValue(parameterIndex - 1, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkIndex(parameterIndex);
        this._preparedValuesCollection.setValue(parameterIndex - 1, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.setDate(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp(parameterIndex, x);
    }

    private void checkIndex(int index) throws SQLException {
        if (index > this._preparedValuesCollection.getCurrentValues().length) {
            throw new SQLException("Cannot set value, invalid index " + index, "GSP", -147);
        }
    }

    private void checkValues() throws SQLException {
        if (!this._preparedValuesCollection.allValuesAreSet()) {
            throw new SQLException("All values must be set", "GSP", -126);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setAsciiStream(parameterIndex, x, Integer.MAX_VALUE);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.setBinaryStream(parameterIndex, x, Integer.MAX_VALUE);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.setBinaryStream(parameterIndex, inputStream, Integer.MAX_VALUE);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, Integer.MAX_VALUE);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public static class PreparedValuesCollection
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private Object[] _currentValues;
        private boolean[] _currentValuesSetStatus;
        private List<Object[]> _valuesBatch;

        public PreparedValuesCollection() {
        }

        public PreparedValuesCollection(int numberOfValues) {
            this._currentValues = new Object[numberOfValues];
            this._currentValuesSetStatus = new boolean[numberOfValues];
        }

        public List<Object[]> getBatchValues() {
            return this._valuesBatch;
        }

        public boolean allValuesAreSet() {
            for (int i = 0; i < this._currentValuesSetStatus.length; ++i) {
                if (this._currentValuesSetStatus[i]) continue;
                return false;
            }
            return true;
        }

        public void setValue(int index, Object value) {
            this._currentValues[index] = value;
            this._currentValuesSetStatus[index] = true;
        }

        public Object[] getCurrentValues() {
            return this._currentValues;
        }

        public void addBatch() {
            if (this._valuesBatch == null) {
                this._valuesBatch = new ArrayList<Object[]>();
            }
            this._valuesBatch.add((Object[])this._currentValues.clone());
            this.resetCurrentValues();
        }

        public void resetCurrentValues() {
            for (int i = 0; i < this._currentValues.length; ++i) {
                this._currentValues[i] = null;
                this._currentValuesSetStatus[i] = false;
            }
        }

        public int size() {
            return this._valuesBatch != null ? this._valuesBatch.size() : 0;
        }

        public void clear() {
            this.resetCurrentValues();
            if (this._valuesBatch != null) {
                this._valuesBatch.clear();
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this._currentValues = IOUtils.readObjectArray(in);
            int length = in.readInt();
            this._valuesBatch = new ArrayList<Object[]>();
            for (int i = 0; i < length; ++i) {
                this._valuesBatch.add(IOUtils.readObjectArray(in));
            }
            this._currentValuesSetStatus = new boolean[length];
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            IOUtils.writeObjectArray(out, this._currentValues);
            int length = this._valuesBatch.size();
            out.writeInt(length);
            for (Object[] valuesArray : this._valuesBatch) {
                IOUtils.writeObjectArray(out, valuesArray);
            }
        }
    }
}

