/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.driver;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.jdbc.ResultEntry;
import com.j_spaces.jdbc.driver.Blob;
import com.j_spaces.jdbc.driver.Clob;
import com.j_spaces.jdbc.driver.GResultSetMetaData;
import com.j_spaces.jdbc.driver.GStatement;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

@InternalApi
public class GResultSet
implements ResultSet {
    private final ResultEntry results;
    private final GStatement statement;
    private boolean last_was_null = false;
    private int currentRow = 0;

    public GResultSet(GStatement statement, ResultEntry results) {
        this.statement = statement;
        this.results = results;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1002;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getRow() throws SQLException {
        return this.currentRow;
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public void afterLast() throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public boolean first() throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.currentRow > this.results.getRowNumber();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.currentRow <= 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.currentRow == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.currentRow == this.results.getRowNumber();
    }

    @Override
    public boolean last() throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public boolean next() throws SQLException {
        if (this.results == null || this.currentRow + 1 > this.results.getRowNumber()) {
            return false;
        }
        ++this.currentRow;
        return true;
    }

    @Override
    public boolean previous() throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.last_was_null;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkRowNumber();
        Object ob = this.results.getFieldValues(this.currentRow)[columnIndex - 1];
        if (ob == null) {
            this.last_was_null = true;
            return 0;
        }
        if (ob instanceof Byte) {
            return (Byte)ob;
        }
        throw new SQLException("Cannot represent this value as a byte", "GSP", -148);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkRowNumber();
        Object ob = this.results.getFieldValues(this.currentRow)[columnIndex - 1];
        if (ob == null) {
            this.last_was_null = true;
            return 0.0;
        }
        if (ob instanceof Number) {
            return ((Number)ob).doubleValue();
        }
        throw new SQLException("Cannot represent this value as a double", "GSP", -149);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkRowNumber();
        Object ob = this.results.getFieldValues(this.currentRow)[columnIndex - 1];
        if (ob == null) {
            this.last_was_null = true;
            return 0.0f;
        }
        if (ob instanceof Number) {
            return ((Number)ob).floatValue();
        }
        throw new SQLException("Cannot represent this value as a float", "GSP", -150);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkRowNumber();
        Object ob = this.results.getFieldValues(this.currentRow)[columnIndex - 1];
        if (ob == null) {
            this.last_was_null = true;
            return 0;
        }
        if (ob instanceof Number) {
            return ((Number)ob).intValue();
        }
        throw new SQLException("Cannot represent this value as an int", "GSP", -151);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkRowNumber();
        Object ob = this.results.getFieldValues(this.currentRow)[columnIndex - 1];
        if (ob == null) {
            this.last_was_null = true;
            return 0L;
        }
        if (ob instanceof Number) {
            return ((Number)ob).longValue();
        }
        throw new SQLException("Cannot represent this value as a long", "GSP", -152);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkRowNumber();
        Object ob = this.results.getFieldValues(this.currentRow)[columnIndex - 1];
        if (ob == null) {
            this.last_was_null = true;
            return 0;
        }
        if (ob instanceof Number) {
            return ((Number)ob).shortValue();
        }
        throw new SQLException("Cannot represent this value as a short", "GSP", -153);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkRowNumber();
        Object ob = this.results.getFieldValues(this.currentRow)[columnIndex - 1];
        if (ob == null) {
            this.last_was_null = true;
            return false;
        }
        if (ob instanceof Boolean) {
            return (Boolean)ob;
        }
        if (ob instanceof Number) {
            return ((Number)ob).floatValue() != 0.0f;
        }
        if (ob instanceof String) {
            return ((String)ob).equalsIgnoreCase("true");
        }
        throw new SQLException("Cannot represent this value as a boolean", "GSP", -154);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkRowNumber();
        Object ob = this.results.getFieldValues(this.currentRow)[columnIndex - 1];
        if (ob == null) {
            this.last_was_null = true;
            return null;
        }
        if (ob instanceof byte[]) {
            return (byte[])ob;
        }
        if (ob instanceof String) {
            return ((String)ob).getBytes();
        }
        throw new SQLException(String.format("Cannot convert %s type to a byte array", ob.getClass().getName()));
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkRowNumber();
        Object result = this.results.getFieldValues(this.currentRow)[columnIndex - 1];
        if (result == null) {
            this.last_was_null = true;
            return null;
        }
        if (result instanceof java.sql.Clob) {
            java.sql.Clob clobResult = (java.sql.Clob)result;
            return clobResult.getAsciiStream();
        }
        throw new SQLException(String.format("Cannot convert %s type to an ascii stream", result.getClass().getName()));
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkRowNumber();
        Object result = this.results.getFieldValues(this.currentRow)[columnIndex - 1];
        if (result == null) {
            this.last_was_null = true;
            return null;
        }
        if (result instanceof java.sql.Blob) {
            java.sql.Blob blobResult = (java.sql.Blob)result;
            return new ByteArrayInputStream(blobResult.getBytes(1L, (int)blobResult.length()));
        }
        throw new SQLException(String.format("Cannot convert %s type to a binary stream", result.getClass().getName()));
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkRowNumber();
        Object result = this.results.getFieldValues(this.currentRow)[columnIndex - 1];
        if (result == null) {
            this.last_was_null = true;
            return null;
        }
        if (result instanceof Clob) {
            Clob clobResult = (Clob)result;
            return new StringReader(clobResult.getClobData());
        }
        throw new SQLException(String.format("Cannot convert %s type to a characters stream", result.getClass().getName()));
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkRowNumber();
        Object ob = this.results.getFieldValues(this.currentRow)[columnIndex - 1];
        if (ob == null) {
            this.last_was_null = true;
        }
        return ob;
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkRowNumber();
        Object ob = this.results.getFieldValues(this.currentRow)[columnIndex - 1];
        if (ob == null) {
            this.last_was_null = true;
            return null;
        }
        return ob.toString();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        if (this.results != null) {
            String[] columnLabels = this.results.getColumnLabels();
            for (int index = 0; index < columnLabels.length; ++index) {
                if (!columnLabels[index].equalsIgnoreCase(columnName)) continue;
                return index + 1;
            }
        }
        throw new SQLException("Column " + columnName + " was not found in result", "GSP", -155);
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkRowNumber();
        Object ob = this.results.getFieldValues(this.currentRow)[columnIndex - 1];
        if (ob == null) {
            this.last_was_null = true;
            return BigDecimal.ZERO;
        }
        if (ob instanceof Number) {
            return new BigDecimal(((Number)ob).doubleValue());
        }
        throw new SQLException("Cannot represent this value as a BigDecimal", "GSP", -149);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.checkRowNumber();
        Object ob = this.results.getFieldValues(this.currentRow)[columnIndex - 1];
        if (ob == null) {
            this.last_was_null = true;
            return null;
        }
        if (ob instanceof URL) {
            return (URL)ob;
        }
        throw new SQLException(String.format("Cannot convert %s type to a URL type", ob.getClass().getName()));
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public java.sql.Blob getBlob(int columnIndex) throws SQLException {
        this.checkRowNumber();
        Object ob = this.results.getFieldValues(this.currentRow)[columnIndex - 1];
        if (ob == null) {
            this.last_was_null = true;
            return null;
        }
        if (ob instanceof java.sql.Blob) {
            Blob blob = (Blob)ob;
            blob.setConnection(this.getStatement().getConnection());
            return blob;
        }
        throw new SQLException("Cannot represent this value as Blob", "GSP", -156);
    }

    @Override
    public void updateBlob(int columnIndex, java.sql.Blob x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public java.sql.Clob getClob(int columnIndex) throws SQLException {
        this.checkRowNumber();
        Object ob = this.results.getFieldValues(this.currentRow)[columnIndex - 1];
        if (ob == null) {
            this.last_was_null = true;
            return null;
        }
        if (ob instanceof java.sql.Clob) {
            Clob clob = (Clob)ob;
            clob.setConnection(this.getStatement().getConnection());
            return clob;
        }
        throw new SQLException("Cannot represent this value as Clob", "GSP", -157);
    }

    @Override
    public void updateClob(int columnIndex, java.sql.Clob x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkRowNumber();
        Object ob = this.results.getFieldValues(this.currentRow)[columnIndex - 1];
        if (ob == null) {
            this.last_was_null = true;
            return null;
        }
        if (ob instanceof Date) {
            return (Date)ob;
        }
        throw new SQLException("Cannot represent this value as Date", "GSP", -158);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        this.checkRowNumber();
        Object ob = this.results.getFieldValues(this.currentRow)[columnIndex - 1];
        if (ob == null) {
            this.last_was_null = true;
            return null;
        }
        if (ob instanceof Ref) {
            return (Ref)ob;
        }
        throw new SQLException(String.format("Cannot convert %s type to a Ref type", ob.getClass().getName()));
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new GResultSetMetaData(this.results);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkRowNumber();
        Object ob = this.results.getFieldValues(this.currentRow)[columnIndex - 1];
        if (ob == null) {
            this.last_was_null = true;
            return null;
        }
        if (ob instanceof Time) {
            return (Time)ob;
        }
        throw new SQLException("Cannot represent this value as Time", "GSP", -159);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkRowNumber();
        Object ob = this.results.getFieldValues(this.currentRow)[columnIndex - 1];
        if (ob == null) {
            this.last_was_null = true;
            return null;
        }
        if (ob instanceof Timestamp) {
            return (Timestamp)ob;
        }
        throw new SQLException("Cannot represent this value as Timestamp", "GSP", -160);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return this.getURL(this.findColumn(columnName));
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public java.sql.Blob getBlob(String columnName) throws SQLException {
        return this.getBlob(this.findColumn(columnName));
    }

    @Override
    public void updateBlob(String columnName, java.sql.Blob x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public java.sql.Clob getClob(String columnName) throws SQLException {
        return this.getClob(this.findColumn(columnName));
    }

    @Override
    public void updateClob(String columnName, java.sql.Clob x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getDate(columnIndex);
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        return this.getRef(this.findColumn(colName));
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getTime(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(colName), map);
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    private void checkRowNumber() throws SQLException {
        this.last_was_null = false;
        if (this.currentRow <= 0) {
            throw new SQLException("The next() method must be called at least once", "GSP", -161);
        }
        if (this.currentRow > this.results.getRowNumber()) {
            throw new SQLException("Exhausted ResultSet!", "GSP", -162);
        }
    }

    public ResultEntry getResult() throws SQLException {
        return this.results;
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

