/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.driver;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.jdbc.ResultEntry;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

@InternalApi
public class GResultSetMetaData
implements ResultSetMetaData {
    private static final int DISPLAY_SIZE = 64;
    private final ResultEntry results;

    public GResultSetMetaData(ResultEntry results) {
        this.results = results;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.results.getFieldNames().length;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return 64;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        int type = 0;
        String clName = this.getColumnClassName(column);
        type = clName.equals(String.class.getName()) ? 12 : (clName.equals(Integer.class.getName()) ? 4 : (clName.equals(Double.class.getName()) ? 8 : (clName.equals(Float.class.getName()) ? 6 : (clName.equals(Object.class.getName()) ? 2000 : (clName.equals(Timestamp.class.getName()) ? 93 : (clName.equals(Time.class.getName()) ? 92 : 1111))))));
        return type;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        return 0;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 1;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        Object[] colObj = this.results.getFieldValues(1);
        if (colObj == null) {
            return false;
        }
        return colObj[column - 1] instanceof Number;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return true;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        if (this.results != null && this.results.getFieldValues(1) != null && this.results.getFieldValues(1)[column - 1] != null) {
            return this.results.getFieldValues(1)[column - 1].getClass().getName();
        }
        return "";
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.results.getColumnLabels()[column - 1];
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.results.getFieldNames()[column - 1];
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.results.getTableNames()[column - 1];
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

