/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.driver;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.jdbc.ResponsePacket;
import com.j_spaces.jdbc.ResultEntry;
import com.j_spaces.jdbc.driver.GConnection;
import com.j_spaces.jdbc.driver.GResultSet;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class GStatement
implements Statement {
    protected final GConnection connection;
    protected int updateCount = -1;
    protected ResultSet resultSet = null;
    protected List<String> _queriesBatch;
    protected boolean ignoreUnsupportedOptions;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.query");
    public static final String IGNORE_UNSUPPORTED_OPTIONS_PROP = "com.gigaspaces.jdbc.ignoreUnsupportedOptions";

    public GStatement(GConnection connection) {
        this.connection = connection;
        this.ignoreUnsupportedOptions = Boolean.parseBoolean(System.getProperty(IGNORE_UNSUPPORTED_OPTIONS_PROP, "false"));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1002;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return 0;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1003;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.updateCount;
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this._queriesBatch != null) {
            this._queriesBatch.clear();
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (this._queriesBatch != null && this._queriesBatch.size() > 0) {
            boolean exceptionOccurred = false;
            String exceptionText = null;
            int[] result = new int[this._queriesBatch.size()];
            for (int i = 0; i < this._queriesBatch.size(); ++i) {
                try {
                    result[i] = this.executeUpdate(this._queriesBatch.get(i));
                    continue;
                }
                catch (SQLException e) {
                    exceptionOccurred = true;
                    exceptionText = e.getMessage();
                    result[i] = -3;
                }
            }
            this._queriesBatch.clear();
            if (exceptionOccurred) {
                throw new BatchUpdateException(exceptionText, result);
            }
            return result;
        }
        return new int[0];
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.handleUnsupportedSqlOperationsCalls("setFetchSize");
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.handleUnsupportedSqlOperationsCalls("setMaxRows");
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.init();
        if (sql.trim().toUpperCase().startsWith("SELECT")) {
            throw new SQLException("Cannot call SELECT with executeUpdate. Use executeQuery instead", "GSP", -143);
        }
        ResponsePacket response = this.connection.sendStatement(sql);
        this.updateCount = response.getIntResult();
        return this.updateCount;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this._queriesBatch == null) {
            this._queriesBatch = new ArrayList<String>();
        }
        this._queriesBatch.add(sql);
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.init();
        ResponsePacket packet = this.connection.sendStatement(sql);
        if (packet.getResultEntry() != null) {
            this.buildResultSet(packet.getResultEntry());
            return true;
        }
        this.updateCount = packet.getIntResult();
        return false;
    }

    private void init() {
        this.updateCount = -1;
        this.resultSet = null;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.resultSet;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.init();
        if (!sql.trim().toUpperCase().startsWith("SELECT") && !sql.toUpperCase().startsWith("CALL")) {
            throw new SQLException("Cannot call anything but SELECT with executeQuery. Use executeUpdate instead", "GSP", -143);
        }
        ResponsePacket response = this.connection.sendStatement(sql);
        this.buildResultSet(response.getResultEntry());
        return this.resultSet;
    }

    protected void buildResultSet(ResultEntry entry) {
        this.resultSet = new GResultSet(this, entry);
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new UnsupportedOperationException();
    }

    private void handleUnsupportedSqlOperationsCalls(String operation) throws SQLException {
        if (!this.ignoreUnsupportedOptions) {
            throw new SQLException("Command not Supported!", "GSP", -132);
        }
        if (_logger.isLoggable(Level.WARNING)) {
            _logger.warning("An unsupported java.sql.Statement." + operation + " command was called and ignored ");
        }
    }
}

