/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.executor;

import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.security.AccessDeniedException;
import com.j_spaces.jdbc.AbstractDMLQuery;
import com.j_spaces.jdbc.NumberUtil;
import com.j_spaces.jdbc.OrderColumn;
import com.j_spaces.jdbc.ResponsePacket;
import com.j_spaces.jdbc.ResultEntry;
import com.j_spaces.jdbc.SelectColumn;
import com.j_spaces.jdbc.SelectQuery;
import com.j_spaces.jdbc.Stack;
import com.j_spaces.jdbc.builder.QueryEntryPacket;
import com.j_spaces.jdbc.builder.QueryTemplatePacket;
import com.j_spaces.jdbc.executor.IQueryExecutor;
import com.j_spaces.jdbc.parser.ExpNode;
import com.j_spaces.jdbc.parser.InnerQueryNode;
import com.j_spaces.jdbc.query.ArrayListResult;
import com.j_spaces.jdbc.query.IQueryResultSet;
import com.j_spaces.jdbc.query.ProjectedResultSet;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;

public abstract class AbstractQueryExecutor
implements IQueryExecutor {
    protected static final Logger _logger = Logger.getLogger("com.gigaspaces.query");
    protected final AbstractDMLQuery query;
    private final HashMap<ExpNode, IQueryResultSet<IEntryPacket>> _intermediateResults = new HashMap();

    public AbstractQueryExecutor(AbstractDMLQuery query) {
        this.query = query;
    }

    @Override
    public int clear(QueryTemplatePacket template, ISpaceProxy space, Transaction txn, int modifiers) throws RemoteException, TransactionException, UnusableEntryException {
        return space.clear(template, txn, modifiers);
    }

    @Override
    public int count(QueryTemplatePacket template, ISpaceProxy space, Transaction txn, int readModifier) throws SQLException {
        try {
            return space.count(template, txn, readModifier);
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new SQLException("Failed to execute count: " + e.getMessage(), "GSP", -111);
        }
    }

    public AbstractDMLQuery getQuery() {
        return this.query;
    }

    public IQueryResultSet<IEntryPacket> extractResults(ExpNode node) {
        return this._intermediateResults.remove(node);
    }

    public void setResults(ExpNode node, IQueryResultSet<IEntryPacket> results) {
        this._intermediateResults.put(node, results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IQueryResultSet<IEntryPacket> traverseExpressionTree(ExpNode root, ISpaceProxy space, Transaction txn, int readModifier, int max) throws SQLException {
        try {
            Stack<ExpNode> tempStack = new Stack<ExpNode>();
            Stack<ExpNode> nodesToProcessStack = new Stack<ExpNode>();
            tempStack.push(root);
            while (!tempStack.isEmpty()) {
                ExpNode curr = (ExpNode)tempStack.pop();
                nodesToProcessStack.push(curr);
                if (curr.getTemplate() != null) continue;
                if (curr.getLeftChild() != null) {
                    tempStack.push(curr.getLeftChild());
                }
                if (curr.getRightChild() == null) continue;
                tempStack.push(curr.getRightChild());
            }
            while (!nodesToProcessStack.isEmpty()) {
                ExpNode node = (ExpNode)nodesToProcessStack.pop();
                if (nodesToProcessStack.isEmpty()) {
                    node.accept(this, space, txn, readModifier, max);
                    continue;
                }
                node.accept(this, space, txn, readModifier, Integer.MAX_VALUE);
            }
            IQueryResultSet<IEntryPacket> iQueryResultSet = this.extractResults(root);
            return iQueryResultSet;
        }
        finally {
            this._intermediateResults.clear();
        }
    }

    public IQueryResultSet readAll(ISpaceProxy space, Transaction txn) throws SQLException {
        return this.executeTemplate(new QueryTemplatePacket(this.query.getTableData(), this.query.getQueryResultType()), space, txn, this.query.getReadModifier(), Integer.MAX_VALUE);
    }

    public IQueryResultSet<IEntryPacket> executeTemplate(QueryTemplatePacket template, ISpaceProxy space, Transaction txn, int readModifier, int max) throws SQLException {
        try {
            if (template == null) {
                return new ArrayListResult();
            }
            template.setExplainPlan(this.getQuery().getExplainPlan());
            return template.read(space, this.query, txn, readModifier, max);
        }
        catch (AccessDeniedException e) {
            throw e;
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.SEVERE, e.getMessage(), e);
            }
            SQLException t = new SQLException("Failed to execute readMultiple: " + e.toString(), "GSP", -111);
            t.initCause(e);
            throw t;
        }
    }

    protected HashMap<ExpNode, IQueryResultSet<IEntryPacket>> getIntermediateResults() {
        return this._intermediateResults;
    }

    @Override
    public IEntryPacket aggregate(IQueryResultSet<IEntryPacket> entries) throws SQLException {
        Iterator<SelectColumn> iter = this.query.getQueryColumns().iterator();
        ArrayList<String> vecFieldNames = new ArrayList<String>();
        ArrayList<Object> vecFieldValues = new ArrayList<Object>();
        while (iter.hasNext()) {
            Object maxMin;
            SelectColumn funcColumn = iter.next();
            if (!funcColumn.isVisible()) continue;
            vecFieldNames.add(funcColumn.toString());
            if (funcColumn.getFunctionName() == null) {
                IEntryPacket first = (IEntryPacket)entries.iterator().next();
                Object value = entries.getFieldValue(funcColumn, first);
                vecFieldValues.add(value);
                continue;
            }
            if (funcColumn.getFunctionName().equals("max")) {
                maxMin = this.minMax(funcColumn, entries, true);
                vecFieldValues.add(maxMin);
                continue;
            }
            if (funcColumn.getFunctionName().equals("min")) {
                maxMin = this.minMax(funcColumn, entries, false);
                vecFieldValues.add(maxMin);
                continue;
            }
            if (funcColumn.getFunctionName().equals("count")) {
                vecFieldValues.add(entries.size());
                continue;
            }
            if (funcColumn.getFunctionName().equals("sum")) {
                Number sum = this.sum(funcColumn, entries);
                vecFieldValues.add(sum);
                continue;
            }
            if (!funcColumn.getFunctionName().equals("avg")) continue;
            Number avg = this.avg(funcColumn, entries);
            vecFieldValues.add(avg);
        }
        return new QueryEntryPacket(vecFieldNames.toArray(new String[vecFieldNames.size()]), vecFieldValues.toArray(new Object[vecFieldValues.size()]));
    }

    @Override
    public IQueryResultSet<IEntryPacket> groupBy(IQueryResultSet<IEntryPacket> entries, List<SelectColumn> groupColumns) throws SQLException {
        IQueryResultSet<IEntryPacket> currGroup = null;
        IEntryPacket currRow = null;
        IEntryPacket prevRow = null;
        Comparator<IEntryPacket> comparator = this.getGroupByComparator(entries, groupColumns);
        Collections.sort((List)((Object)entries), comparator);
        Iterator iter = entries.iterator();
        ArrayList<IQueryResultSet<IEntryPacket>> groupList = new ArrayList<IQueryResultSet<IEntryPacket>>();
        for (int i = 0; i < entries.size(); ++i) {
            prevRow = currRow;
            int rc = comparator.compare(prevRow, currRow = (IEntryPacket)iter.next());
            if (rc != 0) {
                currGroup = entries.newResultSet();
                groupList.add(currGroup);
                currGroup.add(currRow);
                continue;
            }
            currGroup.add(currRow);
        }
        ArrayListResult groupByResult = this.query.isConvertResultToArray() ? new ProjectedResultSet() : new ArrayListResult();
        for (IQueryResultSet iQueryResultSet : groupList) {
            if (this.query.isConvertResultToArray()) {
                groupByResult.add(this.aggregate(iQueryResultSet));
                continue;
            }
            groupByResult.add(iQueryResultSet.iterator().next());
        }
        return groupByResult;
    }

    public Comparator<IEntryPacket> getGroupByComparator(IQueryResultSet<IEntryPacket> queryResult, List<SelectColumn> groupColumns) {
        return new GroupByComparator(groupColumns, queryResult);
    }

    @Override
    public void orderBy(IQueryResultSet<IEntryPacket> entries, List<OrderColumn> orderColumns) throws SQLException {
        Collections.sort((List)((Object)entries), this.getOrderByComparator(entries, orderColumns));
    }

    public Comparator<IEntryPacket> getOrderByComparator(IQueryResultSet<IEntryPacket> entries, List<OrderColumn> orderColumns) {
        return new EntriesOrderByComparator(entries, orderColumns);
    }

    public Object minMax(SelectColumn funcColumn, IQueryResultSet<IEntryPacket> entries, boolean isMax) {
        Object maxMin = null;
        for (IEntryPacket entry : entries) {
            Object value = entries.getFieldValue(funcColumn, entry);
            if (value == null) continue;
            if (maxMin != null) {
                if (isMax) {
                    maxMin = ((Comparable)value).compareTo(maxMin) > 0 ? value : maxMin;
                    continue;
                }
                maxMin = ((Comparable)value).compareTo(maxMin) < 0 ? value : maxMin;
                continue;
            }
            maxMin = value;
        }
        return maxMin;
    }

    public Number avg(SelectColumn funcColumn, IQueryResultSet<IEntryPacket> entries) throws SQLException {
        Iterator iter = entries.iterator();
        IEntryPacket entry = (IEntryPacket)iter.next();
        Number sum = this.getNumber(entry, funcColumn, entries);
        String numberClassName = sum.getClass().getName();
        sum = sum.doubleValue();
        String doubleType = Double.class.getName();
        double size = entries.size();
        while (iter.hasNext()) {
            entry = (IEntryPacket)iter.next();
            Number value = this.getNumber(entry, funcColumn, entries);
            sum = NumberUtil.add(sum, value.doubleValue(), doubleType);
        }
        Number avg = NumberUtil.divide(sum, size, numberClassName);
        return avg;
    }

    public Number sum(SelectColumn funcColumn, IQueryResultSet<IEntryPacket> entries) throws SQLException {
        if (entries.isEmpty()) {
            return null;
        }
        Iterator iter = entries.iterator();
        IEntryPacket entry = (IEntryPacket)iter.next();
        Number sum = this.getNumber(entry, funcColumn, entries);
        while (iter.hasNext()) {
            entry = (IEntryPacket)iter.next();
            sum = NumberUtil.add(sum, this.getNumber(entry, funcColumn, entries), sum.getClass().getName());
        }
        return sum;
    }

    private Number getNumber(IEntryPacket entry, SelectColumn funcColumn, IQueryResultSet<IEntryPacket> entries) {
        Object value = entries.getFieldValue(funcColumn, entry);
        if (value == null) {
            value = 0;
        }
        return (Number)value;
    }

    @Override
    public void filterDistinctEntries(final IQueryResultSet<IEntryPacket> entries) {
        TreeSet<IEntryPacket> treeSet = new TreeSet<IEntryPacket>(new Comparator<IEntryPacket>(){

            @Override
            public int compare(IEntryPacket o1, IEntryPacket o2) {
                for (SelectColumn column : AbstractQueryExecutor.this.query.getQueryColumns()) {
                    if (!column.isVisible()) continue;
                    Comparable c1 = (Comparable)entries.getFieldValue(column, o1);
                    Comparable c2 = (Comparable)entries.getFieldValue(column, o2);
                    if (c1 == null && c2 == null) continue;
                    if (c1 == null) {
                        return 1;
                    }
                    if (c2 == null) {
                        return -1;
                    }
                    int c = c1.compareTo(c2);
                    if (c == 0) continue;
                    return c;
                }
                return 0;
            }
        });
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            IEntryPacket e = (IEntryPacket)iter.next();
            if (treeSet.add(e)) continue;
            iter.remove();
        }
    }

    @Override
    public ResultEntry convertEntriesToResultArrays(IQueryResultSet<IEntryPacket> entries) {
        LinkedList<String> columnNames = new LinkedList<String>();
        LinkedList<String> columnLabelsList = new LinkedList<String>();
        LinkedList<String> tableNamesList = new LinkedList<String>();
        for (SelectColumn col : this.query.getQueryColumns()) {
            if (!col.isVisible()) continue;
            columnNames.add(col.getName());
            columnLabelsList.add(col.getAlias());
            tableNamesList.add(col.getColumnTableData().getTableName());
        }
        String[] fieldNames = columnNames.toArray(new String[columnNames.size()]);
        String[] columnLabels = columnLabelsList.toArray(new String[columnLabelsList.size()]);
        String[] tableNames = tableNamesList.toArray(new String[tableNamesList.size()]);
        Object[][] fieldValues = new Object[entries.size()][columnNames.size()];
        Iterator iter = entries.iterator();
        int row = 0;
        while (iter.hasNext()) {
            IEntryPacket entry = (IEntryPacket)iter.next();
            int column = 0;
            for (int i = 0; i < this.query.getQueryColumns().size(); ++i) {
                SelectColumn sc = this.query.getQueryColumns().get(i);
                if (!sc.isVisible()) continue;
                fieldValues[row][column++] = entries.getFieldValue(sc, entry);
            }
            ++row;
        }
        ResultEntry result = new ResultEntry(fieldNames, columnLabels, tableNames, fieldValues);
        return result;
    }

    @Override
    public void execute(InnerQueryNode innerQueryNode, ISpaceProxy space, Transaction txn, int readModifier, int max) throws SQLException {
        SelectQuery innerQuery = innerQueryNode.getInnerQuery();
        innerQuery.validateQuery(space);
        innerQuery.setPreparedValues(this.query.getPreparedValues());
        innerQuery.setRouting(this.query.getRouting());
        if (!innerQuery.isPrepared() && !innerQuery.containsSubQueries()) {
            innerQuery.build();
        }
        ResponsePacket innerResponse = innerQuery.executeOnSpace(space, txn);
        innerQueryNode.setResults(innerResponse.getResultEntry());
    }

    static class GroupByComparator
    implements Comparator<IEntryPacket> {
        private List<SelectColumn> groupColumns;
        private IQueryResultSet<IEntryPacket> _queryResult;

        GroupByComparator(List<SelectColumn> groupCols, IQueryResultSet<IEntryPacket> queryResult) {
            this.groupColumns = groupCols;
            this._queryResult = queryResult;
        }

        @Override
        public int compare(IEntryPacket e1, IEntryPacket e2) {
            if (e1 == null) {
                if (e2 == null) {
                    return 0;
                }
                return -1;
            }
            if (e2 == null) {
                return 1;
            }
            int rc = 0;
            for (int i = 0; i < this.groupColumns.size(); ++i) {
                SelectColumn groupCol = this.groupColumns.get(i);
                Object obj1 = this._queryResult.getFieldValue(groupCol, e1);
                Object obj2 = this._queryResult.getFieldValue(groupCol, e2);
                rc = obj1 == null && obj2 == null ? 0 : (obj1 == null && obj2 != null ? -1 : (obj1 != null && obj2 == null ? 1 : ((Comparable)obj1).compareTo(obj2)));
                if (rc == 0) continue;
                return rc;
            }
            return rc;
        }
    }

    protected static class EntriesOrderByComparator
    implements Comparator<IEntryPacket> {
        private List<OrderColumn> _orderColumns;
        private IQueryResultSet<IEntryPacket> _queryResult;

        public EntriesOrderByComparator(IQueryResultSet<IEntryPacket> queryResult, List<OrderColumn> orderColumns) {
            this._orderColumns = orderColumns;
            this._queryResult = queryResult;
        }

        @Override
        public int compare(IEntryPacket o1, IEntryPacket o2) {
            int rc = 0;
            for (int i = 0; i < this._orderColumns.size(); ++i) {
                Comparable c2;
                OrderColumn orderCol = this._orderColumns.get(i);
                Comparable c1 = (Comparable)this._queryResult.getFieldValue(orderCol, o1);
                if (c1 == (c2 = (Comparable)this._queryResult.getFieldValue(orderCol, o2))) continue;
                if (c1 == null) {
                    return -1;
                }
                if (c2 == null) {
                    return 1;
                }
                rc = c1.compareTo(c2);
                if (rc == 0) continue;
                return orderCol.isDesc() ? -rc : rc;
            }
            return rc;
        }
    }
}

