/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.executor;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.jdbc.executor.EntriesCursor;
import com.j_spaces.jdbc.parser.ColumnNode;
import com.j_spaces.jdbc.parser.ExpNode;
import com.j_spaces.jdbc.query.IQueryResultSet;
import com.j_spaces.jdbc.query.QueryTableData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

@InternalApi
public class HashedEntriesCursor
implements EntriesCursor {
    private HashMap<Object, List<IEntryPacket>> hashMap = new HashMap();
    private QueryTableData _joinTable;
    private Iterator<IEntryPacket> _cursor;
    private ColumnNode _joinCol;
    private IEntryPacket _currentEntry;

    public HashedEntriesCursor(QueryTableData table, ExpNode indexNode, IQueryResultSet entries) {
        ColumnNode leftChild = (ColumnNode)indexNode.getLeftChild();
        ColumnNode rightChild = (ColumnNode)indexNode.getRightChild();
        this.init(leftChild, rightChild, entries);
    }

    private void init(ColumnNode joinCol, ColumnNode indexCol, IQueryResultSet<IEntryPacket> entries) {
        this._joinCol = joinCol;
        this._joinTable = this._joinCol.getColumnData().getColumnTableData();
        for (IEntryPacket entry : entries) {
            Object fieldValue = indexCol.getFieldValue(entry);
            List<IEntryPacket> entriesOnSameIndex = this.hashMap.get(fieldValue);
            if (entriesOnSameIndex == null) {
                entriesOnSameIndex = new LinkedList<IEntryPacket>();
                this.hashMap.put(fieldValue, entriesOnSameIndex);
            }
            entriesOnSameIndex.add(entry);
        }
    }

    public List<IEntryPacket> getMatch(ColumnNode matchCol, IEntryPacket expectedMatch) {
        Object fieldValue = matchCol.getFieldValue(expectedMatch);
        return this.hashMap.get(fieldValue);
    }

    @Override
    public IEntryPacket getCurrentEntry() {
        return this._currentEntry;
    }

    @Override
    public boolean next() {
        if (this._cursor == null) {
            IEntryPacket joinEntryPacket = this._joinTable.getCurrentEntry();
            List<IEntryPacket> match = this.getMatch(this._joinCol, joinEntryPacket);
            if (match == null) {
                return false;
            }
            this._cursor = match.iterator();
        }
        if (this._cursor.hasNext()) {
            this._currentEntry = this._cursor.next();
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this._cursor = null;
    }

    @Override
    public boolean isBeforeFirst() {
        return this._cursor == null;
    }
}

