/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.executor;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.jdbc.AbstractDMLQuery;
import com.j_spaces.jdbc.JoinedEntry;
import com.j_spaces.jdbc.SelectColumn;
import com.j_spaces.jdbc.Stack;
import com.j_spaces.jdbc.builder.QueryTemplatePacket;
import com.j_spaces.jdbc.executor.AbstractQueryExecutor;
import com.j_spaces.jdbc.parser.AbstractInNode;
import com.j_spaces.jdbc.parser.AndNode;
import com.j_spaces.jdbc.parser.ColumnNode;
import com.j_spaces.jdbc.parser.ExpNode;
import com.j_spaces.jdbc.parser.InNode;
import com.j_spaces.jdbc.parser.InnerQueryNode;
import com.j_spaces.jdbc.parser.LiteralNode;
import com.j_spaces.jdbc.parser.NotInNode;
import com.j_spaces.jdbc.parser.OrNode;
import com.j_spaces.jdbc.parser.ValueNode;
import com.j_spaces.jdbc.query.IQueryResultSet;
import com.j_spaces.jdbc.query.JoinedQueryResult;
import com.j_spaces.jdbc.query.QueryTableData;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import net.jini.core.transaction.Transaction;

@InternalApi
public class JoinedQueryExecutor
extends AbstractQueryExecutor {
    private JoinedEntry _currentEntry;
    private final HashMap<ExpNode, Boolean> _currentEntryResults = new HashMap();
    private final HashMap<ExpNode, Set<LiteralNode>> _inNodeValues = new HashMap();
    private ExpNode[] _traversalOrder;

    public JoinedQueryExecutor(AbstractDMLQuery query) {
        super(query);
    }

    @Override
    public IQueryResultSet<IEntryPacket> execute(ISpaceProxy space, Transaction txn, int readModifier, int max) throws SQLException {
        JoinedQueryResult result = new JoinedQueryResult();
        JoinedIterator iter = new JoinedIterator(this.query.getTablesData(), space, txn);
        while (iter.next()) {
            this._currentEntry = iter.get();
            boolean matches = this.matchesExpressionTree(this.query.getExpTree(), space, txn, readModifier, max);
            if (matches) {
                result.add(this._currentEntry);
            }
            if (result.size() < max) continue;
            break;
        }
        iter.close();
        return result;
    }

    @Override
    public void execute(ExpNode exp, ISpaceProxy space, Transaction txn, int readModifier, int max) throws SQLException {
        if (exp.isJoined()) {
            this.executeJoin(exp);
            return;
        }
        boolean isInRange = exp.getTemplate().matches(this._currentEntry);
        this.setResults(exp, isInRange);
    }

    public boolean getResults(ExpNode node) {
        return this._currentEntryResults.get(node);
    }

    public void setResults(ExpNode node, boolean result) {
        this._currentEntryResults.put(node, result);
    }

    private void executeJoin(ExpNode exp) throws SQLException {
        ColumnNode left = (ColumnNode)exp.getLeftChild();
        ColumnNode right = (ColumnNode)exp.getRightChild();
        int leftEntryIndex = left.getColumnData().getColumnTableData().getTableIndex();
        int rightEntryIndex = right.getColumnData().getColumnTableData().getTableIndex();
        Object leftJoinValue = left.getFieldValue(this._currentEntry.getEntry(leftEntryIndex));
        Object rightJoinValue = right.getFieldValue(this._currentEntry.getEntry(rightEntryIndex));
        boolean isInRange = exp.isValidCompare(leftJoinValue, rightJoinValue);
        this.setResults(exp, isInRange);
    }

    @Override
    public void execute(AndNode exp, ISpaceProxy space, Transaction txn, int readModifier, int max) throws SQLException {
        if (exp.getTemplate() != null) {
            this.setResults((ExpNode)exp, exp.getTemplate().matches(this._currentEntry));
            return;
        }
        if (exp.getLeftChild() == null) {
            this.setResults((ExpNode)exp, this.getResults(exp.getRightChild()));
            return;
        }
        if (exp.getRightChild() == null) {
            this.setResults((ExpNode)exp, this.getResults(exp.getLeftChild()));
            return;
        }
        boolean leftResult = this.getResults(exp.getLeftChild());
        if (!leftResult) {
            this.setResults((ExpNode)exp, leftResult);
            return;
        }
        boolean rightResult = this.getResults(exp.getRightChild());
        if (!rightResult) {
            this.setResults((ExpNode)exp, rightResult);
            return;
        }
        this.setResults((ExpNode)exp, leftResult && rightResult);
    }

    private boolean executeIn(AbstractInNode exp, ISpaceProxy space, Transaction txn, int readModifier) throws SQLException {
        QueryTemplatePacket template = exp.getTemplate();
        if (template == null) {
            Set<LiteralNode> valueSet = this._inNodeValues.get(exp);
            if (valueSet == null) {
                this.execute((InnerQueryNode)exp.getRightChild(), space, txn, readModifier, Integer.MAX_VALUE);
                exp.validateInnerQueryResult();
                valueSet = exp.getValuesList();
                this._inNodeValues.put(exp, valueSet);
            }
            ColumnNode left = (ColumnNode)exp.getLeftChild();
            int entryTableIndex = left.getColumnData().getColumnTableData().getTableIndex();
            Object joinValue = left.getFieldValue(this._currentEntry.getEntry(entryTableIndex));
            boolean isInRange = false;
            for (LiteralNode value : valueSet) {
                if (!value.getValue().equals(joinValue)) continue;
                isInRange = true;
                break;
            }
            return isInRange;
        }
        boolean isInRange = exp.getTemplate().matches(this._currentEntry);
        this.setResults((ExpNode)exp, isInRange);
        return isInRange;
    }

    @Override
    public void execute(InNode exp, ISpaceProxy space, Transaction txn, int readModifier, int max) throws SQLException {
        this.setResults((ExpNode)exp, this.executeIn(exp, space, txn, readModifier));
    }

    @Override
    public void execute(NotInNode exp, ISpaceProxy space, Transaction txn, int readModifier, int max) throws SQLException {
        this.setResults((ExpNode)exp, this.executeIn(exp, space, txn, readModifier));
    }

    @Override
    public void execute(OrNode exp, ISpaceProxy space, Transaction txn, int readModifier, int max) throws SQLException {
        if (exp.getTemplate() != null) {
            this.setResults((ExpNode)exp, exp.getTemplate().matches(this._currentEntry));
            return;
        }
        if (exp.getLeftChild() == null) {
            this.setResults((ExpNode)exp, this.getResults(exp.getRightChild()));
            return;
        }
        if (exp.getRightChild() == null) {
            this.setResults((ExpNode)exp, this.getResults(exp.getLeftChild()));
            return;
        }
        boolean leftResult = this.getResults(exp.getLeftChild());
        boolean rightResult = this.getResults(exp.getRightChild());
        this.setResults((ExpNode)exp, leftResult || rightResult);
    }

    public Comparator<IEntryPacket> getGroupByComparator(List<SelectColumn> groupColumns) {
        return new GroupByComparator(groupColumns);
    }

    protected boolean matchesExpressionTree(ExpNode root, ISpaceProxy space, Transaction txn, int readModifier, int max) throws SQLException {
        if (root == null) {
            return true;
        }
        if (this._traversalOrder != null) {
            for (int i = 0; i < this._traversalOrder.length; ++i) {
                ExpNode node = this._traversalOrder[i];
                if (i < this._traversalOrder.length - 1) {
                    node.accept(this, space, txn, readModifier, Integer.MAX_VALUE);
                    continue;
                }
                node.accept(this, space, txn, readModifier, max);
            }
            return this.getResults(root);
        }
        Stack<ExpNode> stack = new Stack<ExpNode>();
        Stack<ExpNode> stack2 = new Stack<ExpNode>();
        stack.push(root);
        while (!stack.isEmpty()) {
            ExpNode curr = (ExpNode)stack.pop();
            if (!(curr instanceof ValueNode)) {
                stack2.push(curr);
            }
            if (curr.getTemplate() != null) continue;
            if (curr.getLeftChild() != null) {
                stack.push(curr.getLeftChild());
            }
            if (curr.getRightChild() == null) continue;
            stack.push(curr.getRightChild());
        }
        this._traversalOrder = new ExpNode[stack2.size()];
        int index = 0;
        while (!stack2.isEmpty()) {
            ExpNode node = (ExpNode)stack2.pop();
            this._traversalOrder[index++] = node;
            if (stack2.isEmpty()) {
                node.accept(this, space, txn, readModifier, max);
                continue;
            }
            node.accept(this, space, txn, readModifier, Integer.MAX_VALUE);
        }
        return this.getResults(root);
    }

    private class JoinedIterator {
        private JoinedEntry currentEntry;
        private QueryTableData _tableData;
        private List<QueryTableData> _tablesData;

        public JoinedIterator(List<QueryTableData> tablesData, ISpaceProxy space, Transaction txn) throws SQLException {
            this._tablesData = tablesData;
            try {
                for (QueryTableData tableData : JoinedQueryExecutor.this.query.getTablesData()) {
                    tableData.init(space, txn, JoinedQueryExecutor.this.query);
                }
            }
            catch (Exception e) {
                if (AbstractQueryExecutor._logger.isLoggable(Level.SEVERE)) {
                    AbstractQueryExecutor._logger.log(Level.SEVERE, e.getMessage(), e);
                }
                throw new SQLException("Failed to read objects: " + e.getMessage(), "GSP", -111);
            }
            for (int i = 0; i < this._tablesData.size(); ++i) {
                QueryTableData tableData;
                tableData = this._tablesData.get(i);
                if (tableData.isJoined()) continue;
                this._tableData = tableData;
                break;
            }
        }

        boolean next() {
            return this._tableData.next();
        }

        public JoinedEntry get() {
            IEntryPacket[] entries = new IEntryPacket[this._tablesData.size()];
            for (int i = 0; i < entries.length; ++i) {
                entries[i] = this._tablesData.get(i).getCurrentEntry();
            }
            this.currentEntry = new JoinedEntry(entries);
            return this.currentEntry;
        }

        public void close() {
            for (QueryTableData t : this._tablesData) {
                t.clear();
            }
        }
    }

    private static class GroupByComparator
    implements Comparator<IEntryPacket> {
        private List<SelectColumn> groupColumns;

        GroupByComparator(List<SelectColumn> groupCols) {
            this.groupColumns = groupCols;
        }

        @Override
        public int compare(IEntryPacket e1, IEntryPacket e2) {
            if (e1 == null) {
                if (e2 == null) {
                    return 0;
                }
                return -1;
            }
            if (e2 == null) {
                return 1;
            }
            int rc = 0;
            JoinedEntry j1 = (JoinedEntry)e1;
            JoinedEntry j2 = (JoinedEntry)e2;
            for (int i = 0; i < this.groupColumns.size(); ++i) {
                SelectColumn groupCol = this.groupColumns.get(i);
                e1 = j1.getEntry(groupCol.getColumnTableData().getTableIndex());
                e2 = j2.getEntry(groupCol.getColumnTableData().getTableIndex());
                Comparable obj1 = (Comparable)groupCol.getFieldValue(e1);
                Comparable obj2 = (Comparable)groupCol.getFieldValue(e2);
                rc = obj1 == null && obj2 == null ? 0 : (obj1 == null && obj2 != null ? -1 : (obj1 != null && obj2 == null ? 1 : obj1.compareTo(obj2)));
                if (rc == 0) continue;
                return rc;
            }
            return rc;
        }
    }
}

