/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.executor;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.utils.concurrent.ContextClassLoaderCallable;
import com.j_spaces.core.SpaceContext;
import com.j_spaces.jdbc.AbstractDMLQuery;
import com.j_spaces.jdbc.builder.QueryTemplateBuilder;
import com.j_spaces.jdbc.builder.QueryTemplatePacket;
import com.j_spaces.jdbc.executor.AbstractQueryExecutor;
import com.j_spaces.jdbc.parser.AndNode;
import com.j_spaces.jdbc.parser.ExpNode;
import com.j_spaces.jdbc.parser.InNode;
import com.j_spaces.jdbc.parser.NotInNode;
import com.j_spaces.jdbc.parser.OrNode;
import com.j_spaces.jdbc.query.IQueryResultSet;
import java.sql.SQLException;
import net.jini.core.transaction.Transaction;

@InternalApi
public class QueryExecutor
extends AbstractQueryExecutor {
    public QueryExecutor(AbstractDMLQuery query) {
        super(query);
    }

    @Override
    public void execute(OrNode exp, ISpaceProxy space, Transaction txn, int readModifier, int max) throws SQLException {
        if (exp.getTemplate() != null) {
            IQueryResultSet<IEntryPacket> results = this.executeTemplate(exp.getTemplate(), space, txn, readModifier, max);
            this.setResults(exp, results);
            return;
        }
        if (exp.getLeftChild() == null) {
            this.setResults(exp, this.extractResults(exp.getRightChild()));
            return;
        }
        if (exp.getRightChild() == null) {
            this.setResults(exp, this.extractResults(exp.getLeftChild()));
            return;
        }
        IQueryResultSet<IEntryPacket> leftResult = this.extractResults(exp.getLeftChild());
        IQueryResultSet<IEntryPacket> rightResult = this.extractResults(exp.getRightChild());
        if (leftResult.size() >= max) {
            this.setResults(exp, leftResult);
            return;
        }
        if (rightResult.size() >= max) {
            this.setResults(exp, rightResult);
            return;
        }
        if (leftResult.isEmpty()) {
            this.setResults(exp, rightResult);
            return;
        }
        if (rightResult.isEmpty()) {
            this.setResults(exp, leftResult);
            return;
        }
        IQueryResultSet<IEntryPacket> results = leftResult.union(rightResult);
        this.setResults(exp, results);
    }

    @Override
    public void execute(AndNode exp, ISpaceProxy space, Transaction txn, int readModifier, int max) throws SQLException {
        if (exp.getTemplate() != null) {
            IQueryResultSet<IEntryPacket> results = this.executeTemplate(exp.getTemplate(), space, txn, readModifier, max);
            this.setResults(exp, results);
            return;
        }
        if (exp.getLeftChild() == null) {
            this.setResults(exp, this.extractResults(exp.getRightChild()));
            return;
        }
        if (exp.getRightChild() == null) {
            this.setResults(exp, this.extractResults(exp.getLeftChild()));
            return;
        }
        IQueryResultSet<IEntryPacket> leftResult = this.extractResults(exp.getLeftChild());
        IQueryResultSet<IEntryPacket> rightResult = this.extractResults(exp.getRightChild());
        if (leftResult.isEmpty()) {
            this.setResults(exp, leftResult);
            return;
        }
        if (rightResult.isEmpty()) {
            this.setResults(exp, rightResult);
            return;
        }
        IQueryResultSet<IEntryPacket> andResult = leftResult.intersect(rightResult);
        this.setResults(exp, andResult);
    }

    @Override
    public void execute(InNode exp, ISpaceProxy space, Transaction txn, int readModifier, int max) throws SQLException {
        QueryTemplatePacket template = exp.getTemplate();
        if (template == null) {
            exp.validateInnerQueryResult();
            template = QueryTemplateBuilder.buildTemplate(exp, this.query);
            template.prepareForSpace(this.query.getTypeInfo());
        }
        IQueryResultSet<IEntryPacket> results = this.executeTemplate(template, space, txn, readModifier, max);
        this.setResults(exp, results);
    }

    @Override
    public void execute(NotInNode exp, ISpaceProxy space, Transaction txn, int readModifier, int max) throws SQLException {
        QueryTemplatePacket template = exp.getTemplate();
        if (template == null) {
            exp.validateInnerQueryResult();
            template = QueryTemplateBuilder.buildTemplate(exp, this.query);
            template.prepareForSpace(this.query.getTypeInfo());
        }
        IQueryResultSet<IEntryPacket> results = this.executeTemplate(template, space, txn, readModifier, max);
        this.setResults(exp, results);
    }

    @Override
    public IQueryResultSet<IEntryPacket> execute(ISpaceProxy space, Transaction txn, int readModifier, int max) throws SQLException {
        return this.traverseExpressionTree(this.query.getExpTree(), space, txn, readModifier, max);
    }

    @Override
    public void execute(ExpNode expNode, ISpaceProxy space, Transaction txn, int readModifier, int max) throws SQLException {
        IQueryResultSet<IEntryPacket> results = this.executeTemplate(expNode.getTemplate(), space, txn, readModifier, max);
        this.setResults(expNode, results);
    }

    public static class ExecutionTask
    extends ContextClassLoaderCallable<IQueryResultSet<IEntryPacket>> {
        private ISpaceProxy _space;
        private Transaction _transaction;
        private int _maxObjects;
        private int _readModifier;
        private QueryTemplatePacket _packet;
        private SpaceContext _spaceContext;

        public ExecutionTask(QueryTemplatePacket packet, ISpaceProxy space, Transaction transaction, int maxObjects, int readModifier) {
            this._packet = packet;
            this._space = space;
            this._transaction = transaction;
            this._maxObjects = maxObjects;
            this._readModifier = readModifier;
            if (space.isSecured()) {
                this._spaceContext = this._space.getDirectProxy().getSecurityManager().getThreadSpaceContext();
            }
        }

        @Override
        protected IQueryResultSet<IEntryPacket> execute() throws Exception {
            IQueryResultSet<IEntryPacket> result;
            SpaceContext prevContext = null;
            if (this._spaceContext != null) {
                prevContext = this._space.getDirectProxy().getSecurityManager().setThreadSpaceContext(this._spaceContext);
            }
            try {
                result = this._packet.readMultiple(this._space, this._transaction, this._maxObjects, this._readModifier);
            }
            finally {
                if (this._spaceContext != null) {
                    this._space.getDirectProxy().getSecurityManager().setThreadSpaceContext(prevContext);
                }
            }
            return result;
        }
    }
}

