/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.parser;

import com.gigaspaces.internal.metadata.ITypeDesc;
import com.j_spaces.jdbc.ResultEntry;
import com.j_spaces.jdbc.parser.ExpNode;
import com.j_spaces.jdbc.parser.InnerQueryNode;
import com.j_spaces.jdbc.parser.LiteralNode;
import com.j_spaces.jdbc.parser.PreparedNode;
import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractInNode
extends ExpNode {
    protected HashSet<LiteralNode> valuesList;

    public AbstractInNode() {
    }

    @Override
    public void prepareValues(Object[] values) throws SQLException {
        if (this.valuesList != null && values != null) {
            for (LiteralNode valueNode : this.valuesList) {
                if (!valueNode.isPreparedValue()) continue;
                valueNode.setValue(values[((PreparedNode)valueNode).getIndex() - 1]);
            }
        }
    }

    public AbstractInNode(ExpNode leftChild, ExpNode rightChild) {
        super(leftChild, rightChild);
    }

    public void setValuesList(HashSet<LiteralNode> valuesList) {
        this.valuesList = valuesList;
    }

    public Set<LiteralNode> getValuesList() {
        return this.valuesList;
    }

    public <T> Set<T> getConvertedValues(ITypeDesc typeDesc, String propertyName) throws SQLException {
        HashSet<Object> convertedValues = new HashSet<Object>();
        for (LiteralNode value : this.valuesList) {
            Object convertedObject = value.getConvertedObject(typeDesc, propertyName);
            if (convertedObject == null) {
                convertedValues.add(null);
                continue;
            }
            if (convertedObject instanceof Collection) {
                convertedValues.addAll((Collection)convertedObject);
                continue;
            }
            if (convertedObject.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(convertedObject); ++i) {
                    convertedValues.add(Array.get(convertedObject, i));
                }
                continue;
            }
            convertedValues.add(convertedObject);
        }
        return convertedValues;
    }

    @Override
    public Object clone() {
        AbstractInNode cloned = (AbstractInNode)super.clone();
        if (this.getRightChild() != null && this.getRightChild().isInnerQuery()) {
            cloned.setRightChild((InnerQueryNode)this.getRightChild().clone());
        } else {
            HashSet<LiteralNode> clonedSet = new HashSet<LiteralNode>();
            for (LiteralNode value : this.valuesList) {
                clonedSet.add((LiteralNode)value.clone());
            }
            cloned.setValuesList(clonedSet);
        }
        return cloned;
    }

    @Override
    public void validateInnerQueryResult() throws SQLException {
        InnerQueryNode innerQueryNode = (InnerQueryNode)this.rightChild;
        if (!innerQueryNode.isSingleColumnResult()) {
            throw new SQLException("Inner query returned more than 1 row.");
        }
        this.valuesList = new HashSet();
        ResultEntry innerResult = innerQueryNode.getResult();
        for (int i = 0; i < innerResult.getFieldValues().length; ++i) {
            this.valuesList.add(new LiteralNode(innerResult.getFieldValues()[i][0]));
        }
    }
}

