/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.parser;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.jdbc.AbstractDMLQuery;
import com.j_spaces.jdbc.SQLUtil;
import com.j_spaces.jdbc.builder.QueryTemplateBuilder;
import com.j_spaces.jdbc.builder.range.FunctionCallDescription;
import com.j_spaces.jdbc.parser.ValueNode;
import com.j_spaces.jdbc.query.QueryColumnData;
import java.sql.SQLException;

@InternalApi
public class ColumnNode
extends ValueNode {
    private QueryColumnData _columnData;
    private String _name;
    private FunctionCallDescription functionCallDescription;

    public ColumnNode() {
    }

    public ColumnNode(String columnPath) {
        this();
        this._name = columnPath;
    }

    public FunctionCallDescription getFunctionCallDescription() {
        return this.functionCallDescription;
    }

    public void setFunctionCallDescription(FunctionCallDescription functionCallDescription) {
        this.functionCallDescription = functionCallDescription;
    }

    public void createColumnData(AbstractDMLQuery query) throws SQLException {
        this._columnData = QueryColumnData.newColumnData(this._name, query);
    }

    public QueryColumnData getColumnData() {
        return this._columnData;
    }

    public String getColumnPath() {
        return this._columnData.getColumnPath();
    }

    public String toString() {
        if (this.functionCallDescription == null) {
            return this._name;
        }
        return this.functionCallDescription.getName() + "/" + this.functionCallDescription.getNumberOfArguments() + " (" + this._name + ")";
    }

    @Override
    public void accept(QueryTemplateBuilder builder) throws SQLException {
        builder.build(this);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (this._columnData != null) {
            throw new IllegalStateException("Can't set column name after column data has been set.");
        }
        this._name = name;
    }

    public Object getFieldValue(IEntryPacket entry) {
        return SQLUtil.getFieldValue(entry, this._columnData);
    }
}

