/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.parser;

import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.jdbc.builder.QueryTemplateBuilder;
import com.j_spaces.jdbc.builder.QueryTemplatePacket;
import com.j_spaces.jdbc.executor.EntriesCursor;
import com.j_spaces.jdbc.executor.IQueryExecutor;
import com.j_spaces.jdbc.executor.ScanCursor;
import com.j_spaces.jdbc.parser.ColumnNode;
import com.j_spaces.jdbc.parser.InnerQueryNode;
import com.j_spaces.jdbc.query.IQueryResultSet;
import com.j_spaces.jdbc.query.QueryTableData;
import java.sql.SQLException;
import java.util.TreeMap;
import net.jini.core.transaction.Transaction;

public abstract class ExpNode
implements Cloneable {
    protected ExpNode leftChild;
    protected ExpNode rightChild;
    protected QueryTemplatePacket template;

    public ExpNode() {
        this(null, null);
    }

    public ExpNode(ExpNode leftChild, ExpNode rightChild) {
        this.leftChild = leftChild;
        this.rightChild = rightChild;
    }

    public void setLeftChild(ExpNode leftChild) {
        this.leftChild = leftChild;
    }

    public void setRightChild(ExpNode rightChild) {
        this.rightChild = rightChild;
    }

    public ExpNode getLeftChild() {
        return this.leftChild;
    }

    public ExpNode getRightChild() {
        return this.rightChild;
    }

    public void prepareValues(Object[] values) throws SQLException {
        if (this.leftChild != null) {
            this.leftChild.prepareValues(values);
        }
        if (this.rightChild != null) {
            this.rightChild.prepareValues(values);
        }
    }

    public String prepareTemplateValues(TreeMap values, String colName) throws SQLException {
        if (this instanceof ColumnNode) {
            colName = ((ColumnNode)this).getName();
        }
        if (this.leftChild != null) {
            colName = this.leftChild.prepareTemplateValues(values, colName);
        }
        if (this.rightChild != null) {
            colName = this.rightChild.prepareTemplateValues(values, colName);
        }
        return colName;
    }

    public abstract boolean isValidCompare(Object var1, Object var2) throws ClassCastException;

    public boolean isJoined() {
        return this.getRightChild() instanceof ColumnNode && this.getLeftChild() instanceof ColumnNode;
    }

    public abstract ExpNode newInstance();

    public Object clone() {
        ExpNode cloned = this.newInstance();
        if (this.leftChild != null) {
            cloned.leftChild = (ExpNode)this.leftChild.clone();
        }
        if (this.rightChild != null) {
            cloned.rightChild = (ExpNode)this.rightChild.clone();
        }
        if (this.template != null) {
            cloned.setTemplate((QueryTemplatePacket)this.template.clone());
        }
        return cloned;
    }

    public abstract void accept(QueryTemplateBuilder var1) throws SQLException;

    public void accept(IQueryExecutor executor, ISpaceProxy space, Transaction txn, int readModifier, int max) throws SQLException {
        executor.execute(this, space, txn, readModifier, max);
    }

    public QueryTemplatePacket getTemplate() {
        return this.template;
    }

    public void setTemplate(QueryTemplatePacket template) {
        this.template = template;
    }

    public String toString(String op) {
        StringBuilder b = new StringBuilder();
        b.append(this.leftChild != null ? this.leftChild.toString() : null);
        b.append(op);
        b.append(this.rightChild != null ? this.rightChild.toString() : null);
        return b.toString();
    }

    public EntriesCursor createIndex(QueryTableData queryTableData, IQueryResultSet<IEntryPacket> tableEntries) {
        return new ScanCursor(tableEntries);
    }

    public boolean createJoinIndex(QueryTableData tableData) {
        QueryTableData leftTable = ((ColumnNode)this.getLeftChild()).getColumnData().getColumnTableData();
        if (leftTable.equals(tableData)) {
            if (this.isJoined()) {
                tableData.join(this);
            } else if (this.getTemplate() != null && tableData.getTableCondition() == null) {
                tableData.setTableCondition(this);
            }
        }
        return false;
    }

    public boolean isInnerQuery() {
        return false;
    }

    public boolean isContainsItemNode() {
        return false;
    }

    public boolean isContainsItemsRootNode() {
        return false;
    }

    public void validateInnerQueryResult() throws SQLException {
        InnerQueryNode innerQueryNode = (InnerQueryNode)this.rightChild;
        if (!innerQueryNode.isSingleResult() && !innerQueryNode.isEmptyResult()) {
            throw new SQLException("Inner query returned more than 1 rows/columns.");
        }
    }
}

