/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.parser;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.j_spaces.jdbc.SQLUtil;
import com.j_spaces.jdbc.parser.LiteralNode;
import java.sql.SQLException;
import java.util.TreeMap;

@InternalApi
public class PreparedNode
extends LiteralNode {
    private final int index;

    public PreparedNode(Object value) {
        this(value, -1);
    }

    public PreparedNode(Object value, int index) {
        super(value);
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isPreparedValue() {
        return true;
    }

    @Override
    public void prepareValues(Object[] values) throws SQLException {
        if (this.value != null) {
            throw new SQLException("Prepared value already set!", "GSP", -109);
        }
        if (this.index > values.length) {
            throw new SQLException("Prepared value missing!", "GSP", -110);
        }
        this.value = values[this.index - 1];
    }

    @Override
    public String prepareTemplateValues(TreeMap values, String colName) throws SQLException {
        if (this.value != null) {
            throw new SQLException("Prepared value already set!", "GSP", -109);
        }
        this.value = values.remove(colName);
        return null;
    }

    @Override
    public Object getConvertedObject(ITypeDesc typeDesc, String propertyName) throws SQLException {
        return SQLUtil.cast(typeDesc, propertyName, this.value, true);
    }

    @Override
    public Object clone() {
        return new PreparedNode(null, this.index);
    }
}

