/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.parser;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.jdbc.parser.ValueNode;

@InternalApi
public class RowNumNode
extends ValueNode {
    private int startIndex = 0;
    private int endIndex = 0;
    private int maxResults = Integer.MAX_VALUE;

    public RowNumNode(int start, int end) {
        this.startIndex = Math.min(start, end);
        this.endIndex = Math.max(start, end);
    }

    public void setEndIndex(int endIndex) {
        this.endIndex = endIndex;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public boolean hasLimit() {
        return this.getStartIndex() > 1 || this.endIndex != Integer.MAX_VALUE || this.maxResults != Integer.MAX_VALUE;
    }

    public int getLimit() {
        if (!this.hasLimit()) {
            return Integer.MAX_VALUE;
        }
        long maxResultsLimit = (long)this.startIndex + (long)this.maxResults - 1L;
        return (int)Math.min(maxResultsLimit, (long)this.endIndex);
    }

    public boolean isIndexOutOfRange(int i) {
        if (i < this.getStartIndex()) {
            return true;
        }
        return i > this.getLimit();
    }

    public String toString() {
        return "RowNumNode [startIndex=" + this.startIndex + ", endIndex=" + this.endIndex + ", maxResults=" + this.maxResults + "]";
    }

    @Override
    public Object clone() {
        return new RowNumNode(this.startIndex, this.endIndex);
    }
}

