/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.parser.grammar;

import com.j_spaces.jdbc.AbstractDMLQuery;
import com.j_spaces.jdbc.AlterTableQuery;
import com.j_spaces.jdbc.CommitQuery;
import com.j_spaces.jdbc.CreateTableQuery;
import com.j_spaces.jdbc.DeleteQuery;
import com.j_spaces.jdbc.DropTableQuery;
import com.j_spaces.jdbc.InsertQuery;
import com.j_spaces.jdbc.OrderColumn;
import com.j_spaces.jdbc.ProcedureQuery;
import com.j_spaces.jdbc.Query;
import com.j_spaces.jdbc.QueryProcessor;
import com.j_spaces.jdbc.SelectColumn;
import com.j_spaces.jdbc.SelectQuery;
import com.j_spaces.jdbc.UpdateColumn;
import com.j_spaces.jdbc.UpdateQuery;
import com.j_spaces.jdbc.builder.range.FunctionCallDescription;
import com.j_spaces.jdbc.driver.Blob;
import com.j_spaces.jdbc.driver.Clob;
import com.j_spaces.jdbc.parser.AbstractInNode;
import com.j_spaces.jdbc.parser.AndNode;
import com.j_spaces.jdbc.parser.ColumnNode;
import com.j_spaces.jdbc.parser.ContainsItemNode;
import com.j_spaces.jdbc.parser.ContainsItemsRootNode;
import com.j_spaces.jdbc.parser.ContainsNode;
import com.j_spaces.jdbc.parser.EqualNode;
import com.j_spaces.jdbc.parser.ExpNode;
import com.j_spaces.jdbc.parser.GTENode;
import com.j_spaces.jdbc.parser.GTNode;
import com.j_spaces.jdbc.parser.InNode;
import com.j_spaces.jdbc.parser.InnerQueryNode;
import com.j_spaces.jdbc.parser.IsNullNode;
import com.j_spaces.jdbc.parser.LTENode;
import com.j_spaces.jdbc.parser.LTNode;
import com.j_spaces.jdbc.parser.LikeNode;
import com.j_spaces.jdbc.parser.LiteralNode;
import com.j_spaces.jdbc.parser.NotEqualNode;
import com.j_spaces.jdbc.parser.NotInNode;
import com.j_spaces.jdbc.parser.NotLikeNode;
import com.j_spaces.jdbc.parser.OrNode;
import com.j_spaces.jdbc.parser.PreparedNode;
import com.j_spaces.jdbc.parser.RLikeNode;
import com.j_spaces.jdbc.parser.RelationNode;
import com.j_spaces.jdbc.parser.RowNumNode;
import com.j_spaces.jdbc.parser.ValueNode;
import com.j_spaces.jdbc.parser.grammar.ParseException;
import com.j_spaces.jdbc.parser.grammar.SimpleCharStream;
import com.j_spaces.jdbc.parser.grammar.SqlParserConstants;
import com.j_spaces.jdbc.parser.grammar.SqlParserTokenManager;
import com.j_spaces.jdbc.parser.grammar.Token;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class SqlParser
implements SqlParserConstants {
    private int conditionIndex = 0;
    public SqlParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[156];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private final JJCalls[] jj_2_rtns = new JJCalls[37];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static void main(String[] args) throws ParseException {
        SqlParser parser = new SqlParser(System.in);
        while (true) {
            try {
                while (true) {
                    Query query = parser.parseStatement();
                    System.out.println("Query received and parsed: ");
                    System.out.println(query);
                }
            }
            catch (Exception e) {
                System.err.println("Caught Exception - error in query");
                e.printStackTrace();
                parser.ReInit(System.in);
                System.exit(-1);
                continue;
            }
            break;
        }
    }

    public void reset(Reader reader) {
        this.conditionIndex = 0;
        this.ReInit(reader);
    }

    public final Query parseStatement() throws ParseException {
        Query query;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 32: {
                query = this.selectSql();
                break;
            }
            case 38: {
                query = this.deleteSql();
                break;
            }
            case 42: {
                query = this.insertSql();
                break;
            }
            case 47: {
                query = this.updateSql();
                break;
            }
            case 13: {
                query = this.createTable();
                break;
            }
            case 15: {
                query = this.dropTable();
                break;
            }
            case 5: {
                query = this.alterTable();
                break;
            }
            case 50: 
            case 51: {
                query = this.commit();
                break;
            }
            case 14: {
                query = this.executeProcedure();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 101: {
                this.jj_consume_token(101);
                break;
            }
            case 0: {
                this.jj_consume_token(0);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return query;
    }

    public final Query selectSql() throws ParseException {
        ExpNode exp = null;
        this.jj_consume_token(32);
        SelectQuery query = new SelectQuery();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 18: {
                this.setQuantifier(query);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 113: {
                this.jj_consume_token(113);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        this.selectColumnList(query);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 114: {
                this.jj_consume_token(114);
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        this.jj_consume_token(20);
        this.selectTableList(query);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: {
                this.jj_consume_token(36);
                exp = this.SqlExpression(query);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: {
                this.groupBy(query);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 31: {
                this.orderBy(query);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 46: {
                this.jj_consume_token(46);
                query.setForUpdate(true);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
        query.setExpTree(exp);
        return query;
    }

    public final AbstractDMLQuery readMultipleQuery() throws ParseException {
        AbstractDMLQuery query;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                query = this.executeProcedure();
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                query = this.selectSqlQuery();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 101: {
                this.jj_consume_token(101);
                break;
            }
            case 0: {
                this.jj_consume_token(0);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return query;
    }

    public final SelectQuery selectSqlQuery() throws ParseException {
        SelectQuery query = new SelectQuery();
        ExpNode exp = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: 
            case 88: 
            case 89: 
            case 113: {
                exp = this.SqlExpression(query);
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: {
                this.groupBy(query);
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 31: {
                this.orderBy(query);
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 46: {
                this.jj_consume_token(46);
                query.setForUpdate(true);
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
            }
        }
        SelectColumn selectC = new SelectColumn("*");
        query.addColumn(selectC);
        query.setExpTree(exp);
        return query;
    }

    public final DeleteQuery deleteSqlQuery() throws ParseException {
        DeleteQuery query = new DeleteQuery();
        ExpNode exp = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: 
            case 88: 
            case 89: 
            case 113: {
                exp = this.SqlExpression(query);
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 101: {
                this.jj_consume_token(101);
                break;
            }
            case 0: {
                this.jj_consume_token(0);
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        query.setExpTree(exp);
        return query;
    }

    public final SelectQuery countSqlQuery() throws ParseException {
        SelectQuery query = new SelectQuery();
        ExpNode exp = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: 
            case 88: 
            case 89: 
            case 113: {
                exp = this.SqlExpression(query);
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: {
                this.groupBy(query);
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 31: {
                this.orderBy(query);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 46: {
                this.jj_consume_token(46);
                query.setForUpdate(true);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 101: {
                this.jj_consume_token(101);
                break;
            }
            case 0: {
                this.jj_consume_token(0);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        SelectColumn selectC = new SelectColumn("*");
        selectC.setCount(true);
        selectC.setFunctionName("count");
        query.setAggFunction(true);
        query.addColumn(selectC);
        query.setExpTree(exp);
        return query;
    }

    public final Query deleteSql() throws ParseException {
        ExpNode exp = null;
        this.jj_consume_token(38);
        DeleteQuery query = new DeleteQuery();
        this.jj_consume_token(20);
        this.tableNameWithOptionalAlias(query);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: {
                this.jj_consume_token(36);
                exp = this.SqlExpression(query);
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
            }
        }
        query.setExpTree(exp);
        return query;
    }

    public final Query updateSql() throws ParseException {
        ExpNode exp = null;
        this.jj_consume_token(47);
        UpdateQuery query = new UpdateQuery();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: {
                this.jj_consume_token(12);
                this.jj_consume_token(54);
                query.setByUid(true);
                break;
            }
            case 88: 
            case 89: {
                this.tableNameWithOptionalAlias(query);
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(44);
        this.columnListWithValues(query);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: {
                this.jj_consume_token(36);
                exp = this.SqlExpression(query);
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
            }
        }
        query.setExpTree(exp);
        return query;
    }

    public final Query insertSql() throws ParseException {
        Query innerQuery = null;
        this.jj_consume_token(42);
        InsertQuery query = new InsertQuery();
        this.jj_consume_token(43);
        this.tableName(query);
        if (this.jj_2_1(2)) {
            this.jj_consume_token(113);
            this.columnList(query);
            this.jj_consume_token(114);
        }
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 49: {
                this.jj_consume_token(49);
                this.jj_consume_token(113);
                this.insertValuesList(query);
                this.jj_consume_token(114);
                break;
            }
            case 32: 
            case 113: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 113: {
                        this.jj_consume_token(113);
                        break;
                    }
                    default: {
                        this.jj_la1[25] = this.jj_gen;
                    }
                }
                innerQuery = this.selectSql();
                query.setQuery((SelectQuery)innerQuery);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 114: {
                        this.jj_consume_token(114);
                        break block0;
                    }
                }
                this.jj_la1[26] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return query;
    }

    public final Query createTable() throws ParseException {
        ArrayList<Integer> indices;
        ArrayList<String> types;
        ArrayList<String> columns;
        CreateTableQuery query;
        block44: {
            int index = 0;
            this.jj_consume_token(13);
            this.jj_consume_token(45);
            query = new CreateTableQuery();
            String table = this.className();
            query.setTableName(table);
            columns = new ArrayList<String>();
            types = new ArrayList<String>();
            indices = new ArrayList<Integer>();
            this.jj_consume_token(113);
            Token column = this.id();
            String columnName = QueryProcessor.getDefaultConfig().isParserCaseSensitivity() ? column.image : column.image.toUpperCase();
            columns.add(columnName);
            String type = this.sqlType();
            types.add(type);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 41: 
                case 52: {
                    block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 52: {
                            this.jj_consume_token(52);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 28: {
                                    this.jj_consume_token(28);
                                    this.jj_consume_token(29);
                                    break block3;
                                }
                            }
                            this.jj_la1[28] = this.jj_gen;
                            break;
                        }
                        case 41: {
                            this.jj_consume_token(41);
                            break;
                        }
                        default: {
                            this.jj_la1[29] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    indices.add(new Integer(index));
                    break;
                }
                default: {
                    this.jj_la1[30] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 16: {
                    this.jj_consume_token(16);
                    break;
                }
                default: {
                    this.jj_la1[31] = this.jj_gen;
                }
            }
            block37: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 125: {
                        break;
                    }
                    default: {
                        this.jj_la1[32] = this.jj_gen;
                        break block44;
                    }
                }
                this.jj_consume_token(125);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 52: {
                        int i;
                        this.jj_consume_token(52);
                        this.jj_consume_token(113);
                        Token PKName = this.id();
                        for (i = 0; i < columns.size(); ++i) {
                            if (!PKName.image.equalsIgnoreCase((String)columns.get(i))) continue;
                            indices.add(new Integer(i));
                            break;
                        }
                        block39: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 125: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[33] = this.jj_gen;
                                    break block39;
                                }
                            }
                            this.jj_consume_token(125);
                            PKName = this.id();
                            i = 0;
                            while (true) {
                                if (i >= columns.size()) continue block39;
                                if (PKName.image.equalsIgnoreCase((String)columns.get(i))) {
                                    indices.add(new Integer(i));
                                    continue block39;
                                }
                                ++i;
                            }
                            break;
                        }
                        this.jj_consume_token(114);
                        continue block37;
                    }
                    case 53: {
                        this.jj_consume_token(53);
                        this.jj_consume_token(113);
                        column = this.id();
                        if (query.getRoutingFieldName() != null) {
                            throw new ParseException("PARTITION BY can only be set for one column!");
                        }
                        columnName = QueryProcessor.getDefaultConfig().isParserCaseSensitivity() ? column.image : column.image.toUpperCase();
                        query.setRoutingFieldName(columnName);
                        this.jj_consume_token(114);
                        continue block37;
                    }
                    case 88: 
                    case 89: {
                        column = this.id();
                        columnName = QueryProcessor.getDefaultConfig().isParserCaseSensitivity() ? column.image : column.image.toUpperCase();
                        columns.add(columnName);
                        type = this.sqlType();
                        types.add(type);
                        ++index;
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 41: 
                            case 52: {
                                block27 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 52: {
                                        this.jj_consume_token(52);
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 28: {
                                                this.jj_consume_token(28);
                                                this.jj_consume_token(29);
                                                break block27;
                                            }
                                        }
                                        this.jj_la1[34] = this.jj_gen;
                                        break;
                                    }
                                    case 41: {
                                        this.jj_consume_token(41);
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[35] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                                indices.add(new Integer(index));
                                break;
                            }
                            default: {
                                this.jj_la1[36] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 16: {
                                this.jj_consume_token(16);
                                continue block37;
                            }
                        }
                        this.jj_la1[37] = this.jj_gen;
                        continue block37;
                    }
                }
                break;
            }
            this.jj_la1[38] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(114);
        String[] namesArray = new String[columns.size()];
        String[] typesArray = new String[types.size()];
        boolean[] indicesArray = new boolean[types.size()];
        Iterator it = indices.iterator();
        while (it.hasNext()) {
            indicesArray[((Integer)it.next()).intValue()] = true;
        }
        query.setColumnNames(columns.toArray(namesArray));
        query.setColumnTypes(types.toArray(typesArray));
        query.setIndices(indicesArray);
        return query;
    }

    public final Query dropTable() throws ParseException {
        this.jj_consume_token(15);
        this.jj_consume_token(45);
        DropTableQuery query = new DropTableQuery();
        String table = this.className();
        query.setTableName(table);
        return query;
    }

    public final Query alterTable() throws ParseException {
        this.jj_consume_token(5);
        this.jj_consume_token(45);
        AlterTableQuery query = new AlterTableQuery();
        String table = this.className();
        query.setTableName(table);
        this.jj_consume_token(6);
        this.jj_consume_token(52);
        this.jj_consume_token(113);
        ArrayList<String> columns = new ArrayList<String>();
        Token index = this.id();
        String columnName = QueryProcessor.getDefaultConfig().isParserCaseSensitivity() ? index.image : index.image.toUpperCase();
        columns.add(columnName);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 125: {
                    break;
                }
                default: {
                    this.jj_la1[39] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(125);
            index = this.id();
            columnName = QueryProcessor.getDefaultConfig().isParserCaseSensitivity() ? index.image : index.image.toUpperCase();
            columns.add(columnName);
        }
        this.jj_consume_token(114);
        this.jj_consume_token(55);
        this.jj_consume_token(41);
        String[] names = new String[columns.size()];
        query.setIndices(columns.toArray(names));
        return query;
    }

    public final Query commit() throws ParseException {
        CommitQuery query;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 50: {
                this.jj_consume_token(50);
                query = new CommitQuery(true);
                break;
            }
            case 51: {
                this.jj_consume_token(51);
                query = new CommitQuery(false);
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return query;
    }

    public final ProcedureQuery executeProcedure() throws ParseException {
        ProcedureQuery query = null;
        String negative = "";
        ArrayList parmList = new ArrayList();
        this.jj_consume_token(14);
        query = new ProcedureQuery();
        Token procedure = this.id();
        String procName = procedure.image;
        query.setProcName(procName);
        this.jj_consume_token(113);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 88: 
            case 89: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 121: {
                String parameterName;
                Token parameter;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 97: {
                        parameter = this.jj_consume_token(97);
                        parameterName = parameter.image;
                        query.addParamList(parameterName);
                        break;
                    }
                    case 93: {
                        parameter = this.jj_consume_token(93);
                        query.addParamList(new Integer(parameter.image));
                        break;
                    }
                    case 94: {
                        parameter = this.jj_consume_token(94);
                        query.addParamList(new Long(parameter.image.substring(0, parameter.image.length() - 1)));
                        break;
                    }
                    case 95: {
                        parameter = this.jj_consume_token(95);
                        query.addParamList(new Float(parameter.image));
                        negative = "";
                        break;
                    }
                    case 88: 
                    case 89: {
                        parameter = this.id();
                        query.addParamList(procedure.image);
                        break;
                    }
                    case 121: {
                        parameter = this.jj_consume_token(121);
                        query.setPrepared(true);
                        query.addParamList(null);
                        ++this.conditionIndex;
                        break;
                    }
                    default: {
                        this.jj_la1[41] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block22: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 125: {
                            break;
                        }
                        default: {
                            this.jj_la1[42] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(125);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 97: {
                            parameter = this.jj_consume_token(97);
                            parameterName = parameter.image;
                            query.addParamList(parameterName);
                            continue block22;
                        }
                        case 93: {
                            parameter = this.jj_consume_token(93);
                            query.addParamList(new Integer(parameter.image));
                            negative = "";
                            continue block22;
                        }
                        case 94: {
                            parameter = this.jj_consume_token(94);
                            query.addParamList(new Long(parameter.image.substring(0, parameter.image.length() - 1)));
                            continue block22;
                        }
                        case 95: {
                            parameter = this.jj_consume_token(95);
                            query.addParamList(new Float(parameter.image));
                            negative = "";
                            continue block22;
                        }
                        case 88: 
                        case 89: {
                            parameter = this.id();
                            query.addParamList(procedure.image);
                            continue block22;
                        }
                        case 121: {
                            parameter = this.jj_consume_token(121);
                            query.setPrepared(true);
                            query.addParamList(null);
                            ++this.conditionIndex;
                            continue block22;
                        }
                    }
                    break;
                }
                this.jj_la1[43] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[44] = this.jj_gen;
            }
        }
        this.jj_consume_token(114);
        return query;
    }

    public final void setQuantifier(SelectQuery query) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                query.setDistinct(true);
                break;
            }
            case 7: {
                this.jj_consume_token(7);
                query.setDistinct(false);
                break;
            }
            default: {
                this.jj_la1[45] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void columnList(AbstractDMLQuery query) throws ParseException {
        Token column = null;
        column = this.id();
        String columnName = QueryProcessor.getDefaultConfig().isParserCaseSensitivity() ? column.image : column.image.toUpperCase();
        query.addColumn(columnName);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 125: {
                    break;
                }
                default: {
                    this.jj_la1[46] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(125);
            column = this.id();
            columnName = QueryProcessor.getDefaultConfig().isParserCaseSensitivity() ? column.image : column.image.toUpperCase();
            query.addColumn(columnName);
        }
    }

    public final void selectColumnList(SelectQuery query) throws ParseException {
        block25: {
            Object column = null;
            Token value = null;
            SelectColumn selectC = null;
            if (this.jj_2_2(2)) {
                this.id();
                this.jj_consume_token(102);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 54: 
                case 88: 
                case 89: 
                case 97: 
                case 117: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 88: 
                        case 89: {
                            selectC = this.getSelectColumn(query);
                            break;
                        }
                        case 117: {
                            this.jj_consume_token(117);
                            selectC = new SelectColumn("*");
                            break;
                        }
                        case 54: {
                            this.jj_consume_token(54);
                            selectC = new SelectColumn("UID");
                            break;
                        }
                        case 97: {
                            value = this.jj_consume_token(97);
                            selectC = this.getSelectColumn(query);
                            selectC.setValue(value.image);
                            break;
                        }
                        default: {
                            this.jj_la1[47] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    if (selectC == null) break;
                    query.addColumn(selectC);
                    break;
                }
                default: {
                    this.jj_la1[48] = this.jj_gen;
                    if (this.jj_2_3(2)) {
                        this.function(query);
                        break;
                    }
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block21: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 125: {
                        break;
                    }
                    default: {
                        this.jj_la1[49] = this.jj_gen;
                        break block25;
                    }
                }
                this.jj_consume_token(125);
                if (this.jj_2_4(2)) {
                    this.id();
                    this.jj_consume_token(102);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 54: 
                    case 88: 
                    case 89: 
                    case 97: 
                    case 117: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 88: 
                            case 89: {
                                selectC = this.getSelectColumn(query);
                                break;
                            }
                            case 117: {
                                this.jj_consume_token(117);
                                selectC = new SelectColumn("*");
                                break;
                            }
                            case 54: {
                                this.jj_consume_token(54);
                                selectC = new SelectColumn("UID");
                                break;
                            }
                            case 97: {
                                value = this.jj_consume_token(97);
                                selectC = this.getSelectColumn(query);
                                selectC.setValue(value.image);
                                break;
                            }
                            default: {
                                this.jj_la1[50] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        if (selectC == null) continue block21;
                        query.addColumn(selectC);
                        continue block21;
                    }
                }
                this.jj_la1[51] = this.jj_gen;
                if (!this.jj_2_5(2)) break;
                this.function(query);
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        query.addAbsentCol();
    }

    public final void columnListWithValues(UpdateQuery query) throws ParseException {
        ArrayList<LiteralNode> newValues = new ArrayList<LiteralNode>();
        this.setColumnValue(query, newValues);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 125: {
                    break;
                }
                default: {
                    this.jj_la1[52] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(125);
            this.setColumnValue(query, newValues);
        }
        query.setUpdatedValues(newValues);
    }

    public final void setColumnValue(UpdateQuery updateQuery, ArrayList<LiteralNode> newValues) throws ParseException {
        String negative = "";
        UpdateColumn updateColumn = null;
        Token column = this.id();
        String columnName = QueryProcessor.getDefaultConfig().isParserCaseSensitivity() ? column.image : column.image.toUpperCase();
        updateColumn = new UpdateColumn(columnName);
        updateQuery.addUpdateColumn(updateColumn);
        this.jj_consume_token(109);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 120: {
                this.jj_consume_token(120);
                negative = "-";
                break;
            }
            default: {
                this.jj_la1[53] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 121: {
                Token newValue = this.jj_consume_token(121);
                updateQuery.setPrepared(true);
                newValues.add(new PreparedNode(null));
                ++this.conditionIndex;
                break;
            }
            case 97: {
                Token newValue = this.jj_consume_token(97);
                newValues.add(new LiteralNode(newValue.image.substring(1, newValue.image.length() - 1)));
                break;
            }
            case 93: {
                Token newValue = this.jj_consume_token(93);
                newValues.add(new LiteralNode(negative + newValue.image));
                break;
            }
            case 94: {
                Token newValue = this.jj_consume_token(94);
                newValues.add(new LiteralNode(negative + newValue.image.substring(0, newValue.image.length() - 1)));
                break;
            }
            case 95: {
                Token newValue = this.jj_consume_token(95);
                newValues.add(new LiteralNode(negative + newValue.image));
                break;
            }
            case 79: {
                this.jj_consume_token(79);
                newValues.add(new LiteralNode(Boolean.TRUE));
                break;
            }
            case 80: {
                this.jj_consume_token(80);
                newValues.add(new LiteralNode(Boolean.FALSE));
                break;
            }
            case 76: {
                this.jj_consume_token(76);
                newValues.add(new LiteralNode(new Clob("")));
                break;
            }
            case 77: {
                this.jj_consume_token(77);
                newValues.add(new LiteralNode(new Blob(new byte[0])));
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                newValues.add(new LiteralNode(null));
                break;
            }
            case 88: 
            case 89: {
                Token selfIncrementedColumn = this.id();
                columnName = QueryProcessor.getDefaultConfig().isParserCaseSensitivity() ? selfIncrementedColumn.image : selfIncrementedColumn.image.toUpperCase();
                updateColumn.setSelfIncrementedColumnName(columnName);
                updateQuery.setSelfIncrementedUpdateColumn(true);
                this.jj_consume_token(119);
                Token newValue = this.jj_consume_token(93);
                newValues.add(new LiteralNode(negative + newValue.image));
                break;
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void function(SelectQuery query) throws ParseException {
        Token token = null;
        SelectColumn selectC = null;
        Object alias = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: {
                this.jj_consume_token(34);
                selectC = new SelectColumn();
                selectC.setSum(true);
                selectC.setFunctionName("sum");
                query.setAggFunction(true);
                break;
            }
            case 37: {
                this.jj_consume_token(37);
                selectC = new SelectColumn();
                selectC.setCount(true);
                selectC.setFunctionName("count");
                query.setAggFunction(true);
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                selectC = new SelectColumn();
                selectC.setFunctionName("max");
                query.setAggFunction(true);
                break;
            }
            case 27: {
                this.jj_consume_token(27);
                selectC = new SelectColumn();
                selectC.setFunctionName("min");
                query.setAggFunction(true);
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                selectC = new SelectColumn();
                selectC.setFunctionName("avg");
                query.setAggFunction(true);
                break;
            }
            default: {
                this.jj_la1[55] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(113);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 117: {
                this.jj_consume_token(117);
                selectC.setName("*");
                query.addColumn(selectC);
                break;
            }
            case 88: 
            case 89: {
                token = this.id();
                String id = QueryProcessor.getDefaultConfig().isParserCaseSensitivity() ? token.image : token.image.toUpperCase();
                selectC.setName(id);
                query.addColumn(selectC);
                break;
            }
            default: {
                this.jj_la1[56] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(114);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 56: 
            case 88: 
            case 89: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 56: {
                        this.jj_consume_token(56);
                        break;
                    }
                    default: {
                        this.jj_la1[57] = this.jj_gen;
                    }
                }
                token = this.id();
                selectC.setAlias(token.image);
                break;
            }
            default: {
                this.jj_la1[58] = this.jj_gen;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ColumnNode createColumnNode(AbstractDMLQuery query, String columnFunc) throws ParseException {
        Object table = null;
        Object columnName = null;
        ColumnNode columnNode = null;
        Token function = null;
        if (this.jj_2_6(2)) {
            function = this.jj_consume_token(88);
            this.jj_consume_token(113);
            List params = this.createFunctionParams();
            this.jj_consume_token(114);
            ArrayList<Object> args = new ArrayList<Object>();
            int pos = 0;
            int columnIndex = 0;
            for (Object p : params) {
                if (p instanceof ColumnNode) {
                    if (columnNode != null) throw new ParseException("More then one column in function call " + function.image + " call " + columnNode + " " + p);
                    args.add(null);
                    columnNode = (ColumnNode)p;
                    columnIndex = pos;
                } else {
                    args.add(p);
                }
                ++pos;
            }
            if (columnNode == null) {
                throw new ParseException("Missing column in function call " + function.image);
            }
            columnNode.setFunctionCallDescription(new FunctionCallDescription(function.image, columnIndex, args));
            return columnNode;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 88: 
            case 89: {
                Token t = this.id();
                String id = QueryProcessor.getDefaultConfig().isParserCaseSensitivity() ? t.image : t.image.toUpperCase();
                return new ColumnNode(id);
            }
        }
        this.jj_la1[59] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final List createFunctionParams() throws ParseException {
        ArrayList<Object> params = new ArrayList<Object>();
        Object param = this.param();
        params.add(param);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 125: {
                    break;
                }
                default: {
                    this.jj_la1[60] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(125);
            param = this.param();
            params.add(param);
        }
        return params;
    }

    public final Object param() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 97: {
                Token parameter = this.jj_consume_token(97);
                return new String(parameter.image.substring(1, parameter.image.length() - 1));
            }
            case 93: {
                Token parameter = this.jj_consume_token(93);
                return new Integer(parameter.image);
            }
            case 94: {
                Token parameter = this.jj_consume_token(94);
                return new Long(parameter.image.substring(0, parameter.image.length() - 1));
            }
            case 95: {
                Token parameter = this.jj_consume_token(95);
                return new Float(parameter.image);
            }
            case 88: 
            case 89: {
                Token parameter = this.id();
                String id = QueryProcessor.getDefaultConfig().isParserCaseSensitivity() ? parameter.image : parameter.image.toUpperCase();
                return new ColumnNode(id);
            }
        }
        this.jj_la1[61] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void selectTableList(SelectQuery query) throws ParseException {
        String table = null;
        Token alias = null;
        table = this.className();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 88: 
            case 89: {
                alias = this.id();
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
            }
        }
        query.addTableWithAlias(table, alias == null ? null : alias.image);
        alias = null;
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 125: {
                    break;
                }
                default: {
                    this.jj_la1[63] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(125);
            table = this.className();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 88: 
                case 89: {
                    alias = this.id();
                    break;
                }
                default: {
                    this.jj_la1[64] = this.jj_gen;
                }
            }
            query.addTableWithAlias(table, alias == null ? null : alias.image);
            alias = null;
        }
    }

    public final void tableNameWithOptionalAlias(AbstractDMLQuery query) throws ParseException {
        String tableName = null;
        Token tableAlias = null;
        tableName = this.className();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 88: 
            case 89: {
                tableAlias = this.id();
                break;
            }
            default: {
                this.jj_la1[65] = this.jj_gen;
            }
        }
        query.addTableWithAlias(tableName, tableAlias == null ? null : tableAlias.image);
    }

    public final void tableName(AbstractDMLQuery query) throws ParseException {
        String table = null;
        table = this.className();
        query.setTableName(table);
    }

    public final void insertValuesList(InsertQuery insertQuery) throws ParseException {
        Token t = null;
        String negative = "";
        ArrayList<LiteralNode> list = new ArrayList<LiteralNode>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 121: {
                t = this.jj_consume_token(121);
                insertQuery.setPrepared(true);
                list.add(new PreparedNode(null));
                break;
            }
            case 79: {
                this.jj_consume_token(79);
                list.add(new LiteralNode(Boolean.TRUE));
                break;
            }
            case 80: {
                this.jj_consume_token(80);
                list.add(new LiteralNode(Boolean.FALSE));
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                list.add(new LiteralNode(null));
                break;
            }
            case 76: {
                this.jj_consume_token(76);
                list.add(new LiteralNode(new Clob("")));
                break;
            }
            case 77: {
                this.jj_consume_token(77);
                list.add(new LiteralNode(new Blob(new byte[0])));
                break;
            }
            case 97: {
                t = this.jj_consume_token(97);
                list.add(new LiteralNode(new String(t.image.substring(1, t.image.length() - 1))));
                break;
            }
            default: {
                this.jj_la1[69] = this.jj_gen;
                if (this.jj_2_7(2)) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 120: {
                            this.jj_consume_token(120);
                            negative = "-";
                            break;
                        }
                        default: {
                            this.jj_la1[66] = this.jj_gen;
                        }
                    }
                    t = this.jj_consume_token(93);
                    list.add(new LiteralNode(negative + t.image));
                    break;
                }
                if (this.jj_2_8(2)) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 120: {
                            this.jj_consume_token(120);
                            negative = "-";
                            break;
                        }
                        default: {
                            this.jj_la1[67] = this.jj_gen;
                        }
                    }
                    t = this.jj_consume_token(94);
                    list.add(new LiteralNode(negative + t.image.substring(0, t.image.length() - 1)));
                    break;
                }
                if (this.jj_2_9(2)) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 120: {
                            this.jj_consume_token(120);
                            negative = "-";
                            break;
                        }
                        default: {
                            this.jj_la1[68] = this.jj_gen;
                        }
                    }
                    t = this.jj_consume_token(95);
                    list.add(new LiteralNode(negative + t.image));
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        negative = "";
        block39: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 125: {
                    break;
                }
                default: {
                    this.jj_la1[70] = this.jj_gen;
                    break block39;
                }
            }
            this.jj_consume_token(125);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 121: {
                    t = this.jj_consume_token(121);
                    insertQuery.setPrepared(true);
                    list.add(new PreparedNode(null));
                    break;
                }
                case 79: {
                    this.jj_consume_token(79);
                    list.add(new LiteralNode(Boolean.TRUE));
                    break;
                }
                case 80: {
                    this.jj_consume_token(80);
                    list.add(new LiteralNode(Boolean.FALSE));
                    break;
                }
                case 29: {
                    this.jj_consume_token(29);
                    list.add(new LiteralNode(null));
                    break;
                }
                case 76: {
                    this.jj_consume_token(76);
                    list.add(new LiteralNode(new Clob("")));
                    break;
                }
                case 77: {
                    this.jj_consume_token(77);
                    list.add(new LiteralNode(new Blob(new byte[0])));
                    break;
                }
                case 97: {
                    t = this.jj_consume_token(97);
                    list.add(new LiteralNode(new String(t.image.substring(1, t.image.length() - 1))));
                    break;
                }
                default: {
                    this.jj_la1[74] = this.jj_gen;
                    if (this.jj_2_10(2)) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 120: {
                                this.jj_consume_token(120);
                                negative = "-";
                                break;
                            }
                            default: {
                                this.jj_la1[71] = this.jj_gen;
                            }
                        }
                        t = this.jj_consume_token(93);
                        list.add(new LiteralNode(negative + t.image));
                        break;
                    }
                    if (this.jj_2_11(2)) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 120: {
                                this.jj_consume_token(120);
                                negative = "-";
                                break;
                            }
                            default: {
                                this.jj_la1[72] = this.jj_gen;
                            }
                        }
                        t = this.jj_consume_token(94);
                        list.add(new LiteralNode(negative + t.image.substring(0, t.image.length() - 1)));
                        break;
                    }
                    if (this.jj_2_12(2)) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 120: {
                                this.jj_consume_token(120);
                                negative = "-";
                                break;
                            }
                            default: {
                                this.jj_la1[73] = this.jj_gen;
                            }
                        }
                        t = this.jj_consume_token(95);
                        list.add(new LiteralNode(negative + t.image));
                        break;
                    }
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            negative = "";
        }
        insertQuery.setValues(list);
    }

    public final void groupBy(SelectQuery query) throws ParseException {
        SelectColumn groupColumn = null;
        ArrayList<SelectColumn> list = new ArrayList<SelectColumn>();
        this.jj_consume_token(21);
        this.jj_consume_token(12);
        groupColumn = this.getSelectColumn(query);
        list.add(groupColumn);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 125: {
                    break;
                }
                default: {
                    this.jj_la1[75] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(125);
            groupColumn = this.getSelectColumn(query);
            list.add(groupColumn);
        }
        query.setGroupColumn(list);
    }

    public final void orderBy(SelectQuery query) throws ParseException {
        Object column = null;
        OrderColumn orderColumn = null;
        ArrayList<OrderColumn> list = new ArrayList<OrderColumn>();
        this.jj_consume_token(31);
        this.jj_consume_token(12);
        orderColumn = this.createOrderColumn(query);
        list.add(orderColumn);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: 
            case 17: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 9: {
                        this.jj_consume_token(9);
                        orderColumn.setDesc(false);
                        break block0;
                    }
                    case 17: {
                        this.jj_consume_token(17);
                        orderColumn.setDesc(true);
                        break block0;
                    }
                }
                this.jj_la1[76] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[77] = this.jj_gen;
            }
        }
        block7 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 57: 
            case 58: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 57: {
                        this.jj_consume_token(57);
                        orderColumn.setNullsLast(true);
                        break block7;
                    }
                    case 58: {
                        this.jj_consume_token(58);
                        orderColumn.setNullsLast(false);
                        break block7;
                    }
                }
                this.jj_la1[78] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[79] = this.jj_gen;
            }
        }
        block31: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 125: {
                    break;
                }
                default: {
                    this.jj_la1[80] = this.jj_gen;
                    break block31;
                }
            }
            this.jj_consume_token(125);
            orderColumn = this.createOrderColumn(query);
            list.add(orderColumn);
            block17 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 9: 
                case 17: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 9: {
                            this.jj_consume_token(9);
                            orderColumn.setDesc(false);
                            break block17;
                        }
                        case 17: {
                            this.jj_consume_token(17);
                            orderColumn.setDesc(true);
                            break block17;
                        }
                    }
                    this.jj_la1[81] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[82] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 57: 
                case 58: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 57: {
                            this.jj_consume_token(57);
                            orderColumn.setNullsLast(true);
                            continue block31;
                        }
                        case 58: {
                            this.jj_consume_token(58);
                            orderColumn.setNullsLast(false);
                            continue block31;
                        }
                    }
                    this.jj_la1[83] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jj_la1[84] = this.jj_gen;
        }
        query.setOrderColumns(list);
    }

    public final OrderColumn createOrderColumn(AbstractDMLQuery query) throws ParseException {
        String id = null;
        Object col = null;
        Token t = null;
        String alias = null;
        t = this.id();
        id = QueryProcessor.getDefaultConfig().isParserCaseSensitivity() ? t.image : t.image.toUpperCase();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 56: 
            case 88: 
            case 89: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 56: {
                        this.jj_consume_token(56);
                        break;
                    }
                    default: {
                        this.jj_la1[85] = this.jj_gen;
                    }
                }
                t = this.id();
                alias = t.image;
                break;
            }
            default: {
                this.jj_la1[86] = this.jj_gen;
            }
        }
        return new OrderColumn(id, alias);
    }

    public final SelectColumn getSelectColumn(AbstractDMLQuery query) throws ParseException {
        String id = null;
        SelectColumn col = null;
        Token t = null;
        String alias = null;
        t = this.id();
        id = QueryProcessor.getDefaultConfig().isParserCaseSensitivity() ? t.image : t.image.toUpperCase();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 56: 
            case 88: 
            case 89: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 56: {
                        this.jj_consume_token(56);
                        break;
                    }
                    default: {
                        this.jj_la1[87] = this.jj_gen;
                    }
                }
                t = this.id();
                alias = t.image;
                break;
            }
            default: {
                this.jj_la1[88] = this.jj_gen;
            }
        }
        col = new SelectColumn(id, alias);
        return col;
    }

    public final ExpNode SqlExpression(AbstractDMLQuery query) throws ParseException {
        ExpNode exp1 = this.SqlAndExpression(query);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: {
                    break;
                }
                default: {
                    this.jj_la1[89] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(30);
            ExpNode exp2 = this.SqlAndExpression(query);
            exp1 = new OrNode(exp1, exp2);
        }
        return exp1;
    }

    public final ExpNode SqlAndExpression(AbstractDMLQuery query) throws ParseException {
        ExpNode exp1 = this.SqlSimpleExpression(query);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[90] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(8);
            ExpNode exp2 = this.SqlSimpleExpression(query);
            exp1 = new AndNode(exp1, exp2);
        }
        return exp1;
    }

    public final ExpNode SqlSimpleExpression(AbstractDMLQuery query) throws ParseException {
        ExpNode exp;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: 
            case 88: 
            case 89: {
                exp = this.condition(query);
                break;
            }
            case 113: {
                this.jj_consume_token(113);
                exp = this.SqlExpression(query);
                this.jj_consume_token(114);
                break;
            }
            default: {
                this.jj_la1[91] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return exp;
    }

    public final ExpNode SqlContainsItemExpression(AbstractDMLQuery query) throws ParseException {
        ExpNode exp1 = this.SqlContainsItemSimpleExpression(query);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[92] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(8);
            ExpNode exp2 = this.SqlContainsItemSimpleExpression(query);
            exp1 = new AndNode(exp1, exp2);
        }
        return exp1;
    }

    public final ExpNode SqlContainsItemSimpleExpression(AbstractDMLQuery query) throws ParseException {
        ExpNode exp;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: 
            case 88: 
            case 89: {
                exp = this.containtsItemSimpleCondition(query);
                break;
            }
            case 113: {
                this.jj_consume_token(113);
                exp = this.SqlContainsItemSimpleExpression(query);
                this.jj_consume_token(114);
                break;
            }
            default: {
                this.jj_la1[93] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return exp;
    }

    public final ExpNode containtsItemSimpleCondition(AbstractDMLQuery query) throws ParseException {
        Object table1 = null;
        Object table2 = null;
        Object addup = null;
        Object operator = null;
        ColumnNode columnNode1 = null;
        Object columnNode2 = null;
        Object valueNode = null;
        String negative = "";
        ExpNode expNode = null;
        boolean templateMatchCode = false;
        StringBuilder columnPath = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: {
                this.jj_consume_token(40);
                throw new ParseException("ROWNUM not supported inside contains");
            }
            case 88: 
            case 89: {
                columnNode1 = this.createColumnNode(query, null);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 124: {
                        this.jj_consume_token(124);
                        query.setContainsQuery(true);
                        columnPath = new StringBuilder(columnNode1.toString());
                        columnPath.append("[*]");
                        block17: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 124: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[94] = this.jj_gen;
                                    break block17;
                                }
                            }
                            this.jj_consume_token(124);
                            columnPath.append("[*]");
                        }
                        block18: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 102: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[95] = this.jj_gen;
                                    break block18;
                                }
                            }
                            this.jj_consume_token(102);
                            Token t = this.id();
                            String columnNameSuffix = QueryProcessor.getDefaultConfig().isParserCaseSensitivity() ? t.image : t.image.toUpperCase();
                            columnPath.append(".");
                            columnPath.append(columnNameSuffix);
                            while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 124: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[96] = this.jj_gen;
                                        continue block18;
                                    }
                                }
                                this.jj_consume_token(124);
                                columnPath.append("[*]");
                            }
                            break;
                        }
                        expNode = this.containtsItemSimpleConditionImpl(query, columnPath, columnNode1, true);
                        break;
                    }
                    case 11: 
                    case 22: 
                    case 24: 
                    case 28: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 113: {
                        expNode = this.containtsItemSimpleConditionImpl(query, columnPath, columnNode1, false);
                        break;
                    }
                    default: {
                        this.jj_la1[97] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return expNode;
            }
        }
        this.jj_la1[98] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ExpNode containtsItemSimpleConditionImpl(AbstractDMLQuery query, StringBuilder columnPath, ColumnNode columnNode1, boolean insideInternalContains) throws ParseException {
        ExpNode expNode = null;
        if (this.jj_2_13(2)) {
            expNode = this.containsInItemNode(query, columnNode1, columnPath);
        } else if (this.jj_2_14(2)) {
            expNode = this.containsBetweenItemNode(query, columnNode1, columnPath);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 24: 
                case 28: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 113: {
                    expNode = this.containsSimpleItemNode(query, columnNode1, columnPath, insideInternalContains);
                    break;
                }
                default: {
                    this.jj_la1[99] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return expNode;
    }

    public final ExpNode SqlInClause(AbstractDMLQuery query) throws ParseException {
        boolean notIn = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                this.jj_consume_token(28);
                notIn = true;
                break;
            }
            default: {
                this.jj_la1[100] = this.jj_gen;
            }
        }
        this.jj_consume_token(22);
        this.jj_consume_token(113);
        ExpNode exp = this.inExprOrList(query, notIn);
        this.jj_consume_token(114);
        return exp;
    }

    public final String className() throws ParseException {
        StringBuffer buffer = new StringBuffer();
        Token name = null;
        name = this.id();
        buffer.append(name.image);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 102: 
                case 126: {
                    break;
                }
                default: {
                    this.jj_la1[101] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 102: {
                    this.jj_consume_token(102);
                    buffer.append(".");
                    break;
                }
                case 126: {
                    this.jj_consume_token(126);
                    buffer.append("$");
                    break;
                }
                default: {
                    this.jj_la1[102] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            name = this.id();
            buffer.append(name.image);
        }
        String classname = QueryProcessor.getDefaultConfig().isParserCaseSensitivity() ? buffer.toString() : buffer.toString().toUpperCase();
        return classname;
    }

    public final String sqlType() throws ParseException {
        Token param2 = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 70: 
                case 71: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 70: {
                            this.jj_consume_token(70);
                            break;
                        }
                        case 71: {
                            this.jj_consume_token(71);
                            break;
                        }
                        default: {
                            this.jj_la1[103] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 113: {
                            this.jj_consume_token(113);
                            this.jj_consume_token(93);
                            this.jj_consume_token(114);
                            break;
                        }
                        default: {
                            this.jj_la1[104] = this.jj_gen;
                        }
                    }
                    return String.class.getName();
                }
                case 72: {
                    this.jj_consume_token(72);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 113: {
                            this.jj_consume_token(113);
                            this.jj_consume_token(93);
                            this.jj_consume_token(114);
                            break;
                        }
                        default: {
                            this.jj_la1[105] = this.jj_gen;
                        }
                    }
                    return String.class.getName();
                }
                case 59: {
                    this.jj_consume_token(59);
                    return Date.class.getName();
                }
                case 60: {
                    this.jj_consume_token(60);
                    return Timestamp.class.getName();
                }
                case 65: {
                    this.jj_consume_token(65);
                    this.jj_consume_token(113);
                    Token param = this.jj_consume_token(93);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 125: {
                            this.jj_consume_token(125);
                            param2 = this.jj_consume_token(93);
                            break;
                        }
                        default: {
                            this.jj_la1[106] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(114);
                    if (param2 != null && !param2.image.equals("0")) {
                        return Double.class.getName();
                    }
                    int p = Integer.parseInt(param.image);
                    if (p < 10) {
                        return Integer.class.getName();
                    }
                    return Long.class.getName();
                }
                case 61: {
                    this.jj_consume_token(61);
                    return Time.class.getName();
                }
                case 62: {
                    this.jj_consume_token(62);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 113: {
                            this.jj_consume_token(113);
                            this.jj_consume_token(93);
                            this.jj_consume_token(114);
                            break;
                        }
                        default: {
                            this.jj_la1[107] = this.jj_gen;
                        }
                    }
                    return Float.class.getName();
                }
                case 63: {
                    this.jj_consume_token(63);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 113: {
                            this.jj_consume_token(113);
                            this.jj_consume_token(93);
                            this.jj_consume_token(114);
                            break;
                        }
                        default: {
                            this.jj_la1[108] = this.jj_gen;
                        }
                    }
                    return Float.class.getName();
                }
                case 64: {
                    this.jj_consume_token(64);
                    return Double.class.getName();
                }
                case 68: {
                    this.jj_consume_token(68);
                    return Boolean.class.getName();
                }
                case 69: 
                case 81: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 69: {
                            this.jj_consume_token(69);
                            break;
                        }
                        case 81: {
                            this.jj_consume_token(81);
                            break;
                        }
                        default: {
                            this.jj_la1[109] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    return Integer.class.getName();
                }
                case 73: {
                    this.jj_consume_token(73);
                    return Long.class.getName();
                }
                case 75: {
                    this.jj_consume_token(75);
                    return Blob.class.getName();
                }
                case 74: {
                    this.jj_consume_token(74);
                    return Clob.class.getName();
                }
                case 82: {
                    this.jj_consume_token(82);
                    return Timestamp.class.getName();
                }
                case 66: {
                    this.jj_consume_token(66);
                    return BigDecimal.class.getName();
                }
                case 67: {
                    this.jj_consume_token(67);
                    return BigDecimal.class.getName();
                }
                case 83: {
                    this.jj_consume_token(83);
                    return String.class.getName();
                }
                case 84: {
                    this.jj_consume_token(84);
                    return Byte.class.getName();
                }
                case 85: {
                    this.jj_consume_token(85);
                    return Short.class.getName();
                }
                case 86: {
                    this.jj_consume_token(86);
                    return Long.class.getName();
                }
                case 87: {
                    this.jj_consume_token(87);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 113: {
                            this.jj_consume_token(113);
                            this.jj_consume_token(93);
                            this.jj_consume_token(114);
                            break;
                        }
                        default: {
                            this.jj_la1[110] = this.jj_gen;
                        }
                    }
                    return String.class.getName();
                }
            }
            this.jj_la1[111] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        catch (ParseException p) {
            throw new ParseException("unknown sql data type");
        }
    }

    public final Token id() throws ParseException {
        Token id = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 88: {
                id = this.jj_consume_token(88);
                return id;
            }
            case 89: {
                String idStr;
                id = this.jj_consume_token(89);
                id.image = idStr = id.image.substring(1, id.image.length() - 1);
                return id;
            }
        }
        this.jj_la1[112] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ExpNode condition(AbstractDMLQuery query) throws ParseException {
        Object table1 = null;
        Object table2 = null;
        Object addup = null;
        Object operator = null;
        ColumnNode columnNode1 = null;
        Object columnNode2 = null;
        Object valueNode = null;
        String negative = "";
        ExpNode expNode = null;
        Object innerQuery = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: {
                RowNumNode rowNum;
                this.jj_consume_token(40);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 109: {
                        this.jj_consume_token(109);
                        Token t = this.jj_consume_token(93);
                        int temp = Integer.parseInt(t.image);
                        rowNum = new RowNumNode(temp, temp);
                        break;
                    }
                    case 105: {
                        this.jj_consume_token(105);
                        Token t = this.jj_consume_token(93);
                        int temp = Integer.parseInt(t.image);
                        rowNum = new RowNumNode(1, temp - 1);
                        break;
                    }
                    case 106: {
                        this.jj_consume_token(106);
                        Token t = this.jj_consume_token(93);
                        int temp = Integer.parseInt(t.image);
                        rowNum = new RowNumNode(1, temp);
                        break;
                    }
                    case 107: {
                        this.jj_consume_token(107);
                        Token t = this.jj_consume_token(93);
                        int temp = Integer.parseInt(t.image);
                        rowNum = new RowNumNode(temp + 1, Integer.MAX_VALUE);
                        break;
                    }
                    case 108: {
                        this.jj_consume_token(108);
                        Token t = this.jj_consume_token(93);
                        int temp = Integer.parseInt(t.image);
                        rowNum = new RowNumNode(temp, Integer.MAX_VALUE);
                        break;
                    }
                    case 113: {
                        this.jj_consume_token(113);
                        Token startIndex = this.jj_consume_token(93);
                        this.jj_consume_token(125);
                        Token endIndex = this.jj_consume_token(93);
                        this.jj_consume_token(114);
                        rowNum = new RowNumNode(Integer.parseInt(startIndex.image), Integer.parseInt(endIndex.image));
                        break;
                    }
                    default: {
                        this.jj_la1[113] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (query.getRownum() != null) {
                    throw new ParseException("Can't define more than a single condition for rownum. To specify range use rownum(from,to)");
                }
                query.setRownum(rowNum);
                return null;
            }
            case 88: 
            case 89: {
                columnNode1 = this.createColumnNode(query, null);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 124: {
                        expNode = this.containsNode(query, columnNode1);
                        break;
                    }
                    case 23: {
                        expNode = this.isNullNode(query, columnNode1);
                        break;
                    }
                    case 11: {
                        expNode = this.betweenNode(query, columnNode1);
                        break;
                    }
                    case 22: 
                    case 24: 
                    case 25: 
                    case 28: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: {
                        expNode = this.conditionNode(query, columnNode1);
                        break;
                    }
                    case 92: {
                        expNode = this.relationNode(query, columnNode1);
                        break;
                    }
                    default: {
                        this.jj_la1[114] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return expNode;
            }
        }
        this.jj_la1[115] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ExpNode relationNode(AbstractDMLQuery query, ColumnNode columnNode) throws ParseException {
        PreparedNode valueNode = null;
        RelationNode res = null;
        Token rel = null;
        rel = this.jj_consume_token(92);
        Token t = this.jj_consume_token(121);
        query.setPrepared(true);
        valueNode = new PreparedNode(null, ++this.conditionIndex);
        res = new RelationNode(columnNode, rel.image, valueNode);
        return res;
    }

    /*
     * Unable to fully structure code
     */
    public final ExpNode conditionNode(AbstractDMLQuery query, ColumnNode columnNode1) throws ParseException {
        block48: {
            block47: {
                addup = null;
                operator = null;
                valueNode = null;
                expNode = null;
                negative = "";
                innerQuery = null;
                columnNode2 = null;
                if (!this.jj_2_18(2)) break block47;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 109: {
                        this.jj_consume_token(109);
                        expNode = new EqualNode();
                        break;
                    }
                    case 105: {
                        this.jj_consume_token(105);
                        expNode = new LTNode();
                        break;
                    }
                    case 106: {
                        this.jj_consume_token(106);
                        expNode = new LTENode();
                        break;
                    }
                    case 107: {
                        this.jj_consume_token(107);
                        expNode = new GTNode();
                        break;
                    }
                    case 108: {
                        this.jj_consume_token(108);
                        expNode = new GTENode();
                        break;
                    }
                    case 110: {
                        this.jj_consume_token(110);
                        expNode = new NotEqualNode();
                        break;
                    }
                    case 111: {
                        this.jj_consume_token(111);
                        expNode = new NotEqualNode();
                        break;
                    }
                    case 24: {
                        this.jj_consume_token(24);
                        expNode = new LikeNode();
                        break;
                    }
                    case 28: {
                        this.jj_consume_token(28);
                        this.jj_consume_token(24);
                        expNode = new NotLikeNode();
                        break;
                    }
                    case 25: {
                        this.jj_consume_token(25);
                        expNode = new RLikeNode();
                        break;
                    }
                    default: {
                        this.jj_la1[116] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 121: {
                        t = this.jj_consume_token(121);
                        query.setPrepared(true);
                        valueNode = new PreparedNode(null, ++this.conditionIndex);
                        break block48;
                    }
                    case 97: {
                        t = this.jj_consume_token(97);
                        valueNode = new LiteralNode(new String(t.image.substring(1, t.image.length() - 1)));
                        break block48;
                    }
                    case 79: {
                        t = this.jj_consume_token(79);
                        valueNode = new LiteralNode(Boolean.TRUE);
                        break block48;
                    }
                    case 80: {
                        t = this.jj_consume_token(80);
                        valueNode = new LiteralNode(Boolean.FALSE);
                        break block48;
                    }
                    default: {
                        this.jj_la1[122] = this.jj_gen;
                        if (!this.jj_2_15(2)) ** GOTO lbl99
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 120: {
                                this.jj_consume_token(120);
                                negative = "-";
                                break;
                            }
                            default: {
                                this.jj_la1[117] = this.jj_gen;
                            }
                        }
                        t = this.jj_consume_token(93);
                        valueNode = new LiteralNode(negative + t.image);
                        break block48;
lbl99:
                        // 1 sources

                        if (!this.jj_2_16(2)) ** GOTO lbl111
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 120: {
                                this.jj_consume_token(120);
                                negative = "-";
                                break;
                            }
                            default: {
                                this.jj_la1[118] = this.jj_gen;
                            }
                        }
                        t = this.jj_consume_token(94);
                        valueNode = new LiteralNode(negative + t.image.substring(0, t.image.length() - 1));
                        break block48;
lbl111:
                        // 1 sources

                        if (!this.jj_2_17(2)) ** GOTO lbl123
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 120: {
                                this.jj_consume_token(120);
                                negative = "-";
                                break;
                            }
                            default: {
                                this.jj_la1[119] = this.jj_gen;
                            }
                        }
                        t = this.jj_consume_token(95);
                        valueNode = new LiteralNode(negative + t.image);
                        break block48;
lbl123:
                        // 1 sources

                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 98: {
                                t = this.jj_consume_token(98);
                                valueNode = new LiteralNode(t.image);
                                break block48;
                            }
                            case 35: {
                                this.jj_consume_token(35);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 119: 
                                    case 120: {
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 119: {
                                                operator = this.jj_consume_token(119);
                                                break;
                                            }
                                            case 120: {
                                                operator = this.jj_consume_token(120);
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[120] = this.jj_gen;
                                                this.jj_consume_token(-1);
                                                throw new ParseException();
                                            }
                                        }
                                        addup = this.jj_consume_token(93);
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[121] = this.jj_gen;
                                    }
                                }
                                cal = Calendar.getInstance();
                                if (addup != null) {
                                    if (operator.image.equals("+")) {
                                        cal.add(5, Integer.parseInt(addup.image));
                                    } else if (operator.image.equals("-")) {
                                        cal.add(5, -Integer.parseInt(addup.image));
                                    }
                                }
                                valueNode = new LiteralNode(new Timestamp(cal.getTime().getTime()));
                                break block48;
                            }
                            case 113: {
                                this.jj_consume_token(113);
                                innerQuery = this.selectSql();
                                valueNode = new InnerQueryNode((SelectQuery)innerQuery);
                                query.setContainsSubQueries(true);
                                this.jj_consume_token(114);
                                break block48;
                            }
                            case 88: 
                            case 89: {
                                columnNode2 = this.createColumnNode(query, null);
                                break block48;
                            }
                            default: {
                                this.jj_la1[123] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                    }
                }
            }
            if (this.jj_2_19(2)) {
                expNode = this.SqlInClause(query);
                expNode.setLeftChild(columnNode1);
                return expNode;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        expNode.setLeftChild(columnNode1);
        if (columnNode2 == null) {
            expNode.setRightChild(valueNode);
        } else {
            expNode.setRightChild(columnNode2);
        }
        return expNode;
    }

    public final ExpNode isNullNode(AbstractDMLQuery query, ColumnNode columnNode1) throws ParseException {
        IsNullNode expNode = null;
        if (this.jj_2_20(2)) {
            this.jj_consume_token(23);
            this.jj_consume_token(29);
            expNode = new IsNullNode(columnNode1, new LiteralNode(null));
        } else if (this.jj_2_21(2)) {
            this.jj_consume_token(23);
            this.jj_consume_token(28);
            this.jj_consume_token(29);
            expNode = new IsNullNode(columnNode1, new LiteralNode(null));
            expNode.setNot(true);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return expNode;
    }

    public final AndNode betweenNode(AbstractDMLQuery query, ColumnNode columnNode1) throws ParseException {
        ValueNode valueNode = null;
        Object expNode = null;
        this.jj_consume_token(11);
        GTENode gteNode = new GTENode(columnNode1, null);
        LTENode lteNode = new LTENode(columnNode1, null);
        valueNode = this.getBetweenValueNode(query);
        gteNode.setRightChild(valueNode);
        this.jj_consume_token(8);
        valueNode = this.getBetweenValueNode(query);
        lteNode.setRightChild(valueNode);
        return new AndNode(gteNode, lteNode);
    }

    public final ExpNode containsSimpleItemNode(AbstractDMLQuery query, ColumnNode columnNode1, StringBuilder columnPath, boolean insideInternalContains) throws ParseException {
        Object table1 = null;
        Object table2 = null;
        Object addup = null;
        Object operator = null;
        Object columnNode2 = null;
        LiteralNode valueNode = null;
        String negative = "";
        Object expNode = null;
        short templateMatchCode = 0;
        Object containsItems = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 109: {
                this.jj_consume_token(109);
                templateMatchCode = 0;
                break;
            }
            case 105: {
                this.jj_consume_token(105);
                templateMatchCode = 4;
                break;
            }
            case 106: {
                this.jj_consume_token(106);
                templateMatchCode = 5;
                break;
            }
            case 107: {
                this.jj_consume_token(107);
                templateMatchCode = 2;
                break;
            }
            case 108: {
                this.jj_consume_token(108);
                templateMatchCode = 3;
                break;
            }
            case 110: {
                this.jj_consume_token(110);
                templateMatchCode = 1;
                break;
            }
            case 111: {
                this.jj_consume_token(111);
                templateMatchCode = 1;
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                templateMatchCode = 8;
                break;
            }
            case 28: {
                this.jj_consume_token(28);
                this.jj_consume_token(24);
                templateMatchCode = 10;
                break;
            }
            case 113: {
                this.jj_consume_token(113);
                columnNode1.setName(columnPath.toString());
                valueNode = new ContainsItemsRootNode(this.SqlContainsItemExpression(query), columnPath.toString(), columnNode1);
                this.jj_consume_token(114);
                if (insideInternalContains) {
                    return new ContainsItemNode(columnNode1, valueNode, templateMatchCode);
                }
                throw new ParseException("invalid token inside contains conditions");
            }
            default: {
                this.jj_la1[124] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block12 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 121: {
                Token t = this.jj_consume_token(121);
                query.setPrepared(true);
                valueNode = new PreparedNode(null, ++this.conditionIndex);
                break;
            }
            case 97: {
                Token t = this.jj_consume_token(97);
                valueNode = new LiteralNode(new String(t.image.substring(1, t.image.length() - 1)));
                break;
            }
            case 79: {
                Token t = this.jj_consume_token(79);
                valueNode = new LiteralNode(Boolean.TRUE);
                break;
            }
            case 80: {
                Token t = this.jj_consume_token(80);
                valueNode = new LiteralNode(Boolean.FALSE);
                break;
            }
            default: {
                this.jj_la1[128] = this.jj_gen;
                if (this.jj_2_22(2)) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 120: {
                            this.jj_consume_token(120);
                            negative = "-";
                            break;
                        }
                        default: {
                            this.jj_la1[125] = this.jj_gen;
                        }
                    }
                    Token t = this.jj_consume_token(93);
                    valueNode = new LiteralNode(new Integer(negative + t.image));
                    break;
                }
                if (this.jj_2_23(2)) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 120: {
                            this.jj_consume_token(120);
                            negative = "-";
                            break;
                        }
                        default: {
                            this.jj_la1[126] = this.jj_gen;
                        }
                    }
                    Token t = this.jj_consume_token(94);
                    valueNode = new LiteralNode(negative + t.image.substring(0, t.image.length() - 1));
                    break;
                }
                if (this.jj_2_24(2)) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 120: {
                            this.jj_consume_token(120);
                            negative = "-";
                            break;
                        }
                        default: {
                            this.jj_la1[127] = this.jj_gen;
                        }
                    }
                    Token t = this.jj_consume_token(95);
                    valueNode = new LiteralNode(negative + t.image);
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 98: {
                        Token t = this.jj_consume_token(98);
                        valueNode = new LiteralNode(t.image);
                        break block12;
                    }
                }
                this.jj_la1[129] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (columnPath != null) {
            columnNode1.setName(columnPath.toString());
        }
        return new ContainsItemNode(columnNode1, valueNode, templateMatchCode);
    }

    public final AndNode containsBetweenItemNode(AbstractDMLQuery query, ColumnNode columnNode1, StringBuilder columnPath) throws ParseException {
        this.jj_consume_token(11);
        ValueNode gteValue = this.getBetweenValueNode(query);
        this.jj_consume_token(8);
        ValueNode lteValue = this.getBetweenValueNode(query);
        if (columnPath != null) {
            columnNode1.setName(columnPath.toString());
        }
        ContainsItemNode gteNode = new ContainsItemNode(columnNode1, gteValue, 3);
        ContainsItemNode lteNode = new ContainsItemNode(columnNode1, lteValue, 5);
        return new AndNode(gteNode, lteNode);
    }

    public final ExpNode containsInItemNode(AbstractDMLQuery query, ColumnNode columnNode1, StringBuilder columnPath) throws ParseException {
        boolean notIn = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                this.jj_consume_token(28);
                notIn = true;
                break;
            }
            default: {
                this.jj_la1[130] = this.jj_gen;
            }
        }
        this.jj_consume_token(22);
        this.jj_consume_token(113);
        ExpNode inNode = this.inExprOrList(query, notIn);
        this.jj_consume_token(114);
        if (columnPath != null) {
            columnNode1.setName(columnPath.toString());
        }
        inNode.setLeftChild(columnNode1);
        return new ContainsItemNode(columnNode1, inNode, 11);
    }

    public final AndNode containsBetweenNode(AbstractDMLQuery query, ColumnNode columnNode1, String column) throws ParseException {
        this.jj_consume_token(11);
        ValueNode gteValue = this.getBetweenValueNode(query);
        this.jj_consume_token(8);
        ValueNode lteValue = this.getBetweenValueNode(query);
        columnNode1.setName(column);
        ContainsNode gteNode = new ContainsNode(columnNode1, gteValue, 3);
        ContainsNode lteNode = new ContainsNode(columnNode1, lteValue, 5);
        return new AndNode(gteNode, lteNode);
    }

    public final ExpNode containsSimpleNode(AbstractDMLQuery query, ColumnNode columnNode1, String column) throws ParseException {
        short templateMatchCode;
        ValueNode valueNode = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 109: {
                this.jj_consume_token(109);
                templateMatchCode = 0;
                break;
            }
            case 105: {
                this.jj_consume_token(105);
                templateMatchCode = 4;
                break;
            }
            case 106: {
                this.jj_consume_token(106);
                templateMatchCode = 5;
                break;
            }
            case 107: {
                this.jj_consume_token(107);
                templateMatchCode = 2;
                break;
            }
            case 108: {
                this.jj_consume_token(108);
                templateMatchCode = 3;
                break;
            }
            case 110: {
                this.jj_consume_token(110);
                templateMatchCode = 1;
                break;
            }
            case 111: {
                this.jj_consume_token(111);
                templateMatchCode = 1;
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                templateMatchCode = 8;
                break;
            }
            case 28: {
                this.jj_consume_token(28);
                this.jj_consume_token(24);
                templateMatchCode = 10;
                break;
            }
            default: {
                this.jj_la1[131] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        valueNode = this.valueNode(query);
        columnNode1.setName(column);
        return new ContainsNode(columnNode1, valueNode, templateMatchCode);
    }

    public final ExpNode containsInNode(AbstractDMLQuery query, ColumnNode columnNode1, String column) throws ParseException {
        boolean notIn = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                this.jj_consume_token(28);
                notIn = true;
                break;
            }
            default: {
                this.jj_la1[132] = this.jj_gen;
            }
        }
        this.jj_consume_token(22);
        this.jj_consume_token(113);
        ExpNode inNode = this.inExprOrList(query, notIn);
        this.jj_consume_token(114);
        columnNode1.setName(column);
        inNode.setLeftChild(columnNode1);
        return new ContainsNode(columnNode1, inNode, 11);
    }

    public final ExpNode containsNode(AbstractDMLQuery query, ColumnNode columnNode1) throws ParseException {
        Object valueNode = null;
        String negative = "";
        ExpNode expNode = null;
        Object containsItems = null;
        this.jj_consume_token(124);
        query.setContainsQuery(true);
        StringBuilder columnPath = new StringBuilder(columnNode1.toString());
        columnPath.append("[*]");
        boolean templateMatchCode = false;
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 124: {
                    break;
                }
                default: {
                    this.jj_la1[133] = this.jj_gen;
                    break block13;
                }
            }
            this.jj_consume_token(124);
            columnPath.append("[*]");
        }
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 102: {
                    break;
                }
                default: {
                    this.jj_la1[134] = this.jj_gen;
                    break block14;
                }
            }
            this.jj_consume_token(102);
            Token t = this.id();
            String columnNameSuffix = QueryProcessor.getDefaultConfig().isParserCaseSensitivity() ? t.image : t.image.toUpperCase();
            columnPath.append(".");
            columnPath.append(columnNameSuffix);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 124: {
                        break;
                    }
                    default: {
                        this.jj_la1[135] = this.jj_gen;
                        continue block14;
                    }
                }
                this.jj_consume_token(124);
                columnPath.append("[*]");
            }
            break;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: 
            case 22: 
            case 24: 
            case 28: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                expNode = this.containsSingleNode(query, columnNode1, columnPath.toString());
                break;
            }
            case 113: {
                expNode = this.containsMultipleNode(query, columnNode1, columnPath.toString());
                break;
            }
            default: {
                this.jj_la1[136] = this.jj_gen;
                if (this.jj_2_25(2)) {
                    expNode = this.containsIsNullNode(query, columnNode1, columnPath.toString());
                    break;
                }
                if (this.jj_2_26(2)) {
                    expNode = this.containsIsNotNullNode(query, columnNode1, columnPath.toString());
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expNode;
    }

    public final ExpNode containsIsNullNode(AbstractDMLQuery query, ColumnNode columnNode1, String columnPath) throws ParseException {
        IsNullNode valueNode = null;
        this.jj_consume_token(23);
        this.jj_consume_token(29);
        valueNode = new IsNullNode(columnNode1, new LiteralNode(null));
        columnNode1.setName(columnPath);
        return new ContainsNode(columnNode1, valueNode, 6);
    }

    public final ExpNode containsIsNotNullNode(AbstractDMLQuery query, ColumnNode columnNode1, String columnPath) throws ParseException {
        IsNullNode valueNode = null;
        this.jj_consume_token(23);
        this.jj_consume_token(28);
        this.jj_consume_token(29);
        valueNode = new IsNullNode(columnNode1, new LiteralNode(null));
        valueNode.setNot(true);
        columnNode1.setName(columnPath);
        return new ContainsNode(columnNode1, valueNode, 7);
    }

    public final ExpNode containsMultipleNode(AbstractDMLQuery query, ColumnNode columnNode1, String columnPath) throws ParseException {
        ContainsItemsRootNode valueNode = null;
        this.jj_consume_token(113);
        columnNode1.setName(columnPath);
        valueNode = new ContainsItemsRootNode(this.SqlContainsItemExpression(query), columnPath, columnNode1);
        this.jj_consume_token(114);
        return new ContainsItemNode(columnNode1, valueNode, 0);
    }

    public final ExpNode containsSingleNode(AbstractDMLQuery query, ColumnNode columnNode1, String column) throws ParseException {
        ExpNode expNode = null;
        if (this.jj_2_27(2)) {
            expNode = this.containsInNode(query, columnNode1, column);
        } else if (this.jj_2_28(2)) {
            expNode = this.containsBetweenNode(query, columnNode1, column);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 24: 
                case 28: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: {
                    expNode = this.containsSimpleNode(query, columnNode1, column);
                    break;
                }
                default: {
                    this.jj_la1[137] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return expNode;
    }

    public final ValueNode valueNode(AbstractDMLQuery query) throws ParseException {
        LiteralNode valueNode = null;
        String negative = "";
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 121: {
                Token t = this.jj_consume_token(121);
                query.setPrepared(true);
                valueNode = new PreparedNode(null, ++this.conditionIndex);
                break;
            }
            case 97: {
                Token t = this.jj_consume_token(97);
                valueNode = new LiteralNode(new String(t.image.substring(1, t.image.length() - 1)));
                break;
            }
            case 79: {
                Token t = this.jj_consume_token(79);
                valueNode = new LiteralNode(Boolean.TRUE);
                break;
            }
            case 80: {
                Token t = this.jj_consume_token(80);
                valueNode = new LiteralNode(Boolean.FALSE);
                break;
            }
            default: {
                this.jj_la1[141] = this.jj_gen;
                if (this.jj_2_29(2)) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 120: {
                            this.jj_consume_token(120);
                            negative = "-";
                            break;
                        }
                        default: {
                            this.jj_la1[138] = this.jj_gen;
                        }
                    }
                    Token t = this.jj_consume_token(93);
                    valueNode = new LiteralNode(new Integer(negative + t.image));
                    break;
                }
                if (this.jj_2_30(2)) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 120: {
                            this.jj_consume_token(120);
                            negative = "-";
                            break;
                        }
                        default: {
                            this.jj_la1[139] = this.jj_gen;
                        }
                    }
                    Token t = this.jj_consume_token(94);
                    valueNode = new LiteralNode(negative + t.image.substring(0, t.image.length() - 1));
                    break;
                }
                if (this.jj_2_31(2)) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 120: {
                            this.jj_consume_token(120);
                            negative = "-";
                            break;
                        }
                        default: {
                            this.jj_la1[140] = this.jj_gen;
                        }
                    }
                    Token t = this.jj_consume_token(95);
                    valueNode = new LiteralNode(negative + t.image);
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 98: {
                        Token t = this.jj_consume_token(98);
                        valueNode = new LiteralNode(t.image);
                        break block0;
                    }
                }
                this.jj_la1[142] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return valueNode;
    }

    public final ExpNode inExprOrList(AbstractDMLQuery query, boolean isNot) throws ParseException {
        Query innerQuery = null;
        AbstractInNode expNode = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 32: {
                innerQuery = this.selectSql();
                expNode = isNot ? new NotInNode() : new InNode();
                query.setContainsSubQueries(true);
                expNode.setRightChild(new InnerQueryNode((SelectQuery)innerQuery));
                return expNode;
            }
            case 29: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 120: 
            case 121: {
                HashSet<LiteralNode> valuelist = this.inValueList(query);
                if (isNot) {
                    expNode = new NotInNode();
                    expNode.setValuesList(valuelist);
                } else {
                    expNode = new InNode();
                    ((InNode)expNode).setValuesList(valuelist);
                }
                return expNode;
            }
        }
        this.jj_la1[143] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final LiteralNode parseInValue(AbstractDMLQuery query) throws ParseException {
        Token t = null;
        LiteralNode value = null;
        String negative = "";
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 79: {
                t = this.jj_consume_token(79);
                value = new LiteralNode(Boolean.TRUE);
                break;
            }
            case 80: {
                this.jj_consume_token(80);
                value = new LiteralNode(Boolean.FALSE);
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                value = new LiteralNode(null);
                break;
            }
            case 76: {
                this.jj_consume_token(76);
                value = new LiteralNode(new Clob(""));
                break;
            }
            case 77: {
                this.jj_consume_token(77);
                value = new LiteralNode(new Blob(new byte[0]));
                break;
            }
            case 121: {
                this.jj_consume_token(121);
                query.setPrepared(true);
                value = new PreparedNode(null, ++this.conditionIndex);
                break;
            }
            case 97: {
                t = this.jj_consume_token(97);
                value = new LiteralNode(new String(t.image.substring(1, t.image.length() - 1)));
                break;
            }
            default: {
                this.jj_la1[147] = this.jj_gen;
                if (this.jj_2_32(2)) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 120: {
                            this.jj_consume_token(120);
                            negative = "-";
                            break;
                        }
                        default: {
                            this.jj_la1[144] = this.jj_gen;
                        }
                    }
                    t = this.jj_consume_token(93);
                    value = new LiteralNode(negative + t.image);
                    break;
                }
                if (this.jj_2_33(2)) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 120: {
                            this.jj_consume_token(120);
                            negative = "-";
                            break;
                        }
                        default: {
                            this.jj_la1[145] = this.jj_gen;
                        }
                    }
                    t = this.jj_consume_token(94);
                    value = new LiteralNode(negative + t.image.substring(0, t.image.length() - 1));
                    break;
                }
                if (this.jj_2_34(2)) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 120: {
                            this.jj_consume_token(120);
                            negative = "-";
                            break;
                        }
                        default: {
                            this.jj_la1[146] = this.jj_gen;
                        }
                    }
                    t = this.jj_consume_token(95);
                    value = new LiteralNode(negative + t.image);
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return value;
    }

    public final HashSet<LiteralNode> inValueList(AbstractDMLQuery query) throws ParseException {
        LiteralNode value = null;
        HashSet<LiteralNode> list = new HashSet<LiteralNode>();
        value = this.parseInValue(query);
        list.add(value);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 125: {
                    break;
                }
                default: {
                    this.jj_la1[148] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(125);
            value = this.parseInValue(query);
            list.add(value);
        }
        return list;
    }

    public final ValueNode getBetweenValueNode(AbstractDMLQuery query) throws ParseException {
        LiteralNode valueNode = null;
        Token t = null;
        Token operator = null;
        Token addup = null;
        String negative = "";
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 121: {
                t = this.jj_consume_token(121);
                query.setPrepared(true);
                valueNode = new PreparedNode(null, ++this.conditionIndex);
                break;
            }
            case 97: {
                t = this.jj_consume_token(97);
                valueNode = new LiteralNode(new String(t.image.substring(1, t.image.length() - 1)));
                break;
            }
            case 79: {
                t = this.jj_consume_token(79);
                valueNode = new LiteralNode(Boolean.TRUE);
                break;
            }
            case 80: {
                t = this.jj_consume_token(80);
                valueNode = new LiteralNode(Boolean.FALSE);
                break;
            }
            default: {
                this.jj_la1[154] = this.jj_gen;
                if (this.jj_2_35(2)) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 120: {
                            this.jj_consume_token(120);
                            negative = "-";
                            break;
                        }
                        default: {
                            this.jj_la1[149] = this.jj_gen;
                        }
                    }
                    t = this.jj_consume_token(93);
                    valueNode = new LiteralNode(negative + t.image);
                    break;
                }
                if (this.jj_2_36(2)) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 120: {
                            this.jj_consume_token(120);
                            negative = "-";
                            break;
                        }
                        default: {
                            this.jj_la1[150] = this.jj_gen;
                        }
                    }
                    t = this.jj_consume_token(94);
                    valueNode = new LiteralNode(negative + t.image.substring(0, t.image.length() - 1));
                    break;
                }
                if (this.jj_2_37(2)) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 120: {
                            this.jj_consume_token(120);
                            negative = "-";
                            break;
                        }
                        default: {
                            this.jj_la1[151] = this.jj_gen;
                        }
                    }
                    t = this.jj_consume_token(95);
                    valueNode = new LiteralNode(negative + t.image);
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 98: {
                        t = this.jj_consume_token(98);
                        valueNode = new LiteralNode(t.image);
                        break block0;
                    }
                    case 35: {
                        this.jj_consume_token(35);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 119: 
                            case 120: {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 119: {
                                        operator = this.jj_consume_token(119);
                                        break;
                                    }
                                    case 120: {
                                        operator = this.jj_consume_token(120);
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[152] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                                addup = this.jj_consume_token(93);
                                break;
                            }
                            default: {
                                this.jj_la1[153] = this.jj_gen;
                            }
                        }
                        Calendar cal = Calendar.getInstance();
                        if (addup != null) {
                            if (operator.image.equals("+")) {
                                cal.add(5, Integer.parseInt(addup.image));
                            } else if (operator.image.equals("-")) {
                                cal.add(5, -Integer.parseInt(addup.image));
                            }
                        }
                        valueNode = new LiteralNode(new Timestamp(cal.getTime().getTime()));
                        break block0;
                    }
                }
                this.jj_la1[155] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return valueNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_30();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(29, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_31();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(30, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_32();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(31, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_33();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(32, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_34(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_34();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(33, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_35(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_35();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(34, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_36(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_36();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(35, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_37(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_37();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(36, xla);
        }
    }

    private boolean jj_3_25() {
        return this.jj_3R_60();
    }

    private boolean jj_3R_60() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_scan_token(29);
    }

    private boolean jj_3R_72() {
        return this.jj_scan_token(120);
    }

    private boolean jj_3R_71() {
        return this.jj_scan_token(120);
    }

    private boolean jj_3R_70() {
        return this.jj_scan_token(120);
    }

    private boolean jj_3R_24() {
        return this.jj_3R_25();
    }

    private boolean jj_3R_90() {
        return this.jj_scan_token(35);
    }

    private boolean jj_3R_91() {
        return this.jj_3R_25();
    }

    private boolean jj_3R_89() {
        return this.jj_scan_token(98);
    }

    private boolean jj_3_37() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_72()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(95);
    }

    private boolean jj_3_36() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_71()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(94);
    }

    private boolean jj_3_21() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_scan_token(28);
    }

    private boolean jj_3_35() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_70()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(93);
    }

    private boolean jj_3R_88() {
        return this.jj_scan_token(80);
    }

    private boolean jj_3R_87() {
        return this.jj_scan_token(79);
    }

    private boolean jj_3R_85() {
        return this.jj_scan_token(121);
    }

    private boolean jj_3R_86() {
        return this.jj_scan_token(97);
    }

    private boolean jj_3_20() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_scan_token(29);
    }

    private boolean jj_3R_55() {
        return this.jj_3R_82();
    }

    private boolean jj_3R_81() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_85()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_86()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_87()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_88()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_35()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_36()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_37()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_89()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_90()) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_69() {
        return this.jj_scan_token(120);
    }

    private boolean jj_3R_68() {
        return this.jj_scan_token(120);
    }

    private boolean jj_3R_67() {
        return this.jj_scan_token(120);
    }

    private boolean jj_3R_82() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_6()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_91()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_6() {
        if (this.jj_scan_token(88)) {
            return true;
        }
        return this.jj_scan_token(113);
    }

    private boolean jj_3_19() {
        return this.jj_3R_56();
    }

    private boolean jj_3R_37() {
        return this.jj_scan_token(120);
    }

    private boolean jj_3R_54() {
        return this.jj_scan_token(113);
    }

    private boolean jj_3R_36() {
        return this.jj_scan_token(120);
    }

    private boolean jj_3R_35() {
        return this.jj_scan_token(120);
    }

    private boolean jj_3_34() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_69()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(95);
    }

    private boolean jj_3R_84() {
        return this.jj_scan_token(28);
    }

    private boolean jj_3_33() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_68()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(94);
    }

    private boolean jj_3_32() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_67()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(93);
    }

    private boolean jj_3R_83() {
        return this.jj_scan_token(28);
    }

    private boolean jj_3R_62() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_84()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(22)) {
            return true;
        }
        return this.jj_scan_token(113);
    }

    private boolean jj_3R_53() {
        return this.jj_scan_token(35);
    }

    private boolean jj_3R_56() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_83()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(22)) {
            return true;
        }
        return this.jj_scan_token(113);
    }

    private boolean jj_3R_52() {
        return this.jj_scan_token(98);
    }

    private boolean jj_3_17() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_37()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(95);
    }

    private boolean jj_3_16() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_36()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(94);
    }

    private boolean jj_3_15() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_35()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(93);
    }

    private boolean jj_3R_51() {
        return this.jj_scan_token(80);
    }

    private boolean jj_3R_50() {
        return this.jj_scan_token(79);
    }

    private boolean jj_3R_49() {
        return this.jj_scan_token(97);
    }

    private boolean jj_3R_48() {
        return this.jj_scan_token(121);
    }

    private boolean jj_3R_47() {
        return this.jj_scan_token(25);
    }

    private boolean jj_3R_46() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        return this.jj_scan_token(24);
    }

    private boolean jj_3_14() {
        return this.jj_3R_34();
    }

    private boolean jj_3R_45() {
        return this.jj_scan_token(24);
    }

    private boolean jj_3_13() {
        return this.jj_3R_33();
    }

    private boolean jj_3R_44() {
        return this.jj_scan_token(111);
    }

    private boolean jj_3R_43() {
        return this.jj_scan_token(110);
    }

    private boolean jj_3R_42() {
        return this.jj_scan_token(108);
    }

    private boolean jj_3R_41() {
        return this.jj_scan_token(107);
    }

    private boolean jj_3R_40() {
        return this.jj_scan_token(106);
    }

    private boolean jj_3R_39() {
        return this.jj_scan_token(105);
    }

    private boolean jj_3R_38() {
        return this.jj_scan_token(109);
    }

    private boolean jj_3R_66() {
        return this.jj_scan_token(120);
    }

    private boolean jj_3R_65() {
        return this.jj_scan_token(120);
    }

    private boolean jj_3R_64() {
        return this.jj_scan_token(120);
    }

    private boolean jj_3_18() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_38()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_39()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_40()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_41()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_42()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_43()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_44()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_45()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_46()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_47()) {
                                                return true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_48()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_49()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_50()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_51()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_15()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_16()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_17()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_52()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_53()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_54()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_55()) {
                                                    return true;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_79() {
        return this.jj_scan_token(10);
    }

    private boolean jj_3R_78() {
        return this.jj_scan_token(27);
    }

    private boolean jj_3R_77() {
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_76() {
        return this.jj_scan_token(37);
    }

    private boolean jj_3R_75() {
        return this.jj_scan_token(34);
    }

    private boolean jj_3R_26() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_75()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_76()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_77()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_78()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_79()) {
                            return true;
                        }
                    }
                }
            }
        }
        return this.jj_scan_token(113);
    }

    private boolean jj_3_31() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_66()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(95);
    }

    private boolean jj_3_30() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_65()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(94);
    }

    private boolean jj_3_29() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_64()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(93);
    }

    private boolean jj_3R_63() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_3R_81();
    }

    private boolean jj_3R_32() {
        return this.jj_scan_token(120);
    }

    private boolean jj_3R_31() {
        return this.jj_scan_token(120);
    }

    private boolean jj_3R_30() {
        return this.jj_scan_token(120);
    }

    private boolean jj_3R_80() {
        return this.jj_scan_token(28);
    }

    private boolean jj_3R_33() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_80()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(22)) {
            return true;
        }
        return this.jj_scan_token(113);
    }

    private boolean jj_3R_29() {
        return this.jj_scan_token(120);
    }

    private boolean jj_3R_28() {
        return this.jj_scan_token(120);
    }

    private boolean jj_3R_27() {
        return this.jj_scan_token(120);
    }

    private boolean jj_3_12() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_32()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(95);
    }

    private boolean jj_3_11() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_31()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(94);
    }

    private boolean jj_3_10() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_30()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(93);
    }

    private boolean jj_3R_59() {
        return this.jj_scan_token(120);
    }

    private boolean jj_3R_58() {
        return this.jj_scan_token(120);
    }

    private boolean jj_3R_57() {
        return this.jj_scan_token(120);
    }

    private boolean jj_3_9() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_29()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(95);
    }

    private boolean jj_3_8() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_28()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(94);
    }

    private boolean jj_3R_34() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_3R_81();
    }

    private boolean jj_3_7() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_27()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(93);
    }

    private boolean jj_3_24() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_59()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(95);
    }

    private boolean jj_3_23() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_58()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(94);
    }

    private boolean jj_3_28() {
        return this.jj_3R_63();
    }

    private boolean jj_3_22() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_57()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(93);
    }

    private boolean jj_3_27() {
        return this.jj_3R_62();
    }

    private boolean jj_3_5() {
        return this.jj_3R_26();
    }

    private boolean jj_3_4() {
        if (this.jj_3R_25()) {
            return true;
        }
        return this.jj_scan_token(102);
    }

    private boolean jj_3_3() {
        return this.jj_3R_26();
    }

    private boolean jj_3R_61() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_scan_token(28);
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(113)) {
            return true;
        }
        return this.jj_3R_24();
    }

    private boolean jj_3R_74() {
        return this.jj_scan_token(89);
    }

    private boolean jj_3_2() {
        if (this.jj_3R_25()) {
            return true;
        }
        return this.jj_scan_token(102);
    }

    private boolean jj_3R_73() {
        return this.jj_scan_token(88);
    }

    private boolean jj_3R_25() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_73()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_74()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_26() {
        return this.jj_3R_61();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{57376, 1, 262272, 0, 0, 0, 0x200000, Integer.MIN_VALUE, 0, 16384, 1, 0, 0x200000, Integer.MIN_VALUE, 0, 0, 1, 0, 0x200000, Integer.MIN_VALUE, 0, 1, 0, 4096, 0, 0, 0, 0, 0x10000000, 0, 0, 65536, 0, 0, 0x10000000, 0, 0, 65536, 0, 0, 0, 0, 0, 0, 0, 262272, 0, 0, 0, 0, 0, 0, 0, 0, 0x20000000, 0xC000400, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x20000000, 0, 0, 0, 0, 0x20000000, 0, 131584, 131584, 0, 0, 0, 131584, 131584, 0, 0, 0, 0, 0, 0, 0x40000000, 256, 0, 256, 0, 0, 0, 0, 289409024, 0, 0x11000000, 0x10000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 331352064, 0, 0x13000000, 0, 0, 0, 0, 0, 0, 0, 0x11000000, 0, 0, 0, 0, 0, 0x10000000, 0x11000000, 0x10000000, 0, 0, 0, 289409024, 0x11000000, 0, 0, 0, 0, 0, 0x20000000, 0, 0, 0, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{820289, 0, 0, 0, 0, 16, 0, 0, 16384, 0, 0, 256, 0, 0, 16384, 256, 0, 256, 0, 0, 16384, 0, 16, 0, 16, 0, 0, 131073, 0, 0x100200, 0x100200, 0, 0, 0, 0, 0x100200, 0x100200, 0, 0x300000, 0, 786432, 0, 0, 0, 0, 0, 0, 0x400000, 0x400000, 0, 0x400000, 0x400000, 0, 0, 0, 36, 0, 0x1000000, 0x1000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x6000000, 0x6000000, 0, 0, 0, 0x6000000, 0x6000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0, 0, 256, 0, 256, 0, 0, 0, 0, 256, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -134217728, 0, 0, 0, 256, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x3000000, 0, 0, 0, 0x3000000, 0, 0x3000000, 0, 0, 0, 0, 0, 0x3000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x3000000, 0, 0, -486539264, 0, -486539264, -486539264, 0, 0, 0x3000000, 0x3000000, 0, 0x3000000, 0x3000000, 0, 0, -486428672, 0, 0x3000000, 0, 0x3000000, 0x3000000, 0, -486539264, 0x3000000, 0, 0x3000000, 0x3000000, 0, 0, 0, 110592, 0, 0, 0, 0, 110592, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x3000000, 0, 0x3000000, 0, 0, 0x3000000, 0, 0x3000000, 0, 0, 0, 0, 0x3000000, 0, 0, 0, 0, 192, 0, 0, 0, 0, 0, 131104, 0, 0xFE0FFF, 0x3000000, 0, 0x10000000, 0x3000000, 0, 0, 0, 0, 0, 0, 98304, 0x3000000, 0, 0, 0, 0, 98304, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 98304, 0, -536760320, 0, 0, 0, 110592, 0, 0, 0, 0, 0, 0, 98304, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 32, 0, 131072, 262144, 0, 0, 0, 0, 0, 32, 131072, 0, 0, 0, 131072, 32, 131072, 0, 0, 0, 32, 0, 0, 0, 131072, 262144, 131072, 0, 0, 0, 0, 0x20000000, 0x20000000, 0, 0, 0, 0, 0, 0x20000000, 0, 0x2000002, 0x20000000, 0x2000002, 0x2000002, 0, 0x20000000, 0x200002, 0x200002, 0x20000000, 0x200002, 0x200002, 0x20000000, 0x1000000, 0x2000002, 0, 0x200000, 0, 0, 0, 0x20000000, 2, 0, 0x20000000, 0, 0, 0x1000000, 0x1000000, 0x1000000, 0x2000002, 0x20000000, 0x1000000, 0x1000000, 0x1000000, 0x2000002, 0x20000000, 0, 0, 0, 0, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131072, 0, 131072, 0x10000000, 64, 0x10000000, 268631552, 0, 196096, 0, 0x40000040, 0x40000040, 0, 131072, 131072, 0x20000000, 131072, 131072, 0, 131072, 0, 0, 146944, 268500480, 0, 65024, 0x1000000, 0x1000000, 0x1000000, 0x1800000, 0x1800000, 0x2000002, 131076, 196096, 0x1000000, 0x1000000, 0x1000000, 0x2000002, 4, 0, 65024, 0, 0x10000000, 64, 0x10000000, 196096, 65024, 0x1000000, 0x1000000, 0x1000000, 0x2000002, 4, 0x3000002, 0x1000000, 0x1000000, 0x1000000, 0x2000002, 0x20000000, 0x1000000, 0x1000000, 0x1000000, 0x1800000, 0x1800000, 0x2000002, 4};
    }

    public SqlParser(InputStream stream) {
        this(stream, null);
    }

    public SqlParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new SqlParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 156; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 156; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SqlParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new SqlParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 156; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 156; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SqlParser(SqlParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 156; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(SqlParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 156; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[127];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 156; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) == 0) continue;
                la1tokens[96 + j] = true;
            }
        }
        for (i = 0; i < 127; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 37; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                            break;
                        }
                        case 28: {
                            this.jj_3_29();
                            break;
                        }
                        case 29: {
                            this.jj_3_30();
                            break;
                        }
                        case 30: {
                            this.jj_3_31();
                            break;
                        }
                        case 31: {
                            this.jj_3_32();
                            break;
                        }
                        case 32: {
                            this.jj_3_33();
                            break;
                        }
                        case 33: {
                            this.jj_3_34();
                            break;
                        }
                        case 34: {
                            this.jj_3_35();
                            break;
                        }
                        case 35: {
                            this.jj_3_36();
                            break;
                        }
                        case 36: {
                            this.jj_3_37();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        SqlParser.jj_la1_init_0();
        SqlParser.jj_la1_init_1();
        SqlParser.jj_la1_init_2();
        SqlParser.jj_la1_init_3();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

