/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.query;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.PropertyInfo;
import com.j_spaces.jdbc.AbstractDMLQuery;
import com.j_spaces.jdbc.SelectColumn;
import com.j_spaces.jdbc.query.AsterixColumnData;
import com.j_spaces.jdbc.query.QueryTableData;
import com.j_spaces.jdbc.query.UidColumnData;
import java.sql.SQLException;

@InternalApi
public class QueryColumnData {
    protected static final String ASTERIX_COLUMN = "*";
    protected static final String UID_COLUMN = "UID";
    private String _columnName;
    private QueryTableData _columnTableData;
    private int _columnIndexInTable = -1;
    private final String _columnPath;

    public QueryColumnData(String columnPath) {
        if (columnPath == null) {
            this._columnPath = null;
        } else {
            this._columnName = columnPath.split("\\.|\\[\\*\\]", 2)[0];
            this._columnPath = columnPath;
        }
    }

    public QueryColumnData(QueryTableData tableData, String columnPath) throws SQLException {
        this(columnPath);
        this._columnTableData = tableData;
        this.initColumnData();
    }

    public String getColumnName() {
        return this._columnName;
    }

    public QueryTableData getColumnTableData() {
        return this._columnTableData;
    }

    public void setColumnTableData(QueryTableData columnTableData) {
        this._columnTableData = columnTableData;
    }

    public int getColumnIndexInTable() {
        return this._columnIndexInTable;
    }

    public void setColumnIndexInTable(int columnIndexInTable) {
        this._columnIndexInTable = columnIndexInTable;
    }

    public boolean checkAndAssignTableData(QueryTableData tableData) throws SQLException {
        ITypeDesc currentInfo = tableData.getTypeDesc();
        for (int c = 0; c < currentInfo.getNumOfFixedProperties(); ++c) {
            String columnName = this.getColumnName();
            PropertyInfo fixedProperty = currentInfo.getFixedProperty(c);
            if (!fixedProperty.getName().equalsIgnoreCase(columnName)) continue;
            QueryTableData columnTableData = this.getColumnTableData();
            if (columnTableData != null && columnTableData != tableData) {
                throw new SQLException("Ambiguous column name [" + columnName + "]");
            }
            this.setColumnTableData(tableData);
            this.setColumnIndexInTable(c);
            return true;
        }
        return false;
    }

    private void initColumnData() throws SQLException {
        if (this.getColumnTableData() == null) {
            return;
        }
        if (this.getColumnName() != null && (this.getColumnName().equals(UID_COLUMN) || this.getColumnName().equals(ASTERIX_COLUMN))) {
            return;
        }
        ITypeDesc currentInfo = this.getColumnTableData().getTypeDesc();
        for (int c = 0; c < currentInfo.getNumOfFixedProperties(); ++c) {
            if (!currentInfo.getFixedProperty(c).getName().equalsIgnoreCase(this.getColumnName())) continue;
            this.setColumnIndexInTable(c);
            return;
        }
        if (!currentInfo.supportsDynamicProperties()) {
            throw new IllegalArgumentException("Unknown column name '" + this.getColumnName() + "'");
        }
    }

    public String getColumnPath() {
        return this._columnPath;
    }

    public boolean isNestedQueryColumn() {
        if (this._columnName == null) {
            return false;
        }
        return !this._columnPath.equals(this._columnName);
    }

    public static QueryColumnData newColumnData(String columnPath, AbstractDMLQuery query) throws SQLException {
        if (query.isSelectQuery()) {
            for (SelectColumn selectColumn : query.getQueryColumns()) {
                if (!selectColumn.hasAlias() || selectColumn.getAlias().compareToIgnoreCase(columnPath) != 0) continue;
                columnPath = selectColumn.getName();
                break;
            }
        }
        QueryColumnData columnData = null;
        for (QueryTableData tableData : query.getTablesData()) {
            String tableName = null;
            if (QueryColumnData.startsWith(columnPath, tableData.getTableName())) {
                tableName = tableData.getTableName();
            } else if (QueryColumnData.startsWith(columnPath, tableData.getTableAlias())) {
                tableName = tableData.getTableAlias();
            }
            if (tableName == null) continue;
            if (columnData != null) {
                throw new SQLException("Ambiguous column path - [" + columnPath + "]");
            }
            columnData = QueryColumnData.newInstance(tableData, columnPath.substring(tableName.length() + 1));
        }
        if (columnData == null) {
            boolean bl;
            columnData = QueryColumnData.newInstance(columnPath);
            boolean bl2 = false;
            for (QueryTableData tableData : query.getTablesData()) {
                if (!columnData.checkAndAssignTableData(tableData)) continue;
                bl = true;
            }
            if (!bl) {
                if (query.getTablesData().size() == 1 && query.getTableData().getTypeDesc().supportsDynamicProperties()) {
                    columnData.setColumnTableData(query.getTableData());
                    return columnData;
                }
                throw new SQLException("Unknown column path [" + columnPath + "] .", "GSP", -122);
            }
        }
        return columnData;
    }

    private static QueryColumnData newInstance(String columnPath) throws SQLException {
        return QueryColumnData.newInstance(null, columnPath);
    }

    public static QueryColumnData newInstance(QueryTableData tableData, String columnPath) throws SQLException {
        if (columnPath.equalsIgnoreCase(UID_COLUMN)) {
            return new UidColumnData(tableData);
        }
        if (columnPath.equals(ASTERIX_COLUMN)) {
            return new AsterixColumnData(tableData);
        }
        return new QueryColumnData(tableData, columnPath);
    }

    public static boolean startsWith(String columnPath, String tableName) {
        if (tableName == null || columnPath == null) {
            return false;
        }
        return columnPath.startsWith(tableName + ".");
    }

    public void setColumnName(String columnName) {
        this._columnName = columnName;
    }

    public boolean isAsterixColumn() {
        return false;
    }

    public boolean isUidColumn() {
        return false;
    }
}

