/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.query;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.jdbc.AbstractDMLQuery;
import com.j_spaces.jdbc.Stack;
import com.j_spaces.jdbc.builder.QueryTemplatePacket;
import com.j_spaces.jdbc.executor.EntriesCursor;
import com.j_spaces.jdbc.executor.ScanCursor;
import com.j_spaces.jdbc.parser.ColumnNode;
import com.j_spaces.jdbc.parser.ExpNode;
import com.j_spaces.jdbc.query.IQueryResultSet;
import net.jini.core.transaction.Transaction;

@InternalApi
public class QueryTableData {
    private String _tableName;
    private String _tableAlias;
    private int _tableIndex;
    private ITypeDesc _typeDesc;
    private ExpNode _joinCondition;
    private ExpNode _tableCondition;
    private QueryTableData _joinTable;
    private ThreadLocal<EntriesCursor> _entriesCursor = new ThreadLocal();
    private boolean _isJoined;
    private boolean _hasAsterixSelectColumns;

    public boolean hasAsterixSelectColumns() {
        return this._hasAsterixSelectColumns;
    }

    public void setAsterixSelectColumns(boolean hasAsterixSelectColumns) {
        this._hasAsterixSelectColumns = hasAsterixSelectColumns;
    }

    public String getTableName() {
        return this._tableName;
    }

    public void setTableName(String tableName) {
        this._tableName = tableName;
    }

    public String getTableAlias() {
        return this._tableAlias;
    }

    public void setTableAlias(String tableAlias) {
        this._tableAlias = tableAlias;
    }

    public int getTableIndex() {
        return this._tableIndex;
    }

    public void setTableIndex(int tableIndex) {
        this._tableIndex = tableIndex;
    }

    public ITypeDesc getTypeDesc() {
        return this._typeDesc;
    }

    public void setTypeDesc(ITypeDesc typeDesc) {
        this._typeDesc = typeDesc;
    }

    public ExpNode getJoinCondition() {
        return this._joinCondition;
    }

    public void setJoinCondition(ExpNode joinIndex) {
        this._joinCondition = joinIndex;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("  QueryTableData\n    [\n        getTableAlias()=");
        builder.append(this.getTableAlias());
        builder.append(", \n        getTableName()=");
        builder.append(this.getTableName());
        builder.append(", \n        getTableCondition()=");
        builder.append(this.getTableCondition());
        builder.append(", \n        getJoinTable()=");
        if (this.getJoinTable() != null) {
            builder.append(this.getJoinTable().getTableName());
        }
        builder.append(", \n        getJoinExpression()=");
        builder.append(this.getJoinCondition());
        builder.append(", \n        getTableIndex()=");
        builder.append(this.getTableIndex());
        builder.append("\n    ]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._tableAlias == null ? 0 : this._tableAlias.hashCode());
        result = 31 * result + this._tableIndex;
        result = 31 * result + (this._tableName == null ? 0 : this._tableName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryTableData other = (QueryTableData)obj;
        if (this._tableAlias == null ? other._tableAlias != null : !this._tableAlias.equals(other._tableAlias)) {
            return false;
        }
        if (this._tableIndex != other._tableIndex) {
            return false;
        }
        return !(this._tableName == null ? other._tableName != null : !this._tableName.equals(other._tableName));
    }

    public IEntryPacket getCurrentEntry() {
        return this.getEntriesCursor().getCurrentEntry();
    }

    public boolean next() {
        if (this._joinTable == null) {
            return this.getEntriesCursor().next();
        }
        while (this.hasNext()) {
            if (this._joinTable.next()) {
                return true;
            }
            if (this.getEntriesCursor().next()) {
                this._joinTable.reset();
                continue;
            }
            return false;
        }
        return false;
    }

    private boolean hasNext() {
        if (this.getEntriesCursor().isBeforeFirst()) {
            return this.getEntriesCursor().next();
        }
        return true;
    }

    public void reset() {
        this.getEntriesCursor().reset();
        if (this._joinTable != null) {
            this._joinTable.reset();
        }
    }

    public QueryTableData getJoinTable() {
        return this._joinTable;
    }

    public void setJoinTable(QueryTableData joinTable) {
        this._joinTable = joinTable;
    }

    public EntriesCursor getEntriesCursor() {
        return this._entriesCursor.get();
    }

    public void setEntriesCursor(EntriesCursor entriesCursor) {
        this._entriesCursor.set(entriesCursor);
    }

    public ExpNode getTableCondition() {
        return this._tableCondition;
    }

    public void setTableCondition(ExpNode tableCondition) {
        this._tableCondition = tableCondition;
    }

    public boolean isJoined() {
        return this._isJoined;
    }

    public void setJoined(boolean isJoined) {
        this._isJoined = isJoined;
    }

    public void join(ExpNode exp) {
        QueryTableData rightTable = ((ColumnNode)exp.getRightChild()).getColumnData().getColumnTableData();
        if (this.getJoinTable() == null && !rightTable.isJoined() && !rightTable.references(this)) {
            this.setJoinTable(rightTable);
            rightTable.setJoinCondition(exp);
            rightTable.setJoined(true);
        }
    }

    private boolean references(QueryTableData dest) {
        for (QueryTableData source = this; source != null; source = source.getJoinTable()) {
            if (!source.equals(dest)) continue;
            return true;
        }
        return false;
    }

    public QueryTemplatePacket getTemplate(QueryResultTypeInternal queryResultType) {
        if (this.getTableCondition() != null) {
            return this.getTableCondition().getTemplate();
        }
        return new QueryTemplatePacket(this, queryResultType);
    }

    public void init(ISpaceProxy space, Transaction txn, AbstractDMLQuery query) throws Exception {
        IQueryResultSet<IEntryPacket> tableEntries = this.getTemplate(query.getQueryResultType()).readMultiple(space, txn, Integer.MAX_VALUE, query.getReadModifier());
        if (this._joinCondition != null) {
            this.setEntriesCursor(this._joinCondition.createIndex(this, tableEntries));
        } else {
            this.setEntriesCursor(new ScanCursor(tableEntries));
        }
    }

    public void createJoinIndex(ExpNode root) {
        if (root == null) {
            return;
        }
        Stack<ExpNode> stack = new Stack<ExpNode>();
        stack.push(root);
        while (!stack.isEmpty()) {
            ExpNode curr = (ExpNode)stack.pop();
            boolean processChildren = curr.createJoinIndex(this);
            if (!processChildren) continue;
            if (curr.getLeftChild() != null) {
                stack.push(curr.getLeftChild());
            }
            if (curr.getRightChild() == null) continue;
            stack.push(curr.getRightChild());
        }
    }

    public void clear() {
        this.setEntriesCursor(null);
    }
}

