/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jmx;

import com.j_spaces.kernel.ClassLoaderHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public abstract class AbstractDynamicMBean
implements DynamicMBean {
    protected final String THIS_CLASS_NAME = this.getClass().getName();
    private String m_description;
    private final Hashtable<String, MBeanAttributeInfo> m_attributesMap = new Hashtable();
    private final List<MBeanAttributeInfo> m_attributes = new ArrayList<MBeanAttributeInfo>();
    private final List<MBeanOperationInfo> m_operations = new ArrayList<MBeanOperationInfo>();
    private final List<MBeanNotificationInfo> m_notifications = new ArrayList<MBeanNotificationInfo>();
    private final List<MBeanConstructorInfo> m_constructors = new ArrayList<MBeanConstructorInfo>();
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.jmx");

    protected AbstractDynamicMBean() {
    }

    protected abstract void __setConfig(Object var1);

    protected abstract Object __getConfig();

    protected abstract String getType();

    public void addMBeanAttributeInfo(MBeanAttributeInfo info) {
        this.m_attributes.add(info);
        this.m_attributesMap.put(info.getName(), info);
    }

    public void addMBeanOperationInfo(MBeanOperationInfo info) {
        this.m_operations.add(info);
    }

    public void addMBeanNotificationInfo(MBeanNotificationInfo info) {
        this.m_notifications.add(info);
    }

    public void addMBeanConstructorInfo(MBeanConstructorInfo info) {
        this.m_constructors.add(info);
    }

    public void setMBeanDescription(String descr) {
        this.m_description = descr;
    }

    protected MBeanAttributeInfo[] createMBeanAttributesInfo() {
        return this.m_attributes.toArray(new MBeanAttributeInfo[this.m_attributes.size()]);
    }

    protected MBeanOperationInfo[] createMBeanOperationsInfo() {
        return this.m_operations.toArray(new MBeanOperationInfo[this.m_operations.size()]);
    }

    protected MBeanNotificationInfo[] createMBeanNotificationsInfo() {
        return this.m_notifications.toArray(new MBeanNotificationInfo[this.m_notifications.size()]);
    }

    protected MBeanConstructorInfo[] createMBeanConstructorsInfo() {
        if (this.m_constructors.size() <= 0) {
            return this.createMBeanConstructorsInfo1();
        }
        return this.m_constructors.toArray(new MBeanConstructorInfo[this.m_constructors.size()]);
    }

    protected String getMBeanDescription() {
        return this.m_description;
    }

    private MBeanConstructorInfo[] createMBeanConstructorsInfo1() {
        Constructor<?>[] constructors = this.getClass().getConstructors();
        MBeanConstructorInfo[] dConstructors = new MBeanConstructorInfo[constructors.length];
        for (int i = 0; i < constructors.length; ++i) {
            dConstructors[i] = new MBeanConstructorInfo("Instantiate " + this.THIS_CLASS_NAME + " with the specified container.", constructors[i]);
        }
        return dConstructors;
    }

    protected String toUpperCase(String str, int charIndex) {
        char[] name = str.toCharArray();
        name[0] = Character.toUpperCase(name[charIndex]);
        return new String(name);
    }

    protected String toLowCase(String str, int charIndex) {
        char[] name = str.toCharArray();
        name[0] = Character.toLowerCase(name[charIndex]);
        return new String(name);
    }

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null || attributeName.trim().length() <= 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name can not be null or empty"), "Can not invoke a getter of " + this.THIS_CLASS_NAME + " with a null or empty attribute name string.");
        }
        MBeanAttributeInfo attrInfo = this.m_attributesMap.get(attributeName);
        if (attrInfo == null) {
            throw new AttributeNotFoundException("Can not find " + attributeName + " attribute in " + this.THIS_CLASS_NAME);
        }
        if (!attrInfo.isReadable()) {
            throw new AttributeNotFoundException("Can not get attribute [" + attributeName + "] because it is not readable.");
        }
        try {
            String methodPrefix = "get";
            if (attrInfo.isIs()) {
                methodPrefix = "is";
            }
            return this.getClass().getMethod(methodPrefix + this.toUpperCase(attributeName, 0), new Class[0]).invoke((Object)this, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                String value;
                Object result = null;
                Object objConfig = this.__getConfig();
                if (objConfig instanceof Properties && (value = ((Properties)objConfig).getProperty(attributeName)) != null) {
                    result = ClassLoaderHelper.loadClass(attrInfo.getType()).getConstructor(String.class).newInstance(value);
                }
                if (result == null) {
                    result = objConfig.getClass().getField(this.toLowCase(attributeName, 0)).get(objConfig);
                }
                return result;
            }
            catch (NoSuchFieldException ex1) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, ex1.toString(), ex1);
                }
                throw new AttributeNotFoundException("Can not find " + attributeName + " attribute in " + this.THIS_CLASS_NAME);
            }
            catch (Exception ex2) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, ex2.toString(), ex2);
                }
                throw new MBeanException(new Exception(e.getCause()));
            }
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, targetException.toString(), targetException);
            }
            throw new MBeanException((Exception)targetException);
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, e.toString(), e);
            }
            throw new MBeanException(e);
        }
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        block11: {
            if (attribute == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Attribute parameter can not be null"), "Can not invoke setAttribute method of " + this.THIS_CLASS_NAME + " with null attribute parameter");
            }
            String attributeName = attribute.getName();
            Object attributeValue = attribute.getValue();
            if (attributeName == null || attributeName.trim().equals("")) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Name field of attribute parameter can not be null or empty"), "Can not invoke setAttribute method of " + this.THIS_CLASS_NAME + " with null or empty attribute parameter name field");
            }
            MBeanAttributeInfo attrInfo = this.m_attributesMap.get(attributeName);
            if (attrInfo == null) {
                throw new AttributeNotFoundException("Can not find " + attributeName + " attribute in " + this.THIS_CLASS_NAME);
            }
            if (!attrInfo.isWritable()) {
                throw new AttributeNotFoundException("Can not set attribute [" + attributeName + "] because it is not writable.");
            }
            Class[] clazz = new Class[]{attributeValue.getClass()};
            Object objConfig = this.__getConfig();
            try {
                this.getClass().getMethod("set" + this.toUpperCase(attributeName, 0), clazz).invoke((Object)this, attributeValue);
            }
            catch (Exception ex) {
                try {
                    objConfig.getClass().getField(this.toLowCase(attributeName, 0)).set(objConfig, attributeValue);
                }
                catch (NoSuchFieldException ex1) {
                    if (objConfig instanceof Properties) {
                        ((Properties)objConfig).setProperty(attributeName, attributeValue.toString());
                        break block11;
                    }
                    throw new AttributeNotFoundException("Cannot find " + attributeName + " attribute in " + this.THIS_CLASS_NAME);
                }
                catch (Exception ex2) {
                    if (_logger.isLoggable(Level.WARNING)) {
                        _logger.log(Level.WARNING, ex2.toString(), ex2);
                    }
                    throw new MBeanException(new Exception(ex.getCause()));
                }
            }
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributeNames) {
        if (attributeNames == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeNames[] can not be null"), "Can not invoke a getter of " + this.THIS_CLASS_NAME);
        }
        AttributeList resultList = new AttributeList();
        if (attributeNames.length == 0) {
            return resultList;
        }
        for (int i = 0; i < attributeNames.length; ++i) {
            try {
                Object value = this.getAttribute(attributeNames[i]);
                resultList.add(new Attribute(attributeNames[i], value));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return resultList;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("AttributeList attributes can not be null"), "Can not invoke a setter of " + this.THIS_CLASS_NAME);
        }
        AttributeList resultList = new AttributeList();
        if (attributes.isEmpty()) {
            return resultList;
        }
        for (Attribute attr : attributes) {
            try {
                this.setAttribute(attr);
                String name = attr.getName();
                Object value = this.getAttribute(name);
                resultList.add(new Attribute(name, value));
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.WARNING)) continue;
                _logger.log(Level.WARNING, e.toString(), e);
            }
        }
        return resultList;
    }

    @Override
    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (operationName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Operation name can not be null"), "Can not invoke a null operation in " + this.THIS_CLASS_NAME);
        }
        try {
            Class[] clazz = null;
            if (signature != null) {
                clazz = new Class[signature.length];
                for (int i = 0; i < signature.length; ++i) {
                    clazz[i] = ClassLoaderHelper.loadClass(signature[i]);
                }
            }
            return this.getClass().getMethod(operationName, clazz).invoke((Object)this, params);
        }
        catch (NoSuchMethodException ex) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, ex.toString(), ex);
            }
            throw new ReflectionException(ex, "Can not find the operation " + operationName + " in " + this.THIS_CLASS_NAME);
        }
        catch (Exception ex) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, ex.toString(), ex);
            }
            throw new MBeanException(new Exception(ex.getCause()));
        }
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo info;
        block2: {
            info = null;
            try {
                info = new MBeanInfo(this.THIS_CLASS_NAME, this.getMBeanDescription(), this.createMBeanAttributesInfo(), this.createMBeanConstructorsInfo(), this.createMBeanOperationsInfo(), this.createMBeanNotificationsInfo());
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.WARNING)) break block2;
                _logger.log(Level.WARNING, ex.toString(), ex);
            }
        }
        return info;
    }
}

