/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jmx;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.jmx.JMXUtilities;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.management.local_time.LocalTime;
import com.gigaspaces.management.local_time.LocalTimeConstants;
import com.gigaspaces.management.transport.TransportConstants;
import com.gigaspaces.management.transport.TransportProtocolMonitor;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.jmx.JMXSpace;
import com.j_spaces.jmx.JMXSpaceContainer;
import com.j_spaces.jmx.JMXSpaceExt;
import com.j_spaces.jmx.util.ObjectNameFactory;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.ResourceLoader;
import com.j_spaces.kernel.log.JProperties;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.NameAlreadyBoundException;

@InternalApi
public class JMXProvider {
    private static final URL contURL = ResourceLoader.getResourceURL("ContainerMBeanDescriptors.xml", SystemInfo.singleton().getXapHome());
    public static final String CONTAINER_MBEAN_DESCR_URL = contURL != null ? contURL.toString() : null;
    private static final URL spaceURL = ResourceLoader.getResourceURL("JavaSpaceMBeanDescriptors.xml", SystemInfo.singleton().getXapHome());
    public static final String JSPACE_MBEAN_DESCR_URL = spaceURL != null ? spaceURL.toString() : null;
    private static final URL spaceExtURL = ResourceLoader.getResourceURL("JavaSpaceExtMBeanDescriptors.xml", SystemInfo.singleton().getXapHome());
    public static final String JSPACE_EXT_MBEAN_DESCR_URL = spaceExtURL != null ? spaceExtURL.toString() : null;
    public static final String DEFAULT_DOMAIN = "com.gigaspaces";
    private static MBeanServer m_MBeanServer;
    private static Map<String, JMXConnectorServer> _jmxConnectionsMap;
    private static Hashtable<String, ObjectInstance> m_MBeansRepository;
    private static final Logger _logger;
    private static final String CONNECTION_FAILED_MESSAGE = "Failed to receive MBean Server.";
    private static final String failedTransportMBeanRegistrationMessagePrefix = "\nTransport MBean registration failed for container <";
    private static final String failedLocalTimeMBeanRegistrationMessagePrefix = "\nLocalTime MBean registration failed for container <";
    private static final String alreadyRegistredTransportMBeanMessage = "\nTransport MBean is already registered for container <";
    private static final String successfulTransportMBeanRegistrationMessage = "\nTransport MBean was registered successfully for container <";

    private JMXProvider() {
    }

    public static synchronized MBeanServer getMBeanServer(String containerName) {
        block17: {
            try {
                if (m_MBeanServer == null) {
                    try {
                        m_MBeanServer = ManagementFactory.getPlatformMBeanServer();
                    }
                    catch (Throwable th) {
                        m_MBeanServer = MBeanServerFactory.createMBeanServer();
                    }
                }
                if (!System.getProperty("com.gs.jmx.createJmxConnetor", "true").equals("true")) break block17;
                String jmxServiceURL = "";
                JMXConnectorServer jmxConn = _jmxConnectionsMap.get(containerName);
                if (jmxConn != null) break block17;
                String jndiUrl = JProperties.getContainerProperty(containerName, "com.j_spaces.core.container.directory_services.jndi.url", "localhost:10098");
                jmxServiceURL = JMXUtilities.createJMXUrl((String)jndiUrl);
                Properties env = System.getProperties();
                jmxConn = JMXConnectorServerFactory.newJMXConnectorServer(new JMXServiceURL(jmxServiceURL), env, m_MBeanServer);
                _jmxConnectionsMap.put(containerName, jmxConn);
                if (jmxConn.isActive()) break block17;
                try {
                    jmxConn.start();
                    if (_logger.isLoggable(Level.CONFIG)) {
                        _logger.config("\nNew JMXConnectorServer was successfully registered into the MBeanServer using service url: \n" + jmxServiceURL + "\n");
                    }
                }
                catch (IOException ioe) {
                    String message = JSpaceUtilities.getCauseExceptionMessageFromHierarchy(ioe, NameAlreadyBoundException.class);
                    if (message != null) {
                        if (_logger.isLoggable(Level.CONFIG)) {
                            _logger.config("\nUsing an already registered JMXConnectorServer with service url:\n" + jmxServiceURL + "\n");
                        }
                    } else if (_logger.isLoggable(Level.WARNING)) {
                        _logger.log(Level.WARNING, CONNECTION_FAILED_MESSAGE + ioe.toString(), ioe);
                    }
                }
            }
            catch (IOException e) {
                String message = JSpaceUtilities.getCauseExceptionMessageFromHierarchy(e, NameAlreadyBoundException.class);
                if (message != null) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, CONNECTION_FAILED_MESSAGE + e.toString(), e);
                    }
                } else if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, CONNECTION_FAILED_MESSAGE + e.toString(), e);
                }
            }
            catch (Throwable th) {
                if (!_logger.isLoggable(Level.WARNING)) break block17;
                _logger.log(Level.WARNING, CONNECTION_FAILED_MESSAGE + th.toString(), th);
            }
        }
        return m_MBeanServer;
    }

    public static void registerContainerMBean(String containerName, IJSpaceContainer container) {
        block7: {
            MBeanServer mBeanServer = JMXProvider.getMBeanServer(containerName);
            if (mBeanServer == null) {
                return;
            }
            if (m_MBeansRepository.containsKey(containerName)) {
                return;
            }
            try {
                JMXSpaceContainer mbean = new JMXSpaceContainer(container, CONTAINER_MBEAN_DESCR_URL);
                ObjectName objName = ObjectNameFactory.buildObjectName(DEFAULT_DOMAIN, mbean.getType(), containerName);
                m_MBeansRepository.put(containerName, mBeanServer.registerMBean(mbean, objName));
            }
            catch (InstanceAlreadyExistsException e) {
                if (_logger.isLoggable(Level.CONFIG)) {
                    _logger.config("Container MBean is already registered for <" + containerName + ">");
                }
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.WARNING)) break block7;
                _logger.log(Level.WARNING, "Failed to register MBean for <" + containerName + "> container.", ex);
            }
        }
        if (_logger.isLoggable(Level.CONFIG)) {
            _logger.config("\nContainer <" + containerName + "> MBean was registered successfully.\n");
        }
    }

    public static void registerTransportMBean(String containerName) {
        MBeanServer mBeanServer = JMXProvider.getMBeanServer(containerName);
        if (mBeanServer == null) {
            return;
        }
        TransportProtocolMonitor transportConnectionsInfoMBean = new TransportProtocolMonitor();
        ObjectName objName = TransportConstants.createTransportMBeanObjectName(containerName);
        if (!mBeanServer.isRegistered(objName)) {
            block11: {
                try {
                    mBeanServer.registerMBean(transportConnectionsInfoMBean, objName);
                }
                catch (InstanceAlreadyExistsException e) {
                    if (_logger.isLoggable(Level.CONFIG)) {
                        _logger.config(alreadyRegistredTransportMBeanMessage + containerName + ">");
                    }
                }
                catch (NotCompliantMBeanException e) {
                    if (_logger.isLoggable(Level.WARNING)) {
                        _logger.log(Level.SEVERE, failedTransportMBeanRegistrationMessagePrefix + containerName + ">", e);
                    }
                }
                catch (MBeanRegistrationException e) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block11;
                    _logger.log(Level.SEVERE, failedTransportMBeanRegistrationMessagePrefix + containerName + ">", e);
                }
            }
            if (_logger.isLoggable(Level.CONFIG)) {
                _logger.config(successfulTransportMBeanRegistrationMessage + containerName + ">");
            }
        } else if (_logger.isLoggable(Level.CONFIG)) {
            _logger.config(alreadyRegistredTransportMBeanMessage);
        }
    }

    public static void registerLocalTimeMBean(String containerName) {
        MBeanServer mBeanServer = JMXProvider.getMBeanServer(containerName);
        if (mBeanServer == null) {
            return;
        }
        LocalTime localTimeMBean = new LocalTime();
        ObjectName objName = LocalTimeConstants.MBEAN_NAME;
        if (!mBeanServer.isRegistered(objName)) {
            block8: {
                try {
                    mBeanServer.registerMBean(localTimeMBean, objName);
                }
                catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                }
                catch (NotCompliantMBeanException e) {
                    if (_logger.isLoggable(Level.WARNING)) {
                        _logger.log(Level.SEVERE, failedLocalTimeMBeanRegistrationMessagePrefix + containerName + ">", e);
                    }
                }
                catch (MBeanRegistrationException e) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block8;
                    _logger.log(Level.SEVERE, failedLocalTimeMBeanRegistrationMessagePrefix + containerName + ">", e);
                }
            }
            if (_logger.isLoggable(Level.CONFIG)) {
                _logger.config(successfulTransportMBeanRegistrationMessage + containerName + ">");
            }
        }
    }

    public static void unregisterTransportMBean(String containerName) throws Exception {
        MBeanServer mBeanServer = JMXProvider.getMBeanServer(containerName);
        if (mBeanServer == null) {
            return;
        }
        ObjectName transportMBeanObjectName = TransportConstants.createTransportMBeanObjectName(containerName);
        if (mBeanServer.isRegistered(transportMBeanObjectName)) {
            mBeanServer.unregisterMBean(transportMBeanObjectName);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Transport MBean was unregistered successfully.");
            }
        }
    }

    public static void unregisterContainerMBean(IJSpaceContainer container) throws Exception {
        block5: {
            String containerName = container.getName();
            if (m_MBeanServer == null) {
                return;
            }
            try {
                ObjectInstance objInst = m_MBeansRepository.remove(containerName);
                if (objInst != null) {
                    JMXProvider.getMBeanServer(containerName).unregisterMBean(objInst.getObjectName());
                    if (_logger.isLoggable(Level.CONFIG)) {
                        _logger.config("Container <" + containerName + "> MBean was unregistered successfully.");
                    }
                }
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.WARNING)) break block5;
                _logger.log(Level.WARNING, "Failed to unregister MBean for <" + containerName + "> container", ex);
            }
        }
    }

    public static void registerSpaceMBean(String spaceName, SpaceImpl spaceImpl) {
        block7: {
            MBeanServer mBeanServer = JMXProvider.getMBeanServer(spaceImpl.getContainerName());
            if (mBeanServer == null) {
                return;
            }
            if (m_MBeansRepository.containsKey(spaceImpl.getServiceName())) {
                return;
            }
            try {
                IDirectSpaceProxy remoteSpaceProxy = spaceImpl.getSingleProxy();
                JMXSpace mbean = new JMXSpace(remoteSpaceProxy, JSPACE_MBEAN_DESCR_URL);
                ObjectName objName = ObjectNameFactory.buildObjectName(DEFAULT_DOMAIN, mbean.getType(), spaceImpl.getContainerName() + '-' + spaceName);
                m_MBeansRepository.put(spaceImpl.getServiceName(), mBeanServer.registerMBean(mbean, objName));
                JMXSpaceExt mbeanExt = new JMXSpaceExt(remoteSpaceProxy, mbean.m_spaceConfig, JSPACE_EXT_MBEAN_DESCR_URL);
                ObjectName objNameExt = ObjectNameFactory.buildObjectName(DEFAULT_DOMAIN, mbeanExt.getType(), spaceImpl.getContainerName() + '-' + spaceName);
                m_MBeansRepository.put(spaceImpl.getServiceName() + "Ext", mBeanServer.registerMBean(mbeanExt, objNameExt));
                if (_logger.isLoggable(Level.CONFIG)) {
                    _logger.config("\nSpace <" + spaceImpl.getServiceName() + "> MBean was registered successfully.\n");
                }
            }
            catch (InstanceAlreadyExistsException e) {
                if (_logger.isLoggable(Level.CONFIG)) {
                    _logger.config("Space MBean is already registered for <" + spaceImpl.getServiceName() + ">");
                }
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.WARNING)) break block7;
                _logger.log(Level.WARNING, "Failed to register MBean for <" + spaceImpl.getServiceName() + "> space.", ex);
            }
        }
    }

    public static void unregisterSpaceMBean(String spaceName, String containerName) {
        block6: {
            if (m_MBeanServer == null) {
                return;
            }
            try {
                String fullSpaceName = JSpaceUtilities.createFullSpaceName(containerName, spaceName);
                ObjectInstance objInst = m_MBeansRepository.remove(fullSpaceName);
                if (objInst != null) {
                    m_MBeanServer.unregisterMBean(objInst.getObjectName());
                }
                if ((objInst = m_MBeansRepository.remove(fullSpaceName + "Ext")) != null) {
                    m_MBeanServer.unregisterMBean(objInst.getObjectName());
                }
                if (_logger.isLoggable(Level.CONFIG)) {
                    _logger.config("Space <" + containerName + ":" + spaceName + "> MBean was unregister successfully.");
                }
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.WARNING)) break block6;
                _logger.log(Level.WARNING, "Failed to unregister MBean for <" + containerName + ":" + spaceName + "> space.", ex);
            }
        }
    }

    public static synchronized void removeMBeanServer() {
        _jmxConnectionsMap.clear();
        m_MBeanServer = null;
    }

    static {
        _jmxConnectionsMap = new HashMap<String, JMXConnectorServer>(3);
        m_MBeansRepository = new Hashtable();
        _logger = Logger.getLogger("com.gigaspaces.jmx");
    }
}

