/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jmx;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.j_spaces.core.IGSEntry;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.JSpaceState;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.admin.SpaceRuntimeInfo;
import com.j_spaces.core.admin.StatisticsAdmin;
import com.j_spaces.core.admin.TemplateInfo;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.core.filters.StatisticsContext;
import com.j_spaces.jmx.TemplateImpl;
import com.j_spaces.jmx.XMLDescriptorsMBean;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import net.jini.core.entry.Entry;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.TransactionException;

@InternalApi
public class JMXSpace
extends XMLDescriptorsMBean {
    private IJSpace _remoteSpaceProxy;
    private Object m_spaceAdmin;
    public SpaceConfig m_spaceConfig;

    public JMXSpace() {
    }

    public JMXSpace(IJSpace remoteSpaceProxy, String xmlDescriptorsFileURL) throws Exception {
        super(xmlDescriptorsFileURL);
        this._remoteSpaceProxy = remoteSpaceProxy;
        this.m_spaceAdmin = this._remoteSpaceProxy.getAdmin();
        this.__setConfig(((IRemoteJSpaceAdmin)this.m_spaceAdmin).getConfig());
    }

    @Override
    protected void __setConfig(Object config) {
        this.m_spaceConfig = (SpaceConfig)config;
    }

    @Override
    protected Object __getConfig() {
        return this.m_spaceConfig;
    }

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null || attributeName.trim().length() <= 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name can not be null or empty"), "Unable to retrieve property from " + this.THIS_CLASS_NAME + " with a null or empty attribute name string.");
        }
        Object result = this.m_spaceConfig.getProperty("space-config." + attributeName);
        if (result == null) {
            result = super.getAttribute(attributeName);
        }
        return result;
    }

    public void clear(String className) throws RemoteException, TransactionException, UnusableEntryException {
        this._remoteSpaceProxy.clear(JMXSpace.createTemplate(className), null);
    }

    public int count(String className) throws RemoteException, TransactionException, UnusableEntryException {
        return this._remoteSpaceProxy.count(JMXSpace.createTemplate(className), null);
    }

    private static Object createTemplate(String typeName) {
        return typeName == null ? null : new SpaceDocument(typeName);
    }

    public IJSpace getSpace() {
        return this._remoteSpaceProxy;
    }

    public String getSpaceName() {
        return this.m_spaceConfig.getSpaceName();
    }

    public void ping() throws RemoteException {
        this._remoteSpaceProxy.ping();
    }

    public Integer getState() throws RemoteException {
        return ((IRemoteJSpaceAdmin)this.m_spaceAdmin).getState();
    }

    public String getStateString() throws RemoteException {
        return JSpaceState.convertToString(this.getState());
    }

    public ClusterPolicy getClusterPolicy() throws RemoteException {
        return ((IRemoteJSpaceAdmin)this.m_spaceAdmin).getClusterPolicy();
    }

    public Object[] getReplicationStatus() throws RemoteException {
        return ((IRemoteJSpaceAdmin)this.m_spaceAdmin).getReplicationStatus();
    }

    public SpaceRuntimeInfo getRuntimeInfo() throws RemoteException {
        return ((IRemoteJSpaceAdmin)this.m_spaceAdmin).getRuntimeInfo();
    }

    public List<IGSEntry> getTemplatesInfo(String className) throws RemoteException {
        ITypeDesc basicTypeInfo = ((IInternalRemoteJSpaceAdmin)this.m_spaceAdmin).getClassDescriptor(className);
        List<TemplateInfo> templatesInfoList = ((IInternalRemoteJSpaceAdmin)this.m_spaceAdmin).getTemplatesInfo(className);
        ArrayList<IGSEntry> resultList = new ArrayList<IGSEntry>(templatesInfoList.size());
        for (TemplateInfo templateInfo : templatesInfoList) {
            TemplateImpl templateImpl = new TemplateImpl(templateInfo, basicTypeInfo);
            resultList.add(templateImpl);
        }
        return resultList;
    }

    public void spaceCopy(String remoteUrl, Entry template, Boolean includeNotifyTemplatesObj, Integer chunkSizeObj) throws RemoteException {
        boolean includeNotifyTemplates = includeNotifyTemplatesObj == null ? false : includeNotifyTemplatesObj;
        int chunkSize = chunkSizeObj == null ? 1000 : chunkSizeObj;
        ((IRemoteJSpaceAdmin)this.m_spaceAdmin).spaceCopy(remoteUrl, (Object)template, includeNotifyTemplates, chunkSize);
    }

    public boolean isEmbedded() throws RemoteException {
        return this._remoteSpaceProxy.isEmbedded();
    }

    public boolean isStatisticsAvailable() throws RemoteException {
        return ((StatisticsAdmin)this.m_spaceAdmin).isStatisticsAvailable();
    }

    public String[] getStatisticsStringArray() throws RemoteException {
        return ((StatisticsAdmin)this.m_spaceAdmin).getStatisticsStringArray();
    }

    public void setStatisticsSamplingRate(long rate) throws RemoteException {
        ((StatisticsAdmin)this.m_spaceAdmin).setStatisticsSamplingRate(rate);
    }

    public Long getStatisticsSamplingRate() throws RemoteException {
        return ((StatisticsAdmin)this.m_spaceAdmin).getStatisticsSamplingRate();
    }

    public StatisticsContext getStatistics(Integer operationCode) throws RemoteException {
        return ((StatisticsAdmin)this.m_spaceAdmin).getStatistics(operationCode);
    }

    public SpaceURL getURL() throws RemoteException {
        return this._remoteSpaceProxy.getURL();
    }
}

